/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalInternalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.store.AbstractAutoStartMechanism;
import org.jpox.store.StoreData;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.DatastoreInitialisationException;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.exceptions.MissingTableException;
import org.jpox.store.rdbms.table.AbstractTable;
import org.jpox.store.rdbms.table.SchemaTable;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class SchemaAutoStarter
extends AbstractAutoStartMechanism {
    public static final String SCHEMA_TABLE = "SchemaTable";
    private static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected SchemaTable schemaTable = null;
    protected RDBMSManager storeMgr = null;
    protected Connection conn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaAutoStarter(StoreManager store_mgr, ClassLoaderResolver clr) {
        this.storeMgr = (RDBMSManager)store_mgr;
        this.schemaTable = new SchemaTable(this.storeMgr);
        this.schemaTable.initialize(clr);
        try {
            Connection conn = this.storeMgr.getConnection(0);
            try {
                this.schemaTable.exists(conn, true);
                if (AbstractTable.isDumpingDdl()) {
                    try {
                        this.schemaTable.validate(conn, true, false, null);
                    }
                    catch (MissingTableException mte) {}
                } else {
                    this.schemaTable.validate(conn, true, false, null);
                }
            }
            catch (Exception e) {
                JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.ValidationError", this.storeMgr.getSchemaName(), e));
                try {
                    if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
                        JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.DropAndCreate", this.schemaTable.toString()));
                    }
                    try {
                        this.schemaTable.drop(conn);
                    }
                    catch (SQLException sqe) {
                        // empty catch block
                    }
                    this.schemaTable.exists(conn, true);
                    this.schemaTable.validate(conn, true, false, null);
                }
                catch (Exception e2) {
                    JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.ValidationError", this.storeMgr.getSchemaName(), e2));
                }
            }
            finally {
                this.storeMgr.closeConnection(conn);
            }
        }
        catch (SQLException sqe) {
            JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseConnectionError", sqe));
        }
    }

    public Collection getAllClassData() throws DatastoreInitialisationException {
        try {
            this.assertIsOpen();
            HashSet data = null;
            try {
                data = this.schemaTable.getAllClasses(this.conn);
            }
            catch (SQLException sqe2) {
                JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.ClassesReadError", sqe2));
            }
            return data;
        }
        catch (Exception e) {
            throw new DatastoreInitialisationException(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.DatastoreInitialisationException", e), e);
        }
    }

    private void assertIsOpen() {
        if (this.conn == null) {
            throw new JDOFatalInternalException(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.AssertIsOpen"));
        }
    }

    private void assertIsClosed() {
        if (this.conn != null) {
            throw new JDOFatalInternalException(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.AssertIsClosed"));
        }
    }

    public void open() {
        this.assertIsClosed();
        try {
            this.conn = this.storeMgr.getConnection(0);
        }
        catch (SQLException sqe2) {
            JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseConnectionError", sqe2));
            throw new JDOFatalInternalException(LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseConnectionError", sqe2), (Throwable)sqe2);
        }
    }

    public void close() {
        this.assertIsOpen();
        try {
            this.storeMgr.closeConnection(this.conn);
            this.conn = null;
        }
        catch (SQLException sqe2) {
            JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseConnectionError", sqe2));
        }
    }

    public boolean isOpen() {
        return this.conn != null;
    }

    public void addClass(StoreData data) {
        this.assertIsOpen();
        try {
            this.schemaTable.addClass(data, this.conn);
        }
        catch (SQLException sqe2) {
            String msg = LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.AddClassError", data.getName(), sqe2);
            JPOXLogger.RDBMS_SCHEMA.error(msg);
            throw new JDODataStoreException(msg, (Throwable)sqe2);
        }
    }

    public void deleteClass(String class_name) {
        this.assertIsOpen();
        try {
            this.schemaTable.deleteClass(class_name, this.conn);
        }
        catch (SQLException sqe2) {
            JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.DeleteClassError", class_name, sqe2));
        }
    }

    public void deleteAllClasses() {
        this.assertIsOpen();
        try {
            this.schemaTable.deleteAllClasses(this.conn);
        }
        catch (SQLException sqe2) {
            JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.DeleteClassesError", sqe2));
        }
    }

    public String getStorageDescription() {
        return LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.StorageDescription", this.schemaTable.toString());
    }
}

