/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.JDOFatalInternalException;
import org.jpox.store.rdbms.ParamLoggingPreparedStatement;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class SQLExecutionController {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected boolean supportsBatching = false;
    protected int maxBatchSize = -1;
    protected int queryTimeout = 0;
    Map connectionStatements = new HashMap();

    public SQLExecutionController(boolean supportsBatching, int maxBatchSize, int queryTimeout) {
        this.supportsBatching = supportsBatching;
        this.maxBatchSize = maxBatchSize;
        this.queryTimeout = queryTimeout;
    }

    public PreparedStatement getStatementForUpdate(Connection conn, String stmtText, boolean batchable) throws SQLException {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state == null) {
            state = new ConnectionStatementState();
            this.setConnectionStatementState(conn, state);
        }
        if (this.supportsBatching && batchable && state.updateStmtText != null && state.updateStmtText.equals(stmtText) && this.maxBatchSize > state.updateStmtBatchSize) {
            state.updateStmt.addBatch();
            ++state.updateStmtBatchSize;
        } else {
            if (state.updateStmt != null) {
                this.processStatementForUpdate(conn);
            }
            state.updateStmt = conn.prepareStatement(stmtText);
            state.updateStmtText = stmtText;
            if (JPOXLogger.RDBMS_SQL.isDebugEnabled() && JavaUtils.isJRE1_4OrAbove()) {
                state.updateStmt = new ParamLoggingPreparedStatement(state.updateStmt, stmtText);
            }
        }
        return state.updateStmt;
    }

    public PreparedStatement getStatementForQuery(Connection conn, String stmtText, boolean applyTimeout, String resultSetType, String resultSetConcurrency) throws SQLException {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state == null) {
            state = new ConnectionStatementState();
            this.setConnectionStatementState(conn, state);
        }
        if (resultSetType != null || resultSetConcurrency != null) {
            int rsTypeValue = 1003;
            if (resultSetType.equals("scroll-sensitive")) {
                rsTypeValue = 1005;
            } else if (resultSetType.equals("scroll-insensitive")) {
                rsTypeValue = 1004;
            }
            int rsConcurrencyValue = 1007;
            if (resultSetConcurrency.equals("updateable")) {
                rsConcurrencyValue = 1008;
            }
            state.queryStmt = conn.prepareStatement(stmtText, rsTypeValue, rsConcurrencyValue);
        } else {
            state.queryStmt = conn.prepareStatement(stmtText);
        }
        state.queryStmtText = stmtText;
        if (applyTimeout && this.queryTimeout > 0) {
            state.queryStmt.setQueryTimeout(this.queryTimeout);
        }
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled() && JavaUtils.isJRE1_4OrAbove()) {
            state.queryStmt = new ParamLoggingPreparedStatement(state.queryStmt, stmtText);
        }
        return state.queryStmt;
    }

    public int[] processStatementForUpdate(Connection conn) throws SQLException {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state == null) {
            throw new JDOFatalInternalException("No Connection state exists for Connection " + StringUtils.toJVMIDString(conn) + " and thread " + Thread.currentThread().getName());
        }
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            if (state.updateStmt instanceof ParamLoggingPreparedStatement) {
                JPOXLogger.RDBMS_SQL.debug(((ParamLoggingPreparedStatement)state.updateStmt).getStatementWithParamsReplaced());
            } else {
                JPOXLogger.RDBMS_SQL.debug(state.updateStmtText);
            }
        }
        long startTime = System.currentTimeMillis();
        int[] inds = null;
        if (state.updateStmtBatchSize > 0) {
            state.updateStmt.addBatch();
            inds = state.updateStmt.executeBatch();
        } else {
            inds = new int[]{state.updateStmt.executeUpdate()};
        }
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("JDBC.Statement.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        state.updateStmt = null;
        state.updateStmtText = null;
        state.updateStmtBatchSize = 0;
        return inds;
    }

    public ResultSet processStatementForQuery(Connection conn) throws SQLException {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state == null) {
            throw new JDOFatalInternalException("No Connection state exists for Connection " + StringUtils.toJVMIDString(conn) + " and thread " + Thread.currentThread().getName());
        }
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            if (state.queryStmt instanceof ParamLoggingPreparedStatement) {
                JPOXLogger.RDBMS_SQL.debug(((ParamLoggingPreparedStatement)state.queryStmt).getStatementWithParamsReplaced());
            } else {
                JPOXLogger.RDBMS_SQL.debug(state.queryStmtText);
            }
        }
        long startTime = System.currentTimeMillis();
        ResultSet rs = state.queryStmt.executeQuery();
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("JDBC.Statement.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        state.queryStmt = null;
        state.queryStmtText = null;
        return rs;
    }

    protected void removeConnectionStatementState(Connection conn) {
        this.connectionStatements.remove(this.getStateKey(conn));
    }

    protected ConnectionStatementState getConnectionStatementState(Connection conn) {
        return (ConnectionStatementState)this.connectionStatements.get(this.getStateKey(conn));
    }

    protected void setConnectionStatementState(Connection conn, ConnectionStatementState state) {
        this.connectionStatements.put(this.getStateKey(conn), state);
    }

    protected String getStateKey(Connection conn) {
        return StringUtils.toJVMIDString(conn) + "_" + Thread.currentThread().getName();
    }

    class ConnectionStatementState {
        PreparedStatement updateStmt = null;
        String updateStmtText = null;
        int updateStmtBatchSize = 0;
        PreparedStatement queryStmt = null;
        String queryStmtText = null;

        ConnectionStatementState() {
        }
    }
}

