/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.PersistenceManager;
import javax.jdo.datastore.JDOConnection;
import javax.sql.DataSource;
import org.jpox.PersistenceManagerFactoryImpl;
import org.jpox.PersistenceManagerImpl;
import org.jpox.exceptions.ConnectionInUseException;
import org.jpox.exceptions.TransactionActiveException;
import org.jpox.exceptions.TransactionNotActiveException;
import org.jpox.store.rdbms.AbstractRDBMSTransaction;
import org.jpox.store.rdbms.JDOConnectionImpl;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.util.JPOXLogger;

public class RDBMSNonmanagedTransaction
extends AbstractRDBMSTransaction {
    private final PersistenceManagerImpl pm;
    private final DataSource[] ntds;
    private final String userName;
    private final String password;
    private boolean pinnedConnection = false;

    public RDBMSNonmanagedTransaction(PersistenceManagerImpl pm, String userName, String password) {
        this.pm = pm;
        this.dba = (RDBMSAdapter)pm.getStoreManager().getDatastoreAdapter();
        PersistenceManagerFactoryImpl pmf = (PersistenceManagerFactoryImpl)pm.getPersistenceManagerFactory();
        this.tds = pmf.getTransactionalDataSource();
        this.ntds = pmf.getNontransactionalDataSource();
        this.userName = userName;
        this.password = password;
        this.setRetainValues(pmf.getRetainValues());
        this.setRestoreValues(pmf.getRestoreValues());
        this.setOptimistic(pmf.getOptimistic());
        this.setNontransactionalRead(pmf.getNontransactionalRead());
        this.setNontransactionalWrite(pmf.getNontransactionalWrite());
        this.setTransactionIsolation(pmf.getTransactionIsolation());
        this.useUpdateLock = pmf.getUseUpdateLock();
    }

    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public synchronized JDOConnection getJDOConnection() {
        boolean createNew;
        Connection nativeConnection;
        this.assertJDOConnectionNotInUse();
        if (this.conn != null) {
            this.isJDOConnectionInUse = true;
            nativeConnection = this.conn;
            createNew = false;
        } else {
            try {
                nativeConnection = this.dba.getConnection(this.ntds, this.userName, this.password, this.getTransactionIsolation());
                if (this.pm.getPMFContext().getPmfConfiguration().getReadOnlyDatastore()) {
                    nativeConnection.setReadOnly(true);
                }
                createNew = true;
            }
            catch (SQLException e) {
                throw new JDODataStoreException(e.getMessage());
            }
        }
        return new JDOConnectionImpl(nativeConnection, new Runnable(){

            public void run() {
                RDBMSNonmanagedTransaction.this.isJDOConnectionInUse = false;
                if (createNew) {
                    try {
                        nativeConnection.close();
                    }
                    catch (SQLException sqle) {
                        throw new JDODataStoreException(sqle.getMessage());
                    }
                }
            }
        });
    }

    public synchronized Connection getConnection(boolean forWriting, boolean forQuery, boolean useOpenedConnection) throws SQLException {
        this.assertJDOConnectionNotInUse();
        if (this.active) {
            if (!this.getPersistenceManager().getIgnoreCache() && forQuery || forWriting) {
                if (this.optimistic && !this.pinnedConnection) {
                    this.pinnedConnection = true;
                    this.conn = this.dba.getConnection(this.ntds, this.userName, this.password, this.getTransactionIsolation());
                    if (this.pm.getPMFContext().getPmfConfiguration().getReadOnlyDatastore()) {
                        this.conn.setReadOnly(true);
                    }
                    if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                        JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.Optimistic.ConnectionRetrieved", this.conn));
                    }
                }
                this.pm.flush();
            }
            if (this.optimistic && !this.pinnedConnection) {
                this.conn = this.dba.getConnection(this.ntds, this.userName, this.password, this.getTransactionIsolation());
                if (this.pm.getPMFContext().getPmfConfiguration().getReadOnlyDatastore()) {
                    this.conn.setReadOnly(true);
                }
                if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                    JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.Optimistic.ConnectionRetrieved", this.conn));
                }
            }
        } else {
            if (!this.nontransactionalRead || forWriting && !this.nontransactionalWrite) {
                throw new TransactionNotActiveException();
            }
            if (!useOpenedConnection) {
                while (this.conn != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            if (this.conn == null) {
                this.conn = this.dba.getConnection(this.ntds, this.userName, this.password, this.getTransactionIsolation());
                if (this.pm.getPMFContext().getPmfConfiguration().getReadOnlyDatastore()) {
                    this.conn.setReadOnly(true);
                }
                if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                    JPOXLogger.TRANSACTION.debug(LOCALISER.msg(this.optimistic ? "Transaction.Optimistic.ConnectionRetrieved" : "Transaction.Pessimistic.ConnectionRetrieved", this.conn));
                }
            }
        }
        return this.conn;
    }

    public synchronized void releaseConnection(Connection conn) throws SQLException {
        this.assertJDOConnectionNotInUse();
        if (conn == this.conn && (!this.active || this.optimistic && !this.pinnedConnection)) {
            if (conn != null && !conn.getAutoCommit()) {
                conn.commit();
            }
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() throws SQLException {
        try {
            if (this.conn != null) {
                if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                    JPOXLogger.TRANSACTION.debug(LOCALISER.msg(this.optimistic ? "Transaction.Optimistic.ConnectionClosed" : "Transaction.Pessimistic.ConnectionClosed", this.conn));
                }
                this.dba.closeConnection(this.conn);
            }
        }
        finally {
            this.pinnedConnection = false;
            this.conn = null;
            this.notifyAll();
        }
    }

    public synchronized void begin() {
        this.assertNotInUse();
        try {
            if (!this.optimistic) {
                this.conn = this.dba.getConnection(this.tds, this.userName, this.password, this.getTransactionIsolation());
                if (this.pm.getPMFContext().getPmfConfiguration().getReadOnlyDatastore()) {
                    this.conn.setReadOnly(true);
                }
                if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                    JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.Pessimistic.ConnectionRetrieved", this.conn));
                }
            }
            this.active = true;
            if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.StartedForConnection", this.conn));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("Transaction.FailedToStart"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() {
        if (!this.active) {
            throw new TransactionNotActiveException();
        }
        this.assertJDOConnectionNotInUse();
        if (this.rollbackOnly) {
            if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.CommitWithRollbackOnly"));
            }
            throw new JDOFatalDataStoreException(LOCALISER.msg("Transaction.CommitWithRollbackOnly"));
        }
        try {
            this.commiting = true;
            boolean success = false;
            try {
                try {
                    if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                        JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.CommitForConnection", this.conn));
                    }
                    if (this.sync != null) {
                        this.sync.beforeCompletion();
                    }
                    this.pm.flush();
                    this.pm.preCommit();
                    if (this.conn != null && !this.conn.getAutoCommit()) {
                        this.conn.commit();
                    }
                    success = true;
                }
                finally {
                    if (!success) {
                        try {
                            this.pm.preRollback();
                        }
                        finally {
                            if (this.conn != null) {
                                this.conn.rollback();
                            }
                        }
                    }
                }
            }
            finally {
                try {
                    this.active = false;
                    this.closeConnection();
                }
                finally {
                    try {
                        if (success) {
                            this.pm.postCommit();
                        }
                    }
                    finally {
                        this.commiting = false;
                        if (this.sync != null) {
                            if (success) {
                                this.sync.afterCompletion(3);
                            } else {
                                this.sync.afterCompletion(4);
                            }
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("Transaction.FailedToCommit"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() {
        if (!this.active) {
            throw new TransactionNotActiveException();
        }
        this.assertJDOConnectionNotInUse();
        try {
            this.commiting = true;
            try {
                try {
                    if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                        JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.RollbackForConnection", this.conn));
                    }
                    this.pm.preRollback();
                }
                finally {
                    if (this.conn != null) {
                        this.conn.rollback();
                    }
                }
            }
            finally {
                try {
                    this.active = false;
                    this.closeConnection();
                }
                finally {
                    this.commiting = false;
                    if (this.sync != null) {
                        this.sync.afterCompletion(4);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("Transaction.FailedToRollback"), (Throwable)e);
        }
        this.rollbackOnly = false;
    }

    protected void assertNotInUse() {
        if (this.active) {
            throw new TransactionActiveException(this);
        }
        if (this.conn != null) {
            throw new ConnectionInUseException();
        }
    }
}

