/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.jdo.Extent;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.datastore.Sequence;
import javax.jdo.identity.SingleFieldIdentity;
import javax.resource.spi.security.PasswordCredential;
import org.jpox.AbstractPersistenceManagerFactory;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.PersistenceManagerImpl;
import org.jpox.Transaction;
import org.jpox.exceptions.MetaDataForPersistenceCapableClassNotReachableException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.ExtensionMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InheritanceMetaData;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.MapMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.resource.ManagedConnectionImpl;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.DatastoreObject;
import org.jpox.store.FetchStatement;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.OID;
import org.jpox.store.SCOID;
import org.jpox.store.StoreData;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NoExtentException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.poid.PoidConnectionProvider;
import org.jpox.store.poid.PoidGenerator;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.ParamLoggingPreparedStatement;
import org.jpox.store.rdbms.RDBMSFetchStatement;
import org.jpox.store.rdbms.RDBMSManagedTransaction;
import org.jpox.store.rdbms.RDBMSNonmanagedTransaction;
import org.jpox.store.rdbms.RDBMSStoreData;
import org.jpox.store.rdbms.RDBMSStoreHelper;
import org.jpox.store.rdbms.RDBMSTransaction;
import org.jpox.store.rdbms.RequestIdentifier;
import org.jpox.store.rdbms.SequenceImpl;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.adapter.RDBMSAdapterFactory;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.extent.ClassTableExtent;
import org.jpox.store.rdbms.extent.ClassViewExtent;
import org.jpox.store.rdbms.poid.AbstractRDBMSPoidGenerator;
import org.jpox.store.rdbms.request.DeleteRequest;
import org.jpox.store.rdbms.request.FetchRequest;
import org.jpox.store.rdbms.request.InsertRequest;
import org.jpox.store.rdbms.request.LocateRequest;
import org.jpox.store.rdbms.request.UpdateRequest;
import org.jpox.store.rdbms.scostore.AbstractArrayStore;
import org.jpox.store.rdbms.scostore.AbstractCollectionStore;
import org.jpox.store.rdbms.scostore.AbstractMapStore;
import org.jpox.store.rdbms.scostore.FKArrayStore;
import org.jpox.store.rdbms.scostore.FKListStore;
import org.jpox.store.rdbms.scostore.FKMapStore;
import org.jpox.store.rdbms.scostore.FKSetStore;
import org.jpox.store.rdbms.scostore.JoinArrayStore;
import org.jpox.store.rdbms.scostore.JoinListStore;
import org.jpox.store.rdbms.scostore.JoinMapStore;
import org.jpox.store.rdbms.scostore.JoinSetStore;
import org.jpox.store.rdbms.sqlidentifier.SQLIdentifier;
import org.jpox.store.rdbms.table.AbstractTable;
import org.jpox.store.rdbms.table.ArrayTable;
import org.jpox.store.rdbms.table.ClassTable;
import org.jpox.store.rdbms.table.ClassView;
import org.jpox.store.rdbms.table.CollectionTable;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.rdbms.table.ListTable;
import org.jpox.store.rdbms.table.MapTable;
import org.jpox.store.rdbms.table.ProbeTable;
import org.jpox.store.rdbms.table.SetTable;
import org.jpox.store.rdbms.table.Table;
import org.jpox.store.rdbms.table.TableImpl;
import org.jpox.store.rdbms.table.ViewImpl;
import org.jpox.store.scostore.ArrayStore;
import org.jpox.store.scostore.CollectionStore;
import org.jpox.store.scostore.MapStore;
import org.jpox.util.ClassUtils;
import org.jpox.util.FailoverUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.Localiser;
import org.jpox.util.MacroString;
import org.jpox.util.MultiMap;
import org.jpox.util.SoftValueMap;
import org.jpox.util.StringUtils;
import org.jpox.util.TypeConversionHelper;

public class RDBMSManager
extends StoreManager {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    private static final int COLUMN_INFO_EXPIRATION_MS = 300000;
    private String catalogName = null;
    private String schemaName = null;
    private Map columnInfoByTableName = new HashMap();
    private Map columnInfoByColumnName = new HashMap();
    private long columnInfoReadTimestamp = -1L;
    private Map requestsByID = Collections.synchronizedMap(new SoftValueMap());
    private ClassAdder classAdder = null;
    private final Object CLASSADDER_MUTEX = new Object();
    static /* synthetic */ Class class$org$jpox$store$DatastoreAdapter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$jdo$JDOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDBMSManager(ClassLoaderResolver clr, AbstractPersistenceManagerFactory pmf, String userName, String password) {
        super(clr, pmf, userName, password);
        try {
            Connection conn = userName == null ? FailoverUtils.getConnection(this.ds, false) : FailoverUtils.getConnection(this.ds, userName, password, false);
            try {
                this.dba = RDBMSAdapterFactory.getInstance().getDatastoreAdapter(clr, conn, pmf.getPMFConfiguration().getDatastoreAdapterClassName(), pmf.getPMFContext().getPluginManager());
                this.dba.loadDatastoreMapping(pmf.getPMFContext().getPluginManager(), clr);
                if (pmf.getPMFConfiguration().getCatalog() != null && !((RDBMSAdapter)this.dba).supportsCatalogsInTableDefinitions()) {
                    JPOXLogger.RDBMS.warn(LOCALISER_RDBMS.msg("RDBMS.Manager.DefaultCatalogNameUnusable", pmf.getPMFConfiguration().getCatalog()));
                }
                if (pmf.getPMFConfiguration().getSchema() != null && !((RDBMSAdapter)this.dba).supportsSchemasInTableDefinitions()) {
                    JPOXLogger.RDBMS.warn(LOCALISER_RDBMS.msg("RDBMS.Manager.DefaultSchemaNameUnusable", pmf.getPMFConfiguration().getSchema()));
                }
                this.initialiseIdentifierFactory(pmf);
                this.initialiseSchema(pmf.getPMFConfiguration().getAutoStartMechanism(), pmf.getPMFConfiguration().getAutoStartMechanismMode(), conn, clr);
            }
            finally {
                conn.close();
            }
        }
        catch (JDOException jdoex) {
            JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseInitialisationError") + ' ' + LOCALISER_RDBMS.msg("RDBMS.Exception", (Object)jdoex));
            throw jdoex;
        }
        catch (Exception e1) {
            String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseInitialisationError") + ' ' + LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseInitialisationAdvice") + ' ' + LOCALISER_RDBMS.msg("RDBMS.Exception", e1);
            JPOXLogger.RDBMS_SCHEMA.error(msg);
            throw new JDODataStoreException(msg, (Throwable)e1);
        }
    }

    protected void initialiseIdentifierFactory(AbstractPersistenceManagerFactory pmf) {
        String idFactoryName = pmf.getPMFConfiguration().getIdentifierFactory();
        String idFactoryClassName = this.pmfContext.getPluginManager().getAttributeValueForExtension("org.jpox.store_identifierfactory", "name", idFactoryName, "class-name");
        if (idFactoryClassName == null) {
            throw new JDOFatalUserException(LOCALISER.msg("IdentifierFactory.FactoryNotFound", idFactoryName));
        }
        try {
            Class<?> cls = Class.forName(idFactoryClassName);
            Class[] argTypes = new Class[]{class$org$jpox$store$DatastoreAdapter == null ? (class$org$jpox$store$DatastoreAdapter = RDBMSManager.class$("org.jpox.store.DatastoreAdapter")) : class$org$jpox$store$DatastoreAdapter, class$java$lang$String == null ? (class$java$lang$String = RDBMSManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RDBMSManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RDBMSManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RDBMSManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RDBMSManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RDBMSManager.class$("java.lang.String")) : class$java$lang$String};
            Object[] args = new Object[]{this.dba, pmf.getPMFConfiguration().getCatalog(), pmf.getPMFConfiguration().getSchema(), pmf.getPMFConfiguration().getIdentifierCase(), pmf.getPMFConfiguration().getIdentifierWordSeparator(), pmf.getPMFConfiguration().getIdentifierTablePrefix(), pmf.getPMFConfiguration().getIdentifierTableSuffix()};
            this.identifierFactory = (IdentifierFactory)ClassUtils.newInstance(cls, argTypes, args);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JDOFatalUserException(LOCALISER.msg("IdentifierFactory.FactoryClassNotFound", idFactoryName, idFactoryClassName), (Throwable)cnfe);
        }
        catch (Exception e) {
            JPOXLogger.JDO.error(e);
            throw new JDOFatalInternalException(LOCALISER.msg("IdentifierFactory.FactoryError", idFactoryClassName), (Throwable)e);
        }
        if (JPOXLogger.JDO.isDebugEnabled()) {
            JPOXLogger.JDO.debug(LOCALISER.msg("IdentifierFactory.Initialised", idFactoryName, this.identifierFactory.getNameOfIdentifierCase()));
        }
    }

    public void close() {
        super.close();
        this.requestsByID.clear();
        this.columnInfoByTableName.clear();
        this.columnInfoByColumnName.clear();
        this.classAdder = null;
    }

    public boolean supportsQueryLanguage(String language) {
        if (language == null) {
            return false;
        }
        String name = this.getPMFContext().getPluginManager().getAttributeValueForExtension("org.jpox.store_query_query", "name", language, "datastore", "jdbc", "name");
        return name != null;
    }

    public Sequence getSequence(PersistenceManager pm, SequenceMetaData seqmd) {
        return new SequenceImpl(pm, this, seqmd);
    }

    public Transaction getNonmanagedTransaction(PersistenceManagerImpl pm, String userName, String password) {
        return new RDBMSNonmanagedTransaction(pm, userName, password);
    }

    public Transaction getManagedTransaction(ManagedConnectionImpl mc, PasswordCredential credential) {
        return new RDBMSManagedTransaction(mc, credential);
    }

    public Connection getConnection(PersistenceManager pm, boolean forWriting, boolean forQuery, boolean useOpenedConnection) throws SQLException {
        return ((RDBMSTransaction)pm.currentTransaction()).getConnection(forWriting, forQuery, useOpenedConnection);
    }

    public Connection getConnection(PersistenceManager pm, boolean forWriting, boolean forQuery) throws SQLException {
        return ((RDBMSTransaction)pm.currentTransaction()).getConnection(forWriting, forQuery);
    }

    public synchronized void releaseConnection(PersistenceManager pm, Connection conn) throws SQLException {
        ((RDBMSTransaction)pm.currentTransaction()).releaseConnection(conn);
    }

    public Connection getConnection(int isolation_level) throws SQLException {
        return ((RDBMSAdapter)this.dba).getConnection(this.dsNonTx, this.userName, this.password, isolation_level);
    }

    public void closeConnection(Connection conn) throws SQLException {
        ((RDBMSAdapter)this.dba).closeConnection(conn);
    }

    public PreparedStatement getStatement(Connection conn, String stmtText, boolean applyTimeout) throws SQLException {
        return this.getStatement(conn, stmtText, applyTimeout, null, null);
    }

    public PreparedStatement getStatement(Connection conn, String stmtText, boolean applyTimeout, String resultSetType, String resultSetConcurrency) throws SQLException {
        int queryTimeout;
        PreparedStatement ps = null;
        if (resultSetType != null || resultSetConcurrency != null) {
            int rsTypeValue = 1003;
            if (resultSetType.equals("scroll-sensitive")) {
                rsTypeValue = 1005;
            } else if (resultSetType.equals("scroll-insensitive")) {
                rsTypeValue = 1004;
            }
            int rsConcurrencyValue = 1007;
            if (resultSetConcurrency.equals("updateable")) {
                rsConcurrencyValue = 1008;
            }
            ps = conn.prepareStatement(stmtText, rsTypeValue, rsConcurrencyValue);
        } else {
            ps = conn.prepareStatement(stmtText);
        }
        if (applyTimeout && (queryTimeout = this.getPMFContext().getPmfConfiguration().getQueryTimeout()) > 0) {
            ps.setQueryTimeout(queryTimeout);
        }
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled() && JavaUtils.isJRE1_4OrAbove()) {
            ps = new ParamLoggingPreparedStatement(ps, stmtText);
        }
        return ps;
    }

    public int executeStatementUpdate(String stmt, PreparedStatement ps) throws SQLException {
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            if (ps instanceof ParamLoggingPreparedStatement) {
                JPOXLogger.RDBMS_SQL.debug(((ParamLoggingPreparedStatement)ps).getStatementWithParamsReplaced());
            } else {
                JPOXLogger.RDBMS_SQL.debug(stmt);
            }
        }
        long startTime = System.currentTimeMillis();
        int ind = ps.executeUpdate();
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            JPOXLogger.RDBMS_SQL.debug(LOCALISER_RDBMS.msg("JDBC.Statement.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        return ind;
    }

    public int[] executeStatementBatch(String stmt, PreparedStatement ps) throws SQLException {
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            if (ps instanceof ParamLoggingPreparedStatement) {
                JPOXLogger.RDBMS_SQL.debug(((ParamLoggingPreparedStatement)ps).getStatementWithParamsReplaced());
            } else {
                JPOXLogger.RDBMS_SQL.debug(stmt);
            }
        }
        long startTime = System.currentTimeMillis();
        int[] ind = ps.executeBatch();
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            JPOXLogger.RDBMS_SQL.debug(LOCALISER_RDBMS.msg("JDBC.Statement.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        return ind;
    }

    public ResultSet executeStatementQuery(String stmt, PreparedStatement ps) throws SQLException {
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            if (ps instanceof ParamLoggingPreparedStatement) {
                JPOXLogger.RDBMS_SQL.debug(((ParamLoggingPreparedStatement)ps).getStatementWithParamsReplaced());
            } else {
                JPOXLogger.RDBMS_SQL.debug(stmt);
            }
        }
        long startTime = System.currentTimeMillis();
        ResultSet rs = ps.executeQuery();
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            JPOXLogger.RDBMS_SQL.debug(LOCALISER_RDBMS.msg("JDBC.Statement.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseSchema(String auto_start_mechanism, String auto_start_mechanism_mode, Connection conn, ClassLoaderResolver clr) throws Exception {
        block18: {
            RDBMSAdapter rdba = (RDBMSAdapter)this.dba;
            if (this.pmfContext.getPmfConfiguration().getCatalog() != null && rdba.supportsCatalogsInTableDefinitions() || this.pmfContext.getPmfConfiguration().getSchema() != null && rdba.supportsSchemasInTableDefinitions()) {
                this.catalogName = this.pmfContext.getPmfConfiguration().getCatalog();
                this.schemaName = this.pmfContext.getPmfConfiguration().getSchema();
            } else {
                try {
                    try {
                        this.catalogName = rdba.getCatalogName(conn);
                        this.schemaName = rdba.getSchemaName(conn);
                    }
                    catch (UnsupportedOperationException e) {
                        if (this.readOnlyDatastore || this.fixedDatastore) break block18;
                        ProbeTable pt = new ProbeTable(this);
                        pt.initialize(clr);
                        pt.create(conn);
                        try {
                            String[] schema_details = pt.findSchemaDetails(conn);
                            if (schema_details != null) {
                                this.catalogName = schema_details[0];
                                this.schemaName = schema_details[1];
                            }
                        }
                        finally {
                            pt.drop(conn);
                        }
                    }
                }
                catch (SQLException e) {
                    String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseConnectionError") + ' ' + LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseInitialisationAdvice") + ' ' + e.toString();
                    JPOXLogger.RDBMS_SCHEMA.warn(msg);
                }
            }
        }
        if ((this.readOnlyDatastore || this.fixedDatastore) && auto_start_mechanism.equals("SchemaTable")) {
            auto_start_mechanism = "None";
        }
        if (JPOXLogger.RDBMS_SCHEMA.isInfoEnabled()) {
            JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.SchemaDataInitialise", this.catalogName, this.schemaName, auto_start_mechanism));
        }
        if (!this.readOnlyDatastore) {
            this.dba.initialiseDatastore(conn);
        }
        this.initialiseAutoStart(auto_start_mechanism, auto_start_mechanism_mode, clr);
        if (JPOXLogger.RDBMS_SCHEMA.isInfoEnabled()) {
            if (this.readOnlyDatastore) {
                JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.SchemaDataInitialisedReadOnly", this.catalogName, this.schemaName, "" + this.storeDataByClass.size()));
            } else if (this.fixedDatastore) {
                JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.SchemaDataInitialisedFixed", this.catalogName, this.schemaName, "" + this.storeDataByClass.size()));
            } else {
                JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.SchemaDataInitialised", this.catalogName, this.schemaName, "" + this.storeDataByClass.size()));
            }
        }
    }

    private void clearSchemaData() {
        this.deregisterAllStoreData();
        this.columnInfoByTableName.clear();
        this.columnInfoReadTimestamp = -1L;
        this.requestsByID.clear();
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClasses(String[] classNames, ClassLoaderResolver clr, FileWriter writer) {
        if (writer != null) {
            AbstractTable.setDdlDumpWriter(writer);
        }
        Object object = this.CLASSADDER_MUTEX;
        synchronized (object) {
            if (this.classAdder != null) {
                this.classAdder.addClasses(classNames, clr);
                return;
            }
        }
        if (classNames != null && classNames.length > 0) {
            new ClassAdder(classNames, writer).execute(clr);
        }
    }

    public void addClass(String className, ClassLoaderResolver clr) {
        this.addClasses(new String[]{className}, clr, null);
    }

    public void removeAllClasses(ClassLoaderResolver clr) {
        MgmtTransaction mtx = new MgmtTransaction(2){

            public String toString() {
                return LOCALISER_RDBMS.msg("RDBMS.Manager.RemoveAllClassesFromSchema", RDBMSManager.this.catalogName, RDBMSManager.this.schemaName);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void run(ClassLoaderResolver clr) throws SQLException {
                RDBMSManager rDBMSManager = RDBMSManager.this;
                synchronized (rDBMSManager) {
                    boolean success = true;
                    try {
                        JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.RemoveAllClassesFromSchema", RDBMSManager.this.catalogName, RDBMSManager.this.schemaName));
                        HashMap<DatastoreIdentifier, DatastoreContainerObject> baseTablesByName = new HashMap<DatastoreIdentifier, DatastoreContainerObject>();
                        HashMap<DatastoreIdentifier, DatastoreContainerObject> viewsByName = new HashMap<DatastoreIdentifier, DatastoreContainerObject>();
                        Iterator i = RDBMSManager.this.storeDataByClass.values().iterator();
                        while (i.hasNext()) {
                            RDBMSStoreData data = (RDBMSStoreData)i.next();
                            if (JPOXLogger.RDBMS_SCHEMA.isInfoEnabled()) {
                                JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.RemoveClass", data.getName()));
                            }
                            if (!data.hasTable()) continue;
                            if (data.mapsToView()) {
                                viewsByName.put(data.getDatastoreIdentifier(), data.getDatastoreContainerObject());
                                continue;
                            }
                            baseTablesByName.put(data.getDatastoreIdentifier(), data.getDatastoreContainerObject());
                        }
                        Iterator viewsIter = viewsByName.values().iterator();
                        while (viewsIter.hasNext()) {
                            ((ViewImpl)viewsIter.next()).drop(this.getCurrentConnection());
                        }
                        Iterator tablesIter = baseTablesByName.values().iterator();
                        while (tablesIter.hasNext()) {
                            ((TableImpl)tablesIter.next()).dropConstraints(this.getCurrentConnection());
                        }
                        tablesIter = baseTablesByName.values().iterator();
                        while (tablesIter.hasNext()) {
                            ((TableImpl)tablesIter.next()).drop(this.getCurrentConnection());
                        }
                    }
                    catch (Exception e) {
                        success = false;
                        String errorMsg = LOCALISER_RDBMS.msg("RDBMS.Manager.RemoveClassesExceptionError", e);
                        JPOXLogger.RDBMS_SCHEMA.error(errorMsg);
                        throw new JDOUserException(errorMsg, (Throwable)e);
                    }
                    finally {
                        if (success) {
                            RDBMSManager.this.clearSchemaData();
                        }
                    }
                }
            }
        };
        mtx.execute(clr);
    }

    public FetchStatement getFetchStatement(DatastoreContainerObject table) {
        return new RDBMSFetchStatement(table);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized DatastoreContainerObject newJoinDatastoreContainerObject(AbstractPropertyMetaData fmd, ClassLoaderResolver clr) {
        AbstractPropertyMetaData relatedFmd;
        if (fmd.getJoinMetaData() == null && ((relatedFmd = fmd.getRelatedFieldMetaData(clr)) == null || relatedFmd.getJoinMetaData() == null)) {
            Class element_class;
            if (fmd.hasCollection()) {
                element_class = clr.classForName(fmd.getCollection().getElementType());
            } else if (fmd.hasMap()) {
                MapMetaData mmd = (MapMetaData)fmd.getContainer();
                if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() != null) {
                    element_class = clr.classForName(mmd.getKeyType());
                } else {
                    if (fmd.getKeyMetaData() == null || fmd.getKeyMetaData().getMappedBy() == null) throw new JDOUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.MapWithoutJoinWithoutMappedBy", fmd.getFullFieldName()));
                    element_class = clr.classForName(mmd.getValueType());
                }
            } else {
                if (!fmd.hasArray()) return null;
                element_class = clr.classForName(fmd.getTypeName()).getComponentType();
            }
            if (this.getMetaDataManager().getMetaDataForClass(element_class, clr) != null) {
                return null;
            }
            if (!this.getPMFContext().getTypeManager().isReferenceType(element_class)) throw new JDOUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.NonPersistenceCapableCollectionElementNeedsJoin", fmd.getFullFieldName(), fmd.toString()));
            return null;
        }
        DatastoreContainerObject joinTable = this.getDatastoreContainerObject(fmd);
        if (joinTable != null) {
            return joinTable;
        }
        if (this.classAdder == null) {
            throw new IllegalStateException(LOCALISER_RDBMS.msg("RDBMS.Manager.JoinTableCreationError"));
        }
        if (fmd.getType().isArray()) {
            return this.classAdder.addJoinTableForContainer(fmd, clr, 4);
        }
        if (this.getPMFContext().getTypeManager().isSCOList(fmd.getType())) {
            return this.classAdder.addJoinTableForContainer(fmd, clr, 2);
        }
        if (!this.getPMFContext().getTypeManager().isSCOMap(fmd.getType())) return this.classAdder.addJoinTableForContainer(fmd, clr, 1);
        return this.classAdder.addJoinTableForContainer(fmd, clr, 3);
    }

    public CollectionStore getBackingStoreForCollection(AbstractPropertyMetaData fmd, DatastoreObject datastoreTable, ClassLoaderResolver clr, boolean instantiated, boolean listBased) {
        AbstractCollectionStore store = null;
        store = !instantiated ? (datastoreTable == null ? (this.getPMFContext().getTypeManager().isSCOList(fmd.getType()) ? new FKListStore(fmd, this, clr) : new FKSetStore(fmd, this, clr)) : (this.getPMFContext().getTypeManager().isSCOList(fmd.getType()) ? new JoinListStore(fmd, (CollectionTable)datastoreTable, clr) : new JoinSetStore(fmd, (CollectionTable)datastoreTable, clr))) : (datastoreTable == null ? (listBased ? new FKListStore(fmd, this, clr) : new FKSetStore(fmd, this, clr)) : (listBased ? new JoinListStore(fmd, (CollectionTable)datastoreTable, clr) : new JoinSetStore(fmd, (CollectionTable)datastoreTable, clr)));
        return store;
    }

    public MapStore getBackingStoreForMap(AbstractPropertyMetaData fmd, DatastoreObject datastoreTable, ClassLoaderResolver clr) {
        AbstractMapStore store = null;
        store = datastoreTable == null ? new FKMapStore(fmd, this, clr) : new JoinMapStore((MapTable)datastoreTable, clr);
        return store;
    }

    public ArrayStore getBackingStoreForArray(AbstractPropertyMetaData fmd, DatastoreObject datastoreTable, ClassLoaderResolver clr) {
        AbstractArrayStore store = null;
        store = datastoreTable != null ? new JoinArrayStore((ArrayTable)datastoreTable, clr) : new FKArrayStore(fmd, this, clr);
        return store;
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, PersistenceManager pm) {
        RDBMSStoreData data;
        AbstractCollection subclasses;
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        ArrayList<RDBMSStoreData> classTree = new ArrayList<RDBMSStoreData>();
        String targetClassName = null;
        AbstractClassMetaData cmd = null;
        if (id instanceof OID) {
            OID oid = (OID)id;
            cmd = this.getMetaDataManager().getMetaDataForClass(oid.getPcClass(), clr);
            if (cmd.getDiscriminatorStrategy() == null) {
                subclasses = new ArrayList(this.getSubClassesForClass(oid.getPcClass(), true, clr));
                if (subclasses.size() < 1) {
                    JPOXLogger.JDO.debug("1) Id \"" + id + "\" has been determined to be the id of class " + oid.getPcClass());
                    return oid.getPcClass();
                }
                targetClassName = oid.getPcClass();
            }
        } else if (id instanceof SingleFieldIdentity) {
            targetClassName = ((SingleFieldIdentity)id).getTargetClassName();
            cmd = this.getMetaDataManager().getMetaDataForClass(targetClassName, clr);
            if (cmd.getIdentityType() != IdentityType.APPLICATION || !cmd.getObjectidClass().equals(id.getClass().getName())) {
                throw new JDOUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.IDAssignedToIncorrectClass", id, cmd.getFullClassName()));
            }
            if (cmd.getDiscriminatorStrategy() != null) {
                targetClassName = null;
            }
        } else {
            Collection c = (Collection)this.storeDataByAppIdClass.get(id.getClass().getName());
            if (c != null) {
                Iterator iter = c.iterator();
                while (iter.hasNext()) {
                    RDBMSStoreData store_data = (RDBMSStoreData)iter.next();
                    if (!store_data.hasTable()) continue;
                    classTree.add(store_data);
                }
            }
        }
        if (targetClassName != null && (data = (RDBMSStoreData)this.storeDataByClass.get(targetClassName)) != null) {
            if (data.hasTable()) {
                classTree.add(data);
            }
            subclasses = this.getSubClassesForClass(targetClassName, true, clr);
            Iterator subclassesIter = ((HashSet)subclasses).iterator();
            while (subclassesIter.hasNext()) {
                String subclassName = (String)subclassesIter.next();
                RDBMSStoreData subclassData = (RDBMSStoreData)this.storeDataByClass.get(subclassName);
                if (!subclassData.hasTable()) continue;
                classTree.add(subclassData);
            }
        }
        if (classTree.size() == 0 && (cmd == null || cmd.getDiscriminatorStrategy() == null)) {
            JPOXLogger.JDO.debug("2) Id \"" + id + "\" has not determined to the class");
            return null;
        }
        if (classTree.size() == 1 && ((cmd = this.getMetaDataManager().getMetaDataForClass(((RDBMSStoreData)classTree.get(0)).getName(), clr)) == null || cmd.getDiscriminatorStrategy() == null)) {
            JPOXLogger.JDO.debug("3) Id \"" + id + "\" has been determined to be the id of class " + ((RDBMSStoreData)classTree.get(0)).getName());
            return ((RDBMSStoreData)classTree.get(0)).getName();
        }
        if (pm != null) {
            String className = null;
            if (cmd != null && cmd.getDiscriminatorStrategy() != null) {
                DatastoreClass primaryTable = pm.getStoreManager().getDatastoreClass(cmd.getFullClassName(), pm.getClassLoaderResolver());
                if (primaryTable != null) {
                    classTree.add((RDBMSStoreData)this.storeDataByClass.get(cmd.getFullClassName()));
                    HashSet subclasses2 = this.getSubClassesForClass(cmd.getFullClassName(), true, clr);
                    Iterator subclassesIter = subclasses2.iterator();
                    while (subclassesIter.hasNext()) {
                        String subclassName = (String)subclassesIter.next();
                        RDBMSStoreData subclassData = (RDBMSStoreData)this.storeDataByClass.get(subclassName);
                        if (!subclassData.hasTable()) continue;
                        classTree.add(subclassData);
                    }
                    className = RDBMSStoreHelper.getClassNameForIdKeyUsingDiscriminator(pm, this, id, classTree);
                    if (className != null) {
                        JPOXLogger.JDO.debug("4) Id \"" + id + "\" has been determined to be the id of class " + className);
                        return className;
                    }
                    return null;
                }
            } else {
                className = RDBMSStoreHelper.getClassNameForIdKeyUsingUnion(pm, this, id, classTree);
            }
            if (className != null) {
                JPOXLogger.JDO.debug("6) Id \"" + id + "\" has been determined to be the id of class " + className);
                return className;
            }
            if (id instanceof OID) {
                JPOXLogger.JDO.debug("7) Id \"" + id + "\" has been determined to be the id of class " + ((OID)id).getPcClass());
                return ((OID)id).getPcClass();
            }
        } else {
            JPOXLogger.JDO.debug("8) Id \"" + id + "\" has been determined to be the id of class " + ((RDBMSStoreData)classTree.get(0)).getName());
            return ((RDBMSStoreData)classTree.get(0)).getName();
        }
        return null;
    }

    public Extent getExtent(PersistenceManager pm, Class c, boolean subclasses) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(c, pm.getClassLoaderResolver());
        if (!cmd.isRequiresExtent()) {
            throw new NoExtentException(c.getName());
        }
        DatastoreClass t = this.getDatastoreClass(cmd.getFullClassName(), pm.getClassLoaderResolver());
        if (t instanceof ClassView) {
            return new ClassViewExtent(pm, t, c, subclasses);
        }
        if (t instanceof ClassTable) {
            return new ClassTableExtent(pm, t, c, subclasses);
        }
        AbstractClassMetaData[] cmds = this.getClassesManagingTableForClass(cmd, pm.getClassLoaderResolver());
        if (cmds != null) {
            DatastoreClass[] tables = new DatastoreClass[cmds.length];
            for (int i = 0; i < cmds.length; ++i) {
                tables[i] = this.getDatastoreClass(cmds[i].getFullClassName(), pm.getClassLoaderResolver());
            }
            return new ClassTableExtent(pm, tables, c, subclasses);
        }
        throw new JDOUserException("Attempt to create an Extent for class " + c.getName() + " which has MetaData, yet no table was found! This should be impossible");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getStrategyValue(final PersistenceManager pm, DatastoreClass table, AbstractClassMetaData cmd, int absoluteFieldNumber, IdentityStrategy strategy, String sequence, ExtensionMetaData[] extensions) {
        Object m;
        PoidGenerator generator;
        RDBMSManager rDBMSManager = this;
        synchronized (rDBMSManager) {
            int size = this.storeDataByClass.size();
            if (size == 0) {
                String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.SchemaDataUninitialisedForSchema", this.catalogName, this.schemaName);
                JPOXLogger.RDBMS_SCHEMA.error(msg);
                throw new JDOFatalInternalException(msg);
            }
        }
        if (strategy == null || strategy == IdentityStrategy.IDENTITY) {
            throw new JDOFatalInternalException("RDBMSManager.getStrategyValue called for invalid strategy \"" + strategy + "\"");
        }
        String generatorNameKeyInManager = null;
        String poidGeneratorClassName = null;
        ConfigurationElement elem = this.pmfContext.getPluginManager().getConfigurationElementForExtension("org.jpox.store_valuegenerator", "name", strategy.toString());
        if (elem != null) {
            poidGeneratorClassName = elem.getAttribute("class-name");
            if (elem.getAttribute("unique") != null && elem.getAttribute("unique").equalsIgnoreCase("true")) {
                generatorNameKeyInManager = poidGeneratorClassName;
            }
        }
        if (generatorNameKeyInManager == null) {
            generatorNameKeyInManager = absoluteFieldNumber >= 0 ? cmd.getManagedFieldAbsolute(absoluteFieldNumber).getFullFieldName() : cmd.getFullClassName();
        }
        if ((generator = this.poidManager.getPoidGenerator(generatorNameKeyInManager)) == null) {
            DatastoreClass tbl = this.getDatastoreClass(cmd.getBaseAbstractClassMetaData().getFullClassName(), pm.getClassLoaderResolver());
            if (tbl == null) {
                tbl = table;
            }
            m = null;
            if (absoluteFieldNumber >= 0) {
                m = tbl.getFieldMapping(cmd.getManagedFieldAbsolute(absoluteFieldNumber));
                if (m == null) {
                    m = table.getFieldMapping(cmd.getManagedFieldAbsolute(absoluteFieldNumber));
                    tbl = table;
                }
            } else {
                m = tbl.getIDMapping();
            }
            StringBuffer columnsName = new StringBuffer();
            for (int i = 0; i < ((JavaTypeMapping)m).getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    columnsName.append(",");
                }
                columnsName.append(((Object)((JavaTypeMapping)m).getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            }
            Properties properties = new Properties();
            properties.setProperty("class-name", cmd.getFullClassName());
            properties.put("root-class-name", cmd.getBaseAbstractClassMetaData().getFullClassName());
            if (cmd.getManagedFieldAbsolute(absoluteFieldNumber) != null) {
                properties.setProperty("field-name", cmd.getManagedFieldAbsolute(absoluteFieldNumber).getFullFieldName());
            }
            if (cmd.getCatalog() != null) {
                properties.setProperty("catalog-name", cmd.getCatalog());
            }
            if (cmd.getSchema() != null) {
                properties.setProperty("schema-name", cmd.getSchema());
            }
            properties.setProperty("table-name", ((Object)tbl.getIdentifier()).toString());
            properties.setProperty("column-name", columnsName.toString());
            if (sequence != null) {
                properties.setProperty("sequence-name", sequence);
            }
            if (strategy == IdentityStrategy.NATIVE) {
                poidGeneratorClassName = ((RDBMSAdapter)this.dba).supportsSequences() && sequence != null ? "org.jpox.store.rdbms.poid.SequencePoidGenerator" : "org.jpox.store.rdbms.poid.SequenceTablePoidGenerator";
            }
            if (extensions != null) {
                for (int i = 0; i < extensions.length; ++i) {
                    properties.put(extensions[i].getKey(), extensions[i].getValue());
                }
            }
            generator = this.poidManager.createPoidGenerator(pm.getClassLoaderResolver(), generatorNameKeyInManager, poidGeneratorClassName, properties, this, null);
        }
        Object oid = null;
        m = generator;
        synchronized (m) {
            if (generator instanceof AbstractRDBMSPoidGenerator) {
                final RDBMSManager thisStoreMgr = this;
                PoidConnectionProvider connProvider = new PoidConnectionProvider(){
                    Connection conn;

                    public Object retrieveConnection() {
                        try {
                            this.conn = pm.getPMFContext().getPmfConfiguration().getPoidTransactionAttribute().equalsIgnoreCase("UsePM") ? thisStoreMgr.getConnection(pm, false, false) : thisStoreMgr.getConnection(RDBMSManager.this.pmfContext.getPmfConfiguration().getPoidTransactionIsolationLevel());
                        }
                        catch (SQLException e) {
                            String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.POIDConnectionOpenError", e.getMessage());
                            JPOXLogger.POID.error(msg);
                            throw new JDODataStoreException(msg, (Throwable)e);
                        }
                        return this.conn;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void releaseConnection() {
                        try {
                            if (pm.getPMFContext().getPmfConfiguration().getPoidTransactionAttribute().equalsIgnoreCase("UsePM")) {
                                thisStoreMgr.releaseConnection(pm, this.conn);
                            } else {
                                boolean success = false;
                                try {
                                    if (!this.conn.getAutoCommit()) {
                                        this.conn.commit();
                                    }
                                    success = true;
                                }
                                finally {
                                    if (!success && !this.conn.getAutoCommit()) {
                                        this.conn.rollback();
                                    }
                                }
                                RDBMSManager.this.closeConnection(this.conn);
                            }
                            this.conn = null;
                        }
                        catch (SQLException e) {
                            String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.POIDConnectionCloseError", e);
                            JPOXLogger.POID.error(msg);
                            throw new JDODataStoreException(msg, (Throwable)e);
                        }
                    }
                };
                ((AbstractRDBMSPoidGenerator)generator).setConnectionProvider(connProvider);
            }
            oid = generator.next();
        }
        AbstractPropertyMetaData fmd = cmd.getManagedFieldAbsolute(absoluteFieldNumber);
        if (fmd != null) {
            Object convertedValue = TypeConversionHelper.convertTo(oid, fmd.getType());
            if (convertedValue == null) {
                throw new JDOFatalException(LOCALISER_RDBMS.msg("RDBMS.Manager.InvalidGeneratedId", fmd.getFullFieldName(), oid));
            }
            oid = convertedValue;
        }
        if (JPOXLogger.POID.isDebugEnabled()) {
            String fieldName = fmd != null ? fmd.getFullFieldName() : cmd.getFullClassName() + " (datastore id)";
            JPOXLogger.POID.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.StrategyValueGenerated", fieldName, strategy, generator.getClass().getName(), oid));
        }
        return oid;
    }

    public InsertRequest getInsertRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestIdentifier.Type.INSERT, cls.getName());
        InsertRequest req = (InsertRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new InsertRequest(table, cls, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public FetchRequest getFetchRequest(DatastoreClass table, AbstractPropertyMetaData[] fieldMetaData, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, fieldMetaData, RequestIdentifier.Type.FETCH, cls.getName());
        FetchRequest req = (FetchRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new FetchRequest(table, fieldMetaData, cls, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public UpdateRequest getUpdateRequest(DatastoreClass table, AbstractPropertyMetaData[] fieldMetaData, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, fieldMetaData, RequestIdentifier.Type.UPDATE, cls.getName());
        UpdateRequest req = (UpdateRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new UpdateRequest(table, fieldMetaData, cls, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public LocateRequest getLocateRequest(DatastoreClass table, String className) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestIdentifier.Type.LOCATE, className);
        LocateRequest req = (LocateRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new LocateRequest(table);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public DeleteRequest getDeleteRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestIdentifier.Type.DELETE, cls.getName());
        DeleteRequest req = (DeleteRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new DeleteRequest(table, cls, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnInfo getColumnInfoForColumnName(Table table, Connection conn, DatastoreIdentifier column) throws SQLException {
        ColumnInfo colInfo = null;
        if (this.storeDataByClass.size() == 0) {
            colInfo = RDBMSStoreHelper.getColumnInfoForColumnName(this, table, conn, column);
            if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
                JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfos", table, colInfo != null ? "1" : "0"));
            }
        } else {
            RDBMSManager rDBMSManager = this;
            synchronized (rDBMSManager) {
                long now = System.currentTimeMillis();
                DatastoreIdentifier tableId = ((AbstractTable)table).getDatastoreIdentifierFullyQualified();
                List cols = null;
                if (now >= this.columnInfoReadTimestamp && now < this.columnInfoReadTimestamp + 300000L && (cols = (List)this.columnInfoByColumnName.get(tableId.getIdentifier() + column.getIdentifier())) != null) {
                    for (int i = 0; i < cols.size(); ++i) {
                        ColumnInfo ci;
                        String[] c = RDBMSStoreHelper.splitColumnIdentifierName(((RDBMSAdapter)this.getDatastoreAdapter()).getCatalogSeparator(), column.getIdentifier());
                        String columnName = column.getIdentifier();
                        if (c[3] != null) {
                            columnName = c[3];
                        }
                        if (!(ci = (ColumnInfo)cols.get(i)).getColumnName().equals(columnName)) continue;
                        colInfo = ci;
                    }
                }
                if (cols == null) {
                    colInfo = RDBMSStoreHelper.getColumnInfoForColumnName(this, table, conn, column);
                    if (colInfo == null) {
                        JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfoNotFound", column.getIdentifier(), table));
                    } else {
                        this.columnInfoByColumnName.put(tableId.getIdentifier() + column.getIdentifier(), colInfo);
                        if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
                            JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfo", colInfo.getColumnName(), table));
                        }
                    }
                }
            }
        }
        return colInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getColumnInfoForTable(Table table, Connection conn) throws SQLException {
        List cols = null;
        if (this.storeDataByClass.size() == 0) {
            cols = RDBMSStoreHelper.getColumnInfoForTable(this, table, conn);
            if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
                JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfos", table, cols != null ? "" + cols.size() : "0"));
            }
        } else {
            RDBMSManager rDBMSManager = this;
            synchronized (rDBMSManager) {
                long now = System.currentTimeMillis();
                DatastoreIdentifier tableId = ((AbstractTable)table).getDatastoreIdentifierFullyQualified();
                if (now >= this.columnInfoReadTimestamp && now < this.columnInfoReadTimestamp + 300000L) {
                    cols = (List)this.columnInfoByTableName.get(tableId);
                }
                if (cols == null) {
                    this.refreshColumnInfo(table.getCatalogName(), table.getSchemaName(), conn);
                    cols = (List)this.columnInfoByTableName.get(tableId);
                    if (cols == null) {
                        cols = Collections.EMPTY_LIST;
                        JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfoNotFoundForTable", table));
                    } else if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
                        JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfos", table, "" + cols.size()));
                    }
                }
            }
        }
        return cols;
    }

    public List getTableInfo() throws SQLException {
        return this.getTableInfo(this.schemaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTableInfo(String schemaNamePattern) throws SQLException {
        Connection conn = null;
        try {
            conn = this.userName == null ? FailoverUtils.getConnection(this.ds, false) : FailoverUtils.getConnection(this.ds, this.userName, this.password, false);
            List list = RDBMSStoreHelper.getTableInfo(this, this.catalogName, schemaNamePattern, conn);
            return list;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getColumnInfo(String schemaNamePattern, String tableNamePattern) throws SQLException {
        Connection conn = null;
        try {
            conn = this.userName == null ? FailoverUtils.getConnection(this.ds, false) : FailoverUtils.getConnection(this.ds, this.userName, this.password, false);
            ArrayList<ColumnInfo> cols = new ArrayList<ColumnInfo>();
            ResultSet rs = ((RDBMSAdapter)this.dba).getColumns(conn, this.catalogName, schemaNamePattern, tableNamePattern);
            try {
                while (rs.next()) {
                    cols.add(((RDBMSAdapter)this.dba).newColumnInfo(rs));
                }
            }
            finally {
                rs.close();
            }
            ArrayList<ColumnInfo> arrayList = cols;
            return arrayList;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public void invalidateColumnInfoForTable(Table table) {
        DatastoreIdentifier tableId = ((AbstractTable)table).getDatastoreIdentifierFullyQualified();
        this.columnInfoByTableName.remove(tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshColumnInfo(String catalogName, String schemaName, Connection conn) throws SQLException {
        long now = System.currentTimeMillis();
        HashSet<DatastoreIdentifier> table_keys = new HashSet<DatastoreIdentifier>();
        Iterator i = this.storeDataByClass.values().iterator();
        while (i.hasNext()) {
            RDBMSStoreData sd = (RDBMSStoreData)i.next();
            if (sd.getDatastoreContainerObject() == null) continue;
            table_keys.add(((AbstractTable)sd.getDatastoreContainerObject()).getDatastoreIdentifierFullyQualified());
        }
        HashMap<SQLIdentifier, ArrayList<ColumnInfo>> cim = new HashMap<SQLIdentifier, ArrayList<ColumnInfo>>();
        ResultSet rs = ((RDBMSAdapter)this.dba).getColumns(conn, catalogName, schemaName, null);
        try {
            while (rs.next()) {
                String tableIdentifierCatalogName = rs.getString(1);
                String tableIdentifierSchemaName = rs.getString(2);
                String tableIdentifierTableName = rs.getString(3);
                if (rs.wasNull() || tableIdentifierCatalogName != null && tableIdentifierCatalogName.length() < 1) {
                    tableIdentifierCatalogName = null;
                }
                if (rs.wasNull() || tableIdentifierSchemaName != null && tableIdentifierSchemaName.length() < 1) {
                    tableIdentifierSchemaName = null;
                }
                if (rs.wasNull() || tableIdentifierTableName != null && tableIdentifierTableName.length() < 1) {
                    tableIdentifierTableName = null;
                }
                if (tableIdentifierTableName == null) {
                    throw new JDODataStoreException("Invalid 'null' table name identifier returned by database. Check with your JDBC driver vendor (ref:DatabaseMetaData.getColumns).");
                }
                SQLIdentifier fullyQualifiedTableName = (SQLIdentifier)this.identifierFactory.newDatastoreContainerIdentifier(tableIdentifierTableName);
                fullyQualifiedTableName.setCatalogName(tableIdentifierCatalogName);
                fullyQualifiedTableName.setSchemaName(tableIdentifierSchemaName);
                if (!table_keys.contains(fullyQualifiedTableName)) continue;
                ArrayList<ColumnInfo> l = (ArrayList<ColumnInfo>)cim.get(fullyQualifiedTableName);
                if (l == null) {
                    l = new ArrayList<ColumnInfo>();
                    cim.put(fullyQualifiedTableName, l);
                }
                l.add(((RDBMSAdapter)this.dba).newColumnInfo(rs));
            }
        }
        finally {
            rs.close();
        }
        if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
            JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfoLoaded", catalogName, schemaName, "" + cim.size(), "" + (System.currentTimeMillis() - now)));
        }
        if (this.columnInfoByTableName != null && this.columnInfoByTableName != cim) {
            this.columnInfoByTableName.clear();
        }
        this.columnInfoByTableName = cim;
        this.columnInfoReadTimestamp = now;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resolveIdentifierMacro(MacroString.IdentifierMacro im, ClassLoaderResolver clr) {
        JavaTypeMapping m;
        DatastoreClass ct = this.getDatastoreClass(im.className, clr);
        if (im.fieldName == null) {
            im.value = ((Object)ct.getIdentifier()).toString();
            return;
        }
        if (im.fieldName.equals("this")) {
            if (!(ct instanceof ClassTable)) {
                throw new JDOUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.TableIDColumnError", im.className));
            }
            if (im.subfieldName != null) {
                throw new JDOUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.FieldTableError", im.className, im.fieldName, im.subfieldName));
            }
            m = ct.getIDMapping();
        } else {
            AbstractPropertyMetaData fmd = this.getMetaDataManager().getMetaDataForField(im.className, im.fieldName, clr);
            m = ct.getFieldMapping(fmd);
            DatastoreContainerObject t = this.getDatastoreContainerObject(fmd);
            if (im.subfieldName == null) {
                if (t != null) {
                    im.value = ((Object)t.getIdentifier()).toString();
                    return;
                }
            } else if (t instanceof SetTable) {
                SetTable st = (SetTable)t;
                if (im.subfieldName.equals("owner")) {
                    m = st.getOwnerMapping();
                } else {
                    if (!im.subfieldName.equals("element")) throw new JDOUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.InvalidPseudoFieldNameForSet", im.subfieldName, im));
                    m = st.getElementMapping();
                }
            } else if (t instanceof ListTable) {
                ListTable lt = (ListTable)t;
                if (im.subfieldName.equals("owner")) {
                    m = lt.getOwnerMapping();
                } else if (im.subfieldName.equals("element")) {
                    m = lt.getElementMapping();
                } else {
                    if (!im.subfieldName.equals("index")) throw new JDOUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.InvalidPseudoFieldNameForSet", im.subfieldName, im));
                    m = lt.getOrderMapping();
                }
            } else {
                if (!(t instanceof MapTable)) throw new JDOUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.FieldTableError", im.className, im.fieldName, im.subfieldName));
                MapTable mt = (MapTable)t;
                if (im.subfieldName.equals("owner")) {
                    m = mt.getOwnerMapping();
                } else if (im.subfieldName.equals("key")) {
                    m = mt.getKeyMapping();
                } else {
                    if (!im.subfieldName.equals("value")) throw new JDOUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.InvalidPseudoFieldNameForMap", im.subfieldName, im));
                    m = mt.getValueMapping();
                }
            }
        }
        im.value = ((Object)((Column)m.getDataStoreMapping(0).getDatastoreField()).getIdentifier()).toString();
    }

    private DatastoreIdentifier getTableIdentifier(ClassMetaData cmd, ClassLoaderResolver clr) {
        RDBMSStoreData sd;
        if (this.storeDataByClass.containsKey(cmd.getFullClassName()) && (sd = (RDBMSStoreData)this.storeDataByClass.get(cmd.getFullClassName())).getDatastoreIdentifier() != null) {
            return sd.getDatastoreIdentifier();
        }
        return this.identifierFactory.newDatastoreContainerIdentifier(clr, cmd);
    }

    private DatastoreIdentifier getTableIdentifier(AbstractPropertyMetaData fmd, ClassLoaderResolver clr) {
        RDBMSStoreData sd;
        if (this.storeDataByClass.containsKey(fmd) && (sd = (RDBMSStoreData)this.storeDataByClass.get(fmd)).getDatastoreIdentifier() != null) {
            return sd.getDatastoreIdentifier();
        }
        return this.identifierFactory.newDatastoreContainerIdentifier(clr, fmd);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ClassAdder
    extends MgmtTransaction {
        public static final int JOIN_TABLE_SET = 1;
        public static final int JOIN_TABLE_LIST = 2;
        public static final int JOIN_TABLE_MAP = 3;
        public static final int JOIN_TABLE_ARRAY = 4;
        private FileWriter ddlWriter = null;
        private HashSet schemaDataAdded = new HashSet();
        private final String[] classNames;
        private int addClassTablesRecursionCounter = 0;

        private ClassAdder(String[] classNames, FileWriter writer) {
            super(((RDBMSAdapter)RDBMSManager.this.dba).getTransactionIsolationForSchemaCreation());
            this.ddlWriter = writer;
            this.classNames = this.filterSimpleClasses(classNames);
        }

        private String[] filterSimpleClasses(String[] classNames) {
            int filteredClasses = 0;
            for (int i = 0; i < classNames.length; ++i) {
                if (!RDBMSManager.this.getPMFContext().getTypeManager().isSupportedType(classNames[i])) continue;
                classNames[i] = null;
                ++filteredClasses;
            }
            if (filteredClasses == 0) {
                return classNames;
            }
            String[] restClasses = new String[classNames.length - filteredClasses];
            int m = 0;
            for (int i = 0; i < classNames.length; ++i) {
                if (classNames[i] == null) continue;
                restClasses[m++] = classNames[i];
            }
            return restClasses;
        }

        public String toString() {
            return LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesToSchema", RDBMSManager.this.catalogName, RDBMSManager.this.schemaName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run(ClassLoaderResolver clr) throws SQLException {
            if (this.classNames.length == 0) {
                return;
            }
            Object object = RDBMSManager.this.CLASSADDER_MUTEX;
            synchronized (object) {
                RDBMSManager.this.classAdder = this;
                try {
                    this.addClassTablesAndValidate(this.classNames, clr);
                }
                finally {
                    RDBMSManager.this.classAdder = null;
                }
            }
        }

        private void addClasses(String[] classNames, ClassLoaderResolver clr) {
            if ((classNames = this.filterSimpleClasses(classNames)).length == 0) {
                return;
            }
            try {
                if (this.getCurrentConnection() == null) {
                    throw new IllegalStateException(LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesError"));
                }
            }
            catch (SQLException e) {
                throw new JDODataStoreException("SQL exception: " + this, (Throwable)e);
            }
            this.addClassTables(classNames, clr);
        }

        private void addClassTable(ClassMetaData cmd, ClassLoaderResolver clr) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                return;
            }
            if (cmd.getIdentityType() == IdentityType.NONDURABLE && cmd.hasExtension("requires-table") && cmd.getValueForExtension("requires-table") != null && cmd.getValueForExtension("requires-table").equalsIgnoreCase("false")) {
                return;
            }
            RDBMSStoreData sd = (RDBMSStoreData)RDBMSManager.this.storeDataByClass.get(cmd.getFullClassName());
            if (sd == null) {
                if (cmd.getIdentityType() == IdentityType.APPLICATION && !cmd.usesSingleFieldIdentityClass()) {
                    String baseClassWithMetaData = cmd.getBaseAbstractClassMetaData().getFullClassName();
                    Collection c = (Collection)RDBMSManager.this.storeDataByAppIdClass.get(cmd.getObjectidClass());
                    if (c != null && c.size() > 0) {
                        boolean in_same_tree = false;
                        String sample_class_in_other_tree = null;
                        Iterator id_iter = c.iterator();
                        while (id_iter.hasNext()) {
                            RDBMSStoreData id_sd = (RDBMSStoreData)id_iter.next();
                            String otherClassBaseClass = ((AbstractClassMetaData)id_sd.getMetaData()).getBaseAbstractClassMetaData().getFullClassName();
                            if (otherClassBaseClass.equals(baseClassWithMetaData)) {
                                in_same_tree = true;
                                break;
                            }
                            sample_class_in_other_tree = id_sd.getName();
                        }
                        if (!in_same_tree) {
                            String error_msg = LOCALISER_RDBMS.msg("RDBMS.Manager.ObjectIdClassDuplicated", cmd.getFullClassName(), cmd.getObjectidClass(), sample_class_in_other_tree);
                            JPOXLogger.GENERAL.error(error_msg);
                            throw new JDOUserException(error_msg);
                        }
                    }
                }
                if (cmd.isEmbeddedOnly()) {
                    JPOXLogger.RDBMS.info(LOCALISER.msg("StoreManager.NoTableForEmbeddedClass", cmd.getFullClassName()));
                } else {
                    InheritanceMetaData imd = cmd.getInheritanceMetaData();
                    RDBMSStoreData sdNew = null;
                    if (imd.getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                        sdNew = new RDBMSStoreData(cmd, null, false);
                        RDBMSManager.this.registerStoreData(sdNew);
                    } else if (imd.getStrategyValue() == InheritanceStrategy.NEW_TABLE) {
                        DatastoreIdentifier tableName = RDBMSManager.this.getTableIdentifier(cmd, clr);
                        StoreData[] existingStoreData = RDBMSManager.this.getStoreDataForDatastoreContainerObject(tableName);
                        if (existingStoreData != null) {
                            String existingClass = null;
                            for (int j = 0; j < existingStoreData.length; ++j) {
                                if (existingStoreData[j].getName().equals(cmd.getFullClassName())) continue;
                                existingClass = existingStoreData[j].getName();
                                break;
                            }
                            if (existingClass != null) {
                                String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.TableAlreadyInUse", cmd.getFullClassName(), tableName.getIdentifier(), existingClass);
                                JPOXLogger.RDBMS.warn(msg);
                            }
                        }
                        AbstractTable t = null;
                        boolean hasViewDef = false;
                        if (RDBMSManager.this.dba.getVendorID() != null) {
                            hasViewDef = cmd.hasExtension("view-definition-" + RDBMSManager.this.dba.getVendorID());
                        }
                        if (!hasViewDef) {
                            hasViewDef = cmd.hasExtension("view-definition");
                        }
                        t = hasViewDef ? new ClassView(tableName, RDBMSManager.this, cmd) : new ClassTable(tableName, RDBMSManager.this, cmd);
                        sdNew = new RDBMSStoreData(cmd, t, true);
                        RDBMSManager.this.registerStoreData(sdNew);
                        ((Table)t).preInitialize(clr);
                    } else if (imd.getStrategyValue() == InheritanceStrategy.SUPERCLASS_TABLE) {
                        AbstractClassMetaData[] managingCmds = RDBMSManager.this.getClassesManagingTableForClass(cmd, clr);
                        DatastoreContainerObject superTable = null;
                        if (managingCmds != null && managingCmds.length == 1) {
                            RDBMSStoreData superData = (RDBMSStoreData)RDBMSManager.this.storeDataByClass.get(managingCmds[0].getFullClassName());
                            if (superData != null) {
                                superTable = superData.getDatastoreContainerObject();
                            }
                            sdNew = new RDBMSStoreData(cmd, superTable, false);
                            RDBMSManager.this.registerStoreData(sdNew);
                        } else {
                            String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.UnableToFindSuperclassTable", cmd.getFullClassName());
                            JPOXLogger.JDO.error(msg);
                            throw new JDOUserException(msg);
                        }
                    }
                    this.schemaDataAdded.add(sdNew);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addClassTables(String[] classNames, ClassLoaderResolver clr) {
            ++this.addClassTablesRecursionCounter;
            try {
                Iterator iter = this.getReferencedClasses(classNames, clr).iterator();
                try {
                    if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised && !RDBMSManager.this.starter.isOpen()) {
                        RDBMSManager.this.starter.open();
                    }
                    while (iter.hasNext()) {
                        ClassMetaData cmd = (ClassMetaData)iter.next();
                        this.addClassTable(cmd, clr);
                    }
                    Iterator addedIter = this.schemaDataAdded.iterator();
                    while (addedIter.hasNext()) {
                        AbstractClassMetaData cmd;
                        InheritanceMetaData imd;
                        RDBMSStoreData data = (RDBMSStoreData)addedIter.next();
                        if (data.getDatastoreContainerObject() != null || !data.isFCO() || (imd = (cmd = (AbstractClassMetaData)data.getMetaData()).getInheritanceMetaData()).getStrategyValue() != InheritanceStrategy.SUPERCLASS_TABLE) continue;
                        AbstractClassMetaData[] managingCmds = RDBMSManager.this.getClassesManagingTableForClass(cmd, clr);
                        DatastoreClass superTable = null;
                        if (managingCmds == null || managingCmds.length != 1) continue;
                        RDBMSStoreData superData = (RDBMSStoreData)RDBMSManager.this.storeDataByClass.get(managingCmds[0].getFullClassName());
                        if (superData == null) {
                            String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.UnableToFindSuperclassTable", cmd.getFullClassName());
                            JPOXLogger.JDO.error(msg);
                            throw new JDOUserException(msg);
                        }
                        superTable = (DatastoreClass)superData.getDatastoreContainerObject();
                        data.setDatastoreContainerObject(superTable);
                    }
                }
                finally {
                    if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised && RDBMSManager.this.starter.isOpen() && this.addClassTablesRecursionCounter <= 1) {
                        RDBMSManager.this.starter.close();
                    }
                }
            }
            finally {
                --this.addClassTablesRecursionCounter;
            }
        }

        private List getReferencedClasses(String[] classNames, ClassLoaderResolver clr) {
            ArrayList cmds = new ArrayList();
            for (int i = 0; i < classNames.length; ++i) {
                Class clazz = clr.classForName(classNames[i]);
                if (clazz != null && clazz.isInterface()) continue;
                AbstractClassMetaData cmd = RDBMSManager.this.getMetaDataManager().getMetaDataForClass(classNames[i], clr);
                if (cmd == null) {
                    JPOXLogger.RDBMS_SCHEMA.warn(LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesInvalidClassError", classNames[i]));
                    throw new MetaDataForPersistenceCapableClassNotReachableException(classNames[i]);
                }
                cmds.addAll(RDBMSManager.this.getMetaDataManager().getReferencedClassMetaData(cmd, RDBMSManager.this.dba.getVendorID(), clr));
            }
            return cmds;
        }

        private List removeDuplicateTablesFromList(List newTables) {
            ArrayList result = new ArrayList();
            TreeSet uniqueTables = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    DatastoreContainerObject t1 = (DatastoreContainerObject)o1;
                    DatastoreContainerObject t2 = (DatastoreContainerObject)o2;
                    return t1.getIdentifier().getIdentifier().compareTo(t2.getIdentifier().getIdentifier());
                }
            });
            uniqueTables.addAll(newTables);
            result.addAll(uniqueTables);
            return result;
        }

        private List[] initializeClassTables(String[] classNames, ClassLoaderResolver clr) {
            boolean someNeededInitialization;
            ArrayList<Table> tablesToValidate = new ArrayList<Table>();
            ArrayList<Table> viewsToValidate = new ArrayList<Table>();
            ArrayList<Table> recentlyInitilized = new ArrayList<Table>();
            do {
                someNeededInitialization = false;
                RDBMSStoreData[] rdbmsStoreData = RDBMSManager.this.storeDataByClass.values().toArray(new RDBMSStoreData[RDBMSManager.this.storeDataByClass.size()]);
                for (int i = 0; i < rdbmsStoreData.length; ++i) {
                    if (!rdbmsStoreData[i].hasTable()) continue;
                    Table t = (Table)rdbmsStoreData[i].getDatastoreContainerObject();
                    if (!t.isInitialized()) {
                        t.initialize(clr);
                        recentlyInitilized.add(t);
                        if (t instanceof ViewImpl) {
                            viewsToValidate.add(t);
                        } else {
                            tablesToValidate.add(t);
                        }
                        someNeededInitialization = true;
                    }
                    if (rdbmsStoreData[i].isTableOwner() || ((ClassTable)t).managesClass(rdbmsStoreData[i].getName())) continue;
                    ((ClassTable)t).manageClass((ClassMetaData)rdbmsStoreData[i].getMetaData(), clr);
                    if (!tablesToValidate.contains(t)) {
                        tablesToValidate.add(t);
                    }
                    someNeededInitialization = true;
                }
            } while (someNeededInitialization);
            for (int j = 0; j < recentlyInitilized.size(); ++j) {
                ((Table)recentlyInitilized.get(j)).postInitialize(clr);
            }
            return new List[]{tablesToValidate, viewsToValidate};
        }

        private List[] performTablesValidation(List tablesToValidate, ClassLoaderResolver clr) throws SQLException {
            TableImpl t;
            ArrayList autoCreateErrors = new ArrayList();
            ArrayList<TableImpl> tableConstraintsCreated = new ArrayList<TableImpl>();
            ArrayList<TableImpl> tablesCreated = new ArrayList<TableImpl>();
            if (this.ddlWriter != null) {
                tablesToValidate = this.removeDuplicateTablesFromList(tablesToValidate);
            }
            Iterator i = tablesToValidate.iterator();
            while (i.hasNext()) {
                t = (TableImpl)i.next();
                boolean columnsValidated = false;
                if (RDBMSManager.this.checkExistTablesOrViews) {
                    if (this.ddlWriter != null) {
                        try {
                            if (t instanceof ClassTable) {
                                this.ddlWriter.write("-- Table " + t.toString() + " for classes " + StringUtils.objectArrayToString(((ClassTable)t).getManagedClasses()) + "\n");
                            } else if (t instanceof JoinTable) {
                                this.ddlWriter.write("-- Table " + t.toString() + " for join relationship\n");
                            }
                        }
                        catch (IOException ioe) {
                            JPOXLogger.RDBMS_DDL.error("error writing DDL into file", ioe);
                        }
                    }
                    if (t.exists(this.getCurrentConnection(), RDBMSManager.this.autoCreateTables)) {
                        tablesCreated.add(t);
                        columnsValidated = true;
                    } else if (t.isInitializedModified() || RDBMSManager.this.autoCreateColumns) {
                        t.validateColumns(this.getCurrentConnection(), false, RDBMSManager.this.autoCreateColumns, autoCreateErrors);
                        columnsValidated = true;
                    }
                }
                if (RDBMSManager.this.validateTables) {
                    t.validate(this.getCurrentConnection(), RDBMSManager.this.validateColumns, false, autoCreateErrors);
                } else if (!columnsValidated && RDBMSManager.this.pmfContext.getPmfConfiguration().getInitializePrimaryKeyColumnInfo()) {
                    t.initializeColumnInfoForPrimaryKeyColumns(this.getCurrentConnection());
                } else if (!columnsValidated) {
                    t.initializeColumnInfoFromDatastore(this.getCurrentConnection());
                }
                RDBMSManager.this.columnInfoByTableName.remove(t.getDatastoreIdentifierFullyQualified());
            }
            i = tablesToValidate.iterator();
            while (i.hasNext()) {
                t = (TableImpl)i.next();
                if (!RDBMSManager.this.validateConstraints && !RDBMSManager.this.autoCreateConstraints) continue;
                if (this.ddlWriter != null) {
                    try {
                        this.ddlWriter.write("-- Constraints for table " + t.toString() + "\n");
                    }
                    catch (IOException ioe) {
                        JPOXLogger.RDBMS_DDL.error("error writing DDL into file", ioe);
                    }
                }
                if (t.validateConstraints(this.getCurrentConnection(), RDBMSManager.this.autoCreateConstraints, autoCreateErrors, clr)) {
                    tableConstraintsCreated.add(t);
                }
                if (this.ddlWriter == null) continue;
                try {
                    this.ddlWriter.write("\n");
                }
                catch (IOException ioe) {
                    JPOXLogger.RDBMS_DDL.error("error writing DDL into file", ioe);
                }
            }
            return new List[]{tablesCreated, tableConstraintsCreated, autoCreateErrors};
        }

        private List[] performViewsValidation(List viewsToValidate) throws SQLException {
            ArrayList<ViewImpl> viewsCreated = new ArrayList<ViewImpl>();
            ArrayList autoCreateErrors = new ArrayList();
            Iterator i = viewsToValidate.iterator();
            while (i.hasNext()) {
                ViewImpl v = (ViewImpl)i.next();
                if (RDBMSManager.this.checkExistTablesOrViews && v.exists(this.getCurrentConnection(), RDBMSManager.this.autoCreateTables)) {
                    viewsCreated.add(v);
                }
                if (RDBMSManager.this.validateTables) {
                    v.validate(this.getCurrentConnection(), true, false, autoCreateErrors);
                }
                RDBMSManager.this.columnInfoByTableName.remove(v.getDatastoreIdentifierFullyQualified());
            }
            return new List[]{viewsCreated, autoCreateErrors};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rollbackSchemaCreation(Map schemaDataByClassPrev, MultiMap schemaDataByClassAppIDPrev, List viewsCreated, List tableConstraintsCreated, List tablesCreated) {
            if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
                JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.AddTablesRollback"));
            }
            RDBMSManager.this.storeDataByClass = schemaDataByClassPrev;
            RDBMSManager.this.storeDataByAppIdClass = schemaDataByClassAppIDPrev;
            try {
                ListIterator li;
                if (viewsCreated != null) {
                    li = viewsCreated.listIterator(viewsCreated.size());
                    while (li.hasPrevious()) {
                        ((ViewImpl)li.previous()).drop(this.getCurrentConnection());
                    }
                }
                if (tableConstraintsCreated != null) {
                    li = tableConstraintsCreated.listIterator(tableConstraintsCreated.size());
                    while (li.hasPrevious()) {
                        ((TableImpl)li.previous()).dropConstraints(this.getCurrentConnection());
                    }
                }
                if (tablesCreated != null) {
                    li = tablesCreated.listIterator(tablesCreated.size());
                    while (li.hasPrevious()) {
                        ((TableImpl)li.previous()).drop(this.getCurrentConnection());
                    }
                }
            }
            catch (Exception e) {
                JPOXLogger.RDBMS_SCHEMA.warn(LOCALISER_RDBMS.msg("RDBMS.Manager.AddTablesRollbackError", e));
            }
            if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised) {
                try {
                    if (!RDBMSManager.this.starter.isOpen()) {
                        RDBMSManager.this.starter.open();
                    }
                    Iterator schema_added_iter = this.schemaDataAdded.iterator();
                    while (schema_added_iter.hasNext()) {
                        RDBMSStoreData sd = (RDBMSStoreData)schema_added_iter.next();
                        RDBMSManager.this.starter.deleteClass(sd.getName());
                    }
                }
                finally {
                    if (RDBMSManager.this.starter.isOpen()) {
                        RDBMSManager.this.starter.close();
                    }
                }
            }
        }

        private void verifyErrors(List autoCreateErrors) {
            if (autoCreateErrors.size() > 0) {
                Iterator errorsIter = autoCreateErrors.iterator();
                while (errorsIter.hasNext()) {
                    Throwable exc = (Throwable)errorsIter.next();
                    if (RDBMSManager.this.autoCreateWarnOnError) {
                        JPOXLogger.RDBMS.warn(LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesExceptionError", exc));
                        continue;
                    }
                    JPOXLogger.RDBMS.error(LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesExceptionError", exc));
                }
                if (!RDBMSManager.this.autoCreateWarnOnError) {
                    throw new JDODataStoreException(LOCALISER_RDBMS.msg("RDBMS.Manager.AutoCreateError"), autoCreateErrors.toArray(new Throwable[autoCreateErrors.size()]));
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addClassTablesAndValidate(String[] classNames, ClassLoaderResolver clr) {
            HashMap schemaDataByClassPrev = new HashMap(RDBMSManager.this.storeDataByClass);
            MultiMap schemaDataByClassAppIDPrev = new MultiMap((Map)RDBMSManager.this.storeDataByAppIdClass);
            boolean completed = false;
            List tablesCreated = null;
            List tableConstraintsCreated = null;
            List autoCreateErrors = null;
            List viewsCreated = null;
            try {
                this.addClassTables(classNames, clr);
                List[] toValidate = this.initializeClassTables(classNames, clr);
                List[] result = this.performTablesValidation(toValidate[0], clr);
                tablesCreated = result[0];
                tableConstraintsCreated = result[1];
                autoCreateErrors = result[2];
                result = this.performViewsValidation(toValidate[1]);
                viewsCreated = result[0];
                autoCreateErrors.addAll(result[1]);
                this.verifyErrors(autoCreateErrors);
                completed = true;
                if (!completed) {
                    this.rollbackSchemaCreation(schemaDataByClassPrev, schemaDataByClassAppIDPrev, viewsCreated, tableConstraintsCreated, tablesCreated);
                }
                this.schemaDataAdded.clear();
                return;
            }
            catch (SQLException sqle) {
                try {
                    String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesExceptionError", sqle);
                    JPOXLogger.RDBMS_SCHEMA.error(msg);
                    throw new JDODataStoreException(msg, (Throwable)sqle);
                    catch (Exception e) {
                        if ((class$javax$jdo$JDOException == null ? (class$javax$jdo$JDOException = RDBMSManager.class$("javax.jdo.JDOException")) : class$javax$jdo$JDOException).isAssignableFrom(e.getClass())) {
                            throw (JDOException)((Object)e);
                        }
                        JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesExceptionError", e));
                        throw new JDOFatalInternalException(e.toString(), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    if (!completed) {
                        this.rollbackSchemaCreation(schemaDataByClassPrev, schemaDataByClassAppIDPrev, viewsCreated, tableConstraintsCreated, tablesCreated);
                    }
                    this.schemaDataAdded.clear();
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DatastoreContainerObject addJoinTableForContainer(AbstractPropertyMetaData fmd, ClassLoaderResolver clr, int type) {
            RDBMSStoreData data;
            DatastoreIdentifier tableName = RDBMSManager.this.getTableIdentifier(fmd, clr);
            JoinTable join = null;
            if (type == 1) {
                join = new SetTable(tableName, fmd, RDBMSManager.this);
            } else if (type == 2) {
                join = new ListTable(tableName, fmd, RDBMSManager.this);
            } else if (type == 3) {
                join = new MapTable(tableName, fmd, RDBMSManager.this);
            } else if (type == 4) {
                join = new ArrayTable(tableName, fmd, RDBMSManager.this);
            }
            try {
                if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised && !RDBMSManager.this.starter.isOpen()) {
                    RDBMSManager.this.starter.open();
                }
                data = new RDBMSStoreData(fmd, join);
                RDBMSManager.this.registerStoreData(data);
            }
            finally {
                if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised && RDBMSManager.this.starter.isOpen()) {
                    RDBMSManager.this.starter.close();
                }
            }
            this.schemaDataAdded.add(data);
            return join;
        }
    }

    private abstract class MgmtTransaction {
        protected final int isolationLevel;
        protected final int maxRetries;
        protected Connection conn;

        private MgmtTransaction(int isolationLevel) {
            this.isolationLevel = isolationLevel;
            this.maxRetries = RDBMSManager.this.pmfContext.getPmfConfiguration().getDatastoreClassAdditionMaxRetries();
        }

        public abstract String toString();

        protected abstract void run(ClassLoaderResolver var1) throws SQLException;

        protected Connection getCurrentConnection() throws SQLException {
            if (this.conn == null) {
                this.conn = RDBMSManager.this.getConnection(this.isolationLevel);
            }
            return this.conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute(ClassLoaderResolver clr) {
            int attempts = 0;
            while (true) {
                try {
                    try {
                        boolean succeeded = false;
                        try {
                            this.run(clr);
                            succeeded = true;
                        }
                        finally {
                            if (this.conn != null && this.isolationLevel != 0 && !this.conn.getAutoCommit()) {
                                if (succeeded) {
                                    this.conn.commit();
                                } else {
                                    this.conn.rollback();
                                }
                            }
                        }
                    }
                    finally {
                        if (this.conn != null) {
                            RDBMSManager.this.closeConnection(this.conn);
                            this.conn = null;
                        }
                    }
                }
                catch (SQLException e) {
                    if (++attempts < this.maxRetries) continue;
                    throw new JDODataStoreException("SQL exception: " + this, (Throwable)e);
                }
                break;
            }
        }
    }
}

