/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jdo.Extent;
import javax.jdo.FetchPlan;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import org.jpox.FetchPlanImpl;
import org.jpox.PersistenceManager;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.QueryNotUniqueException;
import org.jpox.store.query.QueryResult;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.util.Imports;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public abstract class Query
implements javax.jdo.Query {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    protected final transient PersistenceManager pm;
    protected final transient DatastoreAdapter dba;
    protected Class candidateClass;
    protected String candidateClassName;
    protected boolean subclasses = true;
    protected boolean unique = false;
    protected String result = null;
    protected Class resultClass = null;
    protected String resultClassName = null;
    protected String filter;
    protected String imports;
    protected String variables;
    protected String parameters;
    protected String ordering;
    protected String grouping;
    protected String range;
    protected long fromInclNo = 0L;
    protected long toExclNo = Long.MAX_VALUE;
    protected boolean unmodifiable = false;
    protected boolean ignoreCache = false;
    protected final FetchPlan fetchPlan;
    protected transient boolean isCompiled = false;
    protected transient Imports parsedImports = null;
    protected transient List parameterNames = null;
    protected transient Map parameterTypesByName = null;
    protected transient List variableNames = null;
    protected transient Map variableTypesByName = null;
    protected transient HashSet queryResults = new HashSet();
    protected transient boolean isPreCompile = true;
    protected Map extensions = null;

    public Query(PersistenceManager pm) {
        this.pm = pm;
        if (pm == null) {
            throw new JDOUserException(LOCALISER.msg("Query.NoPMSpecified"));
        }
        this.fetchPlan = ((FetchPlanImpl)pm.getFetchPlan()).getCopy();
        this.ignoreCache = pm.getIgnoreCache();
        this.dba = pm.getStoreManager() == null ? null : pm.getStoreManager().getDatastoreAdapter();
    }

    protected ClassLoader getCandidateLoader() {
        return this.candidateClass == null ? null : this.candidateClass.getClassLoader();
    }

    protected void discardCompiled() {
        this.isCompiled = false;
        this.parsedImports = null;
        this.parameterNames = null;
        this.parameterTypesByName = null;
        this.variableNames = null;
        this.variableTypesByName = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query q = (Query)obj;
        if (this.candidateClass == null ? q.candidateClass != null : !this.candidateClass.equals(q.candidateClass)) {
            return false;
        }
        if (this.filter == null ? q.filter != null : !this.filter.equals(q.filter)) {
            return false;
        }
        if (this.imports == null ? q.imports != null : !this.imports.equals(q.imports)) {
            return false;
        }
        if (this.parameters == null ? q.parameters != null : !this.parameters.equals(q.parameters)) {
            return false;
        }
        if (this.variables == null ? q.variables != null : !this.variables.equals(q.variables)) {
            return false;
        }
        if (this.unique != q.unique) {
            return false;
        }
        if (this.unmodifiable != q.unmodifiable) {
            return false;
        }
        if (this.resultClass != q.resultClass) {
            return false;
        }
        if (this.grouping == null ? q.grouping != null : !this.grouping.equals(q.grouping)) {
            return false;
        }
        return !(this.ordering == null ? q.ordering != null : !this.ordering.equals(q.ordering));
    }

    public int hashCode() {
        return (this.candidateClass == null ? 0 : this.candidateClass.hashCode()) ^ (this.result == null ? 0 : this.result.hashCode()) ^ (this.filter == null ? 0 : this.filter.hashCode()) ^ (this.imports == null ? 0 : this.imports.hashCode()) ^ (this.parameters == null ? 0 : this.parameters.hashCode()) ^ (this.variables == null ? 0 : this.variables.hashCode()) ^ (this.resultClass == null ? 0 : this.resultClass.hashCode()) ^ (this.grouping == null ? 0 : this.grouping.hashCode()) ^ (this.ordering == null ? 0 : this.ordering.hashCode()) ^ (this.range == null ? 0 : this.range.hashCode());
    }

    public StoreManager getStoreManager() {
        return this.pm.getStoreManager();
    }

    public javax.jdo.PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public void addExtension(String key, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap();
        }
        this.extensions.put(key, value);
    }

    public void setExtensions(Map extensions) {
        extensions = new HashMap(extensions);
    }

    public Object getExtension(String key) {
        return this.extensions != null ? this.extensions.get(key) : null;
    }

    public FetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public Class getCandidateClass() {
        return this.candidateClass;
    }

    public void setClass(Class candidateClass) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.candidateClassName = candidateClass != null ? candidateClass.getName() : null;
        this.candidateClass = candidateClass;
    }

    public void setCandidateClassName(String candidateClassName) {
        this.candidateClassName = candidateClassName != null ? candidateClassName.trim() : null;
    }

    public abstract void setCandidates(Extent var1);

    public abstract void setCandidates(Collection var1);

    public void setFilter(String filter) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.filter = filter != null ? filter.trim() : null;
    }

    public void declareImports(String imports) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.imports = imports != null ? imports.trim() : null;
    }

    public void declareParameters(String parameters) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.parameters = parameters != null ? parameters.trim() : null;
    }

    public void declareVariables(String variables) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.variables = variables != null ? variables.trim() : null;
    }

    public void setOrdering(String ordering) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.ordering = ordering != null ? ordering.trim() : null;
    }

    public void setGrouping(String grouping) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.grouping = grouping != null ? grouping.trim() : null;
    }

    public void setUnique(boolean unique) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.unique = unique;
    }

    public void setRange(long fromIncl, long toExcl) {
        this.discardCompiled();
        this.range = null;
        this.fromInclNo = fromIncl;
        this.toExclNo = toExcl;
    }

    public void setRange(String range) {
        this.discardCompiled();
        this.range = range != null ? range.trim() : null;
        this.fromInclNo = 0L;
        this.toExclNo = Long.MAX_VALUE;
    }

    public void setResult(String result) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.result = result != null ? result.trim() : null;
    }

    public void setResultClass(Class result_cls) {
        this.discardCompiled();
        this.resultClassName = result_cls != null ? result_cls.getName() : null;
        this.resultClass = result_cls;
    }

    public void setResultClassName(String resultClassName) {
        this.resultClassName = resultClassName;
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.discardCompiled();
        this.ignoreCache = ignoreCache;
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    public boolean isSubclasses() {
        return this.subclasses;
    }

    public void setSubclasses(boolean subclasses) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.subclasses = subclasses;
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    protected void assertIsModifiable() {
        if (this.unmodifiable) {
            throw new JDOUserException(LOCALISER.msg("Query.Unmodifiable"));
        }
    }

    public void setUnmodifiable() {
        this.unmodifiable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() {
        if (this.isCompiled) {
            return;
        }
        if (this.pm == null) {
            throw new JDOUserException(LOCALISER.msg("Query.NoPersistenceManagerError"));
        }
        boolean done = false;
        try {
            String classDecl;
            StringTokenizer t2;
            StringTokenizer t1;
            this.parsedImports = new Imports();
            if (this.candidateClassName != null) {
                this.parsedImports.importPackage(this.candidateClassName);
            }
            if (this.imports != null) {
                this.parsedImports.parseImports(this.imports);
            }
            this.parameterNames = new ArrayList();
            this.parameterTypesByName = new HashMap();
            if (this.parameters != null && this.parameters.length() > 0) {
                t1 = new StringTokenizer(this.parameters, ",");
                while (t1.hasMoreTokens()) {
                    t2 = new StringTokenizer(t1.nextToken(), " ");
                    if (t2.countTokens() != 2) {
                        throw new JDOUserException(LOCALISER.msg("Query.InvalidParameterListError", this.parameters));
                    }
                    classDecl = t2.nextToken();
                    String parameterName = t2.nextToken();
                    if (!StringUtils.isValidJavaIdentifierForJDOQL(parameterName)) {
                        throw new JDOUserException(LOCALISER.msg("Query.IllegalParameterNameError", parameterName));
                    }
                    if (this.parameterNames.contains(parameterName)) {
                        throw new JDOUserException(LOCALISER.msg("Query.DuplicateParameterNameError", parameterName));
                    }
                    this.parameterNames.add(parameterName);
                    this.parameterTypesByName.put(parameterName, this.resolveClassDeclaration(classDecl));
                }
            }
            this.variableNames = new ArrayList();
            this.variableTypesByName = new HashMap();
            if (this.variables != null && this.variables.length() > 0) {
                t1 = new StringTokenizer(this.variables, ";");
                while (t1.hasMoreTokens()) {
                    t2 = new StringTokenizer(t1.nextToken(), " ");
                    if (t2.countTokens() != 2) {
                        throw new JDOUserException(LOCALISER.msg("Query.InvalidVariableListError", this.variables));
                    }
                    classDecl = t2.nextToken();
                    String variableName = t2.nextToken();
                    if (!StringUtils.isValidJavaIdentifierForJDOQL(variableName)) {
                        throw new JDOUserException(LOCALISER.msg("Query.IllegalVariableNameError", variableName));
                    }
                    if (this.parameterNames.contains(variableName)) {
                        throw new JDOUserException(LOCALISER.msg("Query.ConflictingVariableNameError", variableName));
                    }
                    if (this.variableNames.contains(variableName)) {
                        throw new JDOUserException(LOCALISER.msg("Query.DuplicateVariableNameError", variableName));
                    }
                    this.variableNames.add(variableName);
                    this.variableTypesByName.put(variableName, this.resolveClassDeclaration(classDecl));
                }
            }
            done = true;
        }
        finally {
            if (!done) {
                this.discardCompiled();
            }
        }
    }

    public Class resolveClassDeclaration(String classDecl) {
        try {
            return this.parsedImports.resolveClassDeclaration(classDecl, this.pm.getClassLoaderResolver(), this.getCandidateLoader());
        }
        catch (ClassNotResolvedException e) {
            throw new JDOUserException(LOCALISER.msg("Query.ClassNameNotFoundError", classDecl));
        }
    }

    public Object execute() {
        return this.executeWithArray(new Object[0]);
    }

    public Object execute(Object p1) {
        return this.executeWithArray(new Object[]{p1});
    }

    public Object execute(Object p1, Object p2) {
        return this.executeWithArray(new Object[]{p1, p2});
    }

    public Object execute(Object p1, Object p2, Object p3) {
        return this.executeWithArray(new Object[]{p1, p2, p3});
    }

    public Object executeWithArray(Object[] parameterValues) {
        int i;
        this.isPreCompile = false;
        this.compile();
        HashMap<Object, Object> parameterMap = new HashMap<Object, Object>();
        if (this.parameterNames.size() > 0) {
            for (i = 0; i < parameterValues.length; ++i) {
                parameterMap.put(this.parameterNames.get(i), parameterValues[i]);
            }
        } else {
            for (i = 0; i < parameterValues.length; ++i) {
                parameterMap.put("JPOX_" + i, parameterValues[i]);
            }
        }
        Object theReturn = this.executeWithMap(parameterMap);
        this.isPreCompile = true;
        return theReturn;
    }

    protected abstract boolean shouldReturnSingleRow();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeWithMap(Map parameters) {
        boolean applyRangeChecks;
        if (this.pm.isClosed()) {
            throw new JDOFatalUserException(LOCALISER.msg("Query.PMIsClosed"));
        }
        Collection qr = this.performExecute(parameters);
        RDBMSAdapter rdba = (RDBMSAdapter)this.dba;
        boolean range_specified = this.fromInclNo >= 0L && this.toExclNo >= 0L && (this.fromInclNo != 0L || this.toExclNo != Long.MAX_VALUE);
        boolean using_limit_select_clause = rdba.getRangeByLimitSelectClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_limit_where_clause = rdba.getRangeByLimitWhereClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_rownum = rdba.getRangeByRowNumberColumn().length() > 0;
        boolean bl = applyRangeChecks = range_specified && !using_limit_select_clause && !using_limit_where_clause && !using_rownum;
        if (this.shouldReturnSingleRow()) {
            try {
                if (qr == null || qr.size() == 0) {
                    Object var9_9 = null;
                    return var9_9;
                }
                if (applyRangeChecks && this.toExclNo - this.fromInclNo <= 0L) {
                    Object var9_10 = null;
                    return var9_10;
                }
                Iterator qrIter = qr.iterator();
                Object firstRow = qrIter.next();
                if (qrIter.hasNext()) {
                    throw new QueryNotUniqueException();
                }
                Object e = firstRow;
                return e;
            }
            finally {
                if (qr != null) {
                    this.close(qr);
                }
            }
        }
        if (applyRangeChecks) {
            int i = 0;
            Iterator qr_iter = qr.iterator();
            ArrayList res = new ArrayList();
            while (qr_iter.hasNext()) {
                Object obj = qr_iter.next();
                if ((long)i >= this.fromInclNo && (long)i < this.toExclNo) {
                    res.add(obj);
                }
                ++i;
            }
            return res;
        }
        return qr;
    }

    protected abstract Collection performExecute(Map var1);

    public long deletePersistentAll() {
        return this.deletePersistentAll(new Object[0]);
    }

    public long deletePersistentAll(Object[] parameters) {
        this.isPreCompile = false;
        this.compile();
        if (parameters.length != this.parameterNames.size()) {
            throw new JDOUserException(LOCALISER.msg("Query.IncorrectNumberOfParametersError", "" + this.parameterNames.size(), "" + parameters.length));
        }
        HashMap parameterMap = new HashMap();
        for (int i = 0; i < parameters.length; ++i) {
            parameterMap.put(this.parameterNames.get(i), parameters[i]);
        }
        long theReturn = this.deletePersistentAll(parameterMap);
        this.isPreCompile = true;
        return theReturn;
    }

    public long deletePersistentAll(Map parameters) {
        if (this.result != null) {
            throw new JDOUserException(LOCALISER.msg("Query.DeletePersistent.ResultSpecifiedError"));
        }
        if (this.resultClass != null) {
            throw new JDOUserException(LOCALISER.msg("Query.DeletePersistent.ResultClassSpecifiedError"));
        }
        if (this.resultClassName != null) {
            throw new JDOUserException(LOCALISER.msg("Query.DeletePersistent.ResultClassSpecifiedError"));
        }
        if (this.ordering != null) {
            throw new JDOUserException(LOCALISER.msg("Query.DeletePersistent.OrderingSpecifiedError"));
        }
        if (this.grouping != null) {
            throw new JDOUserException(LOCALISER.msg("Query.DeletePersistent.GroupingSpecifiedError"));
        }
        if (this.range != null) {
            throw new JDOUserException(LOCALISER.msg("Query.DeletePersistent.ResultRangeSpecifiedError"));
        }
        if (this.fromInclNo >= 0L && this.toExclNo >= 0L && (this.fromInclNo != 0L || this.toExclNo != Long.MAX_VALUE)) {
            throw new JDOUserException(LOCALISER.msg("Query.DeletePersistent.ResultRangeSpecifiedError"));
        }
        long qr = this.performDeletePersistentAll(parameters);
        return qr;
    }

    protected abstract long performDeletePersistentAll(Map var1);

    public void close(Object queryResult) {
        if (queryResult != null && queryResult instanceof QueryResult) {
            ((QueryResult)queryResult).close();
            this.queryResults.remove(queryResult);
        }
    }

    public void closeAll() {
        QueryResult[] qrs = this.queryResults.toArray(new QueryResult[this.queryResults.size()]);
        for (int i = 0; i < qrs.length; ++i) {
            this.close(qrs[i]);
        }
    }
}

