/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import org.jpox.ClassNameConstants;
import org.jpox.PersistenceManager;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.expression.StringLiteral;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.SimpleDatastoreRepresentation;
import org.jpox.store.mapping.SingleFieldMapping;

public abstract class ObjectAsStringMapping
extends SingleFieldMapping
implements SimpleDatastoreRepresentation {
    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return new StringLiteral(qs, (JavaTypeMapping)this, this.objectToString(value));
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return new StringExpression(qs, this, te);
    }

    public abstract Class getJavaType();

    public String getJavaTypeForDatastoreMapping(int index) {
        return ClassNameConstants.JAVA_LANG_STRING;
    }

    public void setObject(PersistenceManager pm, Object preparedStatement, int[] exprIndex, Object value) {
        this.getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], this.objectToString(value));
    }

    public Object getObject(PersistenceManager pm, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        Object datastoreValue = this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]);
        Object value = null;
        if (datastoreValue != null) {
            value = this.stringToObject((String)datastoreValue);
        }
        return value;
    }

    protected abstract String objectToString(Object var1);

    protected abstract Object stringToObject(String var1);
}

