/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.store.OID;
import org.jpox.store.OIDFactory;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.util.JPOXLogger;

public abstract class MultiMapping
extends JavaTypeMapping {
    protected JavaTypeMapping[] javaTypeMappings = new JavaTypeMapping[0];
    private int numberOfDatastoreFields = 0;

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        JavaTypeMapping[] jtm = this.javaTypeMappings;
        this.javaTypeMappings = new JavaTypeMapping[jtm.length + 1];
        System.arraycopy(jtm, 0, this.javaTypeMappings, 0, jtm.length);
        this.javaTypeMappings[jtm.length] = mapping;
    }

    public JavaTypeMapping[] getJavaTypeMapping() {
        return this.javaTypeMappings;
    }

    public int getNumberOfDatastoreFields() {
        if (this.numberOfDatastoreFields == 0) {
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                this.numberOfDatastoreFields += this.javaTypeMappings[i].getNumberOfDatastoreFields();
            }
        }
        return this.numberOfDatastoreFields;
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        int currentIndex = 0;
        int numberJavaMappings = this.javaTypeMappings.length;
        for (int i = 0; i < numberJavaMappings; ++i) {
            int numberDatastoreMappings = this.javaTypeMappings[i].getNumberOfDatastoreFields();
            for (int j = 0; j < numberDatastoreMappings; ++j) {
                if (currentIndex == index) {
                    return this.javaTypeMappings[i].getDataStoreMapping(j);
                }
                ++currentIndex;
            }
        }
        throw new JDOFatalInternalException("Invalid index " + index + " for DataStoreMapping.");
    }

    public void setObject(PersistenceManager pm, Object ps, int[] pos, Object value) {
        this.setObject(pm, ps, pos, value, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(PersistenceManager pm, Object ps, int[] pos, Object value, StateManager ownerSM, int ownerFieldNumber) {
        ClassLoaderResolver clr = pm.getClassLoaderResolver();
        int n = 0;
        boolean foundClassAssignableFromValue = false;
        NotYetFlushedException notYetFlushed = null;
        Class type = null;
        PersistenceCapable pc = (PersistenceCapable)value;
        if (pc != null && !pm.isInserting(pc)) {
            Object id = pc.jdoGetObjectId();
            boolean requiresPersisting = false;
            if (pc.jdoIsDetached() && ownerSM != null) {
                requiresPersisting = true;
            } else if (id == null) {
                requiresPersisting = true;
            } else if ((PersistenceManager)pc.jdoGetPersistenceManager() != null && pm.getPMHandle() != ((PersistenceManager)pc.jdoGetPersistenceManager()).getPMHandle()) {
                throw new JDOUserException(LOCALISER.msg("Mapping.FieldNotAssignableIsFromAnotherPM"), id);
            }
            if (requiresPersisting) {
                PersistenceCapable pcNew = (PersistenceCapable)pm.makePersistentInternal(value, null);
                pm.flush();
                id = pcNew.jdoGetObjectId();
                if (pc.jdoIsDetached() && ownerSM != null) {
                    ownerSM.replaceField(ownerFieldNumber, pcNew);
                    int relationType = this.fmd.getRelationType(clr);
                    if (relationType == 2) {
                        StateManager relatedSM = pm.findStateManager(pcNew);
                        relatedSM.replaceField(this.fmd.getRelatedFieldMetaData(clr).getAbsoluteFieldNumber(), ownerSM.getObject());
                    } else if (relationType == 6 && JPOXLogger.JDO.isInfoEnabled()) {
                        JPOXLogger.JDO.info("PCMapping.setObject : object " + ownerSM.getInternalObjectId() + " has field " + ownerFieldNumber + " that is 1-N bidirectional - should really update the reference in the relation. Not yet supported");
                    }
                }
            }
            if (this.getNumberOfDatastoreFields() <= 0) {
                return;
            }
        }
        StateManager sm = null;
        if (value != null) {
            sm = pm.findStateManager(pc);
        }
        try {
            if (pos == null) {
                return;
            }
            if (sm != null) {
                sm.setStoringPC();
            }
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                if (n >= pos.length) {
                    n = 0;
                }
                int[] posMapping = this.javaTypeMappings[i].getReferenceMapping() != null ? new int[this.javaTypeMappings[i].getReferenceMapping().getNumberOfDatastoreFields()] : new int[this.javaTypeMappings[i].getNumberOfDatastoreFields()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = pos[n++];
                }
                try {
                    type = pm.getStoreManager().getMetaDataManager().getMetaDataForInterface(clr.classForName(this.getType()), clr) != null ? clr.classForName(this.getType()) : clr.classForName(this.javaTypeMappings[i].getType());
                    if (value != null && type.isAssignableFrom(value.getClass())) {
                        foundClassAssignableFromValue = true;
                        this.javaTypeMappings[i].setObject(pm, ps, posMapping, value);
                        continue;
                    }
                    this.javaTypeMappings[i].setObject(pm, ps, posMapping, null);
                    continue;
                }
                catch (NotYetFlushedException e) {
                    notYetFlushed = e;
                }
            }
            if (notYetFlushed != null) {
                throw notYetFlushed;
            }
        }
        finally {
            if (sm != null) {
                sm.unsetStoringPC();
            }
        }
        if (value != null && !foundClassAssignableFromValue) {
            throw new ClassCastException(LOCALISER.msg("ReferenceMapping.NotValidImplementation", this.fmd != null ? this.fmd.getFullFieldName() : "", type.getName(), value.getClass().getName()));
        }
    }

    public Object getObject(PersistenceManager pm, Object rs, int[] pos) {
        int n = 0;
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            if (n >= pos.length) {
                n = 0;
            }
            int[] posMapping = this.javaTypeMappings[i].getReferenceMapping() != null ? new int[this.javaTypeMappings[i].getReferenceMapping().getNumberOfDatastoreFields()] : new int[this.javaTypeMappings[i].getNumberOfDatastoreFields()];
            for (int j = 0; j < posMapping.length; ++j) {
                posMapping[j] = pos[n++];
            }
            Object value = null;
            try {
                value = this.javaTypeMappings[i].getObject(pm, rs, posMapping);
            }
            catch (NullValueException e) {
            }
            catch (JDOObjectNotFoundException e) {
                // empty catch block
            }
            if (value == null) continue;
            if (value instanceof OID) {
                String className = this.javaTypeMappings[i].getReferenceMapping() != null ? this.javaTypeMappings[i].getReferenceMapping().getDataStoreMapping(0).getDatastoreField().getStoredJavaType() : this.javaTypeMappings[i].getDataStoreMapping(0).getDatastoreField().getStoredJavaType();
                value = OIDFactory.getInstance(className, ((OID)value).keyValue());
                return pm.getObjectById(value, false);
            }
            if (!pm.getClassLoaderResolver().classForName(this.getType()).isAssignableFrom(value.getClass())) continue;
            return value;
        }
        return null;
    }
}

