/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import org.jpox.ClassLoaderResolver;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.DatastoreObject;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.table.CollectionTable;

public class Mappings {
    public static void selectMapping(QueryExpression qs, StatementExpressionIndex[] statementExpressionIndex) {
        Mappings.selectMapping(qs, null, statementExpressionIndex);
    }

    public static void selectMapping(QueryExpression qs, DatastoreIdentifier tableIdentifier, StatementExpressionIndex[] statementExpressionIndex) {
        if (statementExpressionIndex == null) {
            return;
        }
        for (int i = 0; i < statementExpressionIndex.length; ++i) {
            JavaTypeMapping m;
            if (statementExpressionIndex[i] == null || (m = statementExpressionIndex[i].getMapping()) == null) continue;
            if (m.getNumberOfDatastoreFields() > 0) {
                int[] columnNumbersByField = tableIdentifier != null ? qs.select(tableIdentifier, m, true) : qs.select(m, true);
                statementExpressionIndex[i].setExpressionIndex(columnNumbersByField);
                continue;
            }
            Mappings.setStatementExpressionForFieldWithNoDatastoreColumns(qs, tableIdentifier, m, statementExpressionIndex[i]);
        }
    }

    private static void setStatementExpressionForFieldWithNoDatastoreColumns(QueryExpression qs, DatastoreIdentifier tableIdentifier, JavaTypeMapping m, StatementExpressionIndex statementExpressionIndex) {
        ClassLoaderResolver clr;
        AbstractPropertyMetaData fmd = m.getFieldMetaData();
        int relationType = fmd.getRelationType(clr = qs.getClassLoaderResolver());
        if (relationType == 2) {
            if (fmd.getMappedBy() != null) {
                ScalarExpression targetExpr;
                StoreManager storeMgr = qs.getStoreManager();
                DatastoreClass sourceTable = storeMgr.getDatastoreClass(fmd.getTypeName(), qs.getClassLoaderResolver());
                JavaTypeMapping sourceMapping = sourceTable.getFieldMapping(fmd.getMappedBy());
                DatastoreIdentifier sourceTableIdentifier = storeMgr.getIdentifierFactory().newIdentifier(0, "SOURCECLASS" + fmd.getAbsoluteFieldNumber());
                LogicSetExpression sourceTableExpr = qs.newTableExpression(sourceTable, sourceTableIdentifier, true)[0];
                ScalarExpression sourceExpr = sourceMapping.newScalarExpression(qs, sourceTableExpr);
                if (tableIdentifier != null) {
                    LogicSetExpression targetTableExpr = qs.getTableExpression(tableIdentifier) == null ? qs.newTableExpression(m.getDatastoreContainer(), tableIdentifier) : qs.getTableExpression(tableIdentifier);
                    targetExpr = m.getDatastoreContainer().getIDMapping().newScalarExpression(qs, targetTableExpr);
                } else {
                    targetExpr = m.getDatastoreContainer().getIDMapping().newScalarExpression(qs, qs.getDefaultTableExpression());
                }
                qs.leftOuterJoin(sourceExpr, targetExpr, sourceTableExpr, true, true);
                int[] columnNumbersByField = qs.select(sourceTableIdentifier, sourceTable.getIDMapping(), true);
                statementExpressionIndex.setExpressionIndex(columnNumbersByField);
            }
        } else if (relationType == 6) {
            AbstractPropertyMetaData relatedFmd = fmd.getRelatedFieldMetaData(clr);
            if (fmd.getJoinMetaData() != null || relatedFmd.getJoinMetaData() != null) {
                StoreManager storeMgr = qs.getStoreManager();
                DatastoreContainerObject joinTable = storeMgr.getDatastoreContainerObject(relatedFmd);
                JavaTypeMapping referenceMapping = null;
                JavaTypeMapping selectMapping = null;
                CollectionTable collTable = (CollectionTable)joinTable;
                referenceMapping = collTable.getElementMapping();
                selectMapping = collTable.getOwnerMapping();
                DatastoreObject mainTable = qs.getDefaultTableExpression().getMainTable();
                if (!mainTable.equals(joinTable)) {
                    DatastoreIdentifier joinTableIdentifier = storeMgr.getIdentifierFactory().newIdentifier(0, "JOINTABLE" + fmd.getAbsoluteFieldNumber());
                    LogicSetExpression table_expr_sub = qs.newTableExpression(joinTable, joinTableIdentifier, true)[0];
                    ScalarExpression subExpr = referenceMapping.newScalarExpression(qs, table_expr_sub);
                    ScalarExpression schExpr = null;
                    if (tableIdentifier != null) {
                        LogicSetExpression targetTableExpr = qs.getTableExpression(tableIdentifier) == null ? qs.newTableExpression(m.getDatastoreContainer(), tableIdentifier) : qs.getTableExpression(tableIdentifier);
                        schExpr = m.getDatastoreContainer().getIDMapping().newScalarExpression(qs, targetTableExpr);
                    } else {
                        schExpr = m.getDatastoreContainer().getIDMapping().newScalarExpression(qs, qs.getDefaultTableExpression());
                    }
                    qs.leftOuterJoin(subExpr, schExpr, table_expr_sub, true, true);
                    int[] columnNumbersByField = qs.select(joinTableIdentifier, selectMapping, true);
                    statementExpressionIndex.setExpressionIndex(columnNumbersByField);
                } else {
                    int[] columnNumbersByField = qs.select(selectMapping, true);
                    statementExpressionIndex.setExpressionIndex(columnNumbersByField);
                }
            }
        }
    }

    public static int[] getParametersIndex(int initialPosition, JavaTypeMapping mapping) {
        if (mapping.getNumberOfDatastoreFields() < 1) {
            return new int[]{initialPosition};
        }
        int[] parameter = new int[mapping.getNumberOfDatastoreFields()];
        for (int i = 0; i < parameter.length; ++i) {
            parameter[i] = initialPosition + i;
        }
        return parameter;
    }
}

