/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.StateManager;
import org.jpox.sco.SCO;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.MapExpression;
import org.jpox.store.expression.MapLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.AbstractContainerMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.rdbms.scostore.FKMapStore;
import org.jpox.store.scostore.MapStore;

public class MapMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    static /* synthetic */ Class class$org$jpox$sco$Map;

    public synchronized MapStore getBackingStore(ClassLoaderResolver clr) {
        if (this.containerIsStoredInSingleColumn()) {
            return null;
        }
        if (this.contentsStore == null) {
            this.contentsStore = this.storeMgr.getBackingStoreForMap(this.fmd, this.contentsTable, clr);
        }
        return (MapStore)this.contentsStore;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MapMapping sm = (MapMapping)obj;
        return this.fmd.equals(sm.fmd) && this.storeMgr.equals(sm.storeMgr);
    }

    public Class getJavaType() {
        return class$org$jpox$sco$Map == null ? (class$org$jpox$sco$Map = MapMapping.class$("org.jpox.sco.Map")) : class$org$jpox$sco$Map;
    }

    public void postInsert(StateManager sm) {
        Map value = (Map)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null) {
                this.validateElementsForWriting(sm, value.keySet());
                this.validateElementsForWriting(sm, value.values());
            }
            return;
        }
        if (value == null) {
            sm.replaceField(this.fmd.getAbsoluteFieldNumber(), this.newWrapper(sm, this.fieldName));
            return;
        }
        this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver()).putAll(sm, value);
        sm.replaceField(this.fmd.getAbsoluteFieldNumber(), this.newWrapper(sm, this.fieldName));
    }

    public void postUpdate(StateManager sm) {
        Map value = (Map)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null) {
                this.validateElementsForWriting(sm, value.keySet());
                this.validateElementsForWriting(sm, value.values());
            }
            return;
        }
        if (value == null) {
            sm.replaceField(this.fmd.getAbsoluteFieldNumber(), this.newWrapper(sm, this.fieldName));
            return;
        }
        if (value instanceof SCO) {
            SCO sco = (SCO)((Object)value);
            if (sm.getObject() == sco.getOwner() && this.fieldName.equals(sco.getFieldName())) {
                return;
            }
            if (sco.getOwner() != null) {
                throw new JDOFatalInternalException("Owned second-class object was somehow assigned to a field other than its owner's");
            }
        }
        this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver()).clear(sm);
        this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver()).putAll(sm, value);
        sm.replaceField(this.fmd.getAbsoluteFieldNumber(), this.newWrapper(sm, this.fieldName));
    }

    public void preDelete(StateManager sm) {
    }

    public void deleteDependent(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        sm.isLoaded(sm.getObject(), this.fmd.getAbsoluteFieldNumber());
        Map value = (Map)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (value != null && !value.isEmpty()) {
            if (this.fmd.getMap().isDependentValue() || this.fmd.getMap().isDependentKey()) {
                HashMap m = new HashMap();
                m.putAll(value);
                this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver()).clear(sm);
                Iterator it = m.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Object val = entry.getValue();
                    Object key = entry.getKey();
                    if (this.fmd.getMap().isDependentKey() && key instanceof PersistenceCapable) {
                        if (this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver()) instanceof FKMapStore && val instanceof PersistenceCapable) {
                            ((FKMapStore)this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver())).clearKeyOfValue(sm, key, val);
                        }
                        sm.getPersistenceManager().deletePersistent(key);
                    }
                    if (!this.fmd.getMap().isDependentValue() || !(val instanceof PersistenceCapable)) continue;
                    sm.getPersistenceManager().deletePersistent(val);
                }
            } else {
                this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver()).clear(sm);
            }
        }
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new JDOFatalUserException(LOCALISER.msg("ContainerMapping.QueryInvalidIfSerialised", this.fmd.getFullFieldName()));
        }
        return new MapLiteral(qs, (JavaTypeMapping)this, (Map)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new JDOFatalUserException(LOCALISER.msg("ContainerMapping.QueryInvalidIfSerialised", this.fmd.getFullFieldName()));
        }
        return new MapExpression(qs, this.datastoreContainer.getIDMapping(), te, this.getBackingStore(qs.getClassLoaderResolver()), this.fieldName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

