/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import javax.jdo.JDOObjectNotFoundException;
import org.jpox.PersistenceManager;
import org.jpox.store.OID;
import org.jpox.store.OIDFactory;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.util.StringUtils;

public class InterfaceMapping
extends ReferenceMapping {
    private String implementationClasses;

    public void setImplementationClasses(String implementationClasses) {
        this.implementationClasses = implementationClasses;
    }

    public Object getObject(PersistenceManager pm, Object rs, int[] pos) {
        if (pm.getMetaDataManager().isPersistentInterface(this.type)) {
            String[] implTypes = null;
            implTypes = this.implementationClasses != null ? StringUtils.split(this.implementationClasses, ",") : pm.getMetaDataManager().getClassesImplementingInterface(this.getType(), pm.getClassLoaderResolver());
            int n = 0;
            for (int i = 0; i < implTypes.length; ++i) {
                int j;
                JavaTypeMapping mapping;
                if (implTypes.length > this.javaTypeMappings.length) {
                    PersistenceCapableMapping m = (PersistenceCapableMapping)this.javaTypeMappings[0];
                    mapping = this.dba.getMapping(pm.getClassLoaderResolver().classForName(implTypes[i]), pm.getStoreManager());
                    for (j = 0; j < m.getDataStoreMappings().length; ++j) {
                        mapping.addDataStoreMapping(m.getDataStoreMappings()[j]);
                    }
                    for (j = 0; j < m.getJavaTypeMapping().length; ++j) {
                        ((PersistenceCapableMapping)mapping).addJavaTypeMapping(m.getJavaTypeMapping()[j]);
                    }
                    ((PersistenceCapableMapping)mapping).setReferenceMapping(m.getReferenceMapping());
                } else {
                    mapping = this.javaTypeMappings[i];
                }
                if (n >= pos.length) {
                    n = 0;
                }
                int[] posMapping = mapping.getReferenceMapping() != null ? new int[mapping.getReferenceMapping().getNumberOfDatastoreFields()] : new int[mapping.getNumberOfDatastoreFields()];
                for (j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = pos[n++];
                }
                Object value = null;
                try {
                    value = mapping.getObject(pm, rs, posMapping);
                }
                catch (NullValueException e) {
                }
                catch (JDOObjectNotFoundException e) {
                    // empty catch block
                }
                if (value == null) continue;
                if (value instanceof OID) {
                    String className = mapping.getReferenceMapping() != null ? mapping.getReferenceMapping().getDataStoreMapping(0).getDatastoreField().getStoredJavaType() : mapping.getDataStoreMapping(0).getDatastoreField().getStoredJavaType();
                    value = OIDFactory.getInstance(className, ((OID)value).keyValue());
                    return pm.getObjectById(value, false);
                }
                if (!pm.getClassLoaderResolver().classForName(this.getType()).isAssignableFrom(value.getClass())) continue;
                return value;
            }
            return null;
        }
        return super.getObject(pm, rs, pos);
    }
}

