/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import java.lang.reflect.Array;
import java.util.List;
import javax.jdo.JDOFatalUserException;
import org.jpox.ClassLoaderResolver;
import org.jpox.StateManager;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.store.expression.ArrayExpression;
import org.jpox.store.expression.ArrayLiteral;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.AbstractContainerMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.scostore.ArrayStore;

public class ArrayMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    private static Byte mappingSampleValue = new Byte("0");

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ArrayMapping sm = (ArrayMapping)obj;
        return this.fmd.equals(sm.fmd) && this.storeMgr.equals(sm.storeMgr);
    }

    public Class getJavaType() {
        if (this.fmd != null) {
            return this.fmd.getType();
        }
        return null;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return mappingSampleValue;
    }

    public synchronized ArrayStore getBackingStore(ClassLoaderResolver clr) {
        if (this.containerIsStoredInSingleColumn()) {
            return null;
        }
        if (this.contentsStore == null) {
            this.contentsStore = this.storeMgr.getBackingStoreForArray(this.fmd, this.contentsTable, clr);
        }
        return (ArrayStore)this.contentsStore;
    }

    protected boolean containerIsStoredInSingleColumn() {
        if (super.containerIsStoredInSingleColumn()) {
            return true;
        }
        return this.fmd != null && this.fmd.hasArray() && this.fmd.getJoinMetaData() == null && MetaDataUtils.arrayStorableAsByteArrayInSingleColumn(this.fmd);
    }

    public void postInsert(StateManager sm) {
        Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            this.validateElementsForWriting(sm, value);
            return;
        }
        if (value == null) {
            return;
        }
        this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver()).set(sm, value);
    }

    public void postFetch(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        List elements = this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver()).getArray(sm);
        if (elements != null) {
            boolean primitiveArray = this.fmd.getType().getComponentType().isPrimitive();
            Object array = Array.newInstance(this.fmd.getType().getComponentType(), elements.size());
            for (int i = 0; i < elements.size(); ++i) {
                Object element = elements.get(i);
                if (primitiveArray) {
                    if (element instanceof Boolean) {
                        Array.setBoolean(array, i, (Boolean)element);
                        continue;
                    }
                    if (element instanceof Byte) {
                        Array.setByte(array, i, (Byte)element);
                        continue;
                    }
                    if (element instanceof Character) {
                        Array.setChar(array, i, ((Character)element).charValue());
                        continue;
                    }
                    if (element instanceof Double) {
                        Array.setDouble(array, i, (Double)element);
                        continue;
                    }
                    if (element instanceof Float) {
                        Array.setFloat(array, i, ((Float)element).floatValue());
                        continue;
                    }
                    if (element instanceof Integer) {
                        Array.setInt(array, i, (Integer)element);
                        continue;
                    }
                    if (element instanceof Long) {
                        Array.setLong(array, i, (Long)element);
                        continue;
                    }
                    if (!(element instanceof Short)) continue;
                    Array.setShort(array, i, (Short)element);
                    continue;
                }
                Array.set(array, i, element);
            }
            if (elements.size() == 0) {
                sm.replaceField(this.fmd.getAbsoluteFieldNumber(), null);
            } else {
                sm.replaceField(this.fmd.getAbsoluteFieldNumber(), array);
            }
        } else {
            sm.replaceField(this.fmd.getAbsoluteFieldNumber(), null);
        }
    }

    public void postUpdate(StateManager sm) {
        Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            this.validateElementsForWriting(sm, value);
            return;
        }
        if (value == null) {
            this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver()).clear(sm);
            return;
        }
        this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver()).clear(sm);
        this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver()).set(sm, value);
    }

    public void preDelete(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        this.getBackingStore(sm.getPersistenceManager().getClassLoaderResolver()).clear(sm);
    }

    public void deleteDependent(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new JDOFatalUserException(LOCALISER.msg("ArrayMapping.QueryInvalidIfSingleColumn", this.fmd.getFullFieldName()));
        }
        return new ArrayLiteral(qs, (JavaTypeMapping)this, value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new JDOFatalUserException(LOCALISER.msg("ArrayMapping.QueryInvalidIfSingleColumn", this.fmd.getFullFieldName()));
        }
        return new ArrayExpression(qs, this.datastoreContainer.getIDMapping(), te, this.getBackingStore(qs.getClassLoaderResolver()), this.fieldName);
    }
}

