/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import javax.jdo.spi.PersistenceCapable;
import org.jpox.PersistenceManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.util.Localiser;

class AppIDObjectIdFieldConsumer
implements PersistenceCapable.ObjectIdFieldConsumer {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    private int[] params;
    private int nextParam;
    private PersistenceManager pm;
    private Object statement;
    private JavaTypeMapping[] javaTypeMappings;
    private int mappingNum = 0;

    public AppIDObjectIdFieldConsumer(int[] param, PersistenceManager pm, Object statement, JavaTypeMapping[] javaTypeMappings) {
        this.params = param;
        this.nextParam = 0;
        this.pm = pm;
        this.statement = statement;
        int numMappings = 0;
        for (int i = 0; i < javaTypeMappings.length; ++i) {
            if (javaTypeMappings[i] instanceof PersistenceCapableMapping) {
                numMappings += ((PersistenceCapableMapping)javaTypeMappings[i]).getJavaTypeMapping().length;
                continue;
            }
            ++numMappings;
        }
        this.javaTypeMappings = new JavaTypeMapping[numMappings];
        int mappingNum = 0;
        for (int i = 0; i < javaTypeMappings.length; ++i) {
            if (javaTypeMappings[i] instanceof PersistenceCapableMapping) {
                PersistenceCapableMapping m = (PersistenceCapableMapping)javaTypeMappings[i];
                JavaTypeMapping[] subMappings = m.getJavaTypeMapping();
                for (int j = 0; j < subMappings.length; ++j) {
                    this.javaTypeMappings[mappingNum++] = subMappings[j];
                }
                continue;
            }
            this.javaTypeMappings[mappingNum++] = javaTypeMappings[i];
        }
    }

    private int[] getParamsForField(JavaTypeMapping mapping) {
        if (this.javaTypeMappings.length == 1) {
            return this.params;
        }
        int numCols = mapping.getNumberOfDatastoreFields();
        int[] fieldParams = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            fieldParams[i] = this.params[this.nextParam++];
        }
        return fieldParams;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setBoolean(this.pm, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeByteField(int fieldNumber, byte value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setByte(this.pm, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeCharField(int fieldNumber, char value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setChar(this.pm, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeDoubleField(int fieldNumber, double value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setDouble(this.pm, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setFloat(this.pm, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeIntField(int fieldNumber, int value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setInt(this.pm, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeLongField(int fieldNumber, long value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setLong(this.pm, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeShortField(int fieldNumber, short value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setShort(this.pm, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeStringField(int fieldNumber, String value) {
        JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
        mapping.setString(this.pm, this.statement, this.getParamsForField(mapping), value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        if (value instanceof PersistenceCapable) {
            PersistenceCapable pc = (PersistenceCapable)value;
            pc.jdoCopyKeyFieldsFromObjectId((PersistenceCapable.ObjectIdFieldConsumer)this, pc.jdoGetObjectId());
        } else {
            JavaTypeMapping mapping = this.javaTypeMappings[this.mappingNum++];
            mapping.setObject(this.pm, this.statement, this.getParamsForField(mapping), value);
        }
    }
}

