/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.TypeManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.plugin.PluginManager;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NoTableManagedException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingFactory;
import org.jpox.store.mapping.MappingManager;
import org.jpox.store.mapping.SimpleDatastoreRepresentation;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public abstract class AbstractMappingManager
implements MappingManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$org$jpox$store$mapping$SerialisedPCMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$EmbeddedPCMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$PersistenceCapableMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$SerialisedReferenceMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$InterfaceMapping;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$jpox$store$mapping$ObjectMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$ArrayMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$SerialisedMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$SerialisedElementPCMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$EmbeddedElementPCMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$SerialisedKeyPCMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$EmbeddedKeyPCMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$SerialisedValuePCMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$EmbeddedValuePCMapping;

    public abstract void loadDatastoreMapping(PluginManager var1, ClassLoaderResolver var2, String var3);

    public JavaTypeMapping getMapping(Class c, boolean serialised, boolean embedded, String fieldName, DatastoreAdapter dba, TypeManager typeMgr) {
        Class mc = this.getMappingClass(c, serialised, embedded, fieldName, typeMgr);
        JavaTypeMapping m = MappingFactory.createMapping(mc = this.getOverrideMappingClass(mc, null), dba, c.getName());
        if (m == null) {
            String name = mc.getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            throw new JDOUserException(LOCALISER.msg("Mapping.MappingFieldError", name));
        }
        return m;
    }

    public JavaTypeMapping getMapping(Class c, boolean serialised, boolean embedded, StoreManager storeMgr, ClassLoaderResolver clr, DatastoreAdapter dba) {
        JavaTypeMapping m;
        block3: {
            try {
                DatastoreClass datastoreClass = storeMgr.getDatastoreClass(c.getName(), clr);
                m = datastoreClass.getIDMapping();
            }
            catch (NoTableManagedException ex) {
                Class mc = this.getMappingClass(c, serialised, embedded, null, storeMgr.getPMFContext().getTypeManager());
                mc = this.getOverrideMappingClass(mc, null);
                m = MappingFactory.createMapping(mc, dba, c.getName());
                if (m == null) {
                    String name = mc.getName();
                    name = name.substring(name.lastIndexOf(46) + 1);
                    throw new JDOUserException(LOCALISER.msg("Mapping.MappingFieldError", name));
                }
                if (!(m instanceof SimpleDatastoreRepresentation)) break block3;
                this.createDatastoreMapping(m, storeMgr, null, m.getJavaTypeForDatastoreMapping(0));
            }
        }
        return m;
    }

    public JavaTypeMapping getMapping(DatastoreContainerObject datastoreContainer, AbstractPropertyMetaData fmd, DatastoreAdapter dba, ClassLoaderResolver clr, int mappingFieldType) {
        Class mc = null;
        String userMappingClassName = fmd.getValueForExtension("mapping-class");
        if (userMappingClassName != null) {
            try {
                mc = clr.classForName(userMappingClassName);
            }
            catch (JDOException jdoe) {
                throw new JDOFatalUserException(LOCALISER.msg("Mapping.UserMappingClassNotFound", userMappingClassName));
            }
        } else if (mappingFieldType == 1 || mappingFieldType == 2) {
            mc = this.getElementMappingClass(datastoreContainer, fmd, dba, clr);
        } else if (mappingFieldType == 3) {
            mc = this.getKeyMappingClass(datastoreContainer, fmd, dba, clr);
        } else if (mappingFieldType == 4) {
            mc = this.getValueMappingClass(datastoreContainer, fmd, dba, clr);
        } else {
            AbstractClassMetaData acmd = null;
            acmd = fmd.getType().isInterface() ? datastoreContainer.getStoreManager().getMetaDataManager().getMetaDataForInterface(fmd.getType(), clr) : datastoreContainer.getStoreManager().getMetaDataManager().getMetaDataForClass(fmd.getType(), clr);
            TypeManager typeMgr = datastoreContainer.getStoreManager().getPMFContext().getTypeManager();
            mc = fmd.isSerialized() ? this.getMappingClass(fmd.getType(), true, false, fmd.getFullFieldName(), typeMgr) : (fmd.getEmbeddedMetaData() != null ? this.getMappingClass(fmd.getType(), false, true, fmd.getFullFieldName(), typeMgr) : (acmd != null && acmd.isEmbeddedOnly() ? this.getMappingClass(fmd.getType(), false, true, fmd.getFullFieldName(), typeMgr) : (fmd.isEmbedded() ? this.getMappingClass(fmd.getType(), true, false, fmd.getFullFieldName(), typeMgr) : this.getMappingClass(fmd.getType(), false, false, fmd.getFullFieldName(), typeMgr))));
        }
        mc = this.getOverrideMappingClass(mc, fmd);
        JavaTypeMapping m = MappingFactory.createMapping(mc, dba, fmd, datastoreContainer, clr);
        if (m == null) {
            throw new JDOFatalInternalException(LOCALISER.msg("Mapping.ConstructorMissing", mc.getName()));
        }
        return m;
    }

    protected Class getOverrideMappingClass(Class mappingClass, AbstractPropertyMetaData fmd) {
        return mappingClass;
    }

    protected Class getMappingClass(Class c, boolean serialised, boolean embedded, String fieldName, TypeManager typeMgr) {
        Class superClass;
        Class mappingClass;
        if ((class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = AbstractMappingManager.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(c)) {
            if (serialised) {
                return class$org$jpox$store$mapping$SerialisedPCMapping == null ? (class$org$jpox$store$mapping$SerialisedPCMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedPCMapping")) : class$org$jpox$store$mapping$SerialisedPCMapping;
            }
            if (embedded) {
                return class$org$jpox$store$mapping$EmbeddedPCMapping == null ? (class$org$jpox$store$mapping$EmbeddedPCMapping = AbstractMappingManager.class$("org.jpox.store.mapping.EmbeddedPCMapping")) : class$org$jpox$store$mapping$EmbeddedPCMapping;
            }
            return class$org$jpox$store$mapping$PersistenceCapableMapping == null ? (class$org$jpox$store$mapping$PersistenceCapableMapping = AbstractMappingManager.class$("org.jpox.store.mapping.PersistenceCapableMapping")) : class$org$jpox$store$mapping$PersistenceCapableMapping;
        }
        if (c.isInterface() && !typeMgr.isSupportedType(c.getName())) {
            if (serialised) {
                return class$org$jpox$store$mapping$SerialisedReferenceMapping == null ? (class$org$jpox$store$mapping$SerialisedReferenceMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedReferenceMapping")) : class$org$jpox$store$mapping$SerialisedReferenceMapping;
            }
            if (embedded) {
                return class$org$jpox$store$mapping$EmbeddedPCMapping == null ? (class$org$jpox$store$mapping$EmbeddedPCMapping = AbstractMappingManager.class$("org.jpox.store.mapping.EmbeddedPCMapping")) : class$org$jpox$store$mapping$EmbeddedPCMapping;
            }
            return class$org$jpox$store$mapping$InterfaceMapping == null ? (class$org$jpox$store$mapping$InterfaceMapping = AbstractMappingManager.class$("org.jpox.store.mapping.InterfaceMapping")) : class$org$jpox$store$mapping$InterfaceMapping;
        }
        if (c == (class$java$lang$Object == null ? (class$java$lang$Object = AbstractMappingManager.class$("java.lang.Object")) : class$java$lang$Object)) {
            if (serialised) {
                return class$org$jpox$store$mapping$SerialisedReferenceMapping == null ? (class$org$jpox$store$mapping$SerialisedReferenceMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedReferenceMapping")) : class$org$jpox$store$mapping$SerialisedReferenceMapping;
            }
            if (embedded) {
                throw new JDOFatalUserException(LOCALISER.msg("ObjectMapping.EmbeddedNotSupported", fieldName));
            }
            return class$org$jpox$store$mapping$ObjectMapping == null ? (class$org$jpox$store$mapping$ObjectMapping = AbstractMappingManager.class$("org.jpox.store.mapping.ObjectMapping")) : class$org$jpox$store$mapping$ObjectMapping;
        }
        if (c.isArray()) {
            if ((class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = AbstractMappingManager.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(c.getComponentType())) {
                return class$org$jpox$store$mapping$ArrayMapping == null ? (class$org$jpox$store$mapping$ArrayMapping = AbstractMappingManager.class$("org.jpox.store.mapping.ArrayMapping")) : class$org$jpox$store$mapping$ArrayMapping;
            }
            if (c.getComponentType().isInterface() && !typeMgr.isSupportedType(c.getComponentType().getName())) {
                return class$org$jpox$store$mapping$ArrayMapping == null ? (class$org$jpox$store$mapping$ArrayMapping = AbstractMappingManager.class$("org.jpox.store.mapping.ArrayMapping")) : class$org$jpox$store$mapping$ArrayMapping;
            }
            if (c.getComponentType() == (class$java$lang$Object == null ? (class$java$lang$Object = AbstractMappingManager.class$("java.lang.Object")) : class$java$lang$Object)) {
                return class$org$jpox$store$mapping$ArrayMapping == null ? (class$org$jpox$store$mapping$ArrayMapping = AbstractMappingManager.class$("org.jpox.store.mapping.ArrayMapping")) : class$org$jpox$store$mapping$ArrayMapping;
            }
        }
        if ((mappingClass = this.getDefaultJavaTypeMapping(typeMgr, c.getName())) == null) {
            for (superClass = c.getSuperclass(); superClass != null && !superClass.getName().equals(ClassNameConstants.OBJECT) && mappingClass == null; superClass = superClass.getSuperclass()) {
                mappingClass = this.getDefaultJavaTypeMapping(typeMgr, superClass.getName());
            }
        }
        if (mappingClass == null) {
            if (typeMgr.isSupportedType(c.getName())) {
                throw new JDOUnsupportedOptionException(LOCALISER.msg("MappingManager.NoMappingForJavaTypeField", fieldName, c.getName()));
            }
            for (superClass = c; superClass != null && !superClass.getName().equals(ClassNameConstants.OBJECT) && mappingClass == null; superClass = superClass.getSuperclass()) {
                Class<?>[] interfaces = superClass.getInterfaces();
                for (int i = 0; i < interfaces.length && mappingClass == null; ++i) {
                    mappingClass = this.getDefaultJavaTypeMapping(typeMgr, interfaces[i].getName());
                }
            }
            if (mappingClass == null) {
                mappingClass = class$org$jpox$store$mapping$SerialisedMapping == null ? (class$org$jpox$store$mapping$SerialisedMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedMapping")) : class$org$jpox$store$mapping$SerialisedMapping;
            }
        }
        return mappingClass;
    }

    protected Class getElementMappingClass(DatastoreContainerObject container, AbstractPropertyMetaData fmd, DatastoreAdapter dba, ClassLoaderResolver clr) {
        if (!fmd.hasCollection() && !fmd.hasArray()) {
            throw new JDOFatalInternalException("Attempt to get element mapping for field " + fmd.getFullFieldName() + " that has no collection/array!");
        }
        if (fmd.getJoinMetaData() == null) {
            throw new JDOFatalInternalException("Attempt to get element mapping for field " + fmd.getFullFieldName() + " that has no join table defined for the collection/array");
        }
        boolean serialised = fmd.hasCollection() && fmd.getCollection().isSerializedElement() || fmd.hasArray() && fmd.getArray().isSerializedElement();
        boolean embedded = fmd.hasCollection() && fmd.getCollection().isEmbeddedElement() || fmd.hasArray() && fmd.getArray().isEmbeddedElement();
        boolean elementPC = fmd.hasCollection() && fmd.getCollection().getElementClassMetaData() != null || fmd.hasArray() && fmd.getArray().getElementClassMetaData() != null;
        TypeManager typeMgr = fmd.getMetaDataManager().getPMFContext().getTypeManager();
        Class elementCls = null;
        if (fmd.hasCollection()) {
            elementCls = clr.classForName(fmd.getCollection().getElementType());
        } else if (fmd.hasArray()) {
            elementCls = clr.classForName(fmd.getArray().getElementType());
        }
        boolean elementReference = typeMgr.isReferenceType(elementCls);
        Class mc = null;
        if (serialised && elementPC) {
            mc = class$org$jpox$store$mapping$SerialisedElementPCMapping == null ? (class$org$jpox$store$mapping$SerialisedElementPCMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedElementPCMapping")) : class$org$jpox$store$mapping$SerialisedElementPCMapping;
        } else if (serialised && elementReference) {
            mc = class$org$jpox$store$mapping$SerialisedReferenceMapping == null ? (class$org$jpox$store$mapping$SerialisedReferenceMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedReferenceMapping")) : class$org$jpox$store$mapping$SerialisedReferenceMapping;
        } else if (serialised) {
            mc = class$org$jpox$store$mapping$SerialisedMapping == null ? (class$org$jpox$store$mapping$SerialisedMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedMapping")) : class$org$jpox$store$mapping$SerialisedMapping;
        } else if (embedded) {
            mc = class$org$jpox$store$mapping$EmbeddedElementPCMapping == null ? (class$org$jpox$store$mapping$EmbeddedElementPCMapping = AbstractMappingManager.class$("org.jpox.store.mapping.EmbeddedElementPCMapping")) : class$org$jpox$store$mapping$EmbeddedElementPCMapping;
        } else {
            throw new JDOFatalInternalException("Attempt to get element mapping for field " + fmd.getFullFieldName() + " when not embedded or serialised - please report this to JPOX developers");
        }
        return mc;
    }

    protected Class getKeyMappingClass(DatastoreContainerObject container, AbstractPropertyMetaData fmd, DatastoreAdapter dba, ClassLoaderResolver clr) {
        if (fmd.getMap() == null) {
            throw new JDOFatalInternalException("Attempt to get key mapping for field that has no map!");
        }
        boolean serialised = fmd.hasMap() && fmd.getMap().isSerializedKey();
        boolean embedded = fmd.hasMap() && fmd.getMap().isEmbeddedKey();
        boolean keyPC = fmd.hasMap() && fmd.getMap().getKeyClassMetaData() != null;
        TypeManager typeMgr = fmd.getMetaDataManager().getPMFContext().getTypeManager();
        Class keyCls = clr.classForName(fmd.getMap().getKeyType());
        boolean keyReference = typeMgr.isReferenceType(keyCls);
        Class mc = null;
        if (serialised && keyPC) {
            mc = class$org$jpox$store$mapping$SerialisedKeyPCMapping == null ? (class$org$jpox$store$mapping$SerialisedKeyPCMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedKeyPCMapping")) : class$org$jpox$store$mapping$SerialisedKeyPCMapping;
        } else if (serialised && keyReference) {
            mc = class$org$jpox$store$mapping$SerialisedReferenceMapping == null ? (class$org$jpox$store$mapping$SerialisedReferenceMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedReferenceMapping")) : class$org$jpox$store$mapping$SerialisedReferenceMapping;
        } else if (serialised) {
            mc = class$org$jpox$store$mapping$SerialisedMapping == null ? (class$org$jpox$store$mapping$SerialisedMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedMapping")) : class$org$jpox$store$mapping$SerialisedMapping;
        } else if (embedded) {
            mc = class$org$jpox$store$mapping$EmbeddedKeyPCMapping == null ? (class$org$jpox$store$mapping$EmbeddedKeyPCMapping = AbstractMappingManager.class$("org.jpox.store.mapping.EmbeddedKeyPCMapping")) : class$org$jpox$store$mapping$EmbeddedKeyPCMapping;
        } else {
            throw new JDOFatalInternalException("Attempt to get key mapping for field " + fmd.getFullFieldName() + " when not embedded or serialised - please report this to JPOX developers");
        }
        return mc;
    }

    protected Class getValueMappingClass(DatastoreContainerObject container, AbstractPropertyMetaData fmd, DatastoreAdapter dba, ClassLoaderResolver clr) {
        if (fmd.getMap() == null) {
            throw new JDOFatalInternalException("Attempt to get value mapping for field that has no map!");
        }
        boolean serialised = fmd.hasMap() && fmd.getMap().isSerializedValue();
        boolean embedded = fmd.hasMap() && fmd.getMap().isEmbeddedValue();
        boolean valuePC = fmd.hasMap() && fmd.getMap().getValueClassMetaData() != null;
        TypeManager typeMgr = fmd.getMetaDataManager().getPMFContext().getTypeManager();
        Class valueCls = clr.classForName(fmd.getMap().getValueType());
        boolean valueReference = typeMgr.isReferenceType(valueCls);
        Class mc = null;
        if (serialised && valuePC) {
            mc = class$org$jpox$store$mapping$SerialisedValuePCMapping == null ? (class$org$jpox$store$mapping$SerialisedValuePCMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedValuePCMapping")) : class$org$jpox$store$mapping$SerialisedValuePCMapping;
        } else if (serialised && valueReference) {
            mc = class$org$jpox$store$mapping$SerialisedReferenceMapping == null ? (class$org$jpox$store$mapping$SerialisedReferenceMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedReferenceMapping")) : class$org$jpox$store$mapping$SerialisedReferenceMapping;
        } else if (serialised) {
            mc = class$org$jpox$store$mapping$SerialisedMapping == null ? (class$org$jpox$store$mapping$SerialisedMapping = AbstractMappingManager.class$("org.jpox.store.mapping.SerialisedMapping")) : class$org$jpox$store$mapping$SerialisedMapping;
        } else if (embedded) {
            mc = class$org$jpox$store$mapping$EmbeddedValuePCMapping == null ? (class$org$jpox$store$mapping$EmbeddedValuePCMapping = AbstractMappingManager.class$("org.jpox.store.mapping.EmbeddedValuePCMapping")) : class$org$jpox$store$mapping$EmbeddedValuePCMapping;
        } else {
            throw new JDOFatalInternalException("Attempt to get value mapping for field " + fmd.getFullFieldName() + " when not embedded or serialised - please report this to JPOX developers");
        }
        return mc;
    }

    protected Class getDefaultJavaTypeMapping(TypeManager typeMgr, String javaTypeName) {
        Class cls = typeMgr.getMappingType(javaTypeName);
        if (cls == null) {
            JPOXLogger.JDO.debug(LOCALISER.msg("MappingManager.NoMappingForJavaType", javaTypeName));
            return null;
        }
        return cls;
    }

    public abstract void registerDatastoreMapping(String var1, Class var2, String var3, String var4, boolean var5);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class TypeMapping {
        Class javaMappingType;
        boolean isDefault;

        public TypeMapping(Class javaMappingType, boolean isDefault) {
            this.javaMappingType = javaMappingType;
            this.isDefault = isDefault;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public Class getMappingType() {
            return this.javaMappingType;
        }
    }
}

