/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import javax.jdo.JDOUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.query.StatementText;

public class UnboundVariable
extends ScalarExpression {
    private final String name;
    private Class type;
    private final VariableBinder binder;
    ScalarExpression exprToBind = null;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    public UnboundVariable(QueryExpression qs, String name, Class type, VariableBinder binder) {
        super(qs);
        this.name = name;
        this.type = type;
        this.binder = binder;
        this.getExpressionToBindToThis();
    }

    public String getVariableName() {
        return this.name;
    }

    public LogicSetExpression getLogicSetExpression() {
        if (this.te == null) {
            ScalarExpression boundExpr = this.getExpressionToBindToThis();
            if (boundExpr == null) {
                return null;
            }
            return boundExpr.getLogicSetExpression();
        }
        return this.te;
    }

    public Class getVariableType() {
        return this.type;
    }

    public void setVariableType(Class type) {
        this.type = type;
        this.getExpressionToBindToThis();
    }

    public void bindTo(ScalarExpression qsc) {
        this.binder.bindVariable(this.name, qsc);
    }

    public StatementText toStatementText(int mode) {
        ScalarExpression exprToBind = this.getExpressionToBindToThis();
        if (exprToBind == null) {
            throw new JDOUserException("Unconstrained variable referenced: " + this.name);
        }
        if (!this.qs.hasCrossJoin(exprToBind.te)) {
            this.qs.crossJoin(exprToBind.te, true);
        }
        return exprToBind.toStatementText(mode);
    }

    public ScalarExpression.ExpressionList getExpressionList() {
        ScalarExpression exprToBind = this.getExpressionToBindToThis();
        if (exprToBind == null) {
            throw new JDOUserException("Unconstrained variable referenced: " + this.name);
        }
        if (!this.qs.hasCrossJoin(exprToBind.te)) {
            this.qs.crossJoin(exprToBind.te, true);
        }
        return exprToBind.getExpressionList();
    }

    public StatementText toStatementText() {
        throw new JDOUserException("Unconstrained variable referenced: " + this.name);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        ScalarExpression boundExpr = this.getExpressionToBindToThis();
        this.bindTo(boundExpr);
        if (this.qs.hasCrossJoin(boundExpr.te)) {
            this.qs.andCondition(expr.eq(boundExpr));
        } else {
            this.qs.innerJoin(expr, boundExpr, boundExpr.te, true, true);
        }
        return expr.eq(boundExpr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        ScalarExpression boundExpr = this.getExpressionToBindToThis();
        this.bindTo(boundExpr);
        if (!this.qs.hasCrossJoin(boundExpr.te)) {
            this.qs.innerJoin(expr, boundExpr, boundExpr.te, false, true);
        }
        return expr.noteq(boundExpr);
    }

    public ScalarExpression accessField(String fieldName, boolean innerJoin) {
        ScalarExpression exprToBind = this.getExpressionToBindToThis();
        this.bindTo(exprToBind);
        this.qs.crossJoin(exprToBind.getLogicSetExpression(), true);
        return exprToBind.accessField(fieldName, innerJoin);
    }

    private ScalarExpression getExpressionToBindToThis() {
        if (this.exprToBind != null) {
            return this.exprToBind;
        }
        if (this.type == null) {
            return null;
        }
        if (!(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = UnboundVariable.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(this.type)) {
            return null;
        }
        AbstractClassMetaData typeCmd = this.qs.getStoreManager().getMetaDataManager().getMetaDataForClass(this.type, this.qs.getClassLoaderResolver());
        if (typeCmd.isEmbeddedOnly()) {
            return null;
        }
        String jtJavaName = "UNBOUND." + this.getVariableName();
        DatastoreClass cbt = this.qs.getStoreManager().getDatastoreClass(this.type.getName(), this.qs.getClassLoaderResolver());
        DatastoreIdentifier jtRangeVar = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(0, jtJavaName);
        LogicSetExpression jtExpr = this.qs.getTableExpression(jtRangeVar);
        if (jtExpr == null) {
            jtExpr = this.qs.newTableExpression(cbt, jtRangeVar);
        }
        JavaTypeMapping mb = cbt.getIDMapping();
        ScalarExpression exprBindTo = mb.newScalarExpression(this.qs, jtExpr);
        this.mapping = mb;
        this.exprToBind = exprBindTo;
        return exprBindTo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface VariableBinder {
        public void bindVariable(String var1, ScalarExpression var2);
    }
}

