/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.math.BigInteger;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.BooleanLiteral;
import org.jpox.store.expression.CharacterLiteral;
import org.jpox.store.expression.FloatingPointLiteral;
import org.jpox.store.expression.IntegerLiteral;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.query.StatementText;
import org.jpox.util.StringUtils;

public class StringLiteral
extends StringExpression
implements Literal {
    private final String value;
    private StatementText stUsingParameter = new StatementText();
    static /* synthetic */ Class class$java$lang$String;

    public StringLiteral(QueryExpression qs, JavaTypeMapping mapping, char value) {
        this(qs, mapping, String.valueOf(value));
    }

    public StringLiteral(QueryExpression qs, JavaTypeMapping mapping, String value) {
        super(qs);
        this.mapping = mapping;
        this.value = value;
        this.st.append('\'').append(StringUtils.replaceAll(value, "'", "''")).append('\'');
        if (mapping == null) {
            DatastoreAdapter dba = qs.getStoreManager().getDatastoreAdapter();
            this.stUsingParameter.appendParameter(dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = StringLiteral.class$("java.lang.String")) : class$java$lang$String, qs.getStoreManager(), qs.getClassLoaderResolver()), value);
        } else {
            this.stUsingParameter.appendParameter(mapping, value);
        }
    }

    public void generateStatementWithoutQuotes() {
        this.st.clearStatement();
        this.st.append(StringUtils.replaceAll(this.value, "'", "''"));
    }

    public Object getValue() {
        return this.value;
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.equals(((StringLiteral)expr).value));
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, !this.value.equals(((StringLiteral)expr).value));
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((StringLiteral)expr).value) < 0);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((StringLiteral)expr).value) <= 0);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((StringLiteral)expr).value) > 0);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((StringLiteral)expr).value) >= 0);
        }
        return super.gteq(expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new StringLiteral(this.qs, this.mapping, this.value.concat(((StringLiteral)expr).value));
        }
        if (expr instanceof CharacterLiteral) {
            return new StringLiteral(this.qs, this.mapping, this.value.concat(((Literal)((Object)expr)).getValue().toString()));
        }
        if (expr instanceof IntegerLiteral || expr instanceof FloatingPointLiteral || expr instanceof BooleanLiteral) {
            return new StringLiteral(this.qs, this.mapping, this.value.concat(((Literal)((Object)expr)).getValue().toString()));
        }
        return super.add(expr);
    }

    public BooleanExpression endsWithMethod(ScalarExpression str) {
        if (str instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.endsWith(((StringLiteral)str).value));
        }
        return super.endsWithMethod(str);
    }

    public NumericExpression indexOfMethod(ScalarExpression str) {
        if (str instanceof StringLiteral) {
            return new IntegerLiteral(this.qs, this.mapping, BigInteger.valueOf(this.value.indexOf(((StringLiteral)str).value)));
        }
        return super.indexOfMethod(str);
    }

    public NumericExpression lengthMethod() {
        return new IntegerLiteral(this.qs, this.mapping, BigInteger.valueOf(this.value.length()));
    }

    public BooleanExpression startsWithMethod(ScalarExpression str) {
        if (str instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.startsWith(((StringLiteral)str).value));
        }
        return super.startsWithMethod(str);
    }

    public BooleanExpression startsWithMethod(ScalarExpression str, ScalarExpression toffset) {
        if (str instanceof StringLiteral && toffset instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.startsWith(((StringLiteral)str).value, ((Number)((IntegerLiteral)toffset).getValue()).intValue()));
        }
        return super.startsWithMethod(str, toffset);
    }

    public StringExpression substringMethod(NumericExpression begin) {
        if (begin instanceof IntegerLiteral) {
            return new StringLiteral(this.qs, this.mapping, this.value.substring(((Number)((IntegerLiteral)begin).getValue()).intValue()));
        }
        return super.substringMethod(begin);
    }

    public StringExpression substringMethod(NumericExpression begin, NumericExpression end) {
        if (begin instanceof IntegerLiteral && end instanceof IntegerLiteral) {
            return new StringLiteral(this.qs, this.mapping, this.value.substring(((Number)((IntegerLiteral)begin).getValue()).intValue(), ((Number)((IntegerLiteral)end).getValue()).intValue()));
        }
        return super.substringMethod(begin, end);
    }

    public StringExpression toLowerCaseMethod() {
        return new StringLiteral(this.qs, this.mapping, this.value.toLowerCase());
    }

    public StringExpression toUpperCaseMethod() {
        return new StringLiteral(this.qs, this.mapping, this.value.toUpperCase());
    }

    public StringExpression trimMethod() {
        return new StringLiteral(this.qs, this.mapping, this.value.trim());
    }

    public StatementText toStatementText(int mode) {
        if (mode == ScalarExpression.FILTER) {
            return this.stUsingParameter;
        }
        return super.toStatementText(mode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

