/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.util.Iterator;
import javax.jdo.JDOUserException;
import org.jpox.exceptions.ClassNotPersistenceCapableException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.expression.BooleanBitColumnExpression;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.BooleanLiteral;
import org.jpox.store.expression.ByteLiteral;
import org.jpox.store.expression.CharacterLiteral;
import org.jpox.store.expression.ClassExpression;
import org.jpox.store.expression.FloatingPointLiteral;
import org.jpox.store.expression.IntegerLiteral;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.ObjectLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.SqlDateLiteral;
import org.jpox.store.expression.SqlTimeLiteral;
import org.jpox.store.expression.SqlTimestampLiteral;
import org.jpox.store.expression.StringLiteral;
import org.jpox.store.expression.UnboundVariable;
import org.jpox.store.mapping.BigDecimalMapping;
import org.jpox.store.mapping.BigIntegerMapping;
import org.jpox.store.mapping.BooleanMapping;
import org.jpox.store.mapping.ByteMapping;
import org.jpox.store.mapping.CharacterMapping;
import org.jpox.store.mapping.DiscriminatorMapping;
import org.jpox.store.mapping.DoubleMapping;
import org.jpox.store.mapping.EmbeddedMapping;
import org.jpox.store.mapping.EmbeddedPCMapping;
import org.jpox.store.mapping.FloatMapping;
import org.jpox.store.mapping.IntegerMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.LongMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.mapping.ShortMapping;
import org.jpox.store.mapping.SqlDateMapping;
import org.jpox.store.mapping.SqlTimeMapping;
import org.jpox.store.mapping.SqlTimestampMapping;
import org.jpox.store.mapping.StringMapping;
import org.jpox.util.JPOXLogger;

public class ObjectExpression
extends ScalarExpression {
    protected ScalarExpression conditionExpr;
    private Class castType;
    private String fieldName;
    private String fieldType;
    private boolean usingRelatedTable = true;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    protected ObjectExpression(QueryExpression qs) {
        super(qs);
    }

    public ObjectExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        super(qs, mapping, te);
    }

    public ObjectExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te, JavaTypeMapping refMapping, LogicSetExpression teTarget, JavaTypeMapping selectMapping) {
        this(qs);
        ScalarExpression sourceExpr = mapping.getDatastoreContainer().getIDMapping().newScalarExpression(qs, te);
        ScalarExpression targetExpr = refMapping.newScalarExpression(qs, teTarget);
        qs.leftOuterJoin(sourceExpr, targetExpr, teTarget, true);
        this.mapping = selectMapping;
        this.te = teTarget;
        for (int i = 0; i < this.mapping.getNumberOfDatastoreFields(); ++i) {
            this.expressionList.addExpression(new ScalarExpression.FieldExpression(qs, this.mapping.getDataStoreMapping(i).getDatastoreField(), teTarget));
        }
        this.st.append(this.expressionList.toString());
        this.usingRelatedTable = true;
    }

    public ObjectExpression(QueryExpression qs, ScalarExpression expr, ScalarExpression conditionExpr, LogicSetExpression te) {
        super(qs);
        this.te = te;
        this.mapping = expr.mapping;
        this.st.append(expr.st.toString());
        this.expressionList = expr.expressionList;
        this.conditionExpr = conditionExpr;
    }

    void useFirstDatastoreFieldOnly() {
        if (this.mapping.getNumberOfDatastoreFields() <= 1) {
            return;
        }
        this.expressionList = new ScalarExpression.ExpressionList();
        this.expressionList.addExpression(new ScalarExpression.FieldExpression(this.qs, this.mapping.getDataStoreMapping(0).getDatastoreField(), this.te));
        this.st.clearStatement();
        this.st.append(this.expressionList.toString());
    }

    public void useIdentityFormOfPCMapping() {
        if (this.mapping instanceof PersistenceCapableMapping) {
            this.mapping = ((PersistenceCapableMapping)this.mapping).getIdMapping();
        }
    }

    public void addOuterJoinSuffix(String suffix) {
        if (suffix != null) {
            this.st.append(suffix);
        }
    }

    public ScalarExpression cast(Class castType) {
        LogicSetExpression te = this.qs.getTableExpression(this.qs.getStoreManager().getDatastoreClass(castType.getName(), this.qs.getClassLoaderResolver()).getIdentifier());
        DatastoreClass dc = this.qs.getStoreManager().getDatastoreClass(castType.getName(), this.qs.getClassLoaderResolver());
        if (te == null) {
            DatastoreIdentifier jtRangeVar;
            LogicSetExpression jtTblExpr;
            IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
            String jtIdentifier = this.te.getRangeVariable().getIdentifier();
            if (castType != null && !castType.getName().equals(this.mapping.getType())) {
                String castTypeName = castType.getName();
                jtIdentifier = idFactory.newIdentifier(this.te.getRangeVariable(), castTypeName.substring(castTypeName.lastIndexOf(46) + 1)).getIdentifier();
            }
            if ((jtTblExpr = this.qs.getTableExpression(jtRangeVar = idFactory.newIdentifier(0, jtIdentifier))) == null) {
                jtTblExpr = this.qs.newTableExpression(dc, jtRangeVar);
            }
            te = jtTblExpr;
            this.qs.leftOuterJoin(this, dc.getIDMapping().newScalarExpression(this.qs, jtTblExpr), jtTblExpr, true, true);
        }
        ObjectExpression objectCast = new ObjectExpression(this.qs, dc.getIDMapping(), te);
        objectCast.conditionExpr = this.conditionExpr;
        return objectCast;
    }

    public BooleanExpression eq(ScalarExpression expr) {
        BooleanExpression bExpr = null;
        if (expr instanceof NullLiteral) {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                bExpr = bExpr == null ? expr.eq(this.expressionList.getExpression(i)) : bExpr.and(expr.eq(this.expressionList.getExpression(i)));
            }
        } else if (this.literalIsValidForSimpleComparison(expr)) {
            bExpr = this.expressionList.size() > 1 ? super.eq(expr) : new BooleanExpression(this, OP_EQ, expr);
        } else if (expr instanceof ObjectLiteral) {
            bExpr = expr.eq(this);
        } else if (expr instanceof ObjectExpression) {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                ScalarExpression source = this.expressionList.getExpression(i);
                ScalarExpression target = expr.expressionList.getExpression(i);
                bExpr = bExpr == null ? source.eq(target) : bExpr.and(source.eq(target));
            }
        } else if (expr instanceof UnboundVariable) {
            if (((UnboundVariable)expr).getVariableType() == null) {
                ((UnboundVariable)expr).setVariableType(this.qs.getClassLoaderResolver().classForName(this.fieldType));
            }
            bExpr = expr.eq(this);
        } else {
            bExpr = expr instanceof BooleanBitColumnExpression ? null : super.eq(expr);
        }
        if (this.conditionExpr != null) {
            return new BooleanExpression(this.conditionExpr, OP_AND, bExpr);
        }
        return bExpr;
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        BooleanExpression bExpr = null;
        if (expr instanceof NullLiteral) {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                bExpr = bExpr == null ? expr.eq(this.expressionList.getExpression(i)) : bExpr.and(expr.eq(this.expressionList.getExpression(i)));
            }
            bExpr = new BooleanExpression(OP_NOT, bExpr.encloseWithInParentheses());
        } else if (this.literalIsValidForSimpleComparison(expr)) {
            bExpr = this.expressionList.size() > 1 ? super.noteq(expr) : new BooleanExpression(this, OP_NOTEQ, expr);
        } else if (expr instanceof ObjectLiteral) {
            bExpr = expr.noteq(this);
        } else if (expr instanceof ObjectExpression) {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                ScalarExpression source = this.expressionList.getExpression(i);
                ScalarExpression target = expr.expressionList.getExpression(i);
                bExpr = bExpr == null ? source.eq(target) : bExpr.and(source.eq(target));
            }
            bExpr = new BooleanExpression(OP_NOT, bExpr.encloseWithInParentheses());
        } else if (expr instanceof UnboundVariable) {
            if (((UnboundVariable)expr).getVariableType() == null) {
                ((UnboundVariable)expr).setVariableType(this.qs.getClassLoaderResolver().classForName(this.fieldType));
            }
            bExpr = expr.noteq(this);
        } else if (expr instanceof BooleanBitColumnExpression) {
            if (this.conditionExpr != null) {
                bExpr = new BooleanExpression(ScalarExpression.OP_NOT, this.conditionExpr);
            }
        } else {
            bExpr = super.noteq(expr);
        }
        if (this.conditionExpr != null) {
            return new BooleanExpression(this.conditionExpr, OP_AND, bExpr);
        }
        return bExpr;
    }

    private boolean literalIsValidForSimpleComparison(ScalarExpression expr) {
        return expr instanceof BooleanLiteral && this.mapping instanceof BooleanMapping || expr instanceof ByteLiteral && this.mapping instanceof ByteMapping || expr instanceof CharacterLiteral && this.mapping instanceof CharacterMapping || expr instanceof FloatingPointLiteral && (this.mapping instanceof FloatMapping || this.mapping instanceof DoubleMapping || this.mapping instanceof BigDecimalMapping) || expr instanceof IntegerLiteral && (this.mapping instanceof IntegerMapping || this.mapping instanceof LongMapping || this.mapping instanceof BigIntegerMapping) || this.mapping instanceof ShortMapping || expr instanceof SqlDateLiteral && this.mapping instanceof SqlDateMapping || expr instanceof SqlTimeLiteral && this.mapping instanceof SqlTimeMapping || expr instanceof SqlTimestampLiteral && this.mapping instanceof SqlTimestampMapping || expr instanceof StringLiteral && (this.mapping instanceof StringMapping || this.mapping instanceof CharacterMapping);
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new BooleanExpression(this, OP_IN, expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScalarExpression accessField(String subfieldName, boolean innerJoin) {
        DatastoreIdentifier jtRangeVar;
        LogicSetExpression jtTblExpr;
        DatastoreContainerObject table;
        try {
            if (this.mapping instanceof EmbeddedMapping) {
                table = this.mapping.getDatastoreContainer();
                if (this.te.getMainTable().equals(table)) {
                    return this.te.newFieldExpression(this.fieldName + "." + subfieldName);
                }
            } else if (this.mapping instanceof PersistenceCapableMapping || this.mapping instanceof ReferenceMapping) {
                AbstractClassMetaData otherCmd = this.qs.getStoreManager().getMetaDataManager().getMetaDataForClass(this.mapping.getType(), this.qs.getClassLoaderResolver());
                if (otherCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                    AbstractClassMetaData[] cmds = this.qs.getStoreManager().getClassesManagingTableForClass(otherCmd, this.qs.getClassLoaderResolver());
                    if (cmds == null) throw new JDOUserException(LOCALISER.msg("ObjectExpression.AccessFieldUsingSubclassTableWithNoSubclasses", this.mapping.getFieldMetaData().getFullFieldName()));
                    if (cmds.length > 1) {
                        JPOXLogger.JDO_QUERY.warn(LOCALISER.msg("ObjectExpression.AccessFieldUsingSubclassTableMoreThanOneSubclass", this.mapping.getFieldMetaData().getFullFieldName(), cmds[0].getFullClassName()));
                    }
                    table = this.qs.getStoreManager().getDatastoreClass(cmds[0].getFullClassName(), this.qs.getClassLoaderResolver());
                } else {
                    JavaTypeMapping[] subMappings;
                    AbstractPropertyMetaData subfieldMetaData;
                    table = this.qs.getStoreManager().getDatastoreClass(this.mapping.getType(), this.qs.getClassLoaderResolver());
                    if (this.fieldName != null && subfieldName != null && (subfieldMetaData = otherCmd.getField(subfieldName)) != null && subfieldMetaData.isPrimaryKey() && !(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = ObjectExpression.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(subfieldMetaData.getType()) && (subMappings = ((PersistenceCapableMapping)this.mapping).getJavaTypeMapping()).length == 1) {
                        return subMappings[0].newScalarExpression(this.qs, this.te);
                    }
                }
            } else {
                table = this.qs.getStoreManager().getDatastoreClass(this.mapping.getType(), this.qs.getClassLoaderResolver());
            }
        }
        catch (ClassNotPersistenceCapableException cnpce) {
            return this.te.newFieldExpression(subfieldName);
        }
        if (this.fieldType != null && !this.fieldType.equals(this.mapping.getType())) {
            DiscriminatorMetaData dismd = table.getDiscriminatorMetaData();
            DiscriminatorMapping discriminatorMapping = (DiscriminatorMapping)table.getDiscriminatorMapping();
            if (dismd != null && dismd.getStrategy() != DiscriminatorStrategy.NONE) {
                BooleanExpression discrExpr = this.booleanConditionForClassInDiscriminator(this.qs, this.fieldType, dismd, discriminatorMapping, this.te);
                Iterator subclassIter = this.qs.getStoreManager().getSubClassesForClass(this.fieldType, true, this.qs.getClassLoaderResolver()).iterator();
                while (subclassIter.hasNext()) {
                    String subCandidateType = (String)subclassIter.next();
                    discrExpr.ior(this.booleanConditionForClassInDiscriminator(this.qs, subCandidateType, dismd, discriminatorMapping, this.te));
                }
                discrExpr.encloseWithInParentheses();
                this.qs.andCondition(discrExpr);
            }
        }
        if (this.te.getMainTable().equals(table) && this.usingRelatedTable && this.fieldName == null) {
            return this.te.newFieldExpression(subfieldName);
        }
        String jtIdentifier = this.te.getRangeVariable().getIdentifier();
        if (this.fieldName != null) {
            jtIdentifier = jtIdentifier + '.' + this.fieldName;
        }
        if (!subfieldName.equals("this")) {
            jtIdentifier = jtIdentifier + '.' + subfieldName;
        }
        if (this.castType != null && !this.castType.equals(this.mapping.getType())) {
            String castTypeName = this.castType.getName();
            jtIdentifier = jtIdentifier + '.' + castTypeName.substring(castTypeName.lastIndexOf(46) + 1);
        }
        if ((jtTblExpr = this.qs.getTableExpression(jtRangeVar = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(0, jtIdentifier))) == null) {
            if (this.te.getRangeVariable().getIdentifier().equalsIgnoreCase("this") && table == this.qs.getDefaultTableExpression().getMainTable() && this.fieldName == null) {
                return this.qs.getDefaultTableExpression().newFieldExpression(subfieldName);
            }
            jtTblExpr = this.qs.newTableExpression(table, jtRangeVar);
            ScalarExpression jtExpr = table.getIDMapping().newScalarExpression(this.qs, jtTblExpr);
            ScalarExpression expr = this.mapping.newScalarExpression(this.qs, this.te);
            if (this.mapping.isNullable()) {
                if (innerJoin) {
                    this.qs.innerJoin(jtExpr, expr, jtTblExpr, true, true);
                } else {
                    this.qs.leftOuterJoin(jtExpr, expr, jtTblExpr, true, true);
                }
            } else {
                this.qs.innerJoin(jtExpr, expr, jtTblExpr, true, true);
            }
        }
        if (!(this.mapping instanceof EmbeddedPCMapping)) return jtTblExpr.newFieldExpression(subfieldName);
        return jtTblExpr.newFieldExpression(this.fieldName + "." + subfieldName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BooleanExpression instanceOf(ScalarExpression expr) {
        DatastoreClass table;
        if (!(expr instanceof ClassExpression)) throw new JDOUserException(LOCALISER.msg("ObjectExpression.InstanceOfNotClassExpression", expr.getClass().getName()));
        Class instanceofClass = ((ClassExpression)expr).getCls();
        Class fieldClass = this.qs.getClassLoaderResolver().classForName(this.mapping.getType());
        if (!fieldClass.isAssignableFrom(instanceofClass) && !instanceofClass.isAssignableFrom(fieldClass)) {
            return new BooleanLiteral(this.qs, this.mapping, true).eq(new BooleanLiteral(this.qs, this.mapping, false));
        }
        try {
            if (this.mapping instanceof EmbeddedMapping) {
                return new BooleanLiteral(this.qs, this.mapping, true).eq(new BooleanLiteral(this.qs, this.mapping, true));
            }
            if (this.mapping instanceof PersistenceCapableMapping || this.mapping instanceof ReferenceMapping) {
                AbstractClassMetaData fieldCmd = this.qs.getStoreManager().getMetaDataManager().getMetaDataForClass(this.mapping.getType(), this.qs.getClassLoaderResolver());
                if (fieldCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                    AbstractClassMetaData[] cmds = this.qs.getStoreManager().getClassesManagingTableForClass(fieldCmd, this.qs.getClassLoaderResolver());
                    if (cmds == null) throw new JDOUserException(LOCALISER.msg("ObjectExpression.AccessFieldUsingSubclassTableWithNoSubclasses", this.mapping.getFieldMetaData().getFullFieldName()));
                    if (cmds.length > 1) {
                        JPOXLogger.JDO_QUERY.warn(LOCALISER.msg("ObjectExpression.AccessFieldUsingSubclassTableMoreThanOneSubclass", this.mapping.getFieldMetaData().getFullFieldName(), cmds[0].getFullClassName()));
                    }
                    table = this.qs.getStoreManager().getDatastoreClass(cmds[0].getFullClassName(), this.qs.getClassLoaderResolver());
                } else {
                    table = this.qs.getStoreManager().getDatastoreClass(this.mapping.getType(), this.qs.getClassLoaderResolver());
                }
            } else {
                table = this.qs.getStoreManager().getDatastoreClass(this.mapping.getType(), this.qs.getClassLoaderResolver());
            }
        }
        catch (ClassNotPersistenceCapableException cnpce) {
            return new BooleanLiteral(this.qs, this.mapping, true).eq(new BooleanLiteral(this.qs, this.mapping, true));
        }
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        DiscriminatorMetaData dismd = table.getDiscriminatorMetaData();
        DiscriminatorMapping discriminatorMapping = (DiscriminatorMapping)table.getDiscriminatorMapping();
        if (discriminatorMapping != null) {
            String fieldIdentifier = this.te.getRangeVariable().getIdentifier();
            fieldIdentifier = this.fieldName == null ? fieldIdentifier + ".INST" : fieldIdentifier + '.' + this.fieldName;
            DatastoreIdentifier fieldRangeVar = idFactory.newIdentifier(0, fieldIdentifier);
            LogicSetExpression fieldTblExpr = this.qs.getTableExpression(fieldRangeVar);
            if (fieldTblExpr == null) {
                fieldTblExpr = this.qs.newTableExpression(table, fieldRangeVar);
            }
            ScalarExpression fieldExpr = table.getIDMapping().newScalarExpression(this.qs, fieldTblExpr);
            expr = this.mapping.newScalarExpression(this.qs, this.te);
            this.qs.innerJoin(fieldExpr, expr, fieldTblExpr, true, true);
            BooleanExpression discrExpr = this.booleanConditionForClassInDiscriminator(this.qs, instanceofClass.getName(), dismd, discriminatorMapping, fieldTblExpr);
            Iterator subclassIter = this.qs.getStoreManager().getSubClassesForClass(instanceofClass.getName(), true, this.qs.getClassLoaderResolver()).iterator();
            while (subclassIter.hasNext()) {
                String subCandidateType = (String)subclassIter.next();
                discrExpr.ior(this.booleanConditionForClassInDiscriminator(this.qs, subCandidateType, dismd, discriminatorMapping, fieldTblExpr));
            }
            discrExpr.encloseWithInParentheses();
            return discrExpr;
        }
        if (!(table instanceof DatastoreClass)) return new BooleanLiteral(this.qs, this.mapping, true).eq(new BooleanLiteral(this.qs, this.mapping, true));
        DatastoreClass ct = table;
        if (ct.managesClass(instanceofClass.getName())) {
            return new BooleanLiteral(this.qs, this.mapping, true).eq(new BooleanLiteral(this.qs, this.mapping, true));
        }
        DatastoreClass instanceofTable = this.qs.getStoreManager().getDatastoreClass(instanceofClass.getName(), this.qs.getClassLoaderResolver());
        String fieldIdentifier = this.te.getRangeVariable().getIdentifier();
        fieldIdentifier = this.fieldName == null ? fieldIdentifier + ".INST" : fieldIdentifier + '.' + this.fieldName;
        DatastoreIdentifier fieldRangeVar = idFactory.newIdentifier(0, fieldIdentifier);
        LogicSetExpression fieldTblExpr = this.qs.newTableExpression(instanceofTable, fieldRangeVar);
        ScalarExpression fieldExpr = table.getIDMapping().newScalarExpression(this.qs, this.te);
        expr = this.fieldName == null ? instanceofTable.getIDMapping().newScalarExpression(this.qs, fieldTblExpr) : this.mapping.newScalarExpression(this.qs, fieldTblExpr);
        this.qs.innerJoin(fieldExpr, expr, fieldTblExpr, true, true);
        return new BooleanLiteral(this.qs, this.mapping, true).eq(new BooleanLiteral(this.qs, this.mapping, true));
    }

    public void setFieldDefinition(String fieldName, String fieldType) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
    }

    private BooleanExpression booleanConditionForClassInDiscriminator(QueryExpression stmt, String className, DiscriminatorMetaData dismd, JavaTypeMapping discriminatorMapping, LogicSetExpression tableExpr) {
        String discriminatorValue = className;
        if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            AbstractClassMetaData targetCmd = stmt.getStoreManager().getMetaDataManager().getMetaDataForClass(className, stmt.getClassLoaderResolver());
            discriminatorValue = targetCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
        }
        ScalarExpression discrExpr = discriminatorMapping.newScalarExpression(stmt, tableExpr);
        ScalarExpression discrVal = discriminatorMapping.newLiteral(stmt, discriminatorValue);
        return discrExpr.eq(discrVal);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

