/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.math.BigInteger;
import java.util.List;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.CharacterExpression;
import org.jpox.store.expression.IntegerLiteral;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.mapping.JavaTypeMapping;

public class NumericExpression
extends ScalarExpression {
    protected NumericExpression(QueryExpression qs) {
        super(qs);
    }

    public NumericExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        super(qs, mapping, te);
    }

    public NumericExpression(String functionName, List args) {
        super(functionName, args);
    }

    public NumericExpression(String functionName, List args, List types) {
        super(functionName, args, types);
    }

    public NumericExpression(ScalarExpression.MonadicOperator op, ScalarExpression operand) {
        super(op, operand);
    }

    public NumericExpression(ScalarExpression operand1, ScalarExpression.DyadicOperator op, ScalarExpression operand2) {
        super(operand1, op, operand2);
        this.mapping = operand1.getMapping() != null ? operand1.getMapping() : operand2.getMapping();
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, OP_EQ, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.noteq(this);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, OP_NOTEQ, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_LT, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, OP_LT, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_LTEQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, OP_LTEQ, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_GT, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, OP_GT, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_GTEQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, OP_GTEQ, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        return super.gteq(expr);
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new BooleanExpression(this, OP_IN, expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(this, OP_ADD, expr);
        }
        if (expr instanceof StringExpression) {
            return new StringExpression(this.qs.getStoreManager().getDatastoreAdapter().toStringExpression(this), OP_CONCAT, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(this, OP_ADD, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        if (expr instanceof NullLiteral) {
            return expr;
        }
        return super.add(expr);
    }

    public ScalarExpression sub(ScalarExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(this, OP_SUB, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(this, OP_SUB, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        return super.sub(expr);
    }

    public ScalarExpression mul(ScalarExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(this, OP_MUL, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(this, OP_MUL, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        return super.mul(expr);
    }

    public ScalarExpression div(ScalarExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(this, OP_DIV, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(this, OP_DIV, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        return super.div(expr);
    }

    public ScalarExpression mod(ScalarExpression expr) {
        if (expr instanceof NumericExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().modOperator(this, expr);
        }
        if (expr instanceof CharacterExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().modOperator(this, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        return super.mod(expr);
    }

    public ScalarExpression neg() {
        return new NumericExpression(OP_NEG, this);
    }

    public ScalarExpression com() {
        return this.neg().sub(new IntegerLiteral(this.qs, this.mapping, BigInteger.ONE, false));
    }
}

