/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.jpox.store.expression.ByteLiteral;
import org.jpox.store.expression.FloatingPointLiteral;
import org.jpox.store.expression.IntegerLiteral;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;

public class MathExpression
extends ScalarExpression {
    public MathExpression(QueryExpression qs) {
        super(qs);
    }

    public ScalarExpression absMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                BigInteger absValue = new BigInteger(String.valueOf(Math.abs(originalValue)));
                return new ByteLiteral(this.qs, expr.mapping, absValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Integer absValue = new Integer(Math.abs(originalValue));
                return new IntegerLiteral(this.qs, expr.mapping, absValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double absValue = new Double(Math.abs(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, absValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "absMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().absMethod(expr);
    }

    public ScalarExpression sqrtMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.sqrt(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.sqrt(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.sqrt(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "sqrtMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().sqrtMethod(expr);
    }

    public ScalarExpression cosMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.cos(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.cos(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.cos(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "cosMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().cosMethod(expr);
    }

    public ScalarExpression sinMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.sin(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.sin(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.sin(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "sinMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().sinMethod(expr);
    }

    public ScalarExpression tanMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.tan(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.tan(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.tan(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "tanMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().tanMethod(expr);
    }

    public ScalarExpression acosMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.acos(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.acos(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.acos(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "acosMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().acosMethod(expr);
    }

    public ScalarExpression asinMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.asin(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.asin(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.asin(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "asinMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().asinMethod(expr);
    }

    public ScalarExpression atanMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.atan(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.atan(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.atan(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "atanMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().atanMethod(expr);
    }

    public ScalarExpression expMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.exp(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.exp(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.exp(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "expMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().expMethod(expr);
    }

    public ScalarExpression logMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.log(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.log(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.log(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "logMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().logMethod(expr);
    }

    public ScalarExpression floorMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.floor(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.floor(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.floor(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "floorMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().floorMethod(expr);
    }

    public ScalarExpression ceilrMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.ceil(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.ceil(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.ceil(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "ceilMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().ceilMethod(expr);
    }
}

