/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.math.BigInteger;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.BooleanLiteral;
import org.jpox.store.expression.CharacterExpression;
import org.jpox.store.expression.CharacterLiteral;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.query.StatementText;

public class IntegerLiteral
extends NumericExpression
implements Literal {
    private final Number value;
    private StatementText stUsingParameter = new StatementText();
    private final boolean useParameter;

    public IntegerLiteral(QueryExpression qs, JavaTypeMapping mapping, Number value) {
        super(qs);
        this.mapping = mapping;
        this.value = value;
        this.st.append(String.valueOf(value));
        this.stUsingParameter.appendParameter(mapping, value);
        this.useParameter = true;
    }

    public IntegerLiteral(QueryExpression qs, JavaTypeMapping mapping, Number value, boolean useParameter) {
        super(qs);
        this.mapping = mapping;
        this.value = value;
        this.st.append(String.valueOf(value));
        this.stUsingParameter.appendParameter(mapping, value);
        this.useParameter = useParameter;
    }

    public Object getValue() {
        return this.value;
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) == 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, OP_EQ, literal);
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) != 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, OP_NOTEQ, literal);
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) < 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) <= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_LTEQ, expr);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) > 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) >= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_GTEQ, expr);
        }
        return super.gteq(expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).add(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).add(new BigInteger("" + v)));
        }
        return super.add(expr);
    }

    public ScalarExpression sub(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).subtract(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).subtract(new BigInteger("" + v)));
        }
        return super.sub(expr);
    }

    public ScalarExpression mul(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).multiply(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).multiply(new BigInteger("" + v)));
        }
        return super.mul(expr);
    }

    public ScalarExpression div(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).divide(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).divide(new BigInteger("" + v)));
        }
        return super.div(expr);
    }

    public ScalarExpression mod(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).mod(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).mod(new BigInteger("" + v)));
        }
        return super.mod(expr);
    }

    public ScalarExpression neg() {
        return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).negate());
    }

    public StatementText toStatementText(int mode) {
        if (mode == ScalarExpression.FILTER && this.useParameter) {
            return this.stUsingParameter;
        }
        return super.toStatementText(mode);
    }
}

