/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.math.BigDecimal;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.BooleanLiteral;
import org.jpox.store.expression.CharacterExpression;
import org.jpox.store.expression.CharacterLiteral;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.util.SQLFormat;

public class FloatingPointLiteral
extends NumericExpression
implements Literal {
    private final BigDecimal value;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public FloatingPointLiteral(QueryExpression qs, JavaTypeMapping mapping, Float value) {
        super(qs);
        this.mapping = mapping;
        this.value = new BigDecimal(value.toString());
        DatastoreAdapter dba = qs.getStoreManager().getDatastoreAdapter();
        this.st.appendParameter(dba.getMapping(class$java$lang$Float == null ? (class$java$lang$Float = FloatingPointLiteral.class$("java.lang.Float")) : class$java$lang$Float, qs.getStoreManager(), qs.getClassLoaderResolver()), value);
    }

    public Object getValue() {
        return this.value;
    }

    public FloatingPointLiteral(QueryExpression qs, JavaTypeMapping mapping, Double value) {
        super(qs);
        this.mapping = mapping;
        this.value = new BigDecimal(value.toString());
        DatastoreAdapter dba = qs.getStoreManager().getDatastoreAdapter();
        this.st.appendParameter(dba.getMapping(class$java$lang$Double == null ? (class$java$lang$Double = FloatingPointLiteral.class$("java.lang.Double")) : class$java$lang$Double, qs.getStoreManager(), qs.getClassLoaderResolver()), value);
    }

    public FloatingPointLiteral(QueryExpression qs, BigDecimal value) {
        super(qs);
        this.value = value;
        this.st.append(SQLFormat.format(value));
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) == 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, OP_EQ, literal);
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) != 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, OP_NOTEQ, literal);
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) < 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) <= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_LTEQ, expr);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) > 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) >= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_GTEQ, expr);
        }
        return super.gteq(expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.qs, this.value.add(((FloatingPointLiteral)expr).value));
        }
        return super.add(expr);
    }

    public ScalarExpression sub(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.qs, this.value.subtract(((FloatingPointLiteral)expr).value));
        }
        return super.sub(expr);
    }

    public ScalarExpression mul(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.qs, this.value.multiply(((FloatingPointLiteral)expr).value));
        }
        return super.mul(expr);
    }

    public ScalarExpression div(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.qs, this.value.divide(((FloatingPointLiteral)expr).value, 1));
        }
        return super.mul(expr);
    }

    public ScalarExpression neg() {
        return new FloatingPointLiteral(this.qs, this.value.negate());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

