/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.jdo.JDOUserException;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;

public class ClassExpression
extends ScalarExpression {
    private Class cls;

    public ClassExpression(QueryExpression qs, Class cls) {
        super(qs);
        this.cls = cls;
    }

    public Class getCls() {
        return this.cls;
    }

    public ScalarExpression accessField(String fieldName, boolean innerJoin) {
        try {
            Field fld = this.cls.getField(fieldName);
            if (!(Modifier.isStatic(fld.getModifiers()) && Modifier.isFinal(fld.getModifiers()) && Modifier.isPublic(fld.getModifiers()))) {
                throw new JDOUserException(LOCALISER.msg("ClassExpression.MethodNotPublicStaticFinal", fieldName, this.cls.getName()));
            }
            Object value = fld.get(null);
            if (value == null) {
                return new NullLiteral(this.qs);
            }
            JavaTypeMapping m = this.qs.getStoreManager().getDatastoreAdapter().getMapping(value.getClass(), this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
            return m.newLiteral(this.qs, value);
        }
        catch (IllegalAccessException iae) {
        }
        catch (NoSuchFieldException nsfe) {
            throw new JDOUserException(LOCALISER.msg("ClassExpression.MethodNotFoundForClass", fieldName, this.cls.getName()));
        }
        return null;
    }
}

