/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import org.jpox.store.expression.BooleanLiteral;
import org.jpox.store.expression.ExistsExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;

public class BooleanExpression
extends ScalarExpression {
    protected BooleanExpression(QueryExpression qs) {
        super(qs);
    }

    public BooleanExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        super(qs, mapping, te);
    }

    public BooleanExpression(ScalarExpression.MonadicOperator op, ScalarExpression operand) {
        super(op, operand);
    }

    public BooleanExpression(ScalarExpression operand1, ScalarExpression.DyadicOperator op, ScalarExpression operand2) {
        super(operand1, op, operand2);
    }

    public BooleanExpression and(ScalarExpression expr) {
        if (expr instanceof BooleanLiteral) {
            return expr.and(this);
        }
        if (expr instanceof ExistsExpression && !(this instanceof ExistsExpression)) {
            return expr.and(this);
        }
        if (expr instanceof BooleanExpression) {
            return new BooleanExpression(this, OP_AND, expr);
        }
        return super.and(expr);
    }

    public BooleanExpression eor(ScalarExpression expr) {
        if (expr instanceof BooleanLiteral) {
            return expr.eor(this);
        }
        if (expr instanceof ExistsExpression) {
            return expr.eor(this);
        }
        if (expr instanceof BooleanExpression) {
            if (this.qs.getStoreManager().getDatastoreAdapter().supportsBooleanComparison()) {
                return new BooleanExpression(this, OP_NOTEQ, expr);
            }
            return this.and(expr.not()).ior(this.not().and(expr));
        }
        return super.eor(expr);
    }

    public BooleanExpression ior(ScalarExpression expr) {
        if (expr instanceof BooleanLiteral) {
            return expr.ior(this);
        }
        if (expr instanceof BooleanExpression) {
            return new BooleanExpression(this, OP_OR, expr);
        }
        return super.ior(expr);
    }

    public BooleanExpression not() {
        return new BooleanExpression(OP_NOT, this);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof BooleanLiteral || expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof BooleanExpression) {
            if (this.qs.getStoreManager().getDatastoreAdapter().supportsBooleanComparison()) {
                return new BooleanExpression(this, OP_EQ, expr);
            }
            return this.and(expr).ior(this.not().and(expr.not()));
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof BooleanLiteral || expr instanceof NullLiteral) {
            return expr.noteq(this);
        }
        if (expr instanceof BooleanExpression) {
            if (this.qs.getStoreManager().getDatastoreAdapter().supportsBooleanComparison()) {
                return new BooleanExpression(this, OP_NOTEQ, expr);
            }
            return this.and(expr.not()).ior(this.not().and(expr));
        }
        return super.noteq(expr);
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new BooleanExpression(this, OP_IN, expr);
    }

    public ScalarExpression neg() {
        return new NumericExpression(OP_NEG, this);
    }
}

