/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jpox.AbstractPersistenceManagerFactory;
import org.jpox.ClassLoaderResolver;
import org.jpox.store.AbstractAutoStartMechanism;
import org.jpox.store.StoreData;
import org.jpox.store.StoreManager;
import org.jpox.store.XMLAutoStarterEntityResolver;
import org.jpox.store.exceptions.DatastoreInitialisationException;
import org.jpox.util.JPOXLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLAutoStarter
extends AbstractAutoStartMechanism {
    protected final URL fileUrl;
    protected Document doc;
    protected Element rootElement;

    public XMLAutoStarter(StoreManager storeMgr, ClassLoaderResolver clr) throws MalformedURLException {
        this.fileUrl = new URL("file:" + storeMgr.getPMFContext().getPmfConfiguration().getAutoStartMechanismXmlFile());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            try {
                db.setEntityResolver(new XMLAutoStarterEntityResolver());
                this.rootElement = db.parse(new InputSource(new InputStreamReader(this.fileUrl.openStream()))).getDocumentElement();
                this.doc = this.rootElement.getOwnerDocument();
            }
            catch (Exception e) {
                JPOXLogger.JDO.info(LOCALISER.msg("XMLAutoStarter.StartupFileNonExistent", this.fileUrl.getFile()));
                this.doc = db.newDocument();
                this.rootElement = this.doc.createElement("jpox");
                this.doc.appendChild(this.rootElement);
                this.writeToFile();
            }
        }
        catch (ParserConfigurationException e1) {
            JPOXLogger.JDO.error(LOCALISER.msg("XMLAutoStarter.ErrorReadingStartupFile", this.fileUrl.getFile(), e1.getMessage()));
        }
    }

    public Collection getAllClassData() throws DatastoreInitialisationException {
        HashSet<StoreData> classes = new HashSet<StoreData>();
        NodeList classElements = this.rootElement.getElementsByTagName("class");
        for (int i = 0; i < classElements.getLength(); ++i) {
            Element element = (Element)classElements.item(i);
            boolean owner = true;
            if (element.getAttribute("table-owner") != null && element.getAttribute("table-owner").equals("false")) {
                owner = false;
            }
            StoreData classData = new StoreData(element.getAttribute("name"), element.getAttribute("table"), owner, element.getAttribute("type").equals("FCO") ? 1 : 2, element.getAttribute("interface-name"));
            classes.add(classData);
        }
        return classes;
    }

    public boolean isOpen() {
        return true;
    }

    public void close() {
        this.writeToFile();
        super.close();
    }

    public void addClass(StoreData data) {
        Element classElement = this.doc.createElement("class");
        classElement.setAttribute("name", data.getName());
        if (data.hasTable()) {
            classElement.setAttribute("table", data.getTableName());
            classElement.setAttribute("table-owner", data.isTableOwner() ? "true" : "false");
        }
        classElement.setAttribute("type", data.isFCO() ? "FCO" : "SCO");
        classElement.setAttribute("version", AbstractPersistenceManagerFactory.getVersionNumber());
        if (data.getInterfaceName() != null) {
            classElement.setAttribute("interface-name", data.getInterfaceName());
        }
        this.rootElement.appendChild(classElement);
    }

    public void deleteClass(String className) {
        NodeList classElements = this.rootElement.getElementsByTagName("class");
        for (int i = 0; i < classElements.getLength(); ++i) {
            Element element = (Element)classElements.item(i);
            String attr = element.getAttribute("name");
            if (attr == null || !attr.equals(className)) continue;
            this.rootElement.removeChild(element);
        }
    }

    public void deleteAllClasses() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            this.doc = db.newDocument();
            this.rootElement = this.doc.createElement("jpox");
            this.doc.appendChild(this.rootElement);
        }
        catch (ParserConfigurationException e) {
            JPOXLogger.JDO.error(LOCALISER.msg("XMLAutoStarter.ErrorWritingStartupFile", this.fileUrl.getFile(), e.getMessage()));
        }
    }

    public String getStorageDescription() {
        return LOCALISER.msg("XMLAutoStarter.StorageDescription");
    }

    private synchronized void writeToFile() {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer m = tf.newTransformer();
            DOMSource source = new DOMSource(this.doc);
            FileOutputStream os = new FileOutputStream(this.fileUrl.getFile());
            StreamResult result = new StreamResult(os);
            m.setOutputProperty("indent", "yes");
            m.setOutputProperty("doctype-public", "-//Java Persistent Objects//DTD JPOX Auto Starter Metadata 1.0//EN");
            m.transform(source, result);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            JPOXLogger.JDO.error(LOCALISER.msg("XMLAutoStarter.ErrorWritingStartupFile", this.fileUrl.getFile(), e.getMessage()));
        }
    }
}

