/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import javax.jdo.JDOFatalUserException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.util.Localiser;

public class StoreData {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    public static final int FCO_TYPE = 1;
    public static final int SCO_TYPE = 2;
    protected final String name;
    protected final String interfaceName;
    protected String tableName;
    protected final boolean isTableOwner;
    protected final int type;
    protected final ExtendableMetaData metaData;
    protected DatastoreContainerObject table;

    public StoreData(String name, String tableName, boolean tableOwner, int type, String interfaceName) {
        this.metaData = null;
        this.name = name;
        this.tableName = tableName;
        this.isTableOwner = tableOwner;
        this.type = type;
        this.interfaceName = interfaceName;
    }

    public StoreData(ClassMetaData cmd, DatastoreContainerObject table, boolean tableOwner) {
        if (cmd == null) {
            throw new JDOFatalUserException(LOCALISER.msg("StoreData.MetaDataNullError", this.tableName));
        }
        this.name = cmd.getFullClassName();
        this.table = table;
        this.tableName = table != null ? table.toString() : null;
        this.isTableOwner = tableOwner;
        this.metaData = cmd;
        this.type = 1;
        String interfaces = null;
        for (int i = 0; i < cmd.getImplementsMetaData().length; ++i) {
            interfaces = interfaces == null ? "" : interfaces + ",";
            interfaces = interfaces + cmd.getImplementsMetaData()[i].getName();
        }
        this.interfaceName = interfaces;
    }

    public StoreData(AbstractPropertyMetaData fmd, DatastoreContainerObject table) {
        if (fmd == null) {
            throw new JDOFatalUserException(LOCALISER.msg("StoreData.MetaDataNullError", this.tableName));
        }
        this.name = fmd.getFullFieldName();
        this.table = table;
        this.tableName = table != null ? table.toString() : null;
        this.isTableOwner = true;
        this.metaData = fmd;
        this.type = 2;
        this.interfaceName = table.getStoreManager().getMetaDataManager().isPersistentInterface(fmd.getType().getName()) ? fmd.getType().getName() : null;
    }

    public String getName() {
        return this.name;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isTableOwner() {
        return this.isTableOwner;
    }

    public boolean hasTable() {
        return this.tableName != null;
    }

    public boolean isFCO() {
        return this.type == 1;
    }

    public boolean isSCO() {
        return this.type == 2;
    }

    public int getType() {
        return this.type;
    }

    public String getSuperclass() {
        if (this.metaData instanceof ClassMetaData) {
            return ((ClassMetaData)this.metaData).getPersistenceCapableSuperclass();
        }
        return null;
    }

    public ExtendableMetaData getMetaData() {
        return this.metaData;
    }

    public DatastoreContainerObject getDatastoreContainerObject() {
        return this.table;
    }

    public DatastoreIdentifier getDatastoreIdentifier() {
        if (this.table != null) {
            return this.table.getIdentifier();
        }
        return null;
    }

    public void setDatastoreContainerObject(DatastoreClass table) {
        if (table != null) {
            this.tableName = ((Object)table).toString();
            this.table = table;
        }
    }

    public String toString() {
        if (this.metaData instanceof ClassMetaData) {
            ClassMetaData cmd = (ClassMetaData)this.metaData;
            if (this.tableName != null) {
                return LOCALISER.msg("StoreData.DataForClass", this.name, this.tableName, cmd.getInheritanceMetaData().getStrategyValue().toString());
            }
            return LOCALISER.msg("StoreData.DataForClass", this.name, "(none)", cmd.getInheritanceMetaData().getStrategyValue().toString());
        }
        if (this.metaData instanceof AbstractPropertyMetaData) {
            return LOCALISER.msg("StoreData.DataForField", this.name, this.tableName);
        }
        return LOCALISER.msg("StoreData.DataForClass", this.name, this.tableName);
    }
}

