/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import java.io.Serializable;
import org.jpox.ClassNameConstants;
import org.jpox.util.Localiser;

public class OID
implements Serializable {
    private static final transient Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    private static final transient String oidSeparator = "[OID]";
    public final Object oid;
    public final String pcClass;
    public final String toString;
    public final int hashCode;

    public OID() {
        this.oid = null;
        this.pcClass = null;
        this.toString = null;
        this.hashCode = -1;
    }

    public OID(String pcClass, Object object) {
        this.pcClass = pcClass;
        this.oid = object;
        StringBuffer s = new StringBuffer();
        s.append(this.oid.toString());
        s.append(oidSeparator);
        s.append(this.pcClass);
        this.toString = s.toString();
        this.hashCode = this.toString.hashCode();
    }

    public OID(String str) throws IllegalArgumentException {
        if (str.length() < 2) {
            throw new IllegalArgumentException(LOCALISER.msg("OID.InvalidValue", str));
        }
        int start = 0;
        int end = str.indexOf(oidSeparator, start);
        String oidStr = str.substring(start, end);
        Object oidValue = null;
        try {
            oidValue = new Long(oidStr);
        }
        catch (NumberFormatException nfe) {
            oidValue = oidStr;
        }
        this.oid = oidValue;
        start = end + oidSeparator.length();
        this.pcClass = str.substring(start, str.length());
        this.toString = str;
        this.hashCode = this.toString.hashCode();
    }

    public Object getNewObjectIdCopy() {
        return new OID(this.pcClass, this.oid);
    }

    public Object keyValue() {
        return this.oid;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().getName().equals(ClassNameConstants.OID)) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        return ((OID)obj).toString().equals(this.toString);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString;
    }

    public String getPcClass() {
        return this.pcClass;
    }
}

