/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jpox.ClassLoaderResolver;
import org.jpox.store.AbstractAutoStartMechanism;
import org.jpox.store.StoreData;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.DatastoreInitialisationException;

public class ClassesAutoStarter
extends AbstractAutoStartMechanism {
    protected String classNames;

    public ClassesAutoStarter(StoreManager storeMgr, ClassLoaderResolver clr) {
        this.classNames = storeMgr.getPMFContext().getPmfConfiguration().getAutoStartClassNames();
    }

    public Collection getAllClassData() throws DatastoreInitialisationException {
        HashSet<StoreData> classes = new HashSet<StoreData>();
        if (this.classNames == null) {
            return classes;
        }
        StringTokenizer tokeniser = new StringTokenizer(this.classNames, ",");
        while (tokeniser.hasMoreTokens()) {
            String name = tokeniser.nextToken();
            StoreData classData = new StoreData(name.trim(), null, true, 1, null);
            classes.add(classData);
        }
        return classes;
    }

    public void addClass(StoreData data) {
    }

    public void deleteClass(String className) {
    }

    public void deleteAllClasses() {
    }

    public String getStorageDescription() {
        return LOCALISER.msg("ClassesAutoStarter.StorageDescription");
    }
}

