/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import java.sql.Timestamp;
import java.util.HashSet;
import org.jpox.ClassLoaderResolver;
import org.jpox.plugin.PluginManager;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingManager;
import org.jpox.util.Localiser;

public abstract class AbstractDatastoreAdapter
implements DatastoreAdapter {
    protected static final Localiser LOCALISER_BASE = Localiser.getInstance("org.jpox.store.Localisation");
    protected final HashSet reservedKeywords = new HashSet();
    protected String datastoreProductName;
    protected String datastoreProductVersion;
    protected int datastoreMajorVersion;
    protected int datastoreMinorVersion;
    protected int datastoreRevisionVersion = 0;
    protected String identifierQuoteString;
    protected MappingManager mappingManager;

    protected abstract MappingManager getNewMappingManager();

    public void loadDatastoreMapping(PluginManager mgr, ClassLoaderResolver clr) {
        this.getMappingManager().loadDatastoreMapping(mgr, clr, this.getVendorID());
    }

    public MappingManager getMappingManager() {
        if (this.mappingManager == null) {
            this.mappingManager = this.getNewMappingManager();
        }
        return this.mappingManager;
    }

    public JavaTypeMapping getMapping(Class c, StoreManager storeMgr) {
        return this.getMappingManager().getMapping(c, false, false, null, this, storeMgr.getPMFContext().getTypeManager());
    }

    public JavaTypeMapping getMapping(Class c, boolean serialised, boolean embedded, String fieldName, StoreManager storeMgr) {
        return this.getMappingManager().getMapping(c, serialised, embedded, fieldName, this, storeMgr.getPMFContext().getTypeManager());
    }

    public JavaTypeMapping getMapping(Class c, StoreManager storeMgr, ClassLoaderResolver clr) {
        return this.getMappingManager().getMapping(c, false, false, storeMgr, clr, this);
    }

    protected final JavaTypeMapping getMapping(Class c, ScalarExpression expr) {
        return this.getMappingManager().getMapping(c, false, false, expr.getQueryExpression().getStoreManager(), expr.getQueryExpression().getClassLoaderResolver(), this);
    }

    public JavaTypeMapping getMapping(Class c, boolean serialised, boolean embedded, StoreManager storeMgr, ClassLoaderResolver clr) {
        return this.getMappingManager().getMapping(c, serialised, embedded, storeMgr, clr, this);
    }

    public String getVendorID() {
        return null;
    }

    public boolean isReservedKeyword(String word) {
        return this.reservedKeywords.contains(word);
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public abstract QueryExpression newQueryStatement(DatastoreContainerObject var1, ClassLoaderResolver var2);

    public abstract QueryExpression newQueryStatement(DatastoreContainerObject var1, DatastoreIdentifier var2, ClassLoaderResolver var3);

    public long getAdapterTime(Timestamp time) {
        long timestamp = this.getTime(time.getTime(), time.getNanos());
        int ms = this.getMiliseconds(time.getNanos());
        return timestamp + (long)ms;
    }

    protected long getTime(long time, long nanos) {
        if (nanos < 0L) {
            return (time / 1000L - 1L) * 1000L;
        }
        return time / 1000L * 1000L;
    }

    protected int getMiliseconds(long nanos) {
        return (int)(nanos / 1000000L);
    }

    public int getDatastoreMajorVersion() {
        return this.datastoreMajorVersion;
    }

    public int getDatastoreMinorVersion() {
        return this.datastoreMinorVersion;
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        return new NumericExpression(operand1, ScalarExpression.OP_MOD, operand2);
    }

    public boolean supportsAutoIncrementFields() {
        return false;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsQueryFetchSizeLowerThanOne() {
        return true;
    }
}

