/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.state.jpa;

import javax.jdo.FetchPlan;
import javax.jdo.JDOUserException;
import javax.jdo.Transaction;
import org.jpox.StateManager;
import org.jpox.state.IllegalStateTransitionException;
import org.jpox.state.LifeCycleState;

class PersistentNontransactional
extends LifeCycleState {
    protected PersistentNontransactional() {
        this.isPersistent = true;
        this.isDirty = false;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = false;
        this.stateType = 9;
    }

    public LifeCycleState transitionDeletePersistent(StateManager sm) {
        return this.changeState(sm, 8);
    }

    public LifeCycleState transitionMakeTransactional(StateManager sm) {
        sm.refreshLoadedFields();
        return this.changeState(sm, 2);
    }

    public LifeCycleState transitionMakeTransient(StateManager sm, boolean useFetchPlan) {
        if (useFetchPlan) {
            sm.loadUnloadedFieldsInFetchPlan();
        }
        return this.changeState(sm, 0);
    }

    public LifeCycleState transitionCommit(StateManager sm, Transaction tx) {
        throw new IllegalStateTransitionException(this, "commit", sm);
    }

    public LifeCycleState transitionRollback(StateManager sm, Transaction tx) {
        throw new IllegalStateTransitionException(this, "rollback", sm);
    }

    public LifeCycleState transitionRefresh(StateManager sm) {
        sm.refreshFieldsInFetchPlan();
        return this;
    }

    public LifeCycleState transitionEvict(StateManager sm) {
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionReadField(StateManager sm, boolean isLoaded) {
        Transaction tx = sm.getPersistenceManager().currentTransaction();
        if (!tx.isActive() && !tx.getNontransactionalRead()) {
            throw new JDOUserException(LOCALISER.msg("LifeCycle.PersistentNontransactionalReadFieldNotAllowedNotActiveTx"), sm.getInternalObjectId());
        }
        if (tx.isActive() && !tx.getOptimistic()) {
            sm.saveFields();
            sm.refreshLoadedFields();
            return this.changeState(sm, 2);
        }
        return this;
    }

    public LifeCycleState transitionWriteField(StateManager sm) {
        Transaction tx = sm.getPersistenceManager().currentTransaction();
        if (tx.isActive()) {
            sm.saveFields();
            return this.changeState(sm, 3);
        }
        return this;
    }

    public LifeCycleState transitionRetrieve(StateManager sm, boolean fgOnly) {
        Transaction tx = sm.getPersistenceManager().currentTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            sm.saveFields();
            if (fgOnly) {
                sm.loadUnloadedFieldsInFetchPlan();
            } else {
                sm.loadUnloadedFields();
            }
            return this.changeState(sm, 2);
        }
        if (tx.isActive() && tx.getOptimistic()) {
            sm.saveFields();
            if (fgOnly) {
                sm.loadUnloadedFieldsInFetchPlan();
            } else {
                sm.loadUnloadedFields();
            }
            return this;
        }
        if (fgOnly) {
            sm.loadUnloadedFieldsInFetchPlan();
        } else {
            sm.loadUnloadedFields();
        }
        return this;
    }

    public LifeCycleState transitionRetrieve(StateManager sm, FetchPlan fetchPlan) {
        Transaction tx = sm.getPersistenceManager().currentTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            sm.saveFields();
            sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
            return this.changeState(sm, 2);
        }
        if (tx.isActive() && tx.getOptimistic()) {
            sm.saveFields();
            sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
            return this;
        }
        sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
        return this;
    }

    public LifeCycleState transitionSerialize(StateManager sm) {
        Transaction tx = sm.getPersistenceManager().currentTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            return this.changeState(sm, 2);
        }
        return this;
    }

    public String toString() {
        return "P_NONTRANS";
    }
}

