/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.state;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.FetchPlan;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.Transaction;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.AbstractPersistenceManager;
import org.jpox.ClassLoaderResolver;
import org.jpox.FetchPlanImpl;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.api.ApiAdapter;
import org.jpox.cache.CachedPC;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.sco.SCO;
import org.jpox.sco.SCOCollection;
import org.jpox.sco.SCOContainer;
import org.jpox.sco.SCOMap;
import org.jpox.sco.SCOUtils;
import org.jpox.sco.UnsetOwners;
import org.jpox.state.AbstractFetchFieldManager;
import org.jpox.state.ActivityState;
import org.jpox.state.AttachFieldManager;
import org.jpox.state.CallbackHandler;
import org.jpox.state.DetachFieldManager;
import org.jpox.state.FetchPlanState;
import org.jpox.state.LifeCycleState;
import org.jpox.state.LoadFieldManager;
import org.jpox.state.MakeTransientFieldManager;
import org.jpox.state.NullifyRelationFieldManager;
import org.jpox.store.DatastoreClass;
import org.jpox.store.FieldValues;
import org.jpox.store.OID;
import org.jpox.store.OIDFactory;
import org.jpox.store.StoreManager;
import org.jpox.store.fieldmanager.FieldManager;
import org.jpox.store.fieldmanager.SingleTypeFieldManager;
import org.jpox.store.fieldmanager.SingleValueFieldManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.table.ClassTable;
import org.jpox.util.AIDUtils;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;
import org.jpox.util.TypeConversionHelper;

final class StateManagerImpl
implements StateManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private static final JDOImplHelper HELPER;
    private static final SingleTypeFieldManager HOLLOWFIELDMANAGER;
    private PersistenceManager myPM;
    protected PersistenceCapable myPC;
    private Object myID;
    private Object myInternalID;
    private LifeCycleState myLC;
    private byte jdoFlags;
    private PersistenceCapable savedImage = null;
    private byte savedFlags;
    private boolean[] savedLoadedFields = null;
    private AbstractClassMetaData cmd;
    private StoreManager srm;
    private int fieldCount;
    private boolean dirty = false;
    private boolean[] dirtyFields;
    private boolean[] loadedFields;
    private boolean[] unloadedFields;
    private boolean[] defaultFetchGroupFields;
    private boolean[] secondClassMutableFields;
    private boolean[] nonPrimaryKeyFields;
    private int[] allFieldNumbers;
    private int[] allNonPrimaryKeyFieldNumbers;
    private int[] defaultFetchGroupFieldNumbers;
    private int[] secondClassMutableFieldNumbers;
    private boolean flushedNew = false;
    private Object myVersion;
    private Object transactionalVersion;
    private FieldManager currFM = null;
    private boolean restoreValues = false;
    private FetchPlanImpl.FetchPlanForClass myFP;
    private BitSet jdoLoadedFields;
    private BitSet jdoModifiedFields;
    private ActivityState inserting = ActivityState.NONE;
    private boolean flushing = false;
    private boolean changingState = false;
    private boolean postLoadPending = false;
    private boolean disconnecting = false;
    private boolean deleting = false;
    private boolean detaching = false;
    private PersistenceCapable detachingPC = null;
    private boolean attaching = false;
    private PersistenceCapable attachedPC = null;
    private List insertionNotifyList = new ArrayList();
    private Map insertionUpdateFieldList = new HashMap();
    private int pcObjectType = 0;
    private List embeddedOwners = null;
    private HashMap externalFieldValuesByMapping = new HashMap();
    CallbackHandler callback;
    boolean loadingFetchPlanFields = false;
    private boolean updatingEmbeddedFieldsWithOwner = false;
    private DatastoreClass latestInsertedDatastoreClass = null;
    private boolean storingPC = false;
    private boolean retrievingDetachedState = false;
    private boolean resettingDetachedState = false;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$java$lang$Object;

    public StateManagerImpl(PersistenceManager pm, Class pcClass, Object id) {
        this.myPM = pm;
        this.srm = this.myPM.getStoreManager();
        this.myID = id;
        this.myLC = this.myPM.getPMFContext().getApiAdapter().getLifeCycleState(4);
        this.jdoFlags = 1;
        if (pm.getPMFContext().getTypeManager().isReferenceType(pcClass)) {
            this.cmd = pm.getMetaDataManager().getMetaDataForImplementationOfReference(pcClass, null, pm.getClassLoaderResolver());
            pcClass = pm.getClassLoaderResolver().classForName(this.cmd.getFullClassName(), pcClass.getClassLoader(), true);
        } else {
            try {
                pcClass = pm.getClassLoaderResolver().classForName(pcClass.getName(), pcClass.getClassLoader(), true);
                this.cmd = pm.getMetaDataManager().getMetaDataForClass(pcClass, this.getPersistenceManager().getClassLoaderResolver());
            }
            catch (ClassNotResolvedException e) {
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.ClassNotFoundError", pcClass.getName()));
            }
        }
        if (this.cmd == null) {
            throw new JDOFatalUserException(LOCALISER.msg("StateManager.NotPersistableClassError", pcClass));
        }
        this.myFP = ((FetchPlanImpl)this.myPM.getFetchPlan()).manageFetchPlanForClass(this.cmd);
        this.initialize();
        this.myPC = id instanceof OID || id == null ? HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this) : HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this, this.myID);
    }

    public StateManagerImpl(PersistenceCapable pc, PersistenceManager pm, boolean copyPc) {
        this.pcObjectType = 1;
        this.myPM = pm;
        this.srm = this.myPM.getStoreManager();
        this.myID = null;
        this.myLC = this.myPM.getPMFContext().getApiAdapter().getLifeCycleState(1);
        this.jdoFlags = 1;
        this.myPC = pc;
        this.replaceStateManager(this);
        this.cmd = pm.getMetaDataManager().getMetaDataForClass(pc.getClass().getName(), pm.getClassLoaderResolver());
        if (this.cmd == null) {
            throw new JDOFatalUserException(LOCALISER.msg("StateManager.NotPersistableClassError", pc.getClass().getName()));
        }
        this.myFP = ((FetchPlanImpl)this.myPM.getFetchPlan()).manageFetchPlanForClass(this.cmd);
        this.initialize();
        if (copyPc) {
            PersistenceCapable pcCopy = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
            pcCopy.jdoCopyFields((Object)this.myPC, this.allFieldNumbers);
            pcCopy.jdoReplaceStateManager((javax.jdo.spi.StateManager)this);
            this.myPC = pcCopy;
            this.disconnectClone(pc);
        }
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
    }

    public StateManagerImpl(PersistenceManager pm, Class pcClass, FieldValues fv) {
        this.myPM = pm;
        this.srm = this.myPM.getStoreManager();
        this.myLC = this.myPM.getPMFContext().getApiAdapter().getLifeCycleState(4);
        this.jdoFlags = 1;
        pcClass = pm.getClassLoaderResolver().classForName(pcClass.getName(), pcClass.getClassLoader(), true);
        this.cmd = pm.getMetaDataManager().getMetaDataForClass(pcClass, this.getPersistenceManager().getClassLoaderResolver());
        if (this.cmd == null) {
            throw new JDOFatalUserException(LOCALISER.msg("StateManager.NotPersistableClassError", pcClass));
        }
        if (this.cmd.getIdentityType() != IdentityType.APPLICATION) {
            throw new JDOFatalUserException("This constructor is only for objects using application identity.");
        }
        this.myFP = ((FetchPlanImpl)this.myPM.getFetchPlan()).manageFetchPlanForClass(this.cmd);
        this.initialize();
        this.myPC = HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this);
        if (this.myPC == null) {
            if (!HELPER.getRegisteredClasses().contains(pcClass)) {
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.ClassNotRegistered", pcClass.getName()));
            }
            throw new JDOFatalUserException(LOCALISER.msg("StateManager.ClassNotConstructable", pcClass.getName()));
        }
        this.loadFieldValues(fv);
        this.myID = this.myPC.jdoNewObjectIdInstance();
        if (!this.cmd.usesSingleFieldIdentityClass()) {
            this.myPC.jdoCopyKeyFieldsToObjectId(this.myID);
        }
    }

    public void checkInheritance(FieldValues fv) {
        ClassLoaderResolver clr = this.myPM.getClassLoaderResolver();
        String className = this.srm.getClassNameForObjectID(this.myID, clr, this.myPM);
        if (className == null) {
            throw new JDOObjectNotFoundException(LOCALISER.msg("StateManager.ObjectDoesntExist"), this.myID);
        }
        if (!this.cmd.getFullClassName().equals(className)) {
            Class pcClass;
            try {
                pcClass = this.getPersistenceManager().getClassLoaderResolver().classForName(className, this.myID.getClass().getClassLoader(), true);
                this.cmd = this.myPM.getMetaDataManager().getMetaDataForClass(pcClass, this.getPersistenceManager().getClassLoaderResolver());
            }
            catch (ClassNotResolvedException e) {
                JPOXLogger.JDO.warn(LOCALISER.msg("StateManager.GetObjectByIdClassNotFound", this.myID));
                throw new JDOUserException(LOCALISER.msg("StateManager.GetObjectByIdClassNotFound", this.myID), (Throwable)((Object)e));
            }
            if (this.cmd == null) {
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.NotPersistableClassError", pcClass));
            }
            if (this.cmd.getIdentityType() != IdentityType.APPLICATION) {
                throw new JDOFatalUserException("This constructor is only for objects using application identity.");
            }
            this.myFP = ((FetchPlanImpl)this.myPM.getFetchPlan()).manageFetchPlanForClass(this.cmd);
            this.initialize();
            this.myPC = HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this);
            if (this.myPC == null) {
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.ClassNotRegistered", this.cmd.getFullClassName()));
            }
            this.loadFieldValues(fv);
            this.myID = this.myPC.jdoNewObjectIdInstance();
            if (!this.cmd.usesSingleFieldIdentityClass()) {
                this.myPC.jdoCopyKeyFieldsToObjectId(this.myID);
            }
        }
    }

    public StateManagerImpl(PersistenceManager pm, Class pcClass, Object id, FieldValues fv) {
        this(pm, pcClass, id);
        this.loadFieldValues(fv);
    }

    public StateManagerImpl(PersistenceManager pm, PersistenceCapable pc, FieldValues preInsertChanges) {
        Class<?> pcClass = pc.getClass();
        this.myPM = pm;
        this.srm = this.myPM.getStoreManager();
        this.myPC = pc;
        this.myLC = this.myPM.getPMFContext().getApiAdapter().getLifeCycleState(1);
        this.jdoFlags = (byte)-1;
        this.cmd = pm.getPMFContext().getTypeManager().isReferenceType(pcClass) ? pm.getMetaDataManager().getMetaDataForImplementationOfReference(pcClass, null, pm.getClassLoaderResolver()) : pm.getMetaDataManager().getMetaDataForClass(pm.getClassLoaderResolver().classForName(pcClass.getName(), pcClass.getClassLoader(), true), this.getPersistenceManager().getClassLoaderResolver());
        if (this.cmd == null) {
            throw new JDOFatalUserException(LOCALISER.msg("StateManager.NotPersistableClassError", pcClass.getName()));
        }
        this.myFP = ((FetchPlanImpl)this.myPM.getFetchPlan()).manageFetchPlanForClass(this.cmd);
        this.initialize();
        for (int i = 0; i < this.fieldCount; ++i) {
            this.loadedFields[i] = true;
        }
        this.replaceStateManager(this);
        this.myPC.jdoReplaceFlags();
        this.saveFields();
        this.populateStrategyFields();
        if (preInsertChanges != null) {
            preInsertChanges.fetchFields(this);
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            for (int fieldNumber = 0; fieldNumber < this.allFieldNumbers.length; ++fieldNumber) {
                AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
                if (!fmd.isPrimaryKey() || pm.getMetaDataManager().getMetaDataForClass(fmd.getType(), this.getPersistenceManager().getClassLoaderResolver()) == null) continue;
                FieldManager oldFM = this.currFM;
                this.currFM = new SingleValueFieldManager();
                this.myPC.jdoProvideField(fieldNumber);
                PersistenceCapable pkFieldPC = (PersistenceCapable)((SingleValueFieldManager)this.currFM).fetchObjectField(fieldNumber);
                if (pkFieldPC == null) {
                    throw new JDOUserException(LOCALISER.msg("StateManager.PrimaryKeyFieldIsNull", fmd.getFullFieldName()));
                }
                if (!pkFieldPC.jdoIsPersistent()) {
                    this.myPM.makePersistentInternal(pkFieldPC, null);
                }
                this.currFM = oldFM;
            }
        }
        this.setIdentity();
        this.myPM.enlistInTransaction(this);
    }

    public StateManagerImpl(PersistenceManager pm, PersistenceCapable pc) {
        Class<?> pcClass = pc.getClass();
        this.myPM = pm;
        this.srm = this.myPM.getStoreManager();
        this.myPC = pc;
        this.myLC = null;
        this.jdoFlags = (byte)-1;
        this.cmd = pm.getPMFContext().getTypeManager().isReferenceType(pcClass) ? pm.getMetaDataManager().getMetaDataForImplementationOfReference(pcClass, pc, pm.getClassLoaderResolver()) : pm.getMetaDataManager().getMetaDataForClass(pm.getClassLoaderResolver().classForName(pcClass.getName(), pcClass.getClassLoader(), true), this.getPersistenceManager().getClassLoaderResolver());
        if (this.cmd == null) {
            throw new JDOFatalUserException(LOCALISER.msg("StateManager.NotPersistableClassError", pcClass.getName()));
        }
        this.myFP = ((FetchPlanImpl)this.myPM.getFetchPlan()).manageFetchPlanForClass(this.cmd);
        this.initialize();
        for (int i = 0; i < this.fieldCount; ++i) {
            this.loadedFields[i] = true;
        }
        this.myPC.jdoReplaceFlags();
        this.populateStrategyFields();
        this.setIdentity();
        if (this.myPM.currentTransaction().isActive()) {
            this.myPM.enlistInTransaction(this);
        }
    }

    public StateManagerImpl(PersistenceManager pm, ApiAdapter apiAdapter, PersistenceCapable pc, AbstractClassMetaData cmd, Object id, Object version) {
        this.cmd = cmd;
        this.myID = id;
        this.myPC = pc;
        this.myPM = pm;
        this.myFP = null;
        this.srm = null;
        this.setVersion(version);
        this.myLC = apiAdapter.getLifeCycleState(10);
        this.myPC.jdoReplaceFlags();
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateManagerImpl(PersistenceManager pm, Object id, PersistenceCapable pc, boolean[] loaded) {
        this(pm, pc.getClass(), id);
        this.myLC = this.myPM.getPMFContext().getApiAdapter().getLifeCycleState(2);
        this.jdoFlags = (byte)-1;
        PersistenceCapable persistenceCapable = pc;
        synchronized (persistenceCapable) {
            int i;
            pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)this);
            this.myPC.jdoCopyFields((Object)pc, this.allFieldNumbers);
            for (i = 0; i < this.loadedFields.length; ++i) {
                this.loadedFields[i] = loaded[i];
            }
            for (i = 0; i < this.cmd.getPersistenceCapableFieldNumbers().length; ++i) {
                this.loadedFields[this.cmd.getPersistenceCapableFieldNumbers()[i]] = false;
            }
            for (i = 0; i < this.secondClassMutableFieldNumbers.length; ++i) {
                this.loadedFields[this.secondClassMutableFieldNumbers[i]] = false;
            }
            this.disconnectClone(pc);
        }
        if (this.isFetchPlanLoaded()) {
            this.postLoad();
        }
    }

    private void populateStrategyFields() {
        int totalFieldCount = this.cmd.getNoOfInheritedManagedFields() + this.cmd.getNoOfManagedFields();
        DatastoreClass table = null;
        if (!this.cmd.isEmbeddedOnly()) {
            table = this.srm.getDatastoreClass(this.cmd.getFullClassName(), this.myPM.getClassLoaderResolver());
        }
        for (int fieldNumber = 0; fieldNumber < totalFieldCount; ++fieldNumber) {
            AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
            IdentityStrategy strategy = fmd.getValueStrategy();
            if (strategy == null || this.srm.isStrategyDatastoreAttributed(strategy)) continue;
            boolean applyStrategy = true;
            if (!fmd.getType().isPrimitive() && strategy != null && fmd.hasExtension("strategy-when-notnull") && fmd.getValueForExtension("strategy-when-notnull").equalsIgnoreCase("false") && this.provideField(fieldNumber) != null) {
                applyStrategy = false;
            }
            if (!applyStrategy) continue;
            DatastoreClass fieldTable = table.getBaseDatastoreClassWithField(fmd);
            Object obj = this.srm.getStrategyValue(this.myPM, fieldTable, this.cmd, fieldNumber, strategy, fmd.getSequence(), fmd.getExtensions());
            this.replaceField(fieldNumber, obj);
        }
    }

    public void loadFieldValues(FieldValues fv) {
        FetchPlanImpl.FetchPlanForClass origFetchPlan = this.myFP;
        FetchPlanImpl loadFetchPlan = fv.getFetchPlanForLoading();
        if (loadFetchPlan != null) {
            this.myFP = loadFetchPlan.manageFetchPlanForClass(this.cmd);
        }
        boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
        fv.fetchFields(this);
        if (callPostLoad && this.isFetchPlanLoaded()) {
            this.postLoad();
        }
        this.myFP = origFetchPlan;
    }

    private void setIdentity() {
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            boolean isObjectIDDatastoreAttributed = false;
            int totalFieldCount = this.cmd.getNoOfInheritedManagedFields() + this.cmd.getNoOfManagedFields();
            for (int fieldNumber = 0; fieldNumber < totalFieldCount; ++fieldNumber) {
                AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
                if (!fmd.isPrimaryKey()) continue;
                if (this.srm.isStrategyDatastoreAttributed(fmd.getValueStrategy())) {
                    isObjectIDDatastoreAttributed = true;
                    break;
                }
                if (!this.cmd.usesSingleFieldIdentityClass() || this.provideField(fieldNumber) != null) continue;
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.SingleFieldIdentityPKFieldIsNull", this.cmd.getFullClassName(), fmd.getName()));
            }
            if (!isObjectIDDatastoreAttributed) {
                this.myID = this.srm.newObjectID(this.myPM, this.cmd.getFullClassName(), this.myPC);
            }
        } else if (this.cmd.getIdentityMetaData() == null || !this.srm.isStrategyDatastoreAttributed(this.cmd.getIdentityMetaData().getStrategyValue())) {
            this.myID = this.srm.newObjectID(this.myPM, this.cmd.getFullClassName(), this.myPC);
        }
        if (this.myInternalID != this.myID && this.myID != null) {
            this.myPM.replaceObjectId(this.myPC, this.myInternalID, this.myID);
        }
    }

    public CachedPC getL2CacheableObject() {
        PersistenceCapable pcCopy = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this, this.myPC.jdoGetObjectId());
        int[] containerFieldNumbers = this.cmd.getSecondClassContainerFieldNumbers();
        int[] noncontainerFieldNumbers = new int[this.allFieldNumbers.length - containerFieldNumbers.length];
        boolean[] l2loadedFields = new boolean[this.allFieldNumbers.length];
        int nonNum = 0;
        for (int i = 0; i < this.allFieldNumbers.length; ++i) {
            boolean noncontainer = true;
            for (int j = 0; j < containerFieldNumbers.length; ++j) {
                if (containerFieldNumbers[j] != this.allFieldNumbers[i]) continue;
                noncontainer = false;
                break;
            }
            if (noncontainer) {
                noncontainerFieldNumbers[nonNum++] = this.allFieldNumbers[i];
                l2loadedFields[i] = noncontainer && this.loadedFields[i];
                continue;
            }
            l2loadedFields[i] = false;
        }
        pcCopy.jdoCopyFields((Object)this.myPC, noncontainerFieldNumbers);
        pcCopy.jdoReplaceFlags();
        pcCopy.jdoReplaceStateManager(null);
        return new CachedPC(pcCopy, l2loadedFields);
    }

    private void initialize() {
        this.fieldCount = this.cmd.getNoOfInheritedManagedFields() + this.cmd.getNoOfManagedFields();
        this.dirtyFields = new boolean[this.fieldCount];
        this.loadedFields = new boolean[this.fieldCount];
        this.unloadedFields = new boolean[this.fieldCount];
        this.defaultFetchGroupFields = this.cmd.getDefaultFetchGroupFieldFlags();
        this.secondClassMutableFields = this.cmd.getSecondClassMutableFieldFlags();
        this.nonPrimaryKeyFields = this.cmd.getNonPrimaryKeyFieldFlags();
        this.allFieldNumbers = this.cmd.getAllFieldNumbers();
        this.allNonPrimaryKeyFieldNumbers = this.cmd.getNonPrimaryKeyFieldNumbers();
        this.defaultFetchGroupFieldNumbers = this.cmd.getDefaultFetchGroupFieldNumbers();
        this.secondClassMutableFieldNumbers = this.cmd.getSecondClassMutableFieldNumbers();
        if (this.myPM != null) {
            this.callback = this.myPM.getCallbackHandler();
        }
    }

    private void replaceStateManager(javax.jdo.spi.StateManager sm) {
        try {
            this.myPC.jdoReplaceStateManager(sm);
        }
        catch (SecurityException e) {
            throw new JDOFatalUserException(LOCALISER.msg("StateManager.SecurityProblem"), (Throwable)e);
        }
    }

    public void enlistInTransaction() {
        this.myPM.enlistInTransaction(this);
        if (this.jdoFlags == 1 && this.isDFGLoaded()) {
            this.jdoFlags = (byte)-1;
            this.myPC.jdoReplaceFlags();
        }
    }

    public void evictFromTransaction() {
        this.myPM.evictFromTransaction(this);
        this.jdoFlags = 1;
        this.myPC.jdoReplaceFlags();
    }

    public void saveFields() {
        this.savedImage = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
        this.savedImage.jdoCopyFields((Object)this.myPC, this.allFieldNumbers);
        this.savedFlags = this.jdoFlags;
        this.savedLoadedFields = (boolean[])this.loadedFields.clone();
    }

    public void restoreFields() {
        if (this.savedImage != null) {
            this.loadedFields = this.savedLoadedFields;
            this.jdoFlags = this.savedFlags;
            this.myPC.jdoReplaceFlags();
            this.myPC.jdoCopyFields((Object)this.savedImage, this.allFieldNumbers);
            this.clearDirtyFlags();
            this.clearSavedFields();
        }
    }

    public void clearFields() {
        this.clearFieldsByNumbers(this.allFieldNumbers);
    }

    public void clearNonPrimaryKeyFields() {
        this.clearFieldsByNumbers(this.allNonPrimaryKeyFieldNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFieldsByNumbers(int[] fieldNumbers) {
        try {
            this.callback.preClear(this.myPC);
        }
        finally {
            this.replaceFields(fieldNumbers, HOLLOWFIELDMANAGER);
            this.clearLoadedFlags();
            this.clearDirtyFlags();
            this.callback.postClear(this.myPC);
        }
    }

    public void clearSavedFields() {
        this.savedImage = null;
        this.savedFlags = 0;
        this.savedLoadedFields = null;
    }

    public void clearLoadedFlags() {
        this.jdoFlags = 1;
        this.myPC.jdoReplaceFlags();
        StateManagerImpl.clearFlags(this.loadedFields);
    }

    private void clearDirtyFlags() {
        this.dirty = false;
        StateManagerImpl.clearFlags(this.dirtyFields);
    }

    private void clearDirtyFlags(int[] fields) {
        this.dirty = false;
        StateManagerImpl.clearFlags(this.dirtyFields, fields);
    }

    public String[] getDirtyFieldNames() {
        int[] dirtyFieldNumbers = StateManagerImpl.getFlagsSetTo(this.dirtyFields, true);
        if (dirtyFieldNumbers != null && dirtyFieldNumbers.length > 0) {
            String[] dirtyFieldNames = new String[dirtyFieldNumbers.length];
            for (int i = 0; i < dirtyFieldNumbers.length; ++i) {
                dirtyFieldNames[i] = this.cmd.getManagedFieldAbsolute(dirtyFieldNumbers[i]).getName();
            }
            return dirtyFieldNames;
        }
        return null;
    }

    public String[] getLoadedFieldNames() {
        int[] loadedFieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, true);
        if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
            String[] loadedFieldNames = new String[loadedFieldNumbers.length];
            for (int i = 0; i < loadedFieldNumbers.length; ++i) {
                loadedFieldNames[i] = this.cmd.getManagedFieldAbsolute(loadedFieldNumbers[i]).getName();
            }
            return loadedFieldNames;
        }
        return null;
    }

    public void makeDirty(int field) {
        boolean wasDirty = this.preWriteField(field);
        this.postWriteField(wasDirty);
    }

    public void makeDirty(PersistenceCapable pc, String fieldName) {
        if (!this.disconnectClone(pc)) {
            int fieldNumber = this.cmd.getFieldNumberAbsolute(fieldName);
            if (fieldNumber == -1) {
                throw new JDOUserException(LOCALISER.msg("StateManager.InvalidFieldForClass", fieldName, this.cmd.getFullClassName()));
            }
            this.makeDirty(fieldNumber);
        }
    }

    public StoreManager getStoreManager() {
        return this.srm;
    }

    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    public MetaDataManager getMetaDataManager() {
        return this.myPM.getMetaDataManager();
    }

    public javax.jdo.PersistenceManager getPersistenceManager(PersistenceCapable pc) {
        if (this.myPC != null && this.disconnectClone(pc)) {
            return null;
        }
        if (this.myPM == null) {
            return null;
        }
        this.myPM.hereIsStateManager(this, this.myPC);
        return this.myPM.getPMHandle();
    }

    public PersistenceManager getPersistenceManager() {
        if (this.myPM == null) {
            return null;
        }
        return this.myPM.getPMHandle();
    }

    public PersistenceCapable getObject() {
        return this.myPC;
    }

    public boolean isRestoreValues() {
        return this.restoreValues;
    }

    private void setRestoreValues(boolean restore_values) {
        this.restoreValues = restore_values;
    }

    public Object getObjectId(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return null;
        }
        return this.getExternalObjectId(pc);
    }

    public Object getInternalObjectId() {
        if (this.myID != null) {
            return this.myID;
        }
        if (this.myInternalID == null) {
            this.myInternalID = super.toString();
            return this.myInternalID;
        }
        return this.myInternalID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPostStoreNewObjectId(Object id) {
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                this.myID = null;
                int fieldNumber = 0;
                for (fieldNumber = 0; fieldNumber < this.fieldCount; ++fieldNumber) {
                    AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
                    if (!fmd.isPrimaryKey() || !this.srm.isStrategyDatastoreAttributed(fmd.getValueStrategy())) continue;
                    this.replaceField(fieldNumber, TypeConversionHelper.convertTo(id, fmd.getType()));
                }
            }
            catch (Exception e) {
                JPOXLogger.RDBMS.error(e);
            }
            finally {
                this.myID = AIDUtils.getNewObjectId(this.getObject(), this.cmd);
            }
        } else {
            this.myID = OIDFactory.getInstance(this.cmd.getFullClassName(), id);
        }
        if (this.myInternalID != this.myID && this.myID != null) {
            this.myPM.replaceObjectId(this.myPC, this.myInternalID, this.myID);
        }
    }

    public Object getExternalObjectId(PersistenceCapable pc) {
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            if (!this.flushing && !this.flushedNew && this.inserting == ActivityState.NONE && this.myLC.stateType() == 1) {
                int[] pkFieldNumbers = this.cmd.getPrimaryKeyFieldNumbers();
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(i);
                    if (!this.srm.isStrategyDatastoreAttributed(fmd.getValueStrategy())) continue;
                    this.flush();
                    break;
                }
            }
            if (this.cmd.usesSingleFieldIdentityClass()) {
                return this.myID;
            }
            return AIDUtils.getNewObjectId(this.myPC, this.cmd);
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE && !this.flushing && !this.flushedNew && this.inserting == ActivityState.NONE && this.myLC.stateType() == 1 && this.srm.isStrategyDatastoreAttributed(this.cmd.getIdentityMetaData().getStrategyValue())) {
            this.flush();
        }
        return this.myID;
    }

    public javax.jdo.spi.StateManager replacingStateManager(PersistenceCapable pc, javax.jdo.spi.StateManager sm) {
        if (this.myLC == null) {
            throw new JDOFatalInternalException("Null LifeCycleState");
        }
        if (this.myLC.stateType() == 10) {
            return sm;
        }
        if (pc == this.myPC) {
            if (sm == null) {
                return null;
            }
            if (sm == this) {
                return this;
            }
            if (this.myPM.getPMHandle() == ((StateManagerImpl)sm).myPM.getPMHandle()) {
                ((StateManagerImpl)sm).disconnect();
                return this;
            }
            if (sm != null) {
                throw new JDOUserException(LOCALISER.msg("StateManager.StateManagerChangeError"));
            }
            if (!this.disconnecting) {
                throw new JDOUserException(LOCALISER.msg("StateManager.StateManagerDisconnectError"));
            }
            if (JPOXLogger.JDO.isDebugEnabled()) {
                JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.ClearingStateManager", StringUtils.toJVMIDString(pc)));
            }
            return null;
        }
        if (pc == this.savedImage) {
            return null;
        }
        return sm;
    }

    public Object getTransactionalObjectId(PersistenceCapable pc) {
        return this.getObjectId(pc);
    }

    public boolean isDirty(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isDirty();
    }

    public boolean isTransactional(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isTransactional();
    }

    public boolean isPersistent(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isPersistent();
    }

    public boolean isNew(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isNew();
    }

    public boolean isDeleted(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isDeleted();
    }

    private boolean isFetchPlanLoaded() {
        int[] fpFields = this.myFP.getFieldsInActualFetchPlan();
        for (int i = 0; i < fpFields.length; ++i) {
            if (this.loadedFields[fpFields[i]]) continue;
            return false;
        }
        return true;
    }

    private boolean isDFGLoaded() {
        for (int i = 0; i < this.defaultFetchGroupFieldNumbers.length; ++i) {
            if (this.loadedFields[this.defaultFetchGroupFieldNumbers[i]]) continue;
            return false;
        }
        return true;
    }

    private void loadDFGFields() {
        int[] fieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, this.defaultFetchGroupFieldNumbers, false);
        if (fieldNumbers != null) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.srm.fetch(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.myPM.putObjectIntoCache(this, false, true);
        }
    }

    private void loadSCONonContainerFields() {
        int[] noncontainerFieldNumbers = this.cmd.getSecondClassNonContainerFieldNumbers();
        int[] fieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, noncontainerFieldNumbers, false);
        if (fieldNumbers != null) {
            this.srm.fetch(this, fieldNumbers);
            this.myPM.putObjectIntoCache(this, false, true);
        }
    }

    private void loadNonDFGFields(int[] fieldNumbers) {
        if (this.srm == null) {
            return;
        }
        if (!this.isEmbedded()) {
            this.srm.fetch(this, fieldNumbers);
        }
        this.myPM.putObjectIntoCache(this, false, true);
    }

    public void loadUnloadedFields() {
        int[] fieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, this.allFieldNumbers, false);
        if (fieldNumbers != null) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.srm.fetch(this, fieldNumbers);
            for (int i = 0; i < this.secondClassMutableFieldNumbers.length; ++i) {
                SingleValueFieldManager sfv = new SingleValueFieldManager();
                this.provideFields(new int[]{this.secondClassMutableFieldNumbers[i]}, sfv);
                Object value = sfv.fetchObjectField(i);
                if (!(value instanceof SCOContainer)) continue;
                ((SCOContainer)value).load();
            }
            if (callPostLoad) {
                this.postLoad();
            }
            this.myPM.putObjectIntoCache(this, false, true);
        }
    }

    public void loadFieldsInFetchPlan(FetchPlanState state) {
        if (this.loadingFetchPlanFields) {
            return;
        }
        this.loadingFetchPlanFields = true;
        this.loadUnloadedFieldsInFetchPlan();
        int[] fieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, this.allFieldNumbers, true);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.replaceFields(fieldNumbers, new LoadFieldManager(this, this.secondClassMutableFields, this.myFP, state));
        }
        this.loadingFetchPlanFields = false;
    }

    private void loadFieldsInFetchPlan() {
        int[] fieldNumbers = this.myFP.getFieldsInActualFetchPlan();
        if (fieldNumbers != null) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.srm.fetch(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.myPM.putObjectIntoCache(this, false, true);
        }
    }

    public void loadUnloadedFieldsInFetchPlan() {
        int[] fieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, this.myFP.getFieldsInActualFetchPlan(), false);
        if (fieldNumbers != null) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.srm.fetch(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.myPM.putObjectIntoCache(this, false, true);
        }
    }

    public void loadUnloadedFieldsOfClassInFetchPlan(FetchPlan fetchPlan) {
        FetchPlanImpl.FetchPlanForClass fpc = ((FetchPlanImpl)fetchPlan).manageFetchPlanForClass(this.cmd);
        int[] fieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, fpc.getFieldsInActualFetchPlan(), false);
        if (fieldNumbers != null) {
            boolean callPostLoad = fpc.isToCallPostLoadFetchPlan(this.loadedFields);
            this.srm.fetch(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.myPM.putObjectIntoCache(this, false, true);
        }
    }

    public void refreshFieldsInFetchPlan() {
        int[] fieldNumbers = this.myFP.getFieldsInActualFetchPlan();
        if (fieldNumbers != null) {
            this.clearDirtyFlags(fieldNumbers);
            StateManagerImpl.clearFlags(this.loadedFields, fieldNumbers);
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.srm.fetch(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.callback.postRefresh(this.myPC);
            this.myPM.putObjectIntoCache(this, false, true);
        }
    }

    public void refreshLoadedFields() {
        int[] fieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, this.myFP.getFieldsInActualFetchPlan(), true);
        if (fieldNumbers != null) {
            this.clearDirtyFlags();
            StateManagerImpl.clearFlags(this.loadedFields);
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.srm.fetch(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.myPM.putObjectIntoCache(this, false, true);
        }
    }

    public void unloadField(String fieldName) {
        FieldMetaData fmd = (FieldMetaData)this.getClassMetaData().getField(fieldName);
        this.unloadField(fmd.getAbsoluteFieldNumber());
    }

    void unloadField(int fieldNumber) {
        if (this.pcObjectType != 0) {
            throw new JDOUserException("Cannot unload field of embedded object");
        }
        this.loadedFields[fieldNumber] = false;
        this.unloadedFields[fieldNumber] = true;
    }

    void loadFieldFromDatastore(int fieldNumber) {
        this.srm.fetch(this, new int[]{fieldNumber});
    }

    public boolean isLoaded(PersistenceCapable pc, int field) {
        if (this.disconnectClone(pc)) {
            return true;
        }
        this.transitionReadField(this.loadedFields[field]);
        if (!this.loadedFields[field]) {
            Object value;
            if (!this.unloadedFields[field] && (value = this.provideField(field)) != null) {
                if (this.secondClassMutableFields[field]) {
                    if (value instanceof SCO && !(value instanceof SCOCollection) && !(value instanceof SCOMap)) {
                        SCO newValue = (SCO)this.newSCOEmptyInstance(field);
                        newValue.setValueFrom(value, true);
                        this.loadedFields[field] = true;
                        return true;
                    }
                } else if (this.isPCField(field) && value instanceof PersistenceCapable && this.loadPCFieldFromCache(field, (PersistenceCapable)value)) {
                    return true;
                }
            }
            if (this.pcObjectType != 0) {
                return true;
            }
            if (this.defaultFetchGroupFields[field]) {
                this.loadDFGFields();
            } else {
                this.loadNonDFGFields(new int[]{field});
            }
            this.unloadedFields[field] = false;
        }
        return true;
    }

    private boolean isPCField(int fieldNumber) {
        int[] pcFields = this.cmd.getPersistenceCapableFieldNumbers();
        for (int i = 0; i < pcFields.length; ++i) {
            if (pcFields[i] != fieldNumber) continue;
            return true;
        }
        return false;
    }

    private boolean loadPCFieldFromCache(int fieldNumber, PersistenceCapable pc) {
        Object externalID;
        AbstractPersistenceManager pm;
        PersistenceCapable cachedPC;
        AbstractClassMetaData fieldCmd = this.myPM.getMetaDataManager().getMetaDataForClass(pc.getClass(), this.myPM.getClassLoaderResolver());
        if (fieldCmd.getIdentityType() == IdentityType.APPLICATION && (cachedPC = (pm = (AbstractPersistenceManager)this.myPM).getObjectFromCache(externalID = AIDUtils.getNewObjectId(pc, fieldCmd))) != null) {
            this.replaceField(fieldNumber, cachedPC);
            this.loadedFields[fieldNumber] = true;
            pm.putObjectIntoCache(this.myPM.findStateManager(cachedPC), true, true);
            return true;
        }
        return false;
    }

    public boolean getBooleanField(PersistenceCapable pc, int field, boolean currentValue) {
        throw new JDOUnsupportedOptionException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public byte getByteField(PersistenceCapable pc, int field, byte currentValue) {
        throw new JDOUnsupportedOptionException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public char getCharField(PersistenceCapable pc, int field, char currentValue) {
        throw new JDOUnsupportedOptionException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public double getDoubleField(PersistenceCapable pc, int field, double currentValue) {
        throw new JDOUnsupportedOptionException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public float getFloatField(PersistenceCapable pc, int field, float currentValue) {
        throw new JDOUnsupportedOptionException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public int getIntField(PersistenceCapable pc, int field, int currentValue) {
        throw new JDOUnsupportedOptionException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public long getLongField(PersistenceCapable pc, int field, long currentValue) {
        throw new JDOUnsupportedOptionException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public short getShortField(PersistenceCapable pc, int field, short currentValue) {
        throw new JDOUnsupportedOptionException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public String getStringField(PersistenceCapable pc, int field, String currentValue) {
        throw new JDOUnsupportedOptionException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public Object getObjectField(PersistenceCapable pc, int field, Object currentValue) {
        throw new JDOUnsupportedOptionException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    private void writeField(int field, Object newValue) {
        this.replaceField(field, newValue);
    }

    public void setBooleanField(PersistenceCapable pc, int field, boolean currentValue, boolean newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue ? Boolean.TRUE : Boolean.FALSE);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, newValue ? Boolean.TRUE : Boolean.FALSE);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setByteField(PersistenceCapable pc, int field, byte currentValue, byte newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Byte(newValue));
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Byte(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Byte(newValue));
        }
    }

    public void setCharField(PersistenceCapable pc, int field, char currentValue, char newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Character(newValue));
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Character(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Character(newValue));
        }
    }

    public void setDoubleField(PersistenceCapable pc, int field, double currentValue, double newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Double(newValue));
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Double(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Double(newValue));
        }
    }

    public void setFloatField(PersistenceCapable pc, int field, float currentValue, float newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Float(newValue));
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Float(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Float(newValue));
        }
    }

    public void setIntField(PersistenceCapable pc, int field, int currentValue, int newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Integer(newValue));
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Integer(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Integer(newValue));
        }
    }

    public void setLongField(PersistenceCapable pc, int field, long currentValue, long newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Long(newValue));
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Long(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Long(newValue));
        }
    }

    public void setShortField(PersistenceCapable pc, int field, short currentValue, short newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Short(newValue));
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Short(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Short(newValue));
        }
    }

    public void setStringField(PersistenceCapable pc, int field, String currentValue, String newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || !StateManagerImpl.equals(currentValue, newValue)) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, newValue);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, newValue);
        }
    }

    public void setObjectField(PersistenceCapable pc, int field, Object currentValue, Object newValue) {
        StateManagerImpl currentSM;
        if (currentValue != null && currentValue != newValue && currentValue instanceof PersistenceCapable && (currentSM = (StateManagerImpl)this.myPM.findStateManager((PersistenceCapable)currentValue)) != null && currentSM.isEmbedded()) {
            currentSM.removeEmbeddedOwner(this, field);
        }
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            boolean loadedOldValue = false;
            Object oldValue = currentValue;
            AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(field);
            if (fmd.isDependent() && currentValue == null && newValue == null && !this.loadedFields[field]) {
                this.loadNonDFGFields(new int[]{field});
                loadedOldValue = true;
                oldValue = this.provideField(field);
            }
            boolean wasDirty = this.preWriteField(field);
            if (!this.loadedFields[field] || currentValue != newValue) {
                SCO sco;
                Object owner;
                if (currentValue instanceof SCO) {
                    ((SCO)currentValue).unsetOwner();
                }
                if (newValue instanceof SCO && (owner = (sco = (SCO)newValue).getOwner()) != null) {
                    throw new JDOUserException(LOCALISER.msg("StateManager.SecondClassObjectShareError", sco.getFieldName(), owner));
                }
                this.writeField(field, newValue);
            } else if (loadedOldValue) {
                this.writeField(field, newValue);
            }
            this.postWriteField(wasDirty);
            if (fmd.isDependent() && oldValue != null && newValue == null && oldValue instanceof PersistenceCapable) {
                this.flush();
                JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.DeleteDependentNulledField", oldValue, fmd.getFullFieldName()));
                this.myPM.deletePersistent(oldValue);
            }
        } else {
            this.replaceField(field, newValue);
        }
    }

    public void providedBooleanField(PersistenceCapable pc, int field, boolean currentValue) {
        this.currFM.storeBooleanField(field, currentValue);
    }

    public void providedByteField(PersistenceCapable pc, int field, byte currentValue) {
        this.currFM.storeByteField(field, currentValue);
    }

    public void providedCharField(PersistenceCapable pc, int field, char currentValue) {
        this.currFM.storeCharField(field, currentValue);
    }

    public void providedDoubleField(PersistenceCapable pc, int field, double currentValue) {
        this.currFM.storeDoubleField(field, currentValue);
    }

    public void providedFloatField(PersistenceCapable pc, int field, float currentValue) {
        this.currFM.storeFloatField(field, currentValue);
    }

    public void providedIntField(PersistenceCapable pc, int field, int currentValue) {
        this.currFM.storeIntField(field, currentValue);
    }

    public void providedLongField(PersistenceCapable pc, int field, long currentValue) {
        this.currFM.storeLongField(field, currentValue);
    }

    public void providedShortField(PersistenceCapable pc, int field, short currentValue) {
        this.currFM.storeShortField(field, currentValue);
    }

    public void providedStringField(PersistenceCapable pc, int field, String currentValue) {
        this.currFM.storeStringField(field, currentValue);
    }

    public void providedObjectField(PersistenceCapable pc, int fieldNumber, Object currentValue) {
        this.currFM.storeObjectField(fieldNumber, currentValue);
    }

    public byte replacingFlags(PersistenceCapable pc) {
        if (pc != this.myPC) {
            return 0;
        }
        return this.jdoFlags;
    }

    public boolean replacingBooleanField(PersistenceCapable pc, int field) {
        boolean value = this.currFM.fetchBooleanField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public byte replacingByteField(PersistenceCapable obj, int field) {
        byte value = this.currFM.fetchByteField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public char replacingCharField(PersistenceCapable obj, int field) {
        char value = this.currFM.fetchCharField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public double replacingDoubleField(PersistenceCapable obj, int field) {
        double value = this.currFM.fetchDoubleField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public float replacingFloatField(PersistenceCapable obj, int field) {
        float value = this.currFM.fetchFloatField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public int replacingIntField(PersistenceCapable obj, int field) {
        int value = this.currFM.fetchIntField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public long replacingLongField(PersistenceCapable obj, int field) {
        long value = this.currFM.fetchLongField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public short replacingShortField(PersistenceCapable obj, int field) {
        short value = this.currFM.fetchShortField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public String replacingStringField(PersistenceCapable obj, int field) {
        String value = this.currFM.fetchStringField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public Object replacingObjectField(PersistenceCapable obj, int field) {
        try {
            Object value = this.currFM.fetchObjectField(field);
            this.loadedFields[field] = true;
            return value;
        }
        catch (AbstractFetchFieldManager.EndOfFetchPlanGraphException eodge) {
            return null;
        }
    }

    public synchronized Object provideField(int fieldNumber) {
        if (!this.unloadedFields[fieldNumber]) {
            return this.provideField(this.myPC, fieldNumber);
        }
        return null;
    }

    public synchronized void replaceField(int fieldNumber, Object value) {
        this.replaceField(this.myPC, fieldNumber, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object provideField(PersistenceCapable pc, int fieldNumber) {
        Object obj;
        FieldManager prevFM = this.currFM;
        this.currFM = new SingleValueFieldManager();
        try {
            pc.jdoProvideField(fieldNumber);
            obj = this.currFM.fetchObjectField(fieldNumber);
        }
        finally {
            this.currFM = prevFM;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void replaceField(PersistenceCapable pc, int fieldNumber, Object value) {
        if (this.embeddedOwners != null) {
            Iterator ownerIter = this.embeddedOwners.iterator();
            while (ownerIter.hasNext()) {
                EmbeddedOwnerRelation owner = (EmbeddedOwnerRelation)ownerIter.next();
                StateManagerImpl ownerSM = (StateManagerImpl)owner.sm;
                AbstractPropertyMetaData ownerFmd = ownerSM.cmd.getManagedFieldAbsolute(owner.fieldNumber);
                if (ownerFmd.getCollection() != null) {
                    Object ownerField = ownerSM.provideField(owner.fieldNumber);
                    if (!(ownerField instanceof SCOCollection)) continue;
                    ((SCOCollection)ownerField).updateEmbeddedElement(this.myPC, fieldNumber, value);
                    continue;
                }
                if (ownerFmd.getMap() != null) {
                    Object ownerField = ownerSM.provideField(owner.fieldNumber);
                    if (!(ownerField instanceof SCOMap)) continue;
                    if (this.pcObjectType == 3) {
                        ((SCOMap)ownerField).updateEmbeddedKey(this.myPC, fieldNumber, value);
                    }
                    if (this.pcObjectType != 4) continue;
                    ((SCOMap)ownerField).updateEmbeddedValue(this.myPC, fieldNumber, value);
                    continue;
                }
                if (ownerSM.updatingEmbeddedFieldsWithOwner) continue;
                if (ownerSM.isEmbedded()) {
                    ownerSM.replaceField(owner.fieldNumber, pc);
                    continue;
                }
                boolean wasDirty = ownerSM.preWriteField(owner.fieldNumber);
                ownerSM.replaceField(owner.fieldNumber, pc);
                ownerSM.postWriteField(wasDirty);
            }
        }
        FieldManager prevFM = this.currFM;
        this.currFM = new SingleValueFieldManager();
        try {
            this.currFM.storeObjectField(fieldNumber, value);
            pc.jdoReplaceField(fieldNumber);
        }
        finally {
            this.currFM = prevFM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void provideFields(int[] fieldNumbers, FieldManager fm) {
        FieldManager prevFM = this.currFM;
        this.currFM = fm;
        try {
            this.myPC.jdoProvideFields(fieldNumbers);
        }
        finally {
            this.currFM = prevFM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void replaceFields(int[] fieldNumbers, FieldManager fm, boolean replaceWhenDirty) {
        FieldManager prevFM = this.currFM;
        this.currFM = fm;
        try {
            int[] fieldsToReplace = fieldNumbers;
            if (!replaceWhenDirty) {
                int numberToReplace = fieldNumbers.length;
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (!this.dirtyFields[fieldNumbers[i]]) continue;
                    --numberToReplace;
                }
                if (numberToReplace > 0 && numberToReplace != fieldNumbers.length) {
                    fieldsToReplace = new int[numberToReplace];
                    int n = 0;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (this.dirtyFields[fieldNumbers[i]]) continue;
                        fieldsToReplace[n++] = fieldNumbers[i];
                    }
                } else if (numberToReplace == 0) {
                    fieldsToReplace = null;
                }
            }
            if (fieldsToReplace != null) {
                this.myPC.jdoReplaceFields(fieldsToReplace);
            }
        }
        finally {
            this.currFM = prevFM;
        }
    }

    public synchronized void replaceFields(int[] fieldNumbers, FieldManager fm) {
        this.replaceFields(fieldNumbers, fm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void replaceNonLoadedFields(int[] fieldNumbers, FieldManager fm) {
        FieldManager prevFM = this.currFM;
        this.currFM = fm;
        boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
        try {
            int[] fieldsToReplace = StateManagerImpl.getFlagsSetTo(this.loadedFields, fieldNumbers, false);
            if (fieldsToReplace != null) {
                this.myPC.jdoReplaceFields(fieldsToReplace);
            }
        }
        finally {
            this.currFM = prevFM;
        }
        if (callPostLoad && this.isFetchPlanLoaded()) {
            this.postLoad();
        }
    }

    public boolean isEmbedded() {
        return this.pcObjectType > 0;
    }

    public void setPcObjectType(int embeddedType) {
        this.pcObjectType = embeddedType;
    }

    public void addEmbeddedOwner(StateManager ownerSM, int ownerFieldNumber) {
        if (ownerSM == null) {
            return;
        }
        if (this.embeddedOwners == null) {
            this.embeddedOwners = new ArrayList();
        }
        this.embeddedOwners.add(new EmbeddedOwnerRelation(ownerSM, ownerFieldNumber));
    }

    public void removeEmbeddedOwner(javax.jdo.spi.StateManager ownerSM, int ownerFieldNumber) {
        if (this.embeddedOwners != null) {
            Iterator iter = this.embeddedOwners.iterator();
            while (iter.hasNext()) {
                EmbeddedOwnerRelation relation = (EmbeddedOwnerRelation)iter.next();
                if (relation.sm != ownerSM || relation.fieldNumber != ownerFieldNumber) continue;
                iter.remove();
                break;
            }
        }
    }

    public Object newSCOInstance(int fieldNumber, Object value, boolean forUpdate) {
        AbstractPropertyMetaData fmd;
        if (value instanceof PersistenceCapable && (fmd = this.cmd.getManagedFieldAbsolute(fieldNumber)).getEmbeddedMetaData() != null && fmd.getEmbeddedMetaData().getOwnerField() != null) {
            StateManagerImpl subSM = (StateManagerImpl)this.myPM.findStateManager((PersistenceCapable)value);
            int ownerAbsFieldNum = subSM.cmd.getFieldNumberAbsolute(fmd.getEmbeddedMetaData().getOwnerField());
            if (ownerAbsFieldNum >= 0) {
                this.updatingEmbeddedFieldsWithOwner = true;
                subSM.replaceField(ownerAbsFieldNum, this.myPC);
                this.updatingEmbeddedFieldsWithOwner = false;
            }
        }
        if (this.secondClassMutableFields[fieldNumber] && value != null && (!(value instanceof SCO) || this.myPC != ((SCO)value).getOwner())) {
            fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
            SCO newValue = SCOUtils.newSCOInstance(fmd.getType(), this, fmd, value, forUpdate);
            value = newValue;
        }
        return value;
    }

    public Object replaceSCOField(int fieldNumber, Object value) {
        Object newValue = this.newSCOInstance(fieldNumber, value, true);
        if (newValue != value) {
            this.replaceField(fieldNumber, newValue);
        }
        return newValue;
    }

    public Object newSCOEmptyInstance(int fieldNumber) {
        AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
        SCO newValue = SCOUtils.newSCOInstance(fmd.getType(), this, fmd, null, false);
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionReadField(boolean isLoaded) {
        if (this.myLC == null) {
            return;
        }
        PersistenceCapable persistenceCapable = this.myPC;
        synchronized (persistenceCapable) {
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionReadField(this, isLoaded);
            }
            finally {
                this.postStateChange();
            }
        }
    }

    private void transitionReadField() {
        this.transitionReadField(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionWriteField() {
        PersistenceCapable persistenceCapable = this.myPC;
        synchronized (persistenceCapable) {
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionWriteField(this);
            }
            finally {
                this.postStateChange();
            }
        }
    }

    public Object getVersion(PersistenceCapable pc) {
        if (pc == this.myPC) {
            return this.myVersion;
        }
        return null;
    }

    public void setTransactionalVersion(Object version) {
        this.transactionalVersion = version;
    }

    public Object getTransactionalVersion(PersistenceCapable pc) {
        return this.transactionalVersion;
    }

    public void setVersion(Object version) {
        this.myVersion = version;
        this.transactionalVersion = version;
    }

    public int getHighestFieldNumber() {
        return this.cmd.getNoOfManagedFields() + this.cmd.getNoOfInheritedManagedFields();
    }

    public LifeCycleState getLifecycleState() {
        return this.myLC;
    }

    public void runReachability(Set reachables) {
        if (reachables == null) {
            return;
        }
        if (!reachables.contains(this.getInternalObjectId())) {
            this.flush();
            if (this.isDeleted(this.myPC)) {
                return;
            }
            if (this.getPersistenceManager().isEnlistedInTransaction(this.getInternalObjectId())) {
                this.loadUnloadedFields();
            }
            if (JPOXLogger.JDO_REACHABILITY.isDebugEnabled()) {
                JPOXLogger.JDO_REACHABILITY.debug("Adding instance of " + this.cmd.getFullClassName() + " with id \"" + this.getObjectId(this.myPC) + "\" and lifecycle state \"" + this.myLC + "\" to the list of reachables on commit.");
            }
            reachables.add(this.getInternalObjectId());
            for (int i = 0; i < this.loadedFields.length; ++i) {
                PersistenceCapable pc;
                StateManager valueSM;
                if (!this.loadedFields[i]) continue;
                Object value = this.provideField(i);
                if (value == null) {
                    if (!JPOXLogger.JDO_REACHABILITY.isDebugEnabled()) continue;
                    JPOXLogger.JDO_REACHABILITY.debug("Performing reachability on field " + this.cmd.getManagedFieldAbsolute(i).getFullFieldName() + " which is null");
                    continue;
                }
                if (this.secondClassMutableFields[i] && value instanceof SCOContainer) {
                    if (JPOXLogger.JDO_REACHABILITY.isDebugEnabled()) {
                        JPOXLogger.JDO_REACHABILITY.debug("Performing reachability on SCO field " + this.cmd.getManagedFieldAbsolute(i).getFullFieldName());
                    }
                    SCOContainer sco = (SCOContainer)value;
                    sco.runReachability(reachables);
                    continue;
                }
                if (value.getClass().isArray()) {
                    if (JPOXLogger.JDO_REACHABILITY.isDebugEnabled()) {
                        JPOXLogger.JDO_REACHABILITY.debug("Performing reachability on Array field " + this.cmd.getManagedFieldAbsolute(i).getFullFieldName());
                    }
                    if (!(class$javax$jdo$spi$PersistenceCapable == null ? StateManagerImpl.class$("javax.jdo.spi.PersistenceCapable") : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(value.getClass().getComponentType()) && !value.getClass().getComponentType().isInterface() && value.getClass().getComponentType() != (class$java$lang$Object == null ? StateManagerImpl.class$("java.lang.Object") : class$java$lang$Object)) continue;
                    Object[] arrValue = (Object[])value;
                    for (int j = 0; j < arrValue.length; ++j) {
                        PersistenceCapable pc2 = (PersistenceCapable)arrValue[j];
                        StateManager elementSM = this.myPM.findStateManager(pc2);
                        if (elementSM == null) continue;
                        elementSM.runReachability(reachables);
                    }
                    continue;
                }
                if (!(value instanceof PersistenceCapable)) continue;
                if (JPOXLogger.JDO_REACHABILITY.isDebugEnabled()) {
                    JPOXLogger.JDO_REACHABILITY.debug("Performing reachability on PersistenceCapable field " + this.cmd.getManagedFieldAbsolute(i).getFullFieldName());
                }
                if ((valueSM = this.myPM.findStateManager(pc = (PersistenceCapable)value)) != null) {
                    valueSM.runReachability(reachables);
                    continue;
                }
                if (!JPOXLogger.JDO_REACHABILITY.isDebugEnabled()) continue;
                JPOXLogger.JDO_REACHABILITY.debug("Cannot retrieve a StateManger for PersistenceCapable field " + this.cmd.getManagedFieldAbsolute(i).getFullFieldName() + " with object id " + pc.jdoGetObjectId());
            }
        }
    }

    public void makePersistent() {
        if (this.flushedNew) {
            this.registerTransactional();
            return;
        }
        if (this.cmd.isEmbeddedOnly()) {
            return;
        }
        this.callback.postCreate(this.myPC);
        if (this.myID == null) {
            this.setIdentity();
        }
        this.dirty = true;
        if (this.myPM.isDelayDatastoreOperationsEnabled()) {
            this.myPM.markDirty(this);
        } else {
            this.internalMakePersistent();
        }
        this.registerTransactional();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalMakePersistent() {
        this.inserting = ActivityState.INSERTING;
        try {
            this.callback.preStore(this.myPC);
            this.clearDirtyFlags();
            this.srm.insert(this);
            this.inserting = ActivityState.NONE;
            this.flushedNew = true;
        }
        finally {
            this.inserting = ActivityState.NONE;
            this.flushedNew = true;
            this.callback.postStore(this.myPC);
        }
    }

    public boolean isInserting() {
        return this.inserting == ActivityState.INSERTING;
    }

    public boolean isInserted(int fieldNumber) {
        if (!this.isInserting()) {
            return true;
        }
        if (this.latestInsertedDatastoreClass == null) {
            return false;
        }
        AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
        if (fmd == null) {
            return false;
        }
        if (this.latestInsertedDatastoreClass instanceof ClassTable) {
            return this.latestInsertedDatastoreClass.managesClass(fmd.getClassName());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeActivityState(ActivityState activityState, DatastoreClass table) {
        if (activityState != ActivityState.INSERTING_CALLBACKS) {
            this.inserting = activityState;
        }
        if (activityState == ActivityState.INSERTING_CALLBACKS) {
            this.latestInsertedDatastoreClass = table;
            if (table.managesClass(this.cmd.getFullClassName())) {
                this.inserting = activityState;
                List list = this.insertionNotifyList;
                synchronized (list) {
                    for (int i = 0; i < this.insertionNotifyList.size(); ++i) {
                        StateManagerImpl notifySM = (StateManagerImpl)this.insertionNotifyList.get(i);
                        notifySM.insertionCompleted(this);
                    }
                    this.insertionNotifyList.clear();
                }
            }
        }
    }

    public void addInsertionNotifier(javax.jdo.spi.StateManager sm, ActivityState activityState) {
        this.insertionNotifyList.add(sm);
    }

    public void updateFieldAfterInsert(PersistenceCapable pc, int fieldNumber) {
        StateManagerImpl otherSM = (StateManagerImpl)this.myPM.findStateManager(pc);
        otherSM.addInsertionNotifier(this, ActivityState.INSERTING_CALLBACKS);
        FieldContainer cont = (FieldContainer)this.insertionUpdateFieldList.get(otherSM);
        if (cont == null) {
            cont = new FieldContainer(fieldNumber);
        } else {
            cont.set(fieldNumber);
        }
        this.insertionUpdateFieldList.put(otherSM, cont);
        if (JPOXLogger.JDO.isDebugEnabled()) {
            JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.FieldRegisteredForUpdateAfterInsertion", this.cmd.getManagedFieldAbsolute(fieldNumber).getName(), this.myID));
        }
    }

    void insertionCompleted(StateManagerImpl sm) {
        FieldContainer fldCont = (FieldContainer)this.insertionUpdateFieldList.get(sm);
        if (fldCont != null) {
            this.dirty = true;
            int[] fieldsToUpdate = fldCont.getFields();
            for (int i = 0; i < fieldsToUpdate.length; ++i) {
                if (JPOXLogger.JDO.isDebugEnabled()) {
                    JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.FieldBeingUpdatedNowValueInserted", this.cmd.getManagedFieldAbsolute(fieldsToUpdate[i]).getName(), this.myID));
                }
                this.dirtyFields[fieldsToUpdate[i]] = true;
            }
            this.insertionUpdateFieldList.remove(sm);
            this.flush();
        }
    }

    public void setExternalFieldValueForMapping(JavaTypeMapping mapping, Object value) {
        this.externalFieldValuesByMapping.put(mapping, value);
    }

    public Object getValueForExternalField(JavaTypeMapping mapping) {
        return this.externalFieldValuesByMapping.get(mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePersistentTransactionalTransient() {
        this.preStateChange();
        try {
            if (this.myLC.isTransactional && !this.myLC.isPersistent) {
                this.makePersistent();
                this.myLC = this.myLC.transitionMakePersistent(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTransactional() {
        this.preStateChange();
        try {
            if (this.myLC == null) {
                this.initializeSM(5);
                this.setRestoreValues(true);
            } else {
                this.myLC = this.myLC.transitionMakeTransactional(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeNontransactional() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionMakeNontransactional(this);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTransient(FetchPlanState state) {
        if (state == null) {
            int[] fieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, this.secondClassMutableFieldNumbers, true);
            if (fieldNumbers != null) {
                this.provideFields(fieldNumbers, new UnsetOwners());
            }
        } else {
            this.loadUnloadedFieldsInFetchPlan();
            int[] fieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, this.secondClassMutableFieldNumbers, true);
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                this.replaceFields(fieldNumbers, new MakeTransientFieldManager(this, this.secondClassMutableFields, this.myFP, state));
            }
        }
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionMakeTransient(this, state != null);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(FetchPlanState state) {
        if (!this.cmd.isDetachable()) {
            return;
        }
        if (this.myLC.isDeleted()) {
            return;
        }
        if (this.myPC.jdoIsDetached()) {
            return;
        }
        if (this.detaching) {
            return;
        }
        if (JPOXLogger.JDO.isDebugEnabled()) {
            try {
                JPOXLogger.JDO.debug(LOCALISER.msg("PM.Detach", this.myPC, "" + state.getCurrentFetchDepth()));
            }
            catch (Exception e) {
                JPOXLogger.JDO.debug(LOCALISER.msg("PM.Detach", this.myPC.getClass().getName(), "" + state.getCurrentFetchDepth()));
            }
        }
        this.callback.preDetach(this.myPC);
        try {
            this.detaching = true;
            if ((this.myPM.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                this.loadUnloadedFieldsInFetchPlan();
            }
            DetachFieldManager detachFieldManager = new DetachFieldManager(this, this.secondClassMutableFields, this.myFP, state, false);
            for (int i = 0; i < this.loadedFields.length; ++i) {
                if (!this.loadedFields[i]) continue;
                AbstractPropertyMetaData fmd = this.myFP.getAbstractClassMetaData().getManagedFieldAbsolute(i);
                boolean requiresFCOFetching = MetaDataUtils.getInstance().storesFCO(fmd, this.getPersistenceManager().getClassLoaderResolver());
                if (!requiresFCOFetching) continue;
                try {
                    detachFieldManager.fetchObjectField(i);
                    continue;
                }
                catch (AbstractFetchFieldManager.EndOfFetchPlanGraphException eofpge) {
                    // empty catch block
                }
            }
            this.myLC = this.myLC.transitionDetach(this);
            this.myPC.jdoReplaceFlags();
            ((Detachable)this.myPC).jdoReplaceDetachedState();
            this.callback.postDetach(this.myPC, this.myPC);
            PersistenceCapable toCheckPC = this.myPC;
            Object toCheckID = this.myID;
            this.disconnect();
            if (!toCheckPC.jdoIsDetached()) {
                throw new JDOUserException(LOCALISER.msg("StateManager.DetachOfObjectFailed", toCheckPC.getClass().getName(), toCheckID));
            }
        }
        finally {
            this.detaching = false;
        }
    }

    private int[] getFieldsNumbersToDetach() {
        int[] loadedFieldNumbers;
        int[] fieldsToDetach = this.myFP.getFieldsInActualFetchPlan();
        if ((this.myPM.getFetchPlan().getDetachmentOptions() & 2) == 0 && (loadedFieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, this.allFieldNumbers, true)) != null) {
            int i;
            boolean[] flds = new boolean[this.allFieldNumbers.length];
            for (i = 0; i < fieldsToDetach.length; ++i) {
                flds[fieldsToDetach[i]] = true;
            }
            for (i = 0; i < loadedFieldNumbers.length; ++i) {
                flds[loadedFieldNumbers[i]] = true;
            }
            fieldsToDetach = StateManagerImpl.getFlagsSetTo(flds, true);
        }
        return fieldsToDetach;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object detachCopy(FetchPlanState state) {
        PersistenceCapable detachedPC;
        if (this.myLC.isDeleted()) {
            throw new JDOUserException(LOCALISER.msg("StateManager.DetachOfDeletedObjectNotPossible", this.myPC.getClass().getName(), this.myID));
        }
        if (this.myPC.jdoIsDetached()) {
            throw new JDOUserException(LOCALISER.msg("StateManager.DetachOfAlreadyDetachedObjectNotPossible", this.myPC.getClass().getName(), this.myID));
        }
        if (this.dirty) {
            this.myPM.flush();
        }
        if (this.detaching) {
            return this.detachingPC;
        }
        this.detachingPC = detachedPC = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
        boolean detachable = ClassUtils.isDetachable(this.myPC);
        PersistenceCapable persistenceCapable = this.detachingPC;
        synchronized (persistenceCapable) {
            if (detachable) {
                if (JPOXLogger.JDO.isDebugEnabled()) {
                    try {
                        JPOXLogger.JDO.debug(LOCALISER.msg("PM.DetachCopy", this.myPC, "" + state.getCurrentFetchDepth()));
                    }
                    catch (Exception e) {
                        JPOXLogger.JDO.debug(LOCALISER.msg("PM.DetachCopy", this.myPC.getClass().getName(), "" + state.getCurrentFetchDepth()));
                    }
                }
                this.callback.preDetach(this.myPC);
            }
            try {
                this.detaching = true;
                if ((this.myPM.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                    this.loadUnloadedFieldsInFetchPlan();
                }
                if (this.myLC == this.myPM.getPMFContext().getApiAdapter().getLifeCycleState(4) || this.myLC == this.myPM.getPMFContext().getApiAdapter().getLifeCycleState(9)) {
                    this.myLC = this.myLC.transitionReadField(this, true);
                }
                StateManagerImpl smDetachedPC = new StateManagerImpl(this.myPM, this.myPM.getPMFContext().getApiAdapter(), detachedPC, this.cmd, this.getExternalObjectId(this.myPC), this.myVersion);
                detachedPC.jdoReplaceStateManager((javax.jdo.spi.StateManager)smDetachedPC);
                smDetachedPC.replaceFields(this.getFieldsNumbersToDetach(), new DetachFieldManager(this, this.secondClassMutableFields, this.myFP, state, true));
                if (detachable) {
                    detachedPC.jdoReplaceFlags();
                    ((Detachable)detachedPC).jdoReplaceDetachedState();
                } else {
                    smDetachedPC.makeTransient(null);
                }
                detachedPC.jdoReplaceStateManager(null);
            }
            finally {
                this.detaching = false;
                this.detachingPC = null;
            }
            if (detachable && !detachedPC.jdoIsDetached()) {
                throw new JDOUserException(LOCALISER.msg("StateManager.DetachOfObjectFailed", detachedPC.getClass().getName(), this.myID));
            }
            if (detachable) {
                this.callback.postDetach(this.myPC, detachedPC);
            }
        }
        return detachedPC;
    }

    public Object getAttachedPC() {
        return this.attachedPC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object attachCopy(PersistenceCapable detachedPC, boolean embedded) {
        if (this.attaching) {
            return this;
        }
        this.attaching = true;
        try {
            boolean persistent = false;
            if (embedded) {
                persistent = true;
            } else if (!this.myPM.getPMFContext().getPmfConfiguration().getAttachSameDatastore()) {
                try {
                    this.locate();
                    persistent = true;
                }
                catch (JDOObjectNotFoundException onfe) {}
            } else {
                persistent = true;
            }
            this.callback.preAttach(detachedPC);
            if (detachedPC.jdoIsDeleted()) {
                this.myLC = this.myLC.transitionDeletePersistent(this);
            }
            if (this.myLC == this.myPM.getPMFContext().getApiAdapter().getLifeCycleState(4) || this.myLC == this.myPM.getPMFContext().getApiAdapter().getLifeCycleState(9)) {
                this.myLC = this.myLC.transitionMakeTransactional(this);
            }
            if (persistent) {
                this.loadSCONonContainerFields();
            }
            StateManagerImpl smDetachedPC = new StateManagerImpl(this.myPM, this.myPM.getPMFContext().getApiAdapter(), detachedPC, this.cmd, this.getExternalObjectId(detachedPC), null);
            detachedPC.jdoReplaceStateManager((javax.jdo.spi.StateManager)smDetachedPC);
            smDetachedPC.attachedPC = this.myPC;
            this.retrieveDetachState(smDetachedPC);
            if (!persistent) {
                this.internalAttachCopy(this, smDetachedPC, smDetachedPC.loadedFields, smDetachedPC.dirtyFields, persistent, smDetachedPC.myVersion, false);
                this.makePersistent();
            }
            this.internalAttachCopy(this, smDetachedPC, smDetachedPC.loadedFields, smDetachedPC.dirtyFields, persistent, smDetachedPC.myVersion, true);
            smDetachedPC.attachedPC = null;
            detachedPC.jdoReplaceStateManager(null);
            this.callback.postAttach(this.myPC, detachedPC);
        }
        finally {
            this.attaching = false;
        }
        return this.myPC;
    }

    private void internalAttachCopy(StateManager sm, StateManager smDetached, boolean[] loadedFields, boolean[] dirtyFields, boolean persistent, Object version, boolean cascade) {
        int[] attachFieldNumbers = null;
        int numberOfAttachFields = 0;
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            ++numberOfAttachFields;
        }
        attachFieldNumbers = new int[numberOfAttachFields];
        int n = 0;
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            attachFieldNumbers[n++] = this.allFieldNumbers[i];
        }
        sm.setVersion(version);
        if (attachFieldNumbers != null) {
            smDetached.provideFields(attachFieldNumbers, new AttachFieldManager(sm, this.secondClassMutableFields, dirtyFields, persistent, cascade));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePersistent() {
        if (!this.myLC.isDeleted()) {
            this.callback.preDelete(this.myPC);
            this.srm.deleteDependent(this, this.allFieldNumbers);
            this.dirty = true;
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionDeletePersistent(this);
            }
            finally {
                this.postStateChange();
            }
            if (this.myPM.isDelayDatastoreOperationsEnabled()) {
                this.myPM.markDirty(this);
            } else {
                this.internalDeletePersistent();
            }
            this.callback.postDelete(this.myPC);
        }
    }

    public void nullifyFields() {
        if (!this.myLC.isDeleted() && !this.myPC.jdoIsDetached()) {
            this.replaceFields(this.allNonPrimaryKeyFieldNumbers, new NullifyRelationFieldManager(this));
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDeletePersistent() {
        if (this.deleting) {
            throw new JDOUserException(LOCALISER.msg("StateManager.DeleteRecursiveError"));
        }
        this.deleting = true;
        try {
            if (this.dirty) {
                this.clearDirtyFlags();
                this.myPM.flush();
            }
            this.srm.delete(this);
        }
        finally {
            this.deleting = false;
        }
    }

    public void validate() {
        if (!this.myLC.isTransactional) {
            int[] fieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, this.defaultFetchGroupFieldNumbers, false);
            if (fieldNumbers != null) {
                fieldNumbers = StateManagerImpl.getFlagsSetTo(this.nonPrimaryKeyFields, fieldNumbers, true);
            }
            if (fieldNumbers != null) {
                fieldNumbers = StateManagerImpl.getFlagsSetTo(this.secondClassMutableFields, fieldNumbers, false);
            }
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                this.transitionReadField();
                this.loadFieldsInFetchPlan();
            } else {
                this.locate();
                this.transitionReadField();
            }
        }
    }

    private void locate() {
        this.srm.locate(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() {
        if (this.myLC != this.myPM.getPMFContext().getApiAdapter().getLifeCycleState(2) && this.myLC != this.myPM.getPMFContext().getApiAdapter().getLifeCycleState(9)) {
            return;
        }
        this.preStateChange();
        try {
            try {
                this.callback.preClear(this.myPC);
                this.callback.postClear(this.myPC);
            }
            finally {
                this.myLC = this.myLC.transitionEvict(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRefresh(this);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(boolean fgOnly) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRetrieve((StateManager)this, fgOnly);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(FetchPlan fetchPlan) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRetrieve((StateManager)this, fetchPlan);
        }
        finally {
            this.postStateChange();
        }
    }

    private void preStateChange() {
        this.changingState = true;
    }

    private void postStateChange() {
        this.changingState = false;
        if (this.postLoadPending && this.isFetchPlanLoaded()) {
            this.postLoadPending = false;
            this.postLoad();
        }
    }

    private boolean preWriteField(int field) {
        boolean wasDirty = this.dirty;
        if (this.inserting == ActivityState.NONE) {
            this.dirty = true;
            if (!wasDirty) {
                this.callback.preDirty(this.myPC);
            }
            this.transitionWriteField();
            this.dirty = true;
            this.dirtyFields[field] = true;
            this.loadedFields[field] = true;
        }
        return wasDirty;
    }

    private void postWriteField(boolean wasDirty) {
        if (this.dirty && !wasDirty) {
            this.callback.postDirty(this.myPC);
        }
        if (!(this.inserting != ActivityState.NONE || this.flushing || this.myLC.isTransactional && !this.myLC.isPersistent)) {
            if (this.myPM.currentTransaction().isActive()) {
                this.myPM.markDirty(this);
            } else {
                this.flush();
            }
        }
    }

    private void postLoad() {
        if (this.changingState) {
            this.postLoadPending = true;
        } else {
            if (this.jdoFlags == 1 && this.myLC.isTransactional()) {
                this.jdoFlags = (byte)-1;
                this.myPC.jdoReplaceFlags();
            }
            this.callback.postLoad(this.myPC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionCommit(this, tx);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollback(Transaction tx) {
        this.preStateChange();
        try {
            this.myPM.clearDirty(this);
            this.myLC = this.myLC.transitionRollback(this, tx);
        }
        finally {
            this.postStateChange();
        }
    }

    public void setStoringPC() {
        this.storingPC = true;
    }

    public void unsetStoringPC() {
        this.storingPC = false;
    }

    public void preSerialize(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return;
        }
        this.retrieve(false);
        if (this.myPM.currentTransaction().isActive()) {
            this.myLC = this.myLC.transitionSerialize(this);
        }
        if (!this.storingPC && pc instanceof Detachable && !this.myLC.isDeleted && this.myLC.isPersistent) {
            if (this.myLC.isDirty) {
                this.flush();
            }
            ((Detachable)pc).jdoReplaceDetachedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.dirty) {
            if (this.flushing) {
                return;
            }
            this.flushing = true;
            try {
                if (this.myLC.stateType() == 1 && !this.flushedNew) {
                    if (!this.isEmbedded()) {
                        this.internalMakePersistent();
                    } else {
                        this.callback.preStore(this.myPC);
                        this.callback.postStore(this.myPC);
                    }
                    this.dirty = false;
                } else if (this.myLC.stateType() == 8) {
                    this.callback.preDelete(this.myPC);
                    if (!this.isEmbedded()) {
                        this.internalDeletePersistent();
                    }
                    this.callback.postDelete(this.myPC);
                } else if (this.myLC.stateType() == 7) {
                    if (this.flushedNew) {
                        this.callback.preDelete(this.myPC);
                        if (!this.isEmbedded()) {
                            this.internalDeletePersistent();
                        }
                        this.callback.postDelete(this.myPC);
                    } else {
                        this.dirty = false;
                    }
                } else {
                    int[] dirtyFieldNumbers;
                    if (!this.deleting) {
                        this.callback.preStore(this.myPC);
                    }
                    if ((dirtyFieldNumbers = StateManagerImpl.getFlagsSetTo(this.dirtyFields, true)) == null) {
                        throw new JDOFatalInternalException(LOCALISER.msg("StateManager.InconsistentDirtyStateError"));
                    }
                    if (!this.isEmbedded()) {
                        this.srm.update(this, dirtyFieldNumbers);
                        this.myPM.putObjectIntoCache(this, true, true);
                    }
                    this.clearDirtyFlags();
                    this.callback.postStore(this.myPC);
                }
            }
            finally {
                this.flushing = false;
            }
        }
    }

    private void initializeSM(int newState) {
        final StateManagerImpl thisSM = this;
        this.myLC = this.myPM.getPMFContext().getApiAdapter().getLifeCycleState(newState);
        try {
            if (this.myLC.isPersistent()) {
                this.myPM.addStateManager(this);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        StateManagerImpl.this.myPC.jdoReplaceStateManager((javax.jdo.spi.StateManager)thisSM);
                        return null;
                    }
                    catch (SecurityException e) {
                        throw new JDOFatalUserException("EXC_CannotSetStateManager", (Throwable)e);
                    }
                }
            });
        }
        catch (SecurityException e) {
            throw new JDOUserException(e.getMessage());
        }
        catch (JDOException jdoException) {
            if (this.myPM.getStateManagerById(this.myID) == this) {
                this.myPM.removeStateManager(this);
            }
            throw jdoException;
        }
    }

    private boolean disconnectClone(PersistenceCapable pc) {
        if (this.detaching) {
            return false;
        }
        if (pc != this.myPC) {
            if (JPOXLogger.JDO.isDebugEnabled()) {
                JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.DisconnectClone", StringUtils.toJVMIDString(pc), this));
            }
            pc.jdoReplaceFlags();
            pc.jdoReplaceStateManager(null);
            return true;
        }
        return false;
    }

    private void unsetOwnerInSCOFields() {
        int[] fieldNumbers = StateManagerImpl.getFlagsSetTo(this.loadedFields, this.secondClassMutableFieldNumbers, true);
        if (fieldNumbers != null) {
            this.provideFields(fieldNumbers, new UnsetOwners());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (JPOXLogger.JDO.isDebugEnabled()) {
            JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.Disconnect", StringUtils.toJVMIDString(this.myPC), this));
        }
        if (this.postLoadPending) {
            this.changingState = false;
            this.postLoadPending = false;
            this.postLoad();
        }
        this.unsetOwnerInSCOFields();
        this.myPM.removeStateManager(this);
        this.jdoFlags = 0;
        this.myPC.jdoReplaceFlags();
        this.disconnecting = true;
        try {
            this.replaceStateManager(null);
        }
        finally {
            this.disconnecting = false;
        }
        this.clearSavedFields();
        this.myPM = null;
        this.myFP = null;
        this.myPC = null;
        this.myID = null;
        this.myLC = null;
        this.cmd = null;
        this.srm = null;
    }

    public void registerTransactional() {
        this.myPM.addStateManager(this);
    }

    public void retrieveDetachState(StateManager sm) {
        if (sm.getObject() instanceof Detachable) {
            ((StateManagerImpl)sm).retrievingDetachedState = true;
            ((Detachable)sm.getObject()).jdoReplaceDetachedState();
            ((StateManagerImpl)sm).retrievingDetachedState = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDetachState() {
        if (this.getObject() instanceof Detachable) {
            this.resettingDetachedState = true;
            try {
                ((Detachable)this.getObject()).jdoReplaceDetachedState();
            }
            finally {
                this.resettingDetachedState = false;
            }
        }
    }

    public Object[] replacingDetachedState(Detachable pc, Object[] currentState) {
        int i;
        if (this.resettingDetachedState) {
            return null;
        }
        if (this.retrievingDetachedState) {
            int i2;
            this.jdoLoadedFields = (BitSet)currentState[2];
            for (i2 = 0; i2 < this.loadedFields.length; ++i2) {
                this.loadedFields[i2] = this.jdoLoadedFields.get(i2);
            }
            this.jdoModifiedFields = (BitSet)currentState[3];
            for (i2 = 0; i2 < this.dirtyFields.length; ++i2) {
                this.dirtyFields[i2] = this.jdoModifiedFields.get(i2);
            }
            this.setVersion(currentState[1]);
            return currentState;
        }
        Object[] state = new Object[4];
        state[0] = this.myID;
        state[1] = this.myVersion;
        if (currentState == null || currentState[2] == null) {
            BitSet loadedState = new BitSet();
            for (i = 0; i < this.loadedFields.length; ++i) {
                if (this.loadedFields[i]) {
                    loadedState.set(i);
                    continue;
                }
                loadedState.clear(i);
            }
            state[2] = loadedState;
        } else {
            state[2] = currentState[2];
        }
        if (currentState == null || currentState[3] == null) {
            BitSet modifiedState = new BitSet();
            for (i = 0; i < this.dirtyFields.length; ++i) {
                if (this.dirtyFields[i]) {
                    modifiedState.set(i);
                    continue;
                }
                modifiedState.clear(i);
            }
            state[3] = modifiedState;
        } else {
            state[3] = currentState[3];
        }
        return state;
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static void clearFlags(boolean[] flags) {
        for (int i = 0; i < flags.length; ++i) {
            flags[i] = false;
        }
    }

    private static void clearFlags(boolean[] flags, int[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            flags[fields[i]] = false;
        }
    }

    private static int[] getFlagsSetTo(boolean[] flags, boolean state) {
        int[] temp = new int[flags.length];
        int j = 0;
        for (int i = 0; i < flags.length; ++i) {
            if (flags[i] != state) continue;
            temp[j++] = i;
        }
        if (j != 0) {
            int[] fieldNumbers = new int[j];
            System.arraycopy(temp, 0, fieldNumbers, 0, j);
            return fieldNumbers;
        }
        return null;
    }

    private static int[] getFlagsSetTo(boolean[] flags, int[] indices, boolean state) {
        int[] temp = new int[indices.length];
        int j = 0;
        for (int i = 0; i < indices.length; ++i) {
            if (flags[indices[i]] != state) continue;
            temp[j++] = indices[i];
        }
        if (j != 0) {
            int[] fieldNumbers = new int[j];
            System.arraycopy(temp, 0, fieldNumbers, 0, j);
            return fieldNumbers;
        }
        return null;
    }

    private static Object peekField(Object obj, String fieldName) {
        try {
            Object value = obj.getClass().getDeclaredField(fieldName).get(obj);
            if (value instanceof PersistenceCapable) {
                return StringUtils.toJVMIDString(value);
            }
            return value;
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    private static void dumpPC(PersistenceCapable pc, PrintWriter out) {
        out.println(StringUtils.toJVMIDString(pc));
        if (pc == null) {
            return;
        }
        out.print("jdoStateManager = " + StateManagerImpl.peekField(pc, "jdoStateManager"));
        out.print("jdoFlags = ");
        Object flagsObj = StateManagerImpl.peekField(pc, "jdoFlags");
        if (flagsObj instanceof Byte) {
            out.println(StringUtils.jdoFlagsToString((Byte)flagsObj));
        } else {
            out.println(flagsObj);
        }
        Class<?> c = pc.getClass();
        do {
            String[] fieldNames = HELPER.getFieldNames(c);
            for (int i = 0; i < fieldNames.length; ++i) {
                out.print(fieldNames[i]);
                out.print(" = ");
                out.println(StateManagerImpl.peekField(pc, fieldNames[i]));
            }
        } while ((c = c.getSuperclass()) != null && (class$javax$jdo$spi$PersistenceCapable == null ? StateManagerImpl.class$("javax.jdo.spi.PersistenceCapable") : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(c));
    }

    public void dump(PrintWriter out) {
        out.println("myPM = " + this.myPM);
        out.println("myID = " + this.myID);
        out.println("myLC = " + this.myLC);
        out.println("cmd = " + this.cmd);
        out.println("srm = " + this.srm);
        out.println("fieldCount = " + this.fieldCount);
        out.println("dirty = " + this.dirty);
        out.println("flushing = " + this.flushing);
        out.println("changingState = " + this.changingState);
        out.println("postLoadPending = " + this.postLoadPending);
        out.println("disconnecting = " + this.disconnecting);
        out.println("dirtyFields = " + StringUtils.booleanArrayToString(this.dirtyFields));
        out.println("defaultFetchGroupFields = " + StringUtils.booleanArrayToString(this.defaultFetchGroupFields));
        out.println("secondClassMutableFields = " + StringUtils.booleanArrayToString(this.secondClassMutableFields));
        out.println("allFieldNumbers = " + StringUtils.intArrayToString(this.allFieldNumbers));
        out.println("defaultFetchGroupFieldNumbers = " + StringUtils.intArrayToString(this.defaultFetchGroupFieldNumbers));
        out.println("secondClassMutableFieldNumbers = " + StringUtils.intArrayToString(this.secondClassMutableFieldNumbers));
        out.println();
        out.println("jdoFlags = " + StringUtils.jdoFlagsToString(this.jdoFlags));
        out.println("loadedFields = " + StringUtils.booleanArrayToString(this.loadedFields));
        out.print("myPC = ");
        StateManagerImpl.dumpPC(this.myPC, out);
        out.println();
        out.println("savedFlags = " + StringUtils.jdoFlagsToString(this.savedFlags));
        out.println("savedLoadedFields = " + StringUtils.booleanArrayToString(this.savedLoadedFields));
        out.print("savedImage = ");
        StateManagerImpl.dumpPC(this.savedImage, out);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HOLLOWFIELDMANAGER = new SingleTypeFieldManager();
        HELPER = (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return JDOImplHelper.getInstance();
                }
                catch (SecurityException e) {
                    throw new JDOFatalUserException(LOCALISER.msg("StateManager.SecurityProblem"), (Throwable)e);
                }
            }
        });
    }

    private class FieldContainer {
        boolean[] fieldsToUpdate;

        public FieldContainer(int fieldNumber) {
            this.fieldsToUpdate = new boolean[StateManagerImpl.this.allFieldNumbers.length];
            this.fieldsToUpdate[fieldNumber] = true;
        }

        public void set(int fieldNumber) {
            this.fieldsToUpdate[fieldNumber] = true;
        }

        public int[] getFields() {
            return StateManagerImpl.getFlagsSetTo(this.fieldsToUpdate, true);
        }
    }

    private class EmbeddedOwnerRelation {
        javax.jdo.spi.StateManager sm;
        int fieldNumber;

        public EmbeddedOwnerRelation(javax.jdo.spi.StateManager ownerSM, int ownerFieldNumber) {
            this.sm = ownerSM;
            this.fieldNumber = ownerFieldNumber;
        }
    }
}

