/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.state;

import javax.jdo.spi.PersistenceCapable;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.sco.SCO;
import org.jpox.sco.SCOContainer;
import org.jpox.state.StateManagerImpl;
import org.jpox.store.fieldmanager.AbstractFieldManager;
import org.jpox.store.fieldmanager.SingleValueFieldManager;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class AttachFieldManager
extends AbstractFieldManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private final StateManager smAttached;
    private final boolean[] secondClassMutableFields;
    private final boolean[] dirtyFields;
    private final boolean persistent;
    private final boolean cascadeAttach;

    public AttachFieldManager(StateManager smAttached, boolean[] secondClassMutableFields, boolean[] dirtyFields, boolean persistent, boolean cascadeAttach) {
        this.smAttached = smAttached;
        this.secondClassMutableFields = secondClassMutableFields;
        this.dirtyFields = dirtyFields;
        this.persistent = persistent;
        this.cascadeAttach = cascadeAttach;
    }

    public void storeObjectField(int fieldNumber, Object value) {
        if (value == null) {
            Object oldValue = null;
            AbstractClassMetaData cmd = this.smAttached.getClassMetaData();
            AbstractPropertyMetaData fmd = cmd.getManagedFieldAbsolute(fieldNumber);
            if (fmd.isDependent()) {
                ((StateManagerImpl)this.smAttached).loadFieldFromDatastore(fieldNumber);
                oldValue = this.smAttached.provideField(fieldNumber);
            }
            if (this.dirtyFields[fieldNumber] || !this.persistent) {
                this.smAttached.makeDirty(fieldNumber);
                this.smAttached.replaceField(fieldNumber, null);
            }
            if (fmd.isDependent() && oldValue != null && value == null && oldValue instanceof PersistenceCapable) {
                this.smAttached.flush();
                JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.DeleteDependentNulledField", oldValue, fmd.getFullFieldName()));
                this.smAttached.getPersistenceManager().deletePersistent(oldValue);
            }
        } else if (this.secondClassMutableFields[fieldNumber]) {
            AbstractPropertyMetaData fmd = this.smAttached.getClassMetaData().getManagedFieldAbsolute(fieldNumber);
            if (fmd.isSerialized()) {
                this.smAttached.replaceField(fieldNumber, value);
                this.smAttached.makeDirty(fieldNumber);
            } else {
                SCO sco;
                Object oldValue;
                if (this.dirtyFields[fieldNumber] || !this.persistent) {
                    this.smAttached.makeDirty(fieldNumber);
                }
                if ((oldValue = this.smAttached.provideField(fieldNumber)) == null || oldValue != null && !(oldValue instanceof SCO)) {
                    sco = (SCO)this.smAttached.newSCOEmptyInstance(fieldNumber);
                    if (sco instanceof SCOContainer) {
                        ((SCOContainer)sco).load();
                    }
                    this.smAttached.replaceField(fieldNumber, sco);
                } else {
                    sco = (SCO)oldValue;
                }
                if (this.cascadeAttach) {
                    sco.attachCopy(value);
                }
            }
        } else if (value instanceof PersistenceCapable) {
            AbstractPropertyMetaData fmd;
            boolean embedded;
            PersistenceCapable pc = (PersistenceCapable)value;
            if (this.dirtyFields[fieldNumber] || !this.persistent) {
                this.smAttached.makeDirty(fieldNumber);
            }
            boolean bl = embedded = (fmd = ((StateManagerImpl)this.smAttached).getClassMetaData().getManagedFieldAbsolute(fieldNumber)).getEmbeddedMetaData() != null || fmd.isSerialized();
            if (this.cascadeAttach) {
                Object pcObj = this.smAttached.getPersistenceManager().attachCopy(pc, embedded);
                if (this.dirtyFields[fieldNumber] || !this.persistent) {
                    this.smAttached.makeDirty(fieldNumber);
                } else if (embedded && pc != null && pc.jdoIsDirty()) {
                    this.smAttached.makeDirty(fieldNumber);
                }
                this.smAttached.replaceField(fieldNumber, pcObj);
            }
        } else if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
            this.smAttached.replaceField(fieldNumber, value);
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeBooleanField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeByteField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        }
    }

    public void storeCharField(int fieldNumber, char value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeCharField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeDoubleField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeFloatField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeIntField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeLongField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeShortField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeStringField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        }
    }
}

