/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.sco;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import javax.jdo.JDOUserException;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.sco.SCOMap;
import org.jpox.sco.SCOUtils;
import org.jpox.sco.Set;
import org.jpox.sco.exceptions.IncompatibleFieldTypeException;
import org.jpox.sco.exceptions.IncompatibleKeyTypeException;
import org.jpox.sco.exceptions.IncompatibleValueTypeException;
import org.jpox.sco.exceptions.NullsNotAllowedException;
import org.jpox.sco.exceptions.QueryUnownedSCOException;
import org.jpox.state.FetchPlanState;
import org.jpox.state.StateManagerFactory;
import org.jpox.store.DatastoreClass;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MapMapping;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.scostore.MapStore;

public class TreeMap
extends java.util.TreeMap
implements SCOMap,
Cloneable,
Queryable {
    private transient Object owner;
    private transient StateManager ownerSM;
    private transient String fieldName;
    private transient int fieldNumber;
    private transient Class keyType;
    private transient Class valueType;
    private transient boolean allowNulls;
    protected MapStore backingStore;
    protected java.util.TreeMap delegate;
    protected boolean useCache = true;
    protected boolean isCacheLoaded = false;
    static /* synthetic */ Class class$java$util$TreeMap;

    public TreeMap(StateManager ownerSM, String fieldName) {
        this.init(ownerSM, fieldName);
    }

    private void init(StateManager ownerSM, String fieldName) {
        this.owner = ownerSM.getObject();
        this.ownerSM = ownerSM;
        this.fieldName = fieldName;
        this.allowNulls = false;
        Class<?> c = ownerSM.getObject().getClass();
        StoreManager storeMgr = ownerSM.getStoreManager();
        AbstractClassMetaData cmd = storeMgr.getMetaDataManager().getMetaDataForClass(c, ownerSM.getPersistenceManager().getClassLoaderResolver());
        boolean serialised = SCOUtils.mapHasSerialisedKeysAndValues(cmd.getField(fieldName));
        this.fieldNumber = cmd.getFieldNumberAbsolute(fieldName);
        if (!serialised && cmd.getManagedFieldAbsolute(this.fieldNumber).getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            DatastoreClass ownerTable = storeMgr.getDatastoreClass(c.getName(), ownerSM.getPersistenceManager().getClassLoaderResolver());
            JavaTypeMapping m = ownerTable.getFieldMapping(ownerSM.getClassMetaData().getField(fieldName));
            if (!(m instanceof MapMapping)) {
                throw new IncompatibleFieldTypeException(ownerSM, fieldName, (class$java$util$TreeMap == null ? (class$java$util$TreeMap = TreeMap.class$("java.util.TreeMap")) : class$java$util$TreeMap).getName(), ownerSM.getMetaDataManager().getMetaDataForField(c, ownerSM.getPersistenceManager().getClassLoaderResolver(), fieldName).getTypeName());
            }
            this.backingStore = ((MapMapping)m).getBackingStore(ownerSM.getPersistenceManager().getClassLoaderResolver());
            this.keyType = ownerSM.getPersistenceManager().getClassLoaderResolver().classForName(this.backingStore.getKeyType());
            this.valueType = ownerSM.getPersistenceManager().getClassLoaderResolver().classForName(this.backingStore.getValueType());
        }
        if (this.keyType != null && !this.keyType.isAssignableFrom(this.keyType)) {
            throw new IncompatibleKeyTypeException(ownerSM, fieldName, this.keyType.getName(), this.keyType.getName());
        }
        if (this.valueType != null && !this.valueType.isAssignableFrom(this.valueType)) {
            throw new IncompatibleValueTypeException(ownerSM, fieldName, this.valueType.getName(), this.valueType.getName());
        }
        Comparator comparator = SCOUtils.getComparator(cmd.getField(fieldName), ownerSM.getPersistenceManager().getClassLoaderResolver());
        this.delegate = comparator != null ? new java.util.TreeMap(comparator) : new java.util.TreeMap();
        this.useCache = SCOUtils.useContainerCache(ownerSM, fieldName, cmd);
        if (this.useCache && !SCOUtils.useCachedLazyLoading(ownerSM, fieldName, cmd)) {
            this.loadFromStore();
        }
    }

    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    public void updateEmbeddedKey(Object key, int fieldNumber, Object newValue) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedKey(this.ownerSM, key, fieldNumber, newValue);
        }
    }

    public void updateEmbeddedValue(Object value, int fieldNumber, Object newValue) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedValue(this.ownerSM, value, fieldNumber, newValue);
        }
    }

    public void setValueFrom(Object o, boolean forUpdate) {
        AbstractPropertyMetaData fmd;
        Map m = (Map)o;
        if (m != null && SCOUtils.mapHasSerialisedKeysAndValues(fmd = this.ownerSM.getClassMetaData().getField(this.fieldName)) && (fmd.getMap().getKeyClassMetaData() != null || fmd.getMap().getValueClassMetaData() != null)) {
            PersistenceManager pm = this.ownerSM.getPersistenceManager();
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                PersistenceCapable pcValue;
                PersistenceCapable pcKey;
                StateManager objSM;
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (fmd.getMap().getKeyClassMetaData() != null && (objSM = pm.findStateManager(pcKey = (PersistenceCapable)key)) == null) {
                    objSM = StateManagerFactory.newStateManager(pcKey, pm, false);
                    objSM.addEmbeddedOwner(this.ownerSM, this.fieldNumber);
                }
                if (fmd.getMap().getValueClassMetaData() == null || (objSM = pm.findStateManager(pcValue = (PersistenceCapable)value)) != null) continue;
                objSM = StateManagerFactory.newStateManager(pcValue, pm, false);
                objSM.addEmbeddedOwner(this.ownerSM, this.fieldNumber);
            }
        }
        if (forUpdate) {
            this.clear();
            this.putAll(m);
        } else {
            this.delegate.clear();
            this.delegate.putAll(m);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.owner = null;
            this.ownerSM = null;
            this.fieldName = null;
            this.backingStore = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.makeDirty(this.fieldNumber);
        }
    }

    public void runReachability(java.util.Set reachables) {
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (key instanceof PersistenceCapable) {
                this.ownerSM.getPersistenceManager().findStateManager((PersistenceCapable)key).runReachability(reachables);
            }
            if (!(val instanceof PersistenceCapable)) continue;
            this.ownerSM.getPersistenceManager().findStateManager((PersistenceCapable)val).runReachability(reachables);
        }
    }

    public void makeTransient(FetchPlanState state) {
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (key instanceof PersistenceCapable) {
                this.ownerSM.getPersistenceManager().internalMakeTransient(key, state);
            }
            if (!(val instanceof PersistenceCapable)) continue;
            this.ownerSM.getPersistenceManager().internalMakeTransient(val, state);
        }
        this.ownerSM = null;
        this.backingStore = null;
    }

    public void detach(FetchPlanState state) {
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (key instanceof PersistenceCapable) {
                this.ownerSM.getPersistenceManager().detachInternal(key, state);
            }
            if (!(val instanceof PersistenceCapable)) continue;
            this.ownerSM.getPersistenceManager().detachInternal(val, state);
        }
        this.ownerSM = null;
        this.backingStore = null;
    }

    public void loadFieldsInFetchPlan(FetchPlanState state) {
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (key instanceof PersistenceCapable) {
                this.ownerSM.getPersistenceManager().findStateManager((PersistenceCapable)key).loadFieldsInFetchPlan(state);
            }
            if (!(val instanceof PersistenceCapable)) continue;
            this.ownerSM.getPersistenceManager().findStateManager((PersistenceCapable)val).loadFieldsInFetchPlan(state);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        java.util.TreeMap detached = new java.util.TreeMap();
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (val instanceof PersistenceCapable) {
                val = this.ownerSM.getPersistenceManager().detachCopyInternal(val, state);
            }
            if (key instanceof PersistenceCapable) {
                key = this.ownerSM.getPersistenceManager().detachCopyInternal(key, state);
            }
            detached.put(key, val);
        }
        return detached;
    }

    public void attachCopy(Object value) {
        Map m = (Map)value;
        AbstractPropertyMetaData fmd = this.ownerSM.getClassMetaData().getField(this.fieldName);
        boolean keysWithoutIdentity = SCOUtils.mapHasKeysWithoutIdentity(fmd);
        boolean valuesWithoutIdentity = SCOUtils.mapHasValuesWithoutIdentity(fmd);
        java.util.TreeMap attachedKeysValues = new java.util.TreeMap();
        Iterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (val instanceof PersistenceCapable && val instanceof Detachable) {
                val = this.ownerSM.getPersistenceManager().attachCopy(val, valuesWithoutIdentity);
            }
            if (key instanceof PersistenceCapable && key instanceof Detachable) {
                key = this.ownerSM.getPersistenceManager().attachCopy(key, keysWithoutIdentity);
            }
            attachedKeysValues.put(key, val);
        }
        SCOUtils.updateMapWithMapKeysValues(this, attachedKeysValues);
    }

    public synchronized QueryExpression newQueryStatement() {
        return this.newQueryStatement(this.valueType);
    }

    public synchronized QueryExpression newQueryStatement(Class candidate_class) {
        if (this.backingStore == null) {
            throw new QueryUnownedSCOException();
        }
        return this.backingStore.newQueryStatement(this.ownerSM, candidate_class.getName());
    }

    public synchronized ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        if (this.backingStore == null) {
            throw new QueryUnownedSCOException();
        }
        return this.backingStore.newResultObjectFactory(this.ownerSM, stmt, ignoreCache, useFetchPlan);
    }

    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.clone();
    }

    public Comparator comparator() {
        return this.delegate.comparator();
    }

    public boolean containsKey(Object key) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsKey(key);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsKey(this.ownerSM, key);
        }
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsValue(value);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsValue(this.ownerSM, value);
        }
        return this.delegate.containsValue(value);
    }

    public java.util.Set entrySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerSM, this.fieldName, false, this.backingStore.entrySetStore());
        }
        return this.delegate.entrySet();
    }

    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        return ((Object)this.entrySet()).equals(m.entrySet());
    }

    public Object firstKey() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.firstKey();
        }
        if (!this.useCache) {
            java.util.Set keys = this.keySet();
            Iterator keysIter = keys.iterator();
            return keysIter.next();
        }
        this.loadFromStore();
        return this.delegate.firstKey();
    }

    public Object lastKey() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.lastKey();
        }
        if (!this.useCache) {
            java.util.Set keys = this.keySet();
            Iterator keysIter = keys.iterator();
            Object last = null;
            while (keysIter.hasNext()) {
                last = keysIter.next();
            }
            return last;
        }
        this.loadFromStore();
        return this.delegate.lastKey();
    }

    public SortedMap headMap(Object toKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headMap(toKey);
        }
        if (!this.useCache) {
            throw new JDOUserException("JPOX doesn't currently support TreeMap.headMap() when not using cached containers");
        }
        this.loadFromStore();
        return this.delegate.headMap(toKey);
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.subMap(fromKey, toKey);
        }
        if (!this.useCache) {
            throw new JDOUserException("JPOX doesn't currently support TreeMap.subMap() when not using cached container");
        }
        this.loadFromStore();
        return this.delegate.subMap(fromKey, toKey);
    }

    public SortedMap tailMap(Object fromKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headMap(fromKey);
        }
        if (!this.useCache) {
            throw new JDOUserException("JPOX doesn't currently support TreeMap.tailMap() when not using cached collections");
        }
        this.loadFromStore();
        return this.delegate.headMap(fromKey);
    }

    public Object get(Object key) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerSM, key);
        }
        return this.delegate.get(key);
    }

    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            int h = 0;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public java.util.Set keySet() {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            return new Set(this.ownerSM, this.fieldName, false, this.backingStore.keySetStore(this.ownerSM.getPersistenceManager().getClassLoaderResolver()));
        }
        return this.delegate.keySet();
    }

    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.entrySetStore().size(this.ownerSM);
        }
        return this.delegate.size();
    }

    public Collection values() {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            return new Set(this.ownerSM, this.fieldName, true, this.backingStore.valueSetStore(this.ownerSM.getPersistenceManager().getClassLoaderResolver()));
        }
        return this.delegate.values();
    }

    public void clear() {
        this.makeDirty();
        if (this.backingStore != null) {
            this.backingStore.clear(this.ownerSM);
        }
        this.delegate.clear();
    }

    public Object put(Object key, Object value) {
        if (value == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        this.makeDirty();
        Object oldValue = null;
        if (this.backingStore != null) {
            oldValue = this.backingStore.put(this.ownerSM, key, value);
        }
        Object delegateOldValue = this.delegate.put(key, value);
        if (this.backingStore == null) {
            oldValue = delegateOldValue;
        }
        return oldValue;
    }

    public void putAll(Map m) {
        this.makeDirty();
        if (this.backingStore != null) {
            this.backingStore.putAll(this.ownerSM, m);
        }
        this.delegate.putAll(m);
    }

    public Object remove(Object key) {
        this.makeDirty();
        Object removed = null;
        Object delegateRemoved = this.delegate.remove(key);
        removed = this.backingStore != null ? this.backingStore.remove(this.ownerSM, key) : (Object)delegateRemoved;
        return removed;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new java.util.TreeMap(this.delegate);
        }
        return new java.util.TreeMap(this.delegate);
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            this.delegate.clear();
            SCOUtils.populateMapDelegateWithStoreData(this.delegate, this.backingStore, this.ownerSM);
            this.isCacheLoaded = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

