/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.sco;

import java.io.ObjectStreamException;
import java.sql.Timestamp;
import javax.jdo.JDOHelper;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.StateManager;
import org.jpox.sco.SCO;
import org.jpox.state.FetchPlanState;

public class SqlTimestamp
extends Timestamp
implements SCO {
    private transient PersistenceCapable owner;
    private transient String fieldName;

    public SqlTimestamp(StateManager ownerSM, String fieldName) {
        super(0L);
        this.owner = ownerSM.getObject();
        this.fieldName = fieldName;
    }

    public Object clone() {
        Object obj = super.clone();
        ((SqlTimestamp)obj).unsetOwner();
        return obj;
    }

    public void setTime(long time) {
        super.setTime(time);
        this.makeDirty();
    }

    public void setNanos(int time_nanos) {
        super.setNanos(time_nanos);
        this.makeDirty();
    }

    public void setYear(int year) {
        super.setYear(year);
        this.makeDirty();
    }

    public void setMonth(int month) {
        super.setMonth(month);
        this.makeDirty();
    }

    public void setDate(int date) {
        super.setDate(date);
        this.makeDirty();
    }

    public void setHours(int hours) {
        super.setHours(hours);
        this.makeDirty();
    }

    public void setMinutes(int minutes) {
        super.setMinutes(minutes);
        this.makeDirty();
    }

    public void setSeconds(int seconds) {
        super.setSeconds(seconds);
        this.makeDirty();
    }

    public void setValueFrom(Object o, boolean forUpdate) {
        super.setTime(((Timestamp)o).getTime());
        super.setNanos(((Timestamp)o).getNanos());
    }

    public void unsetOwner() {
        this.owner = null;
        this.fieldName = null;
    }

    public Object getOwner() {
        return this.owner;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void makeDirty() {
        if (this.owner != null) {
            JDOHelper.makeDirty((Object)this.owner, (String)this.fieldName);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        return new Timestamp(this.getTime());
    }

    public void attachCopy(Object value) {
        long oldValue = this.getTime();
        this.setValueFrom(value, true);
        long newValue = ((Timestamp)value).getTime();
        if (oldValue != newValue) {
            this.makeDirty();
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Timestamp(this.getTime());
    }
}

