/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.resource;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jpox.AbstractPersistenceManagerFactory;
import org.jpox.LifecycleListenerForClass;
import org.jpox.resource.ManagedConnectionImpl;
import org.jpox.resource.PersistenceManagerFactoryImpl;

public class ManagedConnectionFactoryImpl
extends AbstractPersistenceManagerFactory
implements ManagedConnectionFactory {
    public ManagedConnectionFactoryImpl() {
        this.setTransactionType("JTA");
    }

    public synchronized void setUserName(String userName) {
        this.setConnectionUserName(userName);
    }

    public synchronized void setPassword(String password) {
        this.setConnectionPassword(password);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ManagedConnectionFactoryImpl)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new ResourceException("NYI");
    }

    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        this.freezeConfiguration();
        return new PersistenceManagerFactoryImpl(this, cm);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        PasswordCredential pc = this.getPasswordCredential(subject);
        ManagedConnectionImpl mc = new ManagedConnectionImpl(this, pc);
        if (this.lifecycleListeners != null) {
            Iterator listenerIter = this.lifecycleListeners.iterator();
            while (listenerIter.hasNext()) {
                LifecycleListenerForClass listener = (LifecycleListenerForClass)listenerIter.next();
                mc.addInstanceLifecycleListener(listener.getListener(), listener.getClasses());
            }
        }
        this.getPmCache().add(mc);
        return mc;
    }

    public ManagedConnection matchManagedConnections(Set mcs, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        PasswordCredential pc = this.getPasswordCredential(subject);
        Iterator i = mcs.iterator();
        while (i.hasNext()) {
            ManagedConnectionImpl mc;
            Object o = i.next();
            if (!(o instanceof ManagedConnectionImpl) || !(mc = (ManagedConnectionImpl)o).getManagedConnectionFactory().equals(this)) continue;
            if (pc == null && mc.getPasswordCredential() == null) {
                return mc;
            }
            if (pc == null || mc.getPasswordCredential() == null || !pc.equals((Object)mc.getPasswordCredential())) continue;
            return mc;
        }
        return null;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public void setLogWriter(PrintWriter writer) throws ResourceException {
    }

    PasswordCredential getPasswordCredential(Subject subject) throws ResourceException {
        if (subject == null) {
            if (this.getConnectionUserName() == null || this.getConnectionPassword() == null) {
                return null;
            }
            PasswordCredential pc = new PasswordCredential(this.getConnectionUserName(), this.getConnectionPassword().toCharArray());
            pc.setManagedConnectionFactory((ManagedConnectionFactory)this);
            return pc;
        }
        Iterator<Object> i = subject.getPrivateCredentials().iterator();
        while (i.hasNext()) {
            PasswordCredential pc;
            Object o = i.next();
            if (!(o instanceof PasswordCredential) || !this.equals((pc = (PasswordCredential)o).getManagedConnectionFactory())) continue;
            return pc;
        }
        throw new ResourceException("No credentials found for ManagedConnectionFactory: " + this);
    }
}

