/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.plugin;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.jpox.ClassLoaderResolver;
import org.jpox.PMFConfiguration;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.Extension;
import org.jpox.plugin.ExtensionPoint;
import org.jpox.plugin.PluginRegistry;
import org.jpox.plugin.PluginRegistryFactory;

public class PluginManager {
    private PluginRegistry registry;

    public PluginManager(PMFConfiguration conf, ClassLoaderResolver clr) {
        this.registry = PluginRegistryFactory.newPluginRegistry(conf, clr);
    }

    public ExtensionPoint getExtensionPoint(String id) {
        return this.registry.getExtensionPoint(id);
    }

    public ExtensionPoint[] getExtensionPoints() {
        return this.registry.getExtensionPoints();
    }

    public void registerExtensionPoints() {
        this.registry.registerExtensionPoints();
    }

    public void registerExtensions() {
        this.registry.registerExtensions();
    }

    public ConfigurationElement getConfigurationElementForExtension(String extensionPointName, String discrimAttrName, String discrimAttrValue) {
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName);
        if (extensionPoint != null) {
            Extension[] ex = extensionPoint.getExtensions();
            for (int i = 0; i < ex.length; ++i) {
                ConfigurationElement[] confElm = ex[i].getConfigurationElements();
                for (int j = 0; j < confElm.length; ++j) {
                    if (!confElm[j].getAttribute(discrimAttrName).equalsIgnoreCase(discrimAttrValue)) continue;
                    return confElm[j];
                }
            }
        }
        return null;
    }

    public ConfigurationElement getConfigurationElementForExtension(String extensionPointName, String discrimAttrName1, String discrimAttrValue1, String discrimAttrName2, String discrimAttrValue2) {
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName);
        if (extensionPoint != null) {
            Extension[] ex = extensionPoint.getExtensions();
            for (int i = 0; i < ex.length; ++i) {
                ConfigurationElement[] confElm = ex[i].getConfigurationElements();
                for (int j = 0; j < confElm.length; ++j) {
                    if (!confElm[j].getAttribute(discrimAttrName1).equalsIgnoreCase(discrimAttrValue1) || !confElm[j].getAttribute(discrimAttrName2).equalsIgnoreCase(discrimAttrValue2)) continue;
                    return confElm[j];
                }
            }
        }
        return null;
    }

    public String getAttributeValueForExtension(String extensionPoint, String discrimAttrName, String discrimAttrValue, String attributeName) {
        ConfigurationElement elem = this.getConfigurationElementForExtension(extensionPoint, discrimAttrName, discrimAttrValue);
        if (elem != null) {
            return elem.getAttribute(attributeName);
        }
        return null;
    }

    public String getAttributeValueForExtension(String extensionPoint, String discrimAttrName1, String discrimAttrValue1, String discrimAttrName2, String discrimAttrValue2, String attributeName) {
        ConfigurationElement elem = this.getConfigurationElementForExtension(extensionPoint, discrimAttrName1, discrimAttrValue1, discrimAttrName2, discrimAttrValue2);
        if (elem != null) {
            return elem.getAttribute(attributeName);
        }
        return null;
    }

    public Object createExecutableExtension(String extensionPoint, String discrimAttrName, String discrimAttrValue, String attributeName, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ConfigurationElement elem = this.getConfigurationElementForExtension(extensionPoint, discrimAttrName, discrimAttrValue);
        if (elem != null) {
            return this.registry.createExecutableExtension(elem, attributeName, argsClass, args);
        }
        return null;
    }

    public Class loadClass(String pluginId, String className) throws ClassNotResolvedException {
        try {
            return this.registry.loadClass(pluginId, className);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotResolvedException(ex.getMessage(), ex);
        }
    }

    public URL resolveURLAsFileURL(URL url) throws IOException {
        return this.registry.resolveURLAsFileURL(url);
    }
}

