/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.jdo.JDOFatalException;
import javax.jdo.JDOFatalInternalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.ExtensionPoint;
import org.jpox.plugin.PluginParser;
import org.jpox.plugin.PluginRegistry;
import org.jpox.util.JavaUtils;
import org.jpox.util.StringUtils;

public class NonManagedPluginRegistry
implements PluginRegistry {
    private final ClassLoaderResolver clr;
    private static final String[] PLUGIN_DIRS = new String[]{"/", "/META-INF/plugins/"};
    private static final String PLUGIN_FILE_REGEX = "plugin(.+)\\.xml$";
    private static final FilenameFilter PLUGIN_FILE_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            if (JavaUtils.isJRE1_4OrAbove()) {
                return name.matches("^plugin(.+)\\.xml$");
            }
            return name.equals("plugin.xml");
        }
    };
    private static final char JAR_SEPARATOR = '!';
    Map extensionPointsByUniqueId = new HashMap();
    ExtensionPoint[] extensionPoints;

    public NonManagedPluginRegistry(ClassLoaderResolver clr) {
        this.clr = clr;
        this.extensionPoints = new ExtensionPoint[0];
    }

    public ExtensionPoint getExtensionPoint(String id) {
        return (ExtensionPoint)this.extensionPointsByUniqueId.get(id);
    }

    public ExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints;
    }

    public void registerExtensionPoints() {
        this.registerExtensions();
    }

    public void registerExtensions() {
        URL plugin;
        HashSet set = new HashSet();
        try {
            for (int i = 0; i < PLUGIN_DIRS.length; ++i) {
                Enumeration paths = this.clr.getResources(PLUGIN_DIRS[i] + "plugin.xml", null);
                while (paths.hasMoreElements()) {
                    set.add(paths.nextElement());
                }
                this.findAdditionalPluginFiles(set, this.clr.getResources(PLUGIN_DIRS[i], null));
            }
        }
        catch (IOException e) {
            throw new JDOFatalException("Error loading resource", (Throwable)e);
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            plugin = (URL)it.next();
            this.registerExtensionPoints(plugin);
        }
        it = set.iterator();
        while (it.hasNext()) {
            plugin = (URL)it.next();
            this.registerExtensions(plugin);
        }
    }

    private void findAdditionalPluginFiles(Set set, Enumeration paths) {
        while (paths.hasMoreElements()) {
            URL pathUrl = (URL)paths.nextElement();
            if (pathUrl.getProtocol().equals("jar")) {
                JarFile jarFile;
                String path = pathUrl.getFile();
                String jarPath = path.substring(0, path.indexOf(33));
                URL jarUrl = null;
                try {
                    jarUrl = new URL(jarPath);
                }
                catch (MalformedURLException e) {
                    throw new JDOFatalInternalException("Malformed URL for file: " + jarPath, (Throwable)e);
                }
                if (!jarUrl.getProtocol().equals("file")) continue;
                String resourcePath = StringUtils.getDecodedStringFromURLString(path.substring(path.indexOf(33) + 2));
                try {
                    jarFile = StringUtils.getJarFileForFilename(jarUrl.getFile());
                }
                catch (IOException e) {
                    throw new JDOFatalInternalException("Error creating JAR-File: " + jarUrl.getFile(), (Throwable)e);
                }
                Enumeration<JarEntry> en = jarFile.entries();
                while (en.hasMoreElements()) {
                    JarEntry entry = en.nextElement();
                    boolean validEntry = false;
                    validEntry = JavaUtils.isJRE1_4OrAbove() ? entry.getName().matches(resourcePath + PLUGIN_FILE_REGEX) : entry.getName().equals(resourcePath + "plugin.xml");
                    if (!validEntry) continue;
                    String pluginFilePath = jarUrl.toString() + '!' + entry.getName();
                    try {
                        set.add(new URL(pluginFilePath));
                    }
                    catch (MalformedURLException e) {
                        throw new JDOFatalInternalException("Malformed URL for file: " + pluginFilePath, (Throwable)e);
                    }
                }
                continue;
            }
            if (!pathUrl.getProtocol().equals("file")) continue;
            File[] pluginFiles = StringUtils.getFileForFilename(pathUrl.getPath()).listFiles(PLUGIN_FILE_FILTER);
            for (int i = 0; pluginFiles != null && i < pluginFiles.length; ++i) {
                try {
                    set.add(pluginFiles[i].toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new JDOFatalInternalException("Malformed URL for file: " + pluginFiles[i], (Throwable)e);
                }
            }
        }
    }

    protected void registerExtensions(URL plugin) {
        if (plugin == null) {
            return;
        }
        List elements = PluginParser.parseExtensions(this, plugin, this.clr);
        for (int i = 0; i < elements.size(); ++i) {
            ExtensionPoint exPoint = (ExtensionPoint)elements.get(i);
            this.extensionPointsByUniqueId.put(exPoint.getUniqueId(), exPoint);
        }
        this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
    }

    protected void registerExtensionPoints(URL plugin) {
        if (plugin == null) {
            return;
        }
        List elements = PluginParser.parseExtensionPoints(this, plugin, this.clr);
        for (int i = 0; i < elements.size(); ++i) {
            ExtensionPoint exPoint = (ExtensionPoint)elements.get(i);
            this.extensionPointsByUniqueId.put(exPoint.getUniqueId(), exPoint);
        }
        this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
    }

    public Object createExecutableExtension(ConfigurationElement confElm, String name, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class cls = this.clr.classForName(confElm.getAttribute(name));
        Constructor constructor = cls.getConstructor(argsClass);
        return constructor.newInstance(args);
    }

    public Class loadClass(String pluginId, String className) throws ClassNotFoundException {
        return this.clr.classForName(className);
    }

    public URL resolveURLAsFileURL(URL url) throws IOException {
        return url;
    }
}

