/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.PackageMetaData;
import org.jpox.util.StringUtils;

public class TableGeneratorMetaData
extends ExtendableMetaData {
    protected final String name;
    protected String tableName;
    protected String catalogName;
    protected String schemaName;
    protected String pkColumnName;
    protected String valueColumnName;
    protected String pkColumnValue;
    protected long initialValue = 1L;
    protected long allocationSize = 1L;

    public TableGeneratorMetaData(ExtendableMetaData parent, String name, String tableName, String catalogName, String schemaName, String pkColumnName, String valueColumnName, String pkColumnValue, String initialValue, String allocationSize) {
        super(parent);
        this.name = name;
        if (StringUtils.isWhitespace(name)) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Sequence.SequenceNameNotSpecifiedError");
        }
        this.tableName = tableName;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.pkColumnName = pkColumnName;
        this.valueColumnName = valueColumnName;
        this.pkColumnValue = pkColumnValue;
        if (!StringUtils.isWhitespace(initialValue)) {
            this.initialValue = new Long(initialValue);
        }
        if (!StringUtils.isWhitespace(allocationSize)) {
            this.allocationSize = new Long(allocationSize);
        }
    }

    public String getFullyQualifiedName() {
        PackageMetaData pmd = (PackageMetaData)this.getParent();
        return pmd.getName() + "." + this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getPKColumnName() {
        return this.pkColumnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public String getPKColumnValue() {
        return this.pkColumnValue;
    }

    public long getInitialValue() {
        return this.initialValue;
    }

    public long getAllocationSize() {
        return this.allocationSize;
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<table-generator name=\"" + this.name + "\"\n");
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</table-generator>\n");
        return sb.toString();
    }
}

