/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOUserException;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.metadata.TableGeneratorMetaData;

public class PackageMetaData
extends ExtendableMetaData {
    protected List interfaces = null;
    protected List classes = null;
    protected Collection sequences = null;
    protected Collection tableGenerators = null;
    protected final String name;
    protected String catalog;
    protected String schema;

    public PackageMetaData(FileMetaData parent, String name, String catalog, String schema) {
        super(parent);
        this.name = name;
        if (this.name == null) {
            throw new JDOUserException(LOCALISER.msg("MetaData.Parser.ExpectedValueInAttribute", "name", this.getFileMetaData().getFilename(), "package"));
        }
        this.catalog = catalog;
        this.schema = schema;
        if (this.catalog == null && parent.getCatalog() != null) {
            this.catalog = parent.getCatalog();
        }
        if (this.schema == null && parent.getSchema() != null) {
            this.schema = parent.getSchema();
        }
    }

    public FileMetaData getFileMetaData() {
        if (this.parent != null) {
            return (FileMetaData)this.parent;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public int getNoOfInterfaces() {
        return this.interfaces != null ? this.interfaces.size() : 0;
    }

    public InterfaceMetaData getInterface(int i) {
        return (InterfaceMetaData)this.interfaces.get(i);
    }

    public InterfaceMetaData getInterface(String name) {
        Iterator iter = this.interfaces.iterator();
        while (iter.hasNext()) {
            InterfaceMetaData imd = (InterfaceMetaData)iter.next();
            if (!imd.getName().equals(name)) continue;
            return imd;
        }
        return null;
    }

    public int getNoOfClasses() {
        return this.classes != null ? this.classes.size() : 0;
    }

    public ClassMetaData getClass(int i) {
        return (ClassMetaData)this.classes.get(i);
    }

    public ClassMetaData getClass(String name) {
        Iterator iter = this.classes.iterator();
        while (iter.hasNext()) {
            ClassMetaData cmd = (ClassMetaData)iter.next();
            if (!cmd.getName().equals(name)) continue;
            return cmd;
        }
        return null;
    }

    public int getNoOfSequences() {
        return this.sequences != null ? this.sequences.size() : 0;
    }

    public SequenceMetaData[] getSequences() {
        return this.sequences == null ? null : this.sequences.toArray(new SequenceMetaData[this.sequences.size()]);
    }

    public SequenceMetaData getSequence(String name) {
        Iterator iter = this.sequences.iterator();
        while (iter.hasNext()) {
            SequenceMetaData seqmd = (SequenceMetaData)iter.next();
            if (!seqmd.getName().equals(name)) continue;
            return seqmd;
        }
        return null;
    }

    public int getNoOfTableGenerators() {
        return this.tableGenerators != null ? this.tableGenerators.size() : 0;
    }

    public TableGeneratorMetaData[] getTableGenerators() {
        return this.tableGenerators == null ? null : this.tableGenerators.toArray(new TableGeneratorMetaData[this.tableGenerators.size()]);
    }

    public TableGeneratorMetaData getTableGenerator(String name) {
        Iterator iter = this.tableGenerators.iterator();
        while (iter.hasNext()) {
            TableGeneratorMetaData tgmd = (TableGeneratorMetaData)iter.next();
            if (!tgmd.getName().equals(name)) continue;
            return tgmd;
        }
        return null;
    }

    public void addClass(ClassMetaData cmd) {
        if (cmd == null) {
            return;
        }
        if (this.classes == null) {
            this.classes = new ArrayList();
        }
        this.classes.add(cmd);
    }

    public void addInterface(InterfaceMetaData imd) {
        if (imd == null) {
            return;
        }
        if (this.interfaces == null) {
            this.interfaces = new ArrayList();
        }
        this.interfaces.add(imd);
    }

    public void addSequence(SequenceMetaData seqmd) {
        if (seqmd == null) {
            return;
        }
        if (this.sequences == null) {
            this.sequences = new HashSet();
        }
        this.sequences.add(seqmd);
        seqmd.parent = this;
    }

    public void addTableGenerator(TableGeneratorMetaData tgmd) {
        if (tgmd == null) {
            return;
        }
        if (this.tableGenerators == null) {
            this.tableGenerators = new HashSet();
        }
        this.tableGenerators.add(tgmd);
        tgmd.parent = this;
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<package name=\"" + this.name + "\"");
        if (this.catalog != null) {
            sb.append(" catalog=\"" + this.catalog + "\"");
        }
        if (this.schema != null) {
            sb.append(" schema=\"" + this.schema + "\"");
        }
        sb.append(">\n");
        if (this.interfaces != null) {
            Iterator int_iter = this.interfaces.iterator();
            while (int_iter.hasNext()) {
                sb.append(((InterfaceMetaData)int_iter.next()).toString(prefix + indent, indent));
            }
        }
        if (this.classes != null) {
            Iterator cls_iter = this.classes.iterator();
            while (cls_iter.hasNext()) {
                sb.append(((ClassMetaData)cls_iter.next()).toString(prefix + indent, indent));
            }
        }
        if (this.sequences != null) {
            Iterator seq_iter = this.sequences.iterator();
            while (seq_iter.hasNext()) {
                sb.append(((SequenceMetaData)seq_iter.next()).toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</package>\n");
        return sb.toString();
    }
}

