/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PrimaryKeyMetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.util.StringUtils;

public class JoinMetaData
extends ExtendableMetaData
implements ColumnMetaDataContainer {
    ForeignKeyMetaData foreignKeyMetaData;
    IndexMetaData indexMetaData;
    UniqueMetaData uniqueMetaData;
    protected PrimaryKeyMetaData primaryKeyMetaData;
    final List columns = new ArrayList();
    Boolean outer;
    String table;
    String column;
    String foreignKey;
    protected ColumnMetaData[] columnMetaData;

    public JoinMetaData(MetaData parent, JoinMetaData joinmd) {
        super(parent);
        this.table = joinmd.table;
        this.column = joinmd.column;
        this.outer = joinmd.outer;
        for (int i = 0; i < joinmd.columns.size(); ++i) {
            this.addColumn(new ColumnMetaData((ExtendableMetaData)this, (ColumnMetaData)joinmd.columns.get(i)));
        }
    }

    public JoinMetaData(MetaData parent, String table, String column, String outer, String fkDeleteAction) {
        super(parent);
        if (table != null && parent instanceof AbstractPropertyMetaData) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Join.TableNotValidWithinField", ((AbstractPropertyMetaData)parent).getFullFieldName());
        }
        this.table = table;
        this.column = column;
        if (outer != null) {
            if (outer.equalsIgnoreCase("true")) {
                this.outer = Boolean.TRUE;
            } else if (outer.equalsIgnoreCase("false")) {
                this.outer = Boolean.FALSE;
            }
        }
        if (!StringUtils.isWhitespace(fkDeleteAction)) {
            this.foreignKeyMetaData = new ForeignKeyMetaData(null, fkDeleteAction, null, null, null, null);
        }
    }

    public void initialise() {
        if (this.columns.size() == 0 && this.column != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = new ColumnMetaData((ExtendableMetaData)this, this.column);
            this.columnMetaData[0].initialise();
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (int i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        if (this.foreignKeyMetaData != null) {
            this.foreignKeyMetaData.initialise();
        }
        if (this.indexMetaData != null) {
            this.indexMetaData.initialise();
        }
        if (this.uniqueMetaData != null) {
            this.uniqueMetaData.initialise();
        }
        if (this.primaryKeyMetaData != null) {
            this.primaryKeyMetaData.initialise();
        }
        this.setInitialised();
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
    }

    public final String getTable() {
        return this.table;
    }

    public final String getColumn() {
        return this.column;
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final boolean isOuter() {
        if (this.outer == null) {
            return false;
        }
        return this.outer;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final UniqueMetaData getUniqueMetaData() {
        return this.uniqueMetaData;
    }

    public final ForeignKeyMetaData getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public final PrimaryKeyMetaData getPrimaryKeyMetaData() {
        return this.primaryKeyMetaData;
    }

    public final void setForeignKeyMetaData(ForeignKeyMetaData foreignKeyMetaData) {
        this.foreignKeyMetaData = foreignKeyMetaData;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
    }

    public final void setUniqueMetaData(UniqueMetaData uniqueMetaData) {
        this.uniqueMetaData = uniqueMetaData;
    }

    public final void setPrimaryKeyMetaData(PrimaryKeyMetaData primaryKeyMetaData) {
        this.primaryKeyMetaData = primaryKeyMetaData;
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<join");
        if (this.table != null) {
            sb.append(" table=\"" + this.table + "\"");
        }
        if (this.column != null) {
            sb.append(" column=\"" + this.column + "\"");
        }
        if (this.outer != null) {
            sb.append(" outer=\"" + this.outer + "\"");
        }
        sb.append(">\n");
        if (this.primaryKeyMetaData != null) {
            sb.append(this.primaryKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.columnMetaData != null) {
            for (int i = 0; i < this.columnMetaData.length; ++i) {
                sb.append(this.columnMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.foreignKeyMetaData != null) {
            sb.append(this.foreignKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.indexMetaData != null) {
            sb.append(this.indexMetaData.toString(prefix + indent, indent));
        }
        if (this.uniqueMetaData != null) {
            sb.append(this.uniqueMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</join>\n");
        return sb.toString();
    }
}

