/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.JDOUserException;
import org.jpox.ClassLoaderResolver;
import org.jpox.PMFContext;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.MetaDataParser;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.PersistenceUnitMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.metadata.TableGeneratorMetaData;
import org.jpox.util.JPOXLogger;

public class JPAMetaDataManager
extends MetaDataManager {
    protected Map classMetaDataByEntityName = new HashMap();
    protected PersistenceUnitMetaData unitMetaData = null;
    protected boolean initialised = false;

    public JPAMetaDataManager(PMFContext pmfContext) {
        super(pmfContext);
    }

    public void initialise(PersistenceUnitMetaData pumd, ClassLoaderResolver clr) {
        HashSet mappingFiles;
        if (this.initialised) {
            return;
        }
        this.unitMetaData = pumd;
        HashSet<Object> exceptions = new HashSet<Object>();
        HashSet classNames = pumd.getClassNames();
        if (classNames != null) {
            Iterator iter = classNames.iterator();
            while (iter.hasNext()) {
                String className = (String)iter.next();
                try {
                    Class cls = clr.classForName(className);
                    this.loadAnnotationsForClass(cls, clr, true);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        if ((mappingFiles = pumd.getMappingFiles()) != null) {
            Iterator iter = mappingFiles.iterator();
            while (iter.hasNext()) {
                String mappingFileName = (String)iter.next();
                try {
                    Enumeration<URL> files = Thread.currentThread().getContextClassLoader().getResources(mappingFileName);
                    while (files.hasMoreElements()) {
                        URL url = files.nextElement();
                        FileMetaData filemd = this.parseFile(url);
                        if (filemd == null) continue;
                        this.registerFile(url.getFile(), filemd);
                        this.populateFileMetaData(filemd, clr, null);
                    }
                }
                catch (InvalidMetaDataException imde) {
                    JPOXLogger.JPA.error(imde.getMessage());
                    exceptions.add((Object)imde);
                }
                catch (IOException ioe) {
                    JPOXLogger.JPA.error("mapping-file " + mappingFileName + " could not be read");
                }
            }
        }
        if (exceptions.size() > 0) {
            throw new JDOUserException("Errors encountered whilst initialising MetaData for JPA. See the nested exceptions for details", exceptions.toArray(new Throwable[exceptions.size()]));
        }
    }

    protected FileMetaData parseFile(URL fileURL) {
        if (this.metaDataParser == null) {
            this.metaDataParser = new MetaDataParser(this, this.validateMetaData);
        }
        return (FileMetaData)this.metaDataParser.parseMetaDataURL(fileURL, "jpa");
    }

    protected void registerFile(String fileURLString, FileMetaData filemd) {
        if (fileURLString == null) {
            return;
        }
        if (this.fileMetaDataByURLString.get(fileURLString) != null) {
            return;
        }
        this.fileMetaDataByURLString.put(fileURLString, filemd);
        this.registerQueriesForFile(filemd);
        this.registerSequencesForFile(filemd);
        this.registerTableGeneratorsForFile(filemd);
        if (filemd.getType() == 5 || filemd.getType() == 4) {
            for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
                PackageMetaData pmd = filemd.getPackage(i);
                for (int j = 0; j < pmd.getNoOfClasses(); ++j) {
                    ClassMetaData cmd = pmd.getClass(j);
                    if (cmd.getEntityName() != null) {
                        this.classMetaDataByEntityName.put(cmd.getEntityName(), cmd);
                    }
                    this.classMetaDataByClass.put(cmd.getFullClassName(), cmd);
                }
            }
        }
    }

    protected void registerSequencesForFile(FileMetaData filemd) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            SequenceMetaData[] seqmds = pmd.getSequences();
            if (seqmds == null) continue;
            for (int j = 0; j < seqmds.length; ++j) {
                this.sequenceMetaDataByPackageSequence.put(seqmds[j].getName(), seqmds[j]);
            }
        }
    }

    protected void registerTableGeneratorsForFile(FileMetaData filemd) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            TableGeneratorMetaData[] tgmds = pmd.getTableGenerators();
            if (tgmds == null) continue;
            for (int j = 0; j < tgmds.length; ++j) {
                this.tableGeneratorMetaDataByPackageSequence.put(tgmds[j].getName(), tgmds[j]);
            }
        }
    }

    public synchronized AbstractClassMetaData getMetaDataForClassInternal(Class c, ClassLoaderResolver clr) {
        AbstractClassMetaData acmd = (AbstractClassMetaData)this.classMetaDataByClass.get(c.getName());
        if (acmd != null) {
            return acmd;
        }
        FileMetaData annFilemd = this.loadAnnotationsForClass(c, clr, true);
        if (annFilemd != null) {
            return annFilemd.getPackage(0).getClass(0);
        }
        return null;
    }

    public synchronized AbstractClassMetaData getMetaDataForEntityName(String entityName) {
        return (AbstractClassMetaData)this.classMetaDataByEntityName.get(entityName);
    }

    public boolean hasMetaDataForClass(String class_name) {
        if (class_name == null) {
            return false;
        }
        return this.classMetaDataByClass.get(class_name) != null;
    }

    protected boolean isClassWithoutMetaData(String className) {
        return !this.hasMetaDataForClass(className);
    }
}

