/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMetaDataHandler;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InheritanceMetaData;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.JoinMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.PropertyMetaData;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.metadata.TableGeneratorMetaData;
import org.jpox.util.JPOXLogger;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class JPAMetaDataHandler
extends AbstractMetaDataHandler {
    String defaultPackageName = null;

    public JPAMetaDataHandler(MetaDataManager mgr, String filename, EntityResolver resolver) {
        super(mgr, filename, resolver);
        this.metadata = new FileMetaData(filename, mgr, null, null);
        this.pushStack(this.metadata);
    }

    protected ClassMetaData newClassObject(PackageMetaData pmd, Attributes attrs) {
        String className = this.getAttr(attrs, "class");
        if (className.indexOf(46) > 0) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        return this.mgr.newClassObject(pmd, className, IdentityType.APPLICATION.toString(), this.getAttr(attrs, "objectid-class"), "true", "true", this.getAttr(attrs, "embedded-only"), ClassPersistenceModifier.PERSISTENCE_CAPABLE.toString(), null, null, null, null, this.getAttr(attrs, "name"));
    }

    protected FieldMetaData newFieldObject(MetaData md, Attributes attrs) {
        String fetch = this.getAttr(attrs, "fetch");
        String dfg = "true";
        if (fetch != null && fetch.equalsIgnoreCase("LAZY")) {
            dfg = "false";
        }
        return this.mgr.newFieldObject(md, this.getAttr(attrs, "name"), null, FieldPersistenceModifier.PERSISTENT.toString(), dfg, null, null, null, this.getAttr(attrs, "dependent"), this.getAttr(attrs, "mapped-by"), null, null, null, null, null, null, this.getAttr(attrs, "load-fetch-group"), null, null, null);
    }

    protected FieldMetaData newPKFieldObject(MetaData md, Attributes attrs) {
        return this.mgr.newFieldObject(md, this.getAttr(attrs, "name"), "true", FieldPersistenceModifier.PERSISTENT.toString(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    protected FieldMetaData newTransientFieldObject(MetaData md, String name) {
        return this.mgr.newFieldObject(md, name, null, FieldPersistenceModifier.NONE.toString(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    protected PropertyMetaData newPropertyObject(MetaData md, Attributes attrs) {
        return null;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        block47: {
            if (JPOXLogger.METADATA.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("<" + qName);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    sb.append(" ");
                    sb.append(attrs.getQName(i)).append("=\"").append(attrs.getValue(i)).append("\"");
                }
                sb.append(">");
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Parser.StartElement", sb.toString(), "" + this.stack.size()));
            }
            try {
                AbstractPropertyMetaData fmd;
                AbstractClassMetaData cmd;
                MetaData md;
                FileMetaData filemd;
                if (qName.equals("entity-mappings")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(5);
                    break block47;
                }
                if (qName.equals("description") || qName.equals("persistence-unit-metadata") || qName.equals("persistence-unit-defaults") || qName.equals("package") || qName.equals("schema") || qName.equals("catalog") || qName.equals("access")) break block47;
                if (qName.equals("sequence-generator")) {
                    md = this.getStack();
                    SequenceMetaData seqmd = new SequenceMetaData((ExtendableMetaData)md, this.getAttr(attrs, "name"), this.getAttr(attrs, "sequence-name"), null, null, this.getAttr(attrs, "initial-value"), this.getAttr(attrs, "allocation-size"));
                    PackageMetaData pmd = null;
                    if (this.defaultPackageName != null) {
                        pmd = ((FileMetaData)this.metadata).getPackage(this.defaultPackageName);
                    } else if (((FileMetaData)this.metadata).getNoOfPackages() > 0) {
                        pmd = ((FileMetaData)this.metadata).getPackage(0);
                    } else {
                        pmd = new PackageMetaData((FileMetaData)this.metadata, "", null, null);
                        ((FileMetaData)this.metadata).addPackage(pmd);
                    }
                    pmd.addSequence(seqmd);
                    break block47;
                }
                if (qName.equals("table-generator")) {
                    md = this.getStack();
                    TableGeneratorMetaData tgmd = new TableGeneratorMetaData((ExtendableMetaData)md, this.getAttr(attrs, "name"), this.getAttr(attrs, "table"), this.getAttr(attrs, "catalog"), this.getAttr(attrs, "schema"), this.getAttr(attrs, "pk-column-name"), this.getAttr(attrs, "value-column-name"), this.getAttr(attrs, "pk-column-value"), this.getAttr(attrs, "initial-value"), this.getAttr(attrs, "allocation-size"));
                    PackageMetaData pmd = null;
                    if (this.defaultPackageName != null) {
                        pmd = ((FileMetaData)this.metadata).getPackage(this.defaultPackageName);
                    } else if (((FileMetaData)this.metadata).getNoOfPackages() > 0) {
                        pmd = ((FileMetaData)this.metadata).getPackage(0);
                    } else {
                        pmd = new PackageMetaData((FileMetaData)this.metadata, "", null, null);
                        ((FileMetaData)this.metadata).addPackage(pmd);
                    }
                    pmd.addTableGenerator(tgmd);
                    break block47;
                }
                if (qName.equals("named-query")) {
                    cmd = (ClassMetaData)this.getStack();
                    QueryMetaData qmd = new QueryMetaData(cmd, this.getAttr(attrs, "name"), "javax.jdo.query.JPQL", null, null, null);
                    cmd.addQuery(qmd);
                    this.pushStack(qmd);
                    break block47;
                }
                if (qName.equals("named-native-query")) {
                    cmd = (ClassMetaData)this.getStack();
                    QueryMetaData qmd = new QueryMetaData(cmd, this.getAttr(attrs, "name"), "javax.jdo.query.SQL", null, this.getAttr(attrs, "result-class"), null);
                    cmd.addQuery(qmd);
                    this.pushStack(qmd);
                    break block47;
                }
                if (qName.equals("query")) break block47;
                if (qName.equals("entity")) {
                    filemd = (FileMetaData)this.getStack();
                    String className = this.getAttr(attrs, "class");
                    String packageName = null;
                    if (className.indexOf(46) > 0) {
                        packageName = className.substring(0, className.lastIndexOf(46));
                    }
                    PackageMetaData pmd = null;
                    if (packageName != null) {
                        pmd = filemd.getPackage(packageName);
                    }
                    if (pmd == null) {
                        pmd = packageName != null ? new PackageMetaData(filemd, packageName, null, null) : (this.defaultPackageName != null ? filemd.getPackage(this.defaultPackageName) : new PackageMetaData(filemd, "", null, null));
                    }
                    ClassMetaData cmd2 = this.newClassObject(pmd, attrs);
                    pmd.addClass(cmd2);
                    this.pushStack(cmd2);
                    break block47;
                }
                if (qName.equals("attributes")) break block47;
                if (qName.equals("id-class")) {
                    cmd = (ClassMetaData)this.getStack();
                    ((ClassMetaData)cmd).objectidClass = this.getAttr(attrs, "class");
                    break block47;
                }
                if (qName.equals("inheritance")) {
                    cmd = (ClassMetaData)this.getStack();
                    String strategy = this.getAttr(attrs, "strategy");
                    String strategyType = null;
                    strategyType = strategy.equalsIgnoreCase("JOINED") ? InheritanceStrategy.SUBCLASS_TABLE.toString() : (strategy.equalsIgnoreCase("TABLE_PER_CLASS") ? InheritanceStrategy.NEW_TABLE.toString() : InheritanceStrategy.NEW_TABLE.toString());
                    InheritanceMetaData inhmd = new InheritanceMetaData(cmd, this.getAttr(attrs, strategyType));
                    cmd.setInheritanceMetaData(inhmd);
                    break block47;
                }
                if (qName.equals("table")) {
                    cmd = (ClassMetaData)this.getStack();
                    ((ClassMetaData)cmd).catalog = this.getAttr(attrs, "catalog");
                    ((ClassMetaData)cmd).schema = this.getAttr(attrs, "schema");
                    ((ClassMetaData)cmd).table = this.getAttr(attrs, "name");
                    break block47;
                }
                if (qName.equals("id")) {
                    cmd = (ClassMetaData)this.getStack();
                    FieldMetaData fmd2 = this.newPKFieldObject(cmd, attrs);
                    cmd.addProperty(fmd2);
                    this.pushStack(fmd2);
                    break block47;
                }
                if (qName.equals("embedded-id")) {
                    cmd = (ClassMetaData)this.getStack();
                    FieldMetaData fmd3 = this.newPKFieldObject(cmd, attrs);
                    cmd.addProperty(fmd3);
                    this.pushStack(fmd3);
                    break block47;
                }
                if (qName.equals("basic")) {
                    cmd = (ClassMetaData)this.getStack();
                    FieldMetaData fmd4 = this.newFieldObject(cmd, attrs);
                    cmd.addProperty(fmd4);
                    this.pushStack(fmd4);
                    break block47;
                }
                if (qName.equals("transient")) {
                    cmd = (ClassMetaData)this.getStack();
                    FieldMetaData fmd5 = this.newTransientFieldObject(cmd, this.getAttr(attrs, "name"));
                    cmd.addProperty(fmd5);
                    this.pushStack(fmd5);
                    break block47;
                }
                if (qName.equals("one-to-many")) {
                    cmd = (ClassMetaData)this.getStack();
                    FieldMetaData fmd6 = this.newFieldObject(cmd, attrs);
                    cmd.addProperty(fmd6);
                    this.pushStack(fmd6);
                    break block47;
                }
                if (qName.equals("one-to-one")) {
                    cmd = (ClassMetaData)this.getStack();
                    FieldMetaData fmd7 = this.newFieldObject(cmd, attrs);
                    cmd.addProperty(fmd7);
                    this.pushStack(fmd7);
                    break block47;
                }
                if (qName.equals("many-to-one")) {
                    cmd = (ClassMetaData)this.getStack();
                    FieldMetaData fmd8 = this.newFieldObject(cmd, attrs);
                    cmd.addProperty(fmd8);
                    this.pushStack(fmd8);
                    break block47;
                }
                if (qName.equals("many-to-many")) {
                    cmd = (ClassMetaData)this.getStack();
                    FieldMetaData fmd9 = this.newFieldObject(cmd, attrs);
                    cmd.addProperty(fmd9);
                    this.pushStack(fmd9);
                    break block47;
                }
                if (qName.equals("version")) {
                    if (this.getStack() instanceof ClassMetaData) {
                        cmd = (ClassMetaData)this.getStack();
                        FieldMetaData fmd10 = this.newFieldObject(cmd, attrs);
                        cmd.addProperty(fmd10);
                        this.pushStack(fmd10);
                    }
                    break block47;
                }
                if (qName.equals("generated-value")) {
                    fmd = (AbstractPropertyMetaData)this.getStack();
                    IdentityStrategy idStrategy = IdentityStrategy.getIdentityStrategy(this.getAttr(attrs, "strategy"));
                    fmd.setValueStrategy(idStrategy);
                    break block47;
                }
                if (qName.equals("join-table")) {
                    fmd = (AbstractPropertyMetaData)this.getStack();
                    JoinMetaData joinmd = new JoinMetaData(fmd, this.getAttr(attrs, "name"), null, null, null);
                    fmd.setJoinMetaData(joinmd);
                    break block47;
                }
                if (qName.equals("column")) {
                    fmd = (AbstractPropertyMetaData)this.getStack();
                    ColumnMetaData colmd = new ColumnMetaData(fmd, this.getAttr(attrs, "name"), null, null, null, null, this.getAttr(attrs, "length"), this.getAttr(attrs, "scale"), this.getAttr(attrs, "nullable"), null, null, this.getAttr(attrs, "insertable"), this.getAttr(attrs, "updatable"), this.getAttr(attrs, "unique"));
                    fmd.addColumn(colmd);
                    break block47;
                }
                if (qName.equals("entity-listeners")) break block47;
                if (qName.equals("entity-listener")) {
                    cmd = (ClassMetaData)this.getStack();
                    cmd.addListener(this.getAttr(attrs, "name"));
                    break block47;
                }
                if (qName.equals("pre-persist")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.addCallback("javax.persistence.PrePersist", this.getAttr(attrs, "method-name"));
                    break block47;
                }
                if (qName.equals("post-persist")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.addCallback("javax.persistence.PostPersist", this.getAttr(attrs, "method-name"));
                    break block47;
                }
                if (qName.equals("pre-remove")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.addCallback("javax.persistence.PreRemove", this.getAttr(attrs, "method-name"));
                    break block47;
                }
                if (qName.equals("post-remove")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.addCallback("javax.persistence.PostRemove", this.getAttr(attrs, "method-name"));
                    break block47;
                }
                if (qName.equals("pre-update")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.addCallback("javax.persistence.PreUpdate", this.getAttr(attrs, "method-name"));
                    break block47;
                }
                if (qName.equals("post-update")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.addCallback("javax.persistence.PostUpdate", this.getAttr(attrs, "method-name"));
                    break block47;
                }
                if (qName.equals("post-load")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.addCallback("javax.persistence.PostLoad", this.getAttr(attrs, "method-name"));
                    break block47;
                }
                if (qName.equals("exclude-default-listeners")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.excludeDefaultListeners();
                    break block47;
                }
                if (qName.equals("exclude-superclass-listeners")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.excludeSuperClassListeners();
                    break block47;
                }
                String message = LOCALISER.msg("MetaData.Parser.UnknownTag.Error", qName);
                JPOXLogger.METADATA.error(message);
                throw new RuntimeException(message);
            }
            catch (RuntimeException ex) {
                JPOXLogger.METADATA.error("The following error occurred while parsing <" + qName + "> nested within " + this.getStack());
                throw ex;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentString;
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Parser.EndElement", "<" + qName + ">", "" + this.stack.size()));
        }
        if ((currentString = this.getString().trim()).length() > 0) {
            ExtendableMetaData extmd = (ExtendableMetaData)this.getStack();
            if (qName.equals("schema")) {
                if (extmd instanceof FileMetaData) {
                    ((FileMetaData)extmd).schema = currentString;
                }
            } else if (qName.equals("catalog")) {
                if (extmd instanceof FileMetaData) {
                    ((FileMetaData)extmd).catalog = currentString;
                }
            } else if (qName.equals("package")) {
                if (extmd instanceof FileMetaData) {
                    FileMetaData filemd = (FileMetaData)extmd;
                    filemd.addPackage(new PackageMetaData(filemd, currentString, null, null));
                    this.defaultPackageName = currentString;
                }
            } else if (qName.equals("discriminator-value")) {
                if (extmd instanceof ClassMetaData) {
                    ClassMetaData cmd = (ClassMetaData)extmd;
                    InheritanceMetaData inhmd = cmd.getInheritanceMetaData();
                    if (inhmd == null) {
                        inhmd = new InheritanceMetaData(cmd, null);
                        cmd.setInheritanceMetaData(inhmd);
                    }
                    String discrimValue = currentString;
                    DiscriminatorMetaData discmd = new DiscriminatorMetaData(inhmd, null, discrimValue, DiscriminatorStrategy.VALUE_MAP.toString(), null);
                    inhmd.setDiscriminatorMetaData(discmd);
                }
            } else if (qName.equals("query") && extmd instanceof QueryMetaData) {
                ((QueryMetaData)extmd).setQuery(currentString);
            }
        }
        if (qName.equals("entity") || qName.equals("id") || qName.equals("embedded-id") || qName.equals("basic") || qName.equals("transient") || qName.equals("one-to-one") || qName.equals("one-to-many") || qName.equals("many-to-one") || qName.equals("many-to-many") || qName.equals("version") || qName.equals("named-query") || qName.equals("named-native-query")) {
            this.popStack();
        }
    }
}

