/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpox.ClassLoaderResolver;
import org.jpox.PMFContext;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.ImplementsMetaData;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.MetaDataParser;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class JDOMetaDataManager
extends MetaDataManager {
    protected String jdoFileSuffix = "jdo";
    protected String ormFileSuffix = "orm";
    protected String jdoqueryFileSuffix = "jdoquery";
    protected String ormMappingName = null;
    public static final int ALL_JDO_LOCATIONS = 1;
    public static final int JDO_1_0_0_LOCATIONS = 2;
    public static final int JDO_1_0_1_LOCATIONS = 3;
    protected int locationDefinition = 1;
    protected Collection classesWithoutMetaData = new HashSet();
    protected Map ormClassMetaDataByClass = new HashMap();
    protected Map classMetaDataByInterface = new HashMap();
    private static final char CLASS_SEPARATOR = '.';
    private static final char PATH_SEPARATOR = '/';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String METADATA_PACKAGE = "package";
    private static final String METADATA_LOCATION_METAINF = "/META-INF/package";
    private static final String METADATA_LOCATION_WEBINF = "/WEB-INF/package";

    public JDOMetaDataManager(PMFContext pmfContext) {
        super(pmfContext);
        String ormMapping;
        String jdoquerySuffix;
        String ormSuffix;
        String jdoSuffix = pmfContext.getPmfConfiguration().getJdoMetaDataFileExtension();
        if (!StringUtils.isWhitespace(jdoSuffix)) {
            this.jdoFileSuffix = jdoSuffix;
        }
        if (!StringUtils.isWhitespace(ormSuffix = pmfContext.getPmfConfiguration().getOrmMetaDataFileExtension())) {
            this.ormFileSuffix = ormSuffix;
        }
        if (!StringUtils.isWhitespace(jdoquerySuffix = pmfContext.getPmfConfiguration().getJdoqueryMetaDataFileExtension())) {
            this.jdoqueryFileSuffix = jdoquerySuffix;
        }
        if (!StringUtils.isWhitespace(ormMapping = pmfContext.getPmfConfiguration().getMapping())) {
            this.ormMappingName = ormMapping;
        }
        Set supportedClasses = this.getPMFContext().getTypeManager().getSupportedTypes();
        Iterator iter = supportedClasses.iterator();
        while (iter.hasNext()) {
            this.classesWithoutMetaData.add(iter.next());
        }
    }

    public void close() {
        super.close();
        this.ormClassMetaDataByClass.clear();
        this.classesWithoutMetaData.clear();
        this.ormClassMetaDataByClass = null;
        this.classesWithoutMetaData = null;
    }

    protected FileMetaData parseFile(URL fileURL) {
        if (this.metaDataParser == null) {
            this.metaDataParser = new MetaDataParser(this, this.validateMetaData);
        }
        return (FileMetaData)this.metaDataParser.parseMetaDataURL(fileURL, "jdo");
    }

    protected void registerFile(String fileURLString, FileMetaData filemd) {
        if (fileURLString == null) {
            return;
        }
        if (this.fileMetaDataByURLString.get(fileURLString) != null) {
            return;
        }
        this.fileMetaDataByURLString.put(fileURLString, filemd);
        this.registerQueriesForFile(filemd);
        this.registerSequencesForFile(filemd);
        this.registerTableGeneratorsForFile(filemd);
        if (filemd.getType() != 3) {
            for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
                int j;
                PackageMetaData pmd = filemd.getPackage(i);
                for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                    ClassMetaData cmd = pmd.getClass(j);
                    if (filemd.getType() == 1 || filemd.getType() == 4) {
                        this.classMetaDataByClass.put(cmd.getFullClassName(), cmd);
                        continue;
                    }
                    if (filemd.getType() != 2) continue;
                    this.ormClassMetaDataByClass.put(cmd.getFullClassName(), cmd);
                }
                for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                    InterfaceMetaData intfmd = pmd.getInterface(j);
                    if (filemd.getType() == 1) {
                        this.classMetaDataByClass.put(intfmd.getFullClassName(), intfmd);
                        continue;
                    }
                    if (filemd.getType() != 2) continue;
                    this.ormClassMetaDataByClass.put(intfmd.getFullClassName(), intfmd);
                }
            }
        }
    }

    protected boolean isClassWithoutMetaData(String className) {
        if (className == null) {
            return true;
        }
        if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("javax.jdo.identity.")) {
            return true;
        }
        return this.classesWithoutMetaData.contains(className);
    }

    public boolean hasMetaDataForClass(String className) {
        if (className == null) {
            return false;
        }
        if (this.isClassWithoutMetaData(className)) {
            return false;
        }
        return this.classMetaDataByClass.get(className) != null;
    }

    public synchronized AbstractClassMetaData getMetaDataForClassInternal(Class c, ClassLoaderResolver clr) {
        if (this.isClassWithoutMetaData(c.getName())) {
            return null;
        }
        AbstractClassMetaData the_md = (AbstractClassMetaData)this.classMetaDataByClass.get(c.getName());
        if (the_md != null) {
            return the_md;
        }
        FileMetaData filemd = this.loadMetaDataForClass(c, clr, null, this.jdoFileSuffix, true);
        if (filemd != null) {
            this.utilisedFileMetaData.add(filemd);
            the_md = (AbstractClassMetaData)this.classMetaDataByClass.get(c.getName());
            return the_md;
        }
        FileMetaData annFilemd = this.loadAnnotationsForClass(c, clr, true);
        if (annFilemd != null) {
            return annFilemd.getPackage(0).getClass(0);
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.RegisterClassWithoutMetaData", c.getName()));
        }
        this.classesWithoutMetaData.add(c.getName());
        return null;
    }

    public QueryMetaData getMetaDataForQuery(Class cls, ClassLoaderResolver clr, String queryName) {
        QueryMetaData qmd = super.getMetaDataForQuery(cls, clr, queryName);
        if (qmd != null) {
            return qmd;
        }
        String query_key = queryName;
        if (cls != null) {
            query_key = cls.getName() + "_" + queryName;
        }
        if (cls != null) {
            AbstractClassMetaData cmd = this.getMetaDataForClass(cls, clr);
            if (cmd == null) {
                return null;
            }
            Object obj = this.queryMetaDataByName.get(query_key);
            if (obj != null) {
                return (QueryMetaData)obj;
            }
            ArrayList locations = new ArrayList();
            locations.addAll(this.getValidMetaDataLocationsForClass(this.jdoqueryFileSuffix, null, cls.getName()));
            for (int i = 0; i < locations.size(); ++i) {
                String location = (String)locations.get(i);
                URL fileURL = clr.getResource(location, cls != null ? cls.getClassLoader() : null);
                if (fileURL != null && this.fileMetaDataByURLString.get(fileURL.toString()) == null) {
                    FileMetaData filemd = this.parseFile(fileURL);
                    filemd.setType(3);
                    this.registerFile(fileURL.toString(), filemd);
                }
                cmd = this.getMetaDataForClass(cls, clr);
                qmd = (QueryMetaData)this.queryMetaDataByName.get(query_key);
                if (qmd != null) {
                    if (JPOXLogger.METADATA.isDebugEnabled()) {
                        JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.FoundQuery", query_key, location));
                    }
                    return qmd;
                }
                if (!JPOXLogger.METADATA.isDebugEnabled()) continue;
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.NotFoundForQueryAtLocationError", query_key, location));
            }
            return null;
        }
        ArrayList locations = new ArrayList();
        locations.addAll(this.getValidMetaDataLocationsForItem(this.jdoFileSuffix, null, null, false));
        locations.addAll(this.getValidMetaDataLocationsForItem(this.ormFileSuffix, this.ormMappingName, null, false));
        locations.addAll(this.getValidMetaDataLocationsForItem(this.jdoqueryFileSuffix, null, null, false));
        for (int i = 0; i < locations.size(); ++i) {
            String location = (String)locations.get(i);
            URL fileURL = clr.getResource(location, cls != null ? cls.getClassLoader() : null);
            if (fileURL != null && this.fileMetaDataByURLString.get(fileURL.toString()) == null) {
                FileMetaData filemd = this.parseFile(fileURL);
                this.registerFile(fileURL.toString(), filemd);
            }
            if ((qmd = (QueryMetaData)this.queryMetaDataByName.get(query_key)) != null) {
                if (JPOXLogger.METADATA.isDebugEnabled()) {
                    JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.FoundQuery", query_key, location));
                }
                return qmd;
            }
            if (!JPOXLogger.METADATA.isDebugEnabled()) continue;
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.NotFoundForQueryAtLocationError", query_key, location));
        }
        return null;
    }

    public SequenceMetaData getMetaDataForSequence(ClassLoaderResolver clr, String packageSequenceName) {
        SequenceMetaData seqmd = super.getMetaDataForSequence(clr, packageSequenceName);
        if (seqmd != null) {
            return seqmd;
        }
        String packageName = packageSequenceName;
        if (packageSequenceName.lastIndexOf(46) >= 0) {
            packageName = packageSequenceName.substring(0, packageSequenceName.lastIndexOf(46));
        }
        ArrayList locations = new ArrayList();
        locations.addAll(this.getValidMetaDataLocationsForItem(this.jdoFileSuffix, null, packageName, false));
        locations.addAll(this.getValidMetaDataLocationsForItem(this.ormFileSuffix, this.ormMappingName, packageName, false));
        for (int i = 0; i < locations.size(); ++i) {
            String location = (String)locations.get(i);
            URL fileURL = clr.getResource(location, null);
            if (fileURL != null && this.fileMetaDataByURLString.get(fileURL.toString()) == null) {
                FileMetaData filemd = this.parseFile(fileURL);
                this.registerFile(fileURL.toString(), filemd);
            }
            if ((seqmd = (SequenceMetaData)this.sequenceMetaDataByPackageSequence.get(packageSequenceName)) != null) {
                if (JPOXLogger.METADATA.isDebugEnabled()) {
                    JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.FoundQuery", packageSequenceName, location));
                }
                return seqmd;
            }
            if (!JPOXLogger.METADATA.isDebugEnabled()) continue;
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.NotFoundForSequenceAtLocationError", packageSequenceName, location));
        }
        return null;
    }

    public void addORMDataToClass(Class c, ClassLoaderResolver clr) {
        if (this.enhancing) {
            return;
        }
        AbstractClassMetaData cmd = (AbstractClassMetaData)this.classMetaDataByClass.get(c.getName());
        AbstractClassMetaData orm_cmd = (AbstractClassMetaData)this.ormClassMetaDataByClass.get(c.getName());
        if (orm_cmd != null) {
            cmd.mergeORMData(orm_cmd);
            this.ormClassMetaDataByClass.remove(c.getName());
            return;
        }
        FileMetaData filemdORM = this.loadMetaDataForClass(c, clr, this.ormMappingName, this.ormFileSuffix, false);
        if (filemdORM != null && (orm_cmd = (AbstractClassMetaData)this.ormClassMetaDataByClass.get(c.getName())) != null) {
            ((FileMetaData)cmd.getPackageMetaData().getParent()).mergeORMData((FileMetaData)orm_cmd.getPackageMetaData().getParent());
            cmd.mergeORMData(orm_cmd);
            this.ormClassMetaDataByClass.remove(c.getName());
        }
    }

    protected FileMetaData loadMetaDataForClass(Class pc_class, ClassLoaderResolver clr, String metadata_file_modifier, String metadata_file_extension, boolean populate) {
        List validLocations = this.getValidMetaDataLocationsForClass(metadata_file_extension, metadata_file_modifier, pc_class.getName());
        Iterator locationsIter = validLocations.iterator();
        while (locationsIter.hasNext()) {
            String location = (String)locationsIter.next();
            URL url = clr.getResource(location, pc_class.getClassLoader());
            if (url != null) {
                FileMetaData filemd = (FileMetaData)this.fileMetaDataByURLString.get(url.toString());
                if (filemd == null) {
                    filemd = this.parseFile(url);
                    this.registerFile(url.toString(), filemd);
                    if (populate) {
                        this.populateFileMetaData(filemd, clr, pc_class.getClassLoader());
                    }
                }
                if ((filemd.getType() != 1 || this.classMetaDataByClass.get(pc_class.getName()) == null) && (filemd.getType() != 2 || this.ormClassMetaDataByClass.get(pc_class.getName()) == null)) continue;
                if (JPOXLogger.METADATA.isDebugEnabled()) {
                    JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.FoundClass", metadata_file_extension, pc_class.getName(), url));
                }
                return filemd;
            }
            if (!JPOXLogger.METADATA.isDebugEnabled()) continue;
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.NotFoundForClassAtLocationError", metadata_file_extension, pc_class.getName(), location));
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.NotFoundForClassError", metadata_file_extension, pc_class.getName()));
        }
        return null;
    }

    List getValidMetaDataLocationsForPackage(String fileExtension, String fileModifier, String packageName) {
        return this.getValidMetaDataLocationsForItem(fileExtension, fileModifier, packageName, false);
    }

    List getValidMetaDataLocationsForClass(String fileExtension, String fileModifier, String className) {
        return this.getValidMetaDataLocationsForItem(fileExtension, fileModifier, className, true);
    }

    List getValidMetaDataLocationsForItem(String fileExtension, String fileModifier, String itemName, boolean isClass) {
        ArrayList<String> locations = new ArrayList<String>();
        String suffix = null;
        if (fileExtension == null) {
            fileExtension = "jdo";
        }
        suffix = fileModifier != null ? "-" + fileModifier + '.' + fileExtension : '.' + fileExtension;
        if (this.locationDefinition == 1 || this.locationDefinition == 3) {
            locations.add(METADATA_LOCATION_METAINF + suffix);
            locations.add(METADATA_LOCATION_WEBINF + suffix);
            locations.add("/package" + suffix);
        }
        if (itemName != null && itemName.length() > 0) {
            int separatorPosition = itemName.indexOf(46);
            if (separatorPosition < 0) {
                if (this.locationDefinition == 1 || this.locationDefinition == 3) {
                    locations.add('/' + itemName + '/' + METADATA_PACKAGE + suffix);
                }
                if (this.locationDefinition == 1 || this.locationDefinition == 2) {
                    locations.add('/' + itemName + suffix);
                }
            } else {
                while (separatorPosition >= 0) {
                    String name = itemName.substring(0, separatorPosition);
                    if (this.locationDefinition == 1 || this.locationDefinition == 3) {
                        locations.add('/' + name.replace('.', '/') + '/' + METADATA_PACKAGE + suffix);
                    }
                    if (this.locationDefinition == 1 || this.locationDefinition == 2) {
                        locations.add('/' + name.replace('.', '/') + suffix);
                    }
                    if ((separatorPosition = itemName.indexOf(46, separatorPosition + 1)) >= 0) continue;
                    if (!(isClass || this.locationDefinition != 1 && this.locationDefinition != 3)) {
                        locations.add('/' + itemName.replace('.', '/') + '/' + METADATA_PACKAGE + suffix);
                    }
                    if (this.locationDefinition != 1 && this.locationDefinition != 2) continue;
                    locations.add('/' + itemName.replace('.', '/') + suffix);
                }
            }
        }
        return locations;
    }

    public InterfaceMetaData getMetaDataForInterface(Class c, ClassLoaderResolver clr) {
        if (c == null || !c.isInterface()) {
            return null;
        }
        InterfaceMetaData imd = (InterfaceMetaData)this.getMetaDataForClassInternal(c, clr);
        if (imd != null) {
            if (!imd.isPopulated() && !imd.isInitialised()) {
                imd.populate(clr, c.getClassLoader());
            }
            if (!imd.isInitialised()) {
                imd.initialise();
            }
            if (this.utilisedFileMetaData.size() > 0) {
                Iterator iter = this.utilisedFileMetaData.iterator();
                while (iter.hasNext()) {
                    FileMetaData filemd = (FileMetaData)iter.next();
                    this.initialiseFileMetaData(filemd, clr, c.getClassLoader());
                }
            }
        }
        this.utilisedFileMetaData.clear();
        return imd;
    }

    public boolean isPersistentInterface(String name) {
        return this.classMetaDataByInterface.get(name) != null;
    }

    public boolean isPersistentInterfaceImplementation(String interfaceName, String implName) {
        ClassMetaData cmd = (ClassMetaData)this.classMetaDataByInterface.get(interfaceName);
        return cmd != null && cmd.getFullClassName().equals(implName);
    }

    public String getImplementationNameForPersistentInterface(String interfaceName) {
        ClassMetaData cmd = (ClassMetaData)this.classMetaDataByInterface.get(interfaceName);
        return cmd != null ? cmd.getFullClassName() : null;
    }

    public ClassMetaData getClassMetaDataForImplementationOfPersistentInterface(String interfaceName) {
        return (ClassMetaData)this.classMetaDataByInterface.get(interfaceName);
    }

    public void registerPersistentInterface(InterfaceMetaData imd, Class implClass, ClassLoaderResolver clr) {
        ClassMetaData cmd = new ClassMetaData(imd, implClass.getName(), true);
        cmd.addImplements(new ImplementsMetaData(cmd, imd.getFullClassName()));
        this.classMetaDataByClass.put(cmd.getFullClassName(), cmd);
        this.classMetaDataByInterface.put(imd.getFullClassName(), cmd);
        this.initialiseClassMetaData(cmd, implClass, clr);
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.DeregisterClassWithoutMetaData", implClass.getName()));
        }
        this.classesWithoutMetaData.remove(implClass.getName());
    }
}

