/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.jdo.JDOFatalInternalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.FetchGroupMetaData;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IdentityMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.JoinMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.PropertyMetaData;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.util.AIDUtils;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;

public class InterfaceMetaData
extends AbstractClassMetaData {
    private boolean populating = false;

    public InterfaceMetaData(PackageMetaData parent, String name, String identityType, String objectidClass, String requiresExtent, String detachable, String embeddedOnly, String catalog, String schema, String table, String entityName) {
        super(parent, name, identityType, objectidClass, requiresExtent, detachable, embeddedOnly, ClassPersistenceModifier.PERSISTENCE_CAPABLE.toString(), null, catalog, schema, table, entityName);
    }

    public void initialise() {
        int i;
        if (this.populating) {
            return;
        }
        this.checkPopulated();
        if (this.isInitialised()) {
            return;
        }
        if (this.pcSuperclassMetaData != null && !this.pcSuperclassMetaData.isInitialised()) {
            this.pcSuperclassMetaData.initialise();
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.InitialisingMetaData", this.fullName));
        }
        Iterator fields_iter = this.properties.iterator();
        int no_of_managed_fields = 0;
        int no_of_overridden_fields = 0;
        while (fields_iter.hasNext()) {
            AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)fields_iter.next();
            fmd.initialise();
            if (!fmd.isJdoField()) continue;
            if (fmd.fieldBelongsToClass()) {
                ++no_of_managed_fields;
                continue;
            }
            ++no_of_overridden_fields;
        }
        this.managedFields = new AbstractPropertyMetaData[no_of_managed_fields];
        this.overriddenFields = new AbstractPropertyMetaData[no_of_overridden_fields];
        fields_iter = this.properties.iterator();
        int field_id = 0;
        int overridden_field_id = 0;
        this.fieldNumbersByName = new HashMap();
        while (fields_iter.hasNext()) {
            AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)fields_iter.next();
            if (!fmd.isJdoField()) continue;
            if (fmd.fieldBelongsToClass()) {
                fmd.setFieldId(field_id);
                this.managedFields[field_id] = fmd;
                this.fieldNumbersByName.put(fmd.getName(), new Integer(field_id));
                ++field_id;
                continue;
            }
            this.overriddenFields[overridden_field_id++] = fmd;
        }
        if (this.pcSuperclassMetaData != null) {
            if (!this.pcSuperclassMetaData.isInitialised()) {
                this.pcSuperclassMetaData.initialise();
            }
            this.noOfInheritedManagedFields = this.pcSuperclassMetaData.getNoOfInheritedManagedFields() + this.pcSuperclassMetaData.getNoOfManagedFields();
        }
        int total_field_count = this.noOfInheritedManagedFields + this.managedFields.length;
        this.allFieldNumbers = new int[total_field_count];
        this.defaultFetchGroupFieldFlags = new boolean[total_field_count];
        this.secondClassMutableFieldFlags = new boolean[total_field_count];
        this.nonPrimaryKeyFieldFlags = new boolean[total_field_count];
        int pk_field_count = 0;
        int dfg_field_count = 0;
        int scm_field_count = 0;
        int pc_field_count = 0;
        for (i = 0; i < total_field_count; ++i) {
            this.allFieldNumbers[i] = i;
            AbstractPropertyMetaData fmd = this.getManagedFieldAbsoluteInternal(i);
            if (fmd.isPrimaryKey()) {
                ++pk_field_count;
            } else {
                this.nonPrimaryKeyFieldFlags[i] = true;
            }
            if (fmd.isDefaultFetchGroup()) {
                this.defaultFetchGroupFieldFlags[i] = true;
                ++dfg_field_count;
            }
            if (this.getMetaDataManager().getPMFContext().getTypeManager().isSecondClassMutableType(fmd.getTypeName())) {
                this.secondClassMutableFieldFlags[i] = true;
                ++scm_field_count;
            }
            if (!fmd.isFieldTypePersistenceCapable()) continue;
            ++pc_field_count;
        }
        if (pk_field_count > 0 && this.identityType != IdentityType.APPLICATION) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PrimaryKeyFieldsFoundButNotUsingApplicationIdentity", (Object)this.fullName, (Object)new Integer(pk_field_count), this.identityType);
        }
        if (pk_field_count > 0) {
            this.primaryKeyFieldNumbers = new int[pk_field_count];
            int pk_num = 0;
            for (i = 0; i < total_field_count; ++i) {
                AbstractPropertyMetaData fmd = this.getManagedFieldAbsoluteInternal(i);
                if (!fmd.isPrimaryKey()) continue;
                this.primaryKeyFieldNumbers[pk_num++] = i;
            }
        } else if (pk_field_count == 0 && this.identityType == IdentityType.APPLICATION) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PrimaryKeyNotSpecifiedError", (Object)this.fullName, this.objectidClass);
        }
        this.nonPrimaryKeyFieldNumbers = new int[total_field_count - pk_field_count];
        this.persistenceCapableFieldNumbers = new int[pc_field_count];
        int npkf = 0;
        int npc = 0;
        for (i = 0; i < total_field_count; ++i) {
            AbstractPropertyMetaData fmd = this.getManagedFieldAbsoluteInternal(i);
            if (!fmd.isPrimaryKey()) {
                this.nonPrimaryKeyFieldNumbers[npkf++] = i;
            }
            if (!fmd.isFieldTypePersistenceCapable()) continue;
            this.persistenceCapableFieldNumbers[npc++] = i;
        }
        this.defaultFetchGroupFieldNumbers = new int[dfg_field_count];
        this.secondClassMutableFieldNumbers = new int[scm_field_count];
        int dfg_num = 0;
        int scm_num = 0;
        for (i = 0; i < total_field_count; ++i) {
            if (this.defaultFetchGroupFieldFlags[i]) {
                this.defaultFetchGroupFieldNumbers[dfg_num++] = i;
            }
            if (!this.secondClassMutableFieldFlags[i]) continue;
            this.secondClassMutableFieldNumbers[scm_num++] = i;
        }
        this.joinMetaData = new JoinMetaData[this.joins.size()];
        for (i = 0; i < this.joinMetaData.length; ++i) {
            this.joinMetaData[i] = (JoinMetaData)this.joins.get(i);
            this.joinMetaData[i].initialise();
        }
        this.indexMetaData = new IndexMetaData[this.indexes.size()];
        for (i = 0; i < this.indexMetaData.length; ++i) {
            this.indexMetaData[i] = (IndexMetaData)this.indexes.get(i);
            this.indexMetaData[i].initialise();
        }
        this.foreignKeyMetaData = new ForeignKeyMetaData[this.foreignKeys.size()];
        for (i = 0; i < this.foreignKeyMetaData.length; ++i) {
            this.foreignKeyMetaData[i] = (ForeignKeyMetaData)this.foreignKeys.get(i);
            this.foreignKeyMetaData[i].initialise();
        }
        this.uniqueMetaData = new UniqueMetaData[this.uniqueConstraints.size()];
        for (i = 0; i < this.uniqueMetaData.length; ++i) {
            this.uniqueMetaData[i] = (UniqueMetaData)this.uniqueConstraints.get(i);
            this.uniqueMetaData[i].initialise();
        }
        this.fetchGroupMetaData = new FetchGroupMetaData[this.fetchGroups.size()];
        this.fetchGroupMetaDataByName = new HashMap();
        for (i = 0; i < this.fetchGroupMetaData.length; ++i) {
            this.fetchGroupMetaData[i] = (FetchGroupMetaData)this.fetchGroups.get(i);
            this.fetchGroupMetaData[i].initialise();
            this.fetchGroupMetaDataByName.put(this.fetchGroupMetaData[i].getName(), this.fetchGroupMetaData[i]);
        }
        if (this.identityType == IdentityType.DATASTORE && this.identityMetaData == null) {
            if (this.pcSuperclassMetaData != null) {
                IdentityMetaData superImd = this.pcSuperclassMetaData.getIdentityMetaData();
                this.identityMetaData = new IdentityMetaData(this, superImd.getColumn(), superImd.getStrategyValue().toString(), superImd.getSequence());
            } else {
                this.identityMetaData = new IdentityMetaData(this, null, null, null);
            }
        }
        if (this.versionMetaData != null) {
            this.versionMetaData.initialise();
        }
        if (this.identityMetaData != null) {
            this.identityMetaData.initialise();
        }
        if (this.inheritanceMetaData != null) {
            this.inheritanceMetaData.initialise();
        }
        if (this.identityType == IdentityType.APPLICATION) {
            this.usesSingleFieldIdentityClass = AIDUtils.isSingleFieldIdentityClass(this.getObjectidClass());
        }
        this.joins.clear();
        this.joins = null;
        this.fetchGroups.clear();
        this.fetchGroups = null;
        this.foreignKeys.clear();
        this.foreignKeys = null;
        this.indexes.clear();
        this.indexes = null;
        this.uniqueConstraints.clear();
        this.uniqueConstraints = null;
        this.setInitialised();
    }

    public synchronized void populate(ClassLoaderResolver clr, ClassLoader primary) {
        if (this.isInitialised() || this.isPopulated()) {
            JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Class.AlreadyPopulatedError", this.name));
            throw new JDOFatalInternalException(LOCALISER.msg("MetaData.Class.AlreadyPopulatedError", this.fullName));
        }
        if (this.populating) {
            return;
        }
        try {
            if (JPOXLogger.METADATA.isDebugEnabled()) {
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.PopulatingMetaData", this.fullName));
            }
            this.populating = true;
            Class cls = this.loadClass(clr, primary);
            this.getMetaDataManager().addORMDataToClass(cls, clr);
            if (ClassUtils.isInnerClass(this.fullName) && !Modifier.isStatic(cls.getModifiers()) && this.persistenceModifier == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.NonStaticInnerClassNotPersistable", this.fullName);
            }
            this.determineSuperClassName(clr, cls);
            this.inheritDetachableSettings();
            this.inheritIdentity();
            this.determineIdentity();
            this.validateUserInputForIdentity();
            this.addPropertiesNotInMetaData(cls);
            if (this.objectidClass == null) {
                this.populatePropertyMetaData(clr, cls, true);
                this.determineObjectIdClass(clr);
                this.populatePropertyMetaData(clr, cls, false);
            } else {
                this.populatePropertyMetaData(clr, cls, true);
                this.populatePropertyMetaData(clr, cls, false);
                this.determineObjectIdClass(clr);
            }
            this.validateUserInputForInheritanceMetaData();
            this.determineInheritanceMetaData();
            this.validateDeprecatedMetaData();
            this.setPopulated();
        }
        catch (RuntimeException e) {
            JPOXLogger.METADATA.debug(e);
            throw e;
        }
        finally {
            this.populating = false;
        }
    }

    protected AbstractPropertyMetaData newDefaultedProperty(String name) {
        return new PropertyMetaData((MetaData)this, name);
    }

    protected void populatePropertyMetaData(ClassLoaderResolver clr, Class cls, boolean pkFields) {
        Collections.sort(this.properties);
        Iterator fields_iter = this.properties.iterator();
        while (fields_iter.hasNext()) {
            AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)fields_iter.next();
            if (pkFields != fmd.isPrimaryKey()) continue;
            Class fieldCls = cls;
            if (!fmd.fieldBelongsToClass()) {
                try {
                    fieldCls = clr.classForName(fmd.getClassName());
                }
                catch (ClassNotResolvedException cnre) {
                    String fieldClassName = this.getPackageName() + "." + fmd.getClassName();
                    try {
                        fieldCls = clr.classForName(fieldClassName);
                        fmd.setClassName(fieldClassName);
                    }
                    catch (ClassNotResolvedException cnre2) {
                        JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Class.ClassNotFoundError", fieldClassName));
                        throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.ClassNotFoundError", fieldClassName);
                    }
                }
            }
            Method cls_field = null;
            try {
                try {
                    cls_field = fieldCls.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fmd.getName(), true), null);
                }
                catch (Exception e) {
                    cls_field = fieldCls.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fmd.getName(), false), null);
                }
            }
            catch (Exception e) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.DeclaredFieldNotFoundError", (Object)this.fullName, fmd.getFullFieldName());
            }
            fmd.populate(clr, cls_field.getReturnType(), cls_field.getModifiers());
        }
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<interface name=\"" + this.name + "\"\n");
        if (this.identityType != null) {
            sb.append(prefix).append("       identity-type=\"" + this.identityType + "\"\n");
        }
        if (this.objectidClass != null) {
            sb.append(prefix).append("       objectid-class=\"" + this.objectidClass + "\"\n");
        }
        if (!this.requiresExtent) {
            sb.append(prefix).append("       requires-extent=\"" + this.requiresExtent + "\"");
        }
        if (this.detachable) {
            sb.append(prefix).append("       detachable=\"" + this.detachable + "\"\n");
        }
        if (this.table != null) {
            sb.append(prefix).append("       table=\"" + this.table + "\"\n");
        }
        sb.append(">\n");
        if (this.identityMetaData != null) {
            sb.append(this.identityMetaData.toString(prefix + indent, indent));
        }
        if (this.primaryKeyMetaData != null) {
            sb.append(this.primaryKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.inheritanceMetaData != null) {
            sb.append(this.inheritanceMetaData.toString(prefix + indent, indent));
        }
        if (this.versionMetaData != null) {
            sb.append(this.versionMetaData.toString(prefix + indent, indent));
        }
        if (this.joins != null) {
            for (i = 0; i < this.joins.size(); ++i) {
                JoinMetaData jmd = (JoinMetaData)this.joins.get(i);
                sb.append(jmd.toString(prefix + indent, indent));
            }
        }
        if (this.foreignKeys != null) {
            for (i = 0; i < this.foreignKeys.size(); ++i) {
                ForeignKeyMetaData fkmd = (ForeignKeyMetaData)this.foreignKeys.get(i);
                sb.append(fkmd.toString(prefix + indent, indent));
            }
        }
        if (this.indexes != null) {
            for (i = 0; i < this.indexes.size(); ++i) {
                IndexMetaData imd = (IndexMetaData)this.indexes.get(i);
                sb.append(imd.toString(prefix + indent, indent));
            }
        }
        if (this.uniqueConstraints != null) {
            for (i = 0; i < this.uniqueConstraints.size(); ++i) {
                UniqueMetaData unimd = (UniqueMetaData)this.uniqueConstraints.get(i);
                sb.append(unimd.toString(prefix + indent, indent));
            }
        }
        if (this.properties != null) {
            for (i = 0; i < this.properties.size(); ++i) {
                PropertyMetaData pmd = (PropertyMetaData)this.properties.get(i);
                sb.append(pmd.toString(prefix + indent, indent));
            }
        }
        if (this.queries != null) {
            Iterator iter = this.queries.iterator();
            while (iter.hasNext()) {
                QueryMetaData q = (QueryMetaData)iter.next();
                sb.append(q.toString(prefix + indent, indent));
            }
        }
        if (this.fetchGroups != null) {
            for (int i2 = 0; i2 < this.fetchGroups.size(); ++i2) {
                FetchGroupMetaData fgmd = (FetchGroupMetaData)this.fetchGroups.get(i2);
                sb.append(fgmd.toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</interface>\n");
        return sb.toString();
    }
}

