/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.io.Serializable;

public class InheritanceStrategy
implements Serializable {
    public static final InheritanceStrategy SUBCLASS_TABLE = new InheritanceStrategy(1);
    public static final InheritanceStrategy NEW_TABLE = new InheritanceStrategy(2);
    public static final InheritanceStrategy SUPERCLASS_TABLE = new InheritanceStrategy(3);
    private final int typeId;

    private InheritanceStrategy(int i) {
        this.typeId = i;
    }

    public boolean equals(Object o) {
        if (o instanceof InheritanceStrategy) {
            return ((InheritanceStrategy)o).typeId == this.typeId;
        }
        return false;
    }

    public String toString() {
        switch (this.typeId) {
            case 1: {
                return "subclass-table";
            }
            case 2: {
                return "new-table";
            }
            case 3: {
                return "superclass-table";
            }
        }
        return "";
    }

    public int getType() {
        return this.typeId;
    }

    public static InheritanceStrategy getInheritanceStrategy(String value) {
        if (value == null) {
            return null;
        }
        if (SUBCLASS_TABLE.toString().equals(value)) {
            return SUBCLASS_TABLE;
        }
        if (NEW_TABLE.toString().equals(value)) {
            return NEW_TABLE;
        }
        if (SUPERCLASS_TABLE.toString().equals(value)) {
            return SUPERCLASS_TABLE;
        }
        return NEW_TABLE;
    }
}

