/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.io.Serializable;

public class IdentityStrategy
implements Serializable {
    public static final IdentityStrategy NATIVE = new IdentityStrategy(1);
    public static final IdentityStrategy SEQUENCE = new IdentityStrategy(2);
    public static final IdentityStrategy IDENTITY = new IdentityStrategy(3);
    public static final IdentityStrategy INCREMENT = new IdentityStrategy(4);
    public static final IdentityStrategy UUIDSTRING = new IdentityStrategy(5);
    public static final IdentityStrategy UUIDHEX = new IdentityStrategy(6);
    public static final IdentityStrategy MAX = new IdentityStrategy(7);
    public static final IdentityStrategy AUID = new IdentityStrategy(8);
    private final int typeId;

    private IdentityStrategy(int i) {
        this.typeId = i;
    }

    public boolean equals(Object o) {
        if (o instanceof IdentityStrategy) {
            return ((IdentityStrategy)o).typeId == this.typeId;
        }
        return false;
    }

    public String toString() {
        switch (this.typeId) {
            case 1: {
                return "native";
            }
            case 2: {
                return "sequence";
            }
            case 3: {
                return "identity";
            }
            case 4: {
                return "increment";
            }
            case 5: {
                return "uuid-string";
            }
            case 6: {
                return "uuid-hex";
            }
            case 7: {
                return "max";
            }
            case 8: {
                return "auid";
            }
        }
        return "";
    }

    public int getType() {
        return this.typeId;
    }

    public static IdentityStrategy getIdentityStrategy(String value) {
        if (value == null) {
            return NATIVE;
        }
        if (NATIVE.toString().equals(value)) {
            return NATIVE;
        }
        if (SEQUENCE.toString().equals(value)) {
            return SEQUENCE;
        }
        if (IDENTITY.toString().equals(value)) {
            return IDENTITY;
        }
        if (INCREMENT.toString().equals(value)) {
            return INCREMENT;
        }
        if ("TABLE".equalsIgnoreCase(value)) {
            return INCREMENT;
        }
        if (UUIDSTRING.toString().equals(value)) {
            return UUIDSTRING;
        }
        if (UUIDHEX.toString().equals(value)) {
            return UUIDHEX;
        }
        if (MAX.toString().equals(value)) {
            return MAX;
        }
        if (AUID.toString().equals(value)) {
            return AUID;
        }
        return NATIVE;
    }
}

