/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jpox.metadata.ExtensionMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.MetaDataUtils;

public class ExtendableMetaData
extends MetaData {
    public static final String JPOX_VENDOR_NAME = "jpox";
    protected List extensions = new ArrayList();

    public ExtendableMetaData(MetaData parent) {
        super(parent);
    }

    public int getNoOfExtensions() {
        return this.extensions.size();
    }

    public ExtensionMetaData[] getExtensions() {
        if (this.extensions.size() == 0) {
            return null;
        }
        ExtensionMetaData[] result = new ExtensionMetaData[this.extensions.size()];
        Iterator iter = this.extensions.iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i++] = (ExtensionMetaData)iter.next();
        }
        return result;
    }

    public ExtensionMetaData getExtension(int i) {
        return (ExtensionMetaData)this.extensions.get(i);
    }

    public boolean hasExtension(String key) {
        if (key == null) {
            return false;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getKey().equals(key) || !ex.getVendorName().equalsIgnoreCase(JPOX_VENDOR_NAME)) continue;
            return true;
        }
        return false;
    }

    public String getValueForExtension(String key) {
        if (key == null) {
            return null;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getKey().equals(key) || !ex.getVendorName().equalsIgnoreCase(JPOX_VENDOR_NAME)) continue;
            return ex.getValue();
        }
        return null;
    }

    public List getValuesForExtensionStartingWith(String key) {
        ArrayList<String> values = new ArrayList<String>();
        if (key == null) {
            return values;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getKey().startsWith(key) || !ex.getVendorName().equalsIgnoreCase(JPOX_VENDOR_NAME)) continue;
            values.add(ex.getValue());
        }
        return values;
    }

    public String[] getValuesForExtension(String key) {
        if (key == null) {
            return null;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getKey().equals(key) || !ex.getVendorName().equalsIgnoreCase(JPOX_VENDOR_NAME)) continue;
            return MetaDataUtils.getInstance().getValuesForCommaSeparatedAttribute(ex.getValue());
        }
        return null;
    }

    public void addExtension(String vendor, String key, String value) {
        if (vendor == null || vendor.equalsIgnoreCase(JPOX_VENDOR_NAME) && (key == null || value == null)) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Extendable.Invalid", (Object)vendor, (Object)key, value);
        }
        if (vendor.equals(JPOX_VENDOR_NAME) && this.hasExtension(key)) {
            this.removeExtension(key);
        }
        this.extensions.add(new ExtensionMetaData(vendor, key, value));
    }

    public void addExtension(String key, String value) {
        this.addExtension(JPOX_VENDOR_NAME, key, value);
    }

    public void removeExtension(String key) {
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            if (!ex.getVendorName().equalsIgnoreCase(JPOX_VENDOR_NAME) || !ex.getKey().equals(key)) continue;
            iter.remove();
            break;
        }
    }

    public String toString() {
        if (this.extensions.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            sb.append(ex.toString()).append("\n");
        }
        return sb.toString();
    }

    public String toString(String prefix, String indent) {
        if (this.extensions.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = (ExtensionMetaData)iter.next();
            sb.append(prefix).append(ex.toString()).append("\n");
        }
        return sb.toString();
    }
}

