/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.List;
import java.util.Set;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ContainerMetaData;
import org.jpox.metadata.ElementMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class CollectionMetaData
extends ContainerMetaData {
    protected String elementType = "java.lang.Object";
    protected AbstractClassMetaData elementClassMetaData;
    protected Boolean embeddedElement;
    protected Boolean serializedElement;
    protected Boolean dependentElement;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$java$lang$Object;

    public CollectionMetaData(AbstractPropertyMetaData parent, CollectionMetaData colmd) {
        super(parent);
        this.embeddedElement = colmd.embeddedElement;
        this.serializedElement = colmd.serializedElement;
        this.dependentElement = colmd.dependentElement;
        this.elementType = colmd.elementType;
        this.elementClassMetaData = colmd.elementClassMetaData;
    }

    public CollectionMetaData(AbstractPropertyMetaData parent, String elementType, String embeddedElement, String dependentElement, String serializedElement) {
        super(parent);
        if (!StringUtils.isWhitespace(elementType)) {
            this.elementType = ClassUtils.createFullClassName(parent.getAbstractClassMetaData().getPackageName(), elementType);
        }
        if (embeddedElement != null) {
            if (embeddedElement.equalsIgnoreCase("true")) {
                this.embeddedElement = Boolean.TRUE;
            } else if (embeddedElement.equalsIgnoreCase("false")) {
                this.embeddedElement = Boolean.FALSE;
            }
        }
        if (dependentElement != null) {
            if (dependentElement.equalsIgnoreCase("true")) {
                this.dependentElement = Boolean.TRUE;
            } else if (dependentElement.equalsIgnoreCase("false")) {
                this.dependentElement = Boolean.FALSE;
            }
        }
        if (serializedElement != null) {
            if (serializedElement.equalsIgnoreCase("true")) {
                this.serializedElement = Boolean.TRUE;
            } else if (serializedElement.equalsIgnoreCase("false")) {
                this.serializedElement = Boolean.FALSE;
            }
        }
    }

    public void populate(ClassLoaderResolver clr) {
        ElementMetaData elemmd;
        Class field_type;
        if (!(class$java$util$Collection == null ? (class$java$util$Collection = CollectionMetaData.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(field_type = this.getAbstractPropertyMetaData().getType())) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Collection.IsNotCollectionError", (Object)this.getFieldName(), this.getAbstractPropertyMetaData().getClassName(false));
        }
        if (this.elementType == null) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Collection.ElementTypeNotSpecifiedError", (Object)this.getFieldName(), this.getAbstractPropertyMetaData().getClassName(false));
        }
        Class elementTypeClass = null;
        try {
            elementTypeClass = clr.classForName(this.elementType);
        }
        catch (ClassNotResolvedException cnre) {
            try {
                elementTypeClass = clr.classForName(ClassUtils.getJavaLangClassForType(this.elementType));
            }
            catch (ClassNotResolvedException cnre2) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Collection.ElementTypeNotFoundError", (Object)this.getFieldName(), (Object)this.getAbstractPropertyMetaData().getClassName(false), this.elementType);
            }
        }
        if (!elementTypeClass.getName().equals(this.elementType)) {
            JPOXLogger.METADATA.info(LOCALISER.msg("MetaData.Collection.ElementTypeResolved", this.getFieldName(), this.getAbstractPropertyMetaData().getClassName(false), this.elementType, elementTypeClass.getName()));
            this.elementType = elementTypeClass.getName();
        }
        if (this.embeddedElement == null) {
            this.embeddedElement = this.getMetaDataManager().getPMFContext().getTypeManager().isDefaultEmbeddedType(elementTypeClass) ? Boolean.TRUE : ((class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = CollectionMetaData.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(elementTypeClass) || (class$java$lang$Object == null ? (class$java$lang$Object = CollectionMetaData.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(elementTypeClass) || elementTypeClass.isInterface() ? Boolean.FALSE : Boolean.TRUE);
        }
        if (this.embeddedElement == Boolean.FALSE && !(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = CollectionMetaData.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(elementTypeClass) && !elementTypeClass.isInterface() && elementTypeClass != (class$java$lang$Object == null ? (class$java$lang$Object = CollectionMetaData.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.embeddedElement = Boolean.TRUE;
        }
        if ((elemmd = ((AbstractPropertyMetaData)this.parent).getElementMetaData()) != null && elemmd.getEmbeddedMetaData() != null) {
            this.embeddedElement = Boolean.TRUE;
        }
        if (this.dependentElement == Boolean.TRUE && !(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = CollectionMetaData.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(elementTypeClass) && !elementTypeClass.isInterface() && elementTypeClass != (class$java$lang$Object == null ? (class$java$lang$Object = CollectionMetaData.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.dependentElement = Boolean.FALSE;
        }
        this.elementClassMetaData = this.getAbstractPropertyMetaData().getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(elementTypeClass, clr);
        this.setPopulated();
    }

    public String getElementType() {
        return this.elementType;
    }

    public AbstractClassMetaData getElementClassMetaData() {
        if (this.elementClassMetaData != null && !this.elementClassMetaData.isInitialised()) {
            this.elementClassMetaData.initialise();
        }
        return this.elementClassMetaData;
    }

    public boolean isEmbeddedElement() {
        if (this.embeddedElement == null) {
            return false;
        }
        return this.embeddedElement;
    }

    public boolean isDependentElement() {
        if (this.dependentElement == null) {
            return false;
        }
        return this.dependentElement;
    }

    public boolean isSerializedElement() {
        if (this.serializedElement == null) {
            return false;
        }
        return this.serializedElement;
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, String dba_vendor_id, ClassLoaderResolver clr) {
        AbstractClassMetaData element_cmd = this.getMetaDataManager().getMetaDataForClass(this.elementType, clr);
        if (element_cmd != null) {
            element_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
        }
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<collection element-type=\"").append(this.elementType).append("\"");
        if (this.embeddedElement != null) {
            sb.append(" embedded-element=\"").append(this.embeddedElement).append("\"");
        }
        if (this.dependentElement != null) {
            sb.append(" dependent-element=\"").append(this.dependentElement).append("\"");
        }
        if (this.serializedElement != null) {
            sb.append(" serialized-element=\"").append(this.serializedElement).append("\"");
        }
        sb.append(">\n");
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</collection>\n");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

