/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOFatalInternalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.FetchGroupMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IdentityMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.ImplementsMetaData;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.JoinMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.util.AIDUtils;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;

public class ClassMetaData
extends AbstractClassMetaData {
    protected List implementations = new ArrayList();
    protected ImplementsMetaData[] implementsMetaData;
    protected boolean isAbstractPersistenceCapable;
    private boolean populating = false;

    public ClassMetaData(PackageMetaData parent, String name, String identityType, String objectidClass, String requiresExtent, String detachable, String embeddedOnly, String modifier, String persistenceCapableSuperclass, String catalog, String schema, String table, String entityName) {
        super(parent, name, identityType, objectidClass, requiresExtent, detachable, embeddedOnly, modifier, persistenceCapableSuperclass, catalog, schema, table, entityName);
    }

    public ClassMetaData(InterfaceMetaData imd, String implClassName, boolean copyFields) {
        super(imd, implClassName, copyFields);
    }

    public synchronized void populate(ClassLoaderResolver clr, ClassLoader primary) {
        if (this.isInitialised() || this.isPopulated()) {
            JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Class.AlreadyPopulatedError", this.name));
            throw new JDOFatalInternalException(LOCALISER.msg("MetaData.Class.AlreadyPopulatedError", this.fullName));
        }
        if (this.populating) {
            return;
        }
        try {
            if (JPOXLogger.METADATA.isDebugEnabled()) {
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.PopulatingMetaData", this.fullName));
            }
            this.populating = true;
            Class cls = this.loadClass(clr, primary);
            this.isAbstractPersistenceCapable = Modifier.isAbstract(cls.getModifiers());
            this.getMetaDataManager().addORMDataToClass(cls, clr);
            if (ClassUtils.isInnerClass(this.fullName) && !Modifier.isStatic(cls.getModifiers()) && this.persistenceModifier == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.NonStaticInnerClassNotPersistable", this.fullName);
            }
            this.determineSuperClassName(clr, cls);
            this.inheritDetachableSettings();
            this.inheritIdentity();
            this.determineIdentity();
            this.validateUserInputForIdentity();
            this.addPropertiesNotInMetaData(cls);
            if (this.objectidClass == null) {
                this.populatePropertyMetaData(clr, cls, true);
                this.determineObjectIdClass(clr);
                this.populatePropertyMetaData(clr, cls, false);
            } else {
                this.populatePropertyMetaData(clr, cls, true);
                this.populatePropertyMetaData(clr, cls, false);
                this.determineObjectIdClass(clr);
            }
            this.validateUserInputForInheritanceMetaData();
            this.determineInheritanceMetaData();
            this.validateDeprecatedMetaData();
            for (int i = 0; i < this.implementations.size(); ++i) {
                ((ImplementsMetaData)this.implementations.get(i)).populate(clr);
            }
            if (this.persistentInterfaceImplNeedingTableFromSuperclass) {
                AbstractClassMetaData acmd = this.getMetaDataForSuperinterfaceManagingTable(cls, clr);
                if (acmd != null) {
                    this.table = acmd.table;
                    this.schema = acmd.schema;
                    this.catalog = acmd.catalog;
                }
                this.persistentInterfaceImplNeedingTableFromSuperclass = false;
            } else if (this.persistentInterfaceImplNeedingTableFromSubclass) {
                this.persistentInterfaceImplNeedingTableFromSubclass = false;
            }
            this.setPopulated();
        }
        catch (RuntimeException e) {
            JPOXLogger.METADATA.debug(e);
            throw e;
        }
        finally {
            this.populating = false;
        }
    }

    private AbstractClassMetaData getMetaDataForSuperinterfaceManagingTable(Class cls, ClassLoaderResolver clr) {
        Collection superinterfaces = ClassUtils.getSuperinterfaces(cls);
        Iterator iter = superinterfaces.iterator();
        while (iter.hasNext()) {
            Class superintf = (Class)iter.next();
            InterfaceMetaData acmd = this.getMetaDataManager().getMetaDataForInterface(superintf, clr);
            if (acmd == null || acmd.getInheritanceMetaData() == null) continue;
            if (acmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.NEW_TABLE) {
                return acmd;
            }
            if (acmd.getInheritanceMetaData().getStrategyValue() != InheritanceStrategy.SUPERCLASS_TABLE) continue;
            return this.getMetaDataForSuperinterfaceManagingTable(superintf, clr);
        }
        return null;
    }

    protected void addPropertiesNotInMetaData(Class cls) {
        Collections.sort(this.properties);
        try {
            Field[] cls_fields = cls.getDeclaredFields();
            for (int i = 0; i < cls_fields.length; ++i) {
                if (!cls_fields[i].getDeclaringClass().getName().equals(this.fullName) || cls_fields[i].getName().startsWith("jdo") || ClassUtils.isInnerClass(cls_fields[i].getName()) || Modifier.isStatic(cls_fields[i].getModifiers()) || Collections.binarySearch(this.properties, cls_fields[i].getName()) >= 0) continue;
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.AddingUnspecifiedField", cls_fields[i].getName(), this.name));
                AbstractPropertyMetaData fmd = this.newDefaultedProperty(cls_fields[i].getName());
                this.properties.add(fmd);
                Collections.sort(this.properties);
            }
        }
        catch (Exception e) {
            JPOXLogger.METADATA.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void populatePropertyMetaData(ClassLoaderResolver clr, Class cls, boolean pkFields) {
        Collections.sort(this.properties);
        Iterator fields_iter = this.properties.iterator();
        while (fields_iter.hasNext()) {
            AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)fields_iter.next();
            if (pkFields != fmd.isPrimaryKey()) continue;
            Class fieldCls = cls;
            if (!fmd.fieldBelongsToClass()) {
                try {
                    fieldCls = clr.classForName(fmd.getClassName());
                }
                catch (ClassNotResolvedException cnre) {
                    String fieldClassName = this.getPackageName() + "." + fmd.getClassName();
                    try {
                        fieldCls = clr.classForName(fieldClassName);
                        fmd.setClassName(fieldClassName);
                    }
                    catch (ClassNotResolvedException cnre2) {
                        JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Class.ClassNotFoundError", fieldClassName));
                        throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.ClassNotFoundError", fieldClassName);
                    }
                }
            }
            Field cls_field = null;
            try {
                cls_field = fieldCls.getDeclaredField(fmd.getName());
            }
            catch (Exception e) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.DeclaredFieldNotFoundError", (Object)this.fullName, fmd.getFullFieldName());
            }
            fmd.populate(clr, cls_field.getType(), cls_field.getModifiers());
        }
    }

    public synchronized void initialise() {
        int i;
        if (this.populating) {
            return;
        }
        this.checkPopulated();
        if (this.isInitialised()) {
            return;
        }
        if (this.pcSuperclassMetaData != null && !this.pcSuperclassMetaData.isInitialised()) {
            this.pcSuperclassMetaData.initialise();
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.InitialisingMetaData", this.fullName));
        }
        Iterator fields_iter = this.properties.iterator();
        int no_of_managed_fields = 0;
        int no_of_overridden_fields = 0;
        while (fields_iter.hasNext()) {
            AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)fields_iter.next();
            fmd.initialise();
            if (!fmd.isJdoField()) continue;
            if (fmd.fieldBelongsToClass()) {
                ++no_of_managed_fields;
                continue;
            }
            ++no_of_overridden_fields;
        }
        this.managedFields = new AbstractPropertyMetaData[no_of_managed_fields];
        this.overriddenFields = new AbstractPropertyMetaData[no_of_overridden_fields];
        fields_iter = this.properties.iterator();
        int field_id = 0;
        int overridden_field_id = 0;
        this.fieldNumbersByName = new HashMap();
        while (fields_iter.hasNext()) {
            AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)fields_iter.next();
            if (!fmd.isJdoField()) continue;
            if (fmd.fieldBelongsToClass()) {
                fmd.setFieldId(field_id);
                this.managedFields[field_id] = fmd;
                this.fieldNumbersByName.put(fmd.getName(), new Integer(field_id));
                ++field_id;
                continue;
            }
            this.overriddenFields[overridden_field_id++] = fmd;
        }
        if (this.pcSuperclassMetaData != null) {
            if (!this.pcSuperclassMetaData.isInitialised()) {
                this.pcSuperclassMetaData.initialise();
            }
            this.noOfInheritedManagedFields = this.pcSuperclassMetaData.getNoOfInheritedManagedFields() + this.pcSuperclassMetaData.getNoOfManagedFields();
        }
        int total_field_count = this.noOfInheritedManagedFields + this.managedFields.length;
        this.allFieldNumbers = new int[total_field_count];
        this.defaultFetchGroupFieldFlags = new boolean[total_field_count];
        this.secondClassMutableFieldFlags = new boolean[total_field_count];
        this.nonPrimaryKeyFieldFlags = new boolean[total_field_count];
        int pk_field_count = 0;
        int dfg_field_count = 0;
        int scm_field_count = 0;
        int pc_field_count = 0;
        for (i = 0; i < total_field_count; ++i) {
            this.allFieldNumbers[i] = i;
            AbstractPropertyMetaData fmd = this.getManagedFieldAbsoluteInternal(i);
            if (fmd.isPrimaryKey()) {
                ++pk_field_count;
            } else {
                this.nonPrimaryKeyFieldFlags[i] = true;
            }
            if (fmd.isDefaultFetchGroup()) {
                this.defaultFetchGroupFieldFlags[i] = true;
                ++dfg_field_count;
            }
            if (this.getMetaDataManager().getPMFContext().getTypeManager().isSecondClassMutableType(fmd.getTypeName())) {
                this.secondClassMutableFieldFlags[i] = true;
                ++scm_field_count;
            }
            if (!fmd.isFieldTypePersistenceCapable()) continue;
            ++pc_field_count;
        }
        if (pk_field_count > 0 && this.identityType != IdentityType.APPLICATION) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PrimaryKeyFieldsFoundButNotUsingApplicationIdentity", (Object)this.fullName, (Object)new Integer(pk_field_count), this.identityType);
        }
        if (pk_field_count > 0) {
            this.primaryKeyFieldNumbers = new int[pk_field_count];
            int pk_num = 0;
            for (i = 0; i < total_field_count; ++i) {
                AbstractPropertyMetaData fmd = this.getManagedFieldAbsoluteInternal(i);
                if (!fmd.isPrimaryKey()) continue;
                this.primaryKeyFieldNumbers[pk_num++] = i;
            }
        } else if (pk_field_count == 0 && this.identityType == IdentityType.APPLICATION) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PrimaryKeyNotSpecifiedError", (Object)this.fullName, this.objectidClass);
        }
        this.nonPrimaryKeyFieldNumbers = new int[total_field_count - pk_field_count];
        this.persistenceCapableFieldNumbers = new int[pc_field_count];
        int npkf = 0;
        int npc = 0;
        for (i = 0; i < total_field_count; ++i) {
            AbstractPropertyMetaData fmd = this.getManagedFieldAbsoluteInternal(i);
            if (!fmd.isPrimaryKey()) {
                this.nonPrimaryKeyFieldNumbers[npkf++] = i;
            }
            if (!fmd.isFieldTypePersistenceCapable()) continue;
            this.persistenceCapableFieldNumbers[npc++] = i;
        }
        this.defaultFetchGroupFieldNumbers = new int[dfg_field_count];
        this.secondClassMutableFieldNumbers = new int[scm_field_count];
        int dfg_num = 0;
        int scm_num = 0;
        for (i = 0; i < total_field_count; ++i) {
            if (this.defaultFetchGroupFieldFlags[i]) {
                this.defaultFetchGroupFieldNumbers[dfg_num++] = i;
            }
            if (!this.secondClassMutableFieldFlags[i]) continue;
            this.secondClassMutableFieldNumbers[scm_num++] = i;
        }
        this.implementsMetaData = new ImplementsMetaData[this.implementations.size()];
        for (i = 0; i < this.implementations.size(); ++i) {
            this.implementsMetaData[i] = (ImplementsMetaData)this.implementations.get(i);
            this.implementsMetaData[i].initialise();
        }
        this.joinMetaData = new JoinMetaData[this.joins.size()];
        for (i = 0; i < this.joinMetaData.length; ++i) {
            this.joinMetaData[i] = (JoinMetaData)this.joins.get(i);
            this.joinMetaData[i].initialise();
        }
        this.indexMetaData = new IndexMetaData[this.indexes.size()];
        for (i = 0; i < this.indexMetaData.length; ++i) {
            this.indexMetaData[i] = (IndexMetaData)this.indexes.get(i);
            this.indexMetaData[i].initialise();
        }
        this.foreignKeyMetaData = new ForeignKeyMetaData[this.foreignKeys.size()];
        for (i = 0; i < this.foreignKeyMetaData.length; ++i) {
            this.foreignKeyMetaData[i] = (ForeignKeyMetaData)this.foreignKeys.get(i);
            this.foreignKeyMetaData[i].initialise();
        }
        this.uniqueMetaData = new UniqueMetaData[this.uniqueConstraints.size()];
        for (i = 0; i < this.uniqueMetaData.length; ++i) {
            this.uniqueMetaData[i] = (UniqueMetaData)this.uniqueConstraints.get(i);
            this.uniqueMetaData[i].initialise();
        }
        this.fetchGroupMetaData = new FetchGroupMetaData[this.fetchGroups.size()];
        this.fetchGroupMetaDataByName = new HashMap();
        for (i = 0; i < this.fetchGroupMetaData.length; ++i) {
            this.fetchGroupMetaData[i] = (FetchGroupMetaData)this.fetchGroups.get(i);
            this.fetchGroupMetaData[i].initialise();
            this.fetchGroupMetaDataByName.put(this.fetchGroupMetaData[i].getName(), this.fetchGroupMetaData[i]);
        }
        if (this.identityType == IdentityType.DATASTORE && this.identityMetaData == null) {
            if (this.pcSuperclassMetaData != null) {
                IdentityMetaData superImd = this.pcSuperclassMetaData.getIdentityMetaData();
                this.identityMetaData = new IdentityMetaData(this, superImd.getColumn(), superImd.getStrategyValue().toString(), superImd.getSequence());
            } else {
                this.identityMetaData = new IdentityMetaData(this, null, null, null);
            }
        }
        if (this.versionMetaData != null) {
            this.versionMetaData.initialise();
        }
        if (this.identityMetaData != null) {
            this.identityMetaData.initialise();
        }
        if (this.inheritanceMetaData != null) {
            this.inheritanceMetaData.initialise();
        }
        if (this.identityType == IdentityType.APPLICATION) {
            this.usesSingleFieldIdentityClass = AIDUtils.isSingleFieldIdentityClass(this.getObjectidClass());
        }
        this.joins.clear();
        this.joins = null;
        this.fetchGroups.clear();
        this.fetchGroups = null;
        this.foreignKeys.clear();
        this.foreignKeys = null;
        this.indexes.clear();
        this.indexes = null;
        this.uniqueConstraints.clear();
        this.uniqueConstraints = null;
        this.implementations.clear();
        this.implementations = null;
        this.setInitialised();
    }

    protected AbstractPropertyMetaData newDefaultedProperty(String name) {
        return new FieldMetaData((MetaData)this, name);
    }

    public final ImplementsMetaData[] getImplementsMetaData() {
        return this.implementsMetaData;
    }

    public boolean implementsInterface(String interfaceName) {
        if (this.implementsMetaData != null) {
            for (int i = 0; i < this.implementsMetaData.length; ++i) {
                if (!this.implementsMetaData[i].getName().equals(interfaceName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAbstractPersistenceCapable() {
        return this.isAbstractPersistenceCapable;
    }

    public void addImplements(ImplementsMetaData implmd) {
        if (implmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new RuntimeException("Already initialised");
        }
        this.implementations.add(implmd);
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<class name=\"" + this.name + "\"\n");
        if (this.identityType != null) {
            sb.append(prefix).append("       identity-type=\"" + this.identityType + "\"\n");
        }
        if (this.objectidClass != null) {
            sb.append(prefix).append("       objectid-class=\"" + this.objectidClass + "\"\n");
        }
        if (!this.requiresExtent) {
            sb.append(prefix).append("       requires-extent=\"" + this.requiresExtent + "\"");
        }
        if (this.embeddedOnly) {
            sb.append(prefix).append("       embedded-only=\"" + this.embeddedOnly + "\"\n");
        }
        if (this.persistenceModifier != null) {
            sb.append(prefix).append("       persistence-modifier=\"" + this.persistenceModifier + "\"\n");
        }
        if (this.catalog != null) {
            sb.append(prefix).append("       catalog=\"" + this.catalog + "\"\n");
        }
        if (this.schema != null) {
            sb.append(prefix).append("       schema=\"" + this.schema + "\"\n");
        }
        if (this.table != null) {
            sb.append(prefix).append("       table=\"" + this.table + "\"\n");
        }
        if (this.detachable) {
            sb.append(prefix).append("       detachable=\"" + this.detachable + "\">\n");
        }
        if (this.implementsMetaData != null) {
            for (i = 0; i < this.implementsMetaData.length; ++i) {
                sb.append(this.implementsMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.identityMetaData != null) {
            sb.append(this.identityMetaData.toString(prefix + indent, indent));
        }
        if (this.primaryKeyMetaData != null) {
            sb.append(this.primaryKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.inheritanceMetaData != null) {
            sb.append(this.inheritanceMetaData.toString(prefix + indent, indent));
        }
        if (this.versionMetaData != null) {
            sb.append(this.versionMetaData.toString(prefix + indent, indent));
        }
        if (this.joinMetaData != null) {
            for (i = 0; i < this.joinMetaData.length; ++i) {
                sb.append(this.joinMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.foreignKeyMetaData != null) {
            for (i = 0; i < this.foreignKeyMetaData.length; ++i) {
                sb.append(this.foreignKeyMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.indexMetaData != null) {
            for (i = 0; i < this.indexMetaData.length; ++i) {
                sb.append(this.indexMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.uniqueMetaData != null) {
            for (i = 0; i < this.uniqueMetaData.length; ++i) {
                sb.append(this.uniqueMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.managedFields != null) {
            for (i = 0; i < this.managedFields.length; ++i) {
                sb.append(this.managedFields[i].toString(prefix + indent, indent));
            }
        }
        if (this.unmappedColumns != null) {
            for (i = 0; i < this.unmappedColumns.size(); ++i) {
                ColumnMetaData col = (ColumnMetaData)this.unmappedColumns.get(i);
                sb.append(col.toString(prefix + indent, indent));
            }
        }
        if (this.queries != null) {
            Iterator iter = this.queries.iterator();
            while (iter.hasNext()) {
                QueryMetaData q = (QueryMetaData)iter.next();
                sb.append(q.toString(prefix + indent, indent));
            }
        }
        if (this.fetchGroupMetaData != null) {
            for (int i2 = 0; i2 < this.fetchGroupMetaData.length; ++i2) {
                sb.append(this.fetchGroupMetaData[i2].toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</class>\n");
        return sb.toString();
    }
}

