/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.ArrayMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.CollectionMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;
import org.jpox.metadata.ContainerMetaData;
import org.jpox.metadata.ElementMetaData;
import org.jpox.metadata.EmbeddedMetaData;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.ExtensionMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.IndexedValue;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.JoinMetaData;
import org.jpox.metadata.KeyMetaData;
import org.jpox.metadata.MapMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.metadata.NullValue;
import org.jpox.metadata.OrderMetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.metadata.ValueMetaData;
import org.jpox.sco.SCOUtils;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public abstract class AbstractPropertyMetaData
extends ExtendableMetaData
implements Comparable,
ColumnMetaDataContainer {
    protected ColumnMetaData[] columnMetaData;
    protected ContainerMetaData container;
    protected EmbeddedMetaData embeddedMetaData;
    protected JoinMetaData joinMetaData;
    protected ElementMetaData elementMetaData;
    protected KeyMetaData keyMetaData;
    protected ValueMetaData valueMetaData;
    protected IndexMetaData indexMetaData;
    protected IndexedValue indexed = null;
    protected UniqueMetaData uniqueMetaData;
    protected final boolean uniqueConstraint;
    protected OrderMetaData orderMetaData;
    protected ForeignKeyMetaData foreignKeyMetaData;
    protected Boolean defaultFetchGroup;
    protected String column;
    protected String mappedBy;
    protected Boolean embedded;
    protected Boolean dependent;
    protected Boolean serialized;
    protected final String loadFetchGroup;
    public static final int DEFAULT_RECURSION_DEPTH = 1;
    public static final int UNDEFINED_RECURSION_DEPTH = 0;
    protected int recursionDepth = 0;
    protected final String name;
    protected NullValue nullValue = NullValue.NONE;
    protected FieldPersistenceModifier persistenceModifier = FieldPersistenceModifier.DEFAULT;
    protected Boolean primaryKey;
    protected String table;
    protected IdentityStrategy valueStrategy;
    protected String sequence;
    protected String className = null;
    protected String fieldType;
    protected Class type;
    protected int modifiers;
    protected int fieldId = -1;
    protected int relationType = -1;
    protected AbstractPropertyMetaData relatedFieldMetaData = null;
    protected List columns = new ArrayList();
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    public AbstractPropertyMetaData(MetaData parent, String name) {
        this(parent, name, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public AbstractPropertyMetaData(MetaData parent, AbstractPropertyMetaData fmd) {
        super(parent);
        this.name = fmd.name;
        this.primaryKey = fmd.primaryKey;
        this.defaultFetchGroup = fmd.defaultFetchGroup;
        this.column = fmd.column;
        this.mappedBy = fmd.mappedBy;
        this.dependent = fmd.dependent;
        this.embedded = fmd.embedded;
        this.serialized = fmd.serialized;
        this.nullValue = fmd.nullValue;
        this.persistenceModifier = fmd.persistenceModifier;
        this.table = fmd.table;
        this.indexed = fmd.indexed;
        this.valueStrategy = fmd.valueStrategy;
        this.sequence = fmd.sequence;
        this.uniqueConstraint = fmd.uniqueConstraint;
        this.loadFetchGroup = fmd.loadFetchGroup;
        this.fieldType = fmd.fieldType;
        if (fmd.joinMetaData != null) {
            this.joinMetaData = new JoinMetaData(this, fmd.joinMetaData);
        }
        if (fmd.elementMetaData != null) {
            this.elementMetaData = new ElementMetaData((MetaData)this, fmd.elementMetaData);
        }
        if (fmd.keyMetaData != null) {
            this.keyMetaData = new KeyMetaData((MetaData)this, fmd.keyMetaData);
        }
        if (fmd.valueMetaData != null) {
            this.valueMetaData = new ValueMetaData((MetaData)this, fmd.valueMetaData);
        }
        if (fmd.orderMetaData != null) {
            this.orderMetaData = new OrderMetaData(this, fmd.orderMetaData);
        }
        if (fmd.indexMetaData != null) {
            this.indexMetaData = new IndexMetaData(this, fmd.indexMetaData);
        }
        if (fmd.uniqueMetaData != null) {
            this.uniqueMetaData = new UniqueMetaData(this, fmd.uniqueMetaData);
        }
        if (fmd.foreignKeyMetaData != null) {
            this.foreignKeyMetaData = new ForeignKeyMetaData(this, fmd.foreignKeyMetaData);
        }
        if (fmd.embeddedMetaData != null) {
            this.embeddedMetaData = new EmbeddedMetaData(this, fmd.embeddedMetaData);
        }
        if (fmd.container != null) {
            if (fmd.container instanceof CollectionMetaData) {
                this.container = new CollectionMetaData(this, (CollectionMetaData)fmd.container);
            } else if (fmd.container instanceof MapMetaData) {
                this.container = new MapMetaData(this, (MapMetaData)fmd.container);
            } else if (fmd.container instanceof ArrayMetaData) {
                this.container = new ArrayMetaData(this, (ArrayMetaData)fmd.container);
            }
        }
        for (int i = 0; i < fmd.columns.size(); ++i) {
            this.addColumn(new ColumnMetaData((ExtendableMetaData)this, (ColumnMetaData)fmd.columns.get(i)));
        }
    }

    public AbstractPropertyMetaData(MetaData parent, String name, String pk, String modifier, String defaultFetchGroup, String nullValue, String embedded, String serialized, String dependent, String mappedBy, String column, String table, String deleteAction, String indexed, String unique, String recursionDepth, String loadFetchGroup, String valueStrategy, String sequence, String fieldType) {
        super(parent);
        if (name == null) {
            throw new JDOUserException(LOCALISER.msg("MetaData.Parser.ExpectedValueInAttribute", "name", this.getClassName(true), "field"));
        }
        if (name.indexOf(46) >= 0) {
            this.className = name.substring(0, name.lastIndexOf(46));
            this.name = name.substring(name.lastIndexOf(46) + 1);
        } else {
            this.name = name;
        }
        if (!StringUtils.isWhitespace(pk) && pk.equalsIgnoreCase("true")) {
            this.primaryKey = Boolean.TRUE;
            this.defaultFetchGroup = Boolean.TRUE;
        } else {
            this.primaryKey = Boolean.FALSE;
        }
        this.column = StringUtils.isWhitespace(column) ? null : column;
        String string = this.mappedBy = StringUtils.isWhitespace(mappedBy) ? null : mappedBy;
        if (dependent != null) {
            if (dependent.equalsIgnoreCase("true")) {
                this.dependent = Boolean.TRUE;
            } else if (dependent.equalsIgnoreCase("false")) {
                this.dependent = Boolean.FALSE;
            }
        }
        if (embedded != null) {
            if (embedded.equalsIgnoreCase("true")) {
                this.embedded = Boolean.TRUE;
            } else if (embedded.equalsIgnoreCase("false")) {
                this.embedded = Boolean.FALSE;
            }
        }
        if (serialized != null) {
            if (serialized.equalsIgnoreCase("true")) {
                this.serialized = Boolean.TRUE;
            } else if (serialized.equalsIgnoreCase("false")) {
                this.serialized = Boolean.FALSE;
            }
        }
        this.nullValue = NullValue.getNullValue(nullValue);
        if (!StringUtils.isWhitespace(modifier)) {
            this.persistenceModifier = FieldPersistenceModifier.getFieldPersistenceModifier(modifier);
        }
        if (this.persistenceModifier == null) {
            JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Field.PopulateWithWrongValue", name, this.getClassName(false), modifier, "persistence-modifier"));
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Field.PopulateWithWrongValue", (Object)name, (Object)this.getClassName(false), (Object)modifier, "persistence-modifier");
        }
        if (defaultFetchGroup != null) {
            if (defaultFetchGroup.equalsIgnoreCase("true")) {
                this.defaultFetchGroup = Boolean.TRUE;
            } else if (defaultFetchGroup.equalsIgnoreCase("false")) {
                this.defaultFetchGroup = Boolean.FALSE;
            }
        }
        String string2 = this.table = StringUtils.isWhitespace(table) ? null : table;
        if (deleteAction != null) {
            this.foreignKeyMetaData = new ForeignKeyMetaData(null, deleteAction, null, null, null, null);
        }
        this.indexed = IndexedValue.getIndexedValue(indexed);
        this.uniqueConstraint = unique != null && unique.equalsIgnoreCase("true");
        String string3 = this.loadFetchGroup = StringUtils.isWhitespace(loadFetchGroup) ? null : loadFetchGroup;
        if (recursionDepth != null) {
            try {
                this.recursionDepth = new Integer(recursionDepth);
            }
            catch (Exception e) {
                this.recursionDepth = 0;
            }
        }
        this.valueStrategy = valueStrategy == null ? null : IdentityStrategy.getIdentityStrategy(valueStrategy);
        this.sequence = StringUtils.isWhitespace(sequence) ? null : sequence;
        this.fieldType = StringUtils.isWhitespace(fieldType) ? null : fieldType;
    }

    public void mergeORMData(AbstractPropertyMetaData ormFmd) {
        ExtensionMetaData[] ormExtensions;
        if (ormFmd == null) {
            return;
        }
        if (this.isInitialised() || this.isPopulated()) {
            throw new JDOFatalInternalException(LOCALISER.msg("MetaData.Field.AlreadyPopulatedError", this.name, ormFmd.getAbstractClassMetaData().getFullClassName()));
        }
        if (ormFmd.className != null) {
            this.className = ormFmd.className;
        }
        if (ormFmd.container != null) {
            this.container = ormFmd.container;
            this.container.parent = this;
        }
        if (this.primaryKey == Boolean.FALSE && ormFmd.primaryKey == Boolean.TRUE) {
            this.primaryKey = ClassUtils.booleanValueOf(ormFmd.isPrimaryKey());
        }
        if (ormFmd.getTable() != null) {
            this.table = ormFmd.getTable();
        }
        if (ormFmd.getColumn() != null) {
            this.column = ormFmd.getColumn();
        }
        if (ormFmd.dependent != null) {
            this.dependent = ormFmd.dependent;
        }
        if (ormFmd.getMappedBy() != null) {
            this.mappedBy = ormFmd.getMappedBy();
        }
        if (ormFmd.getValueStrategy() != null) {
            this.valueStrategy = ormFmd.getValueStrategy();
        }
        if (ormFmd.getSequence() != null) {
            this.sequence = ormFmd.getSequence();
        }
        if (ormFmd.getJoinMetaData() != null) {
            this.joinMetaData = ormFmd.getJoinMetaData();
            if (this.joinMetaData != null) {
                this.joinMetaData.parent = this;
            }
        }
        if (ormFmd.getEmbeddedMetaData() != null) {
            this.embeddedMetaData = ormFmd.getEmbeddedMetaData();
            if (this.embeddedMetaData != null) {
                this.embeddedMetaData.parent = this;
            }
        }
        if (ormFmd.getElementMetaData() != null) {
            this.elementMetaData = ormFmd.getElementMetaData();
            if (this.elementMetaData != null) {
                this.elementMetaData.parent = this;
            }
        }
        if (ormFmd.getKeyMetaData() != null) {
            this.keyMetaData = ormFmd.getKeyMetaData();
            if (this.keyMetaData != null) {
                this.keyMetaData.parent = this;
            }
        }
        if (ormFmd.getValueMetaData() != null) {
            this.valueMetaData = ormFmd.getValueMetaData();
            if (this.valueMetaData != null) {
                this.valueMetaData.parent = this;
            }
        }
        if (ormFmd.getOrderMetaData() != null) {
            this.orderMetaData = ormFmd.getOrderMetaData();
            if (this.orderMetaData != null) {
                this.orderMetaData.parent = this;
            }
        }
        if (ormFmd.getForeignKeyMetaData() != null) {
            this.foreignKeyMetaData = ormFmd.getForeignKeyMetaData();
            if (this.foreignKeyMetaData != null) {
                this.foreignKeyMetaData.parent = this;
            }
        }
        if (ormFmd.indexed != null) {
            this.indexed = ormFmd.indexed;
        }
        if (ormFmd.getIndexMetaData() != null) {
            this.indexMetaData = ormFmd.getIndexMetaData();
            if (this.indexMetaData != null) {
                this.indexMetaData.parent = this;
            }
        }
        if (ormFmd.getUniqueMetaData() != null) {
            this.uniqueMetaData = ormFmd.getUniqueMetaData();
            if (this.uniqueMetaData != null) {
                this.uniqueMetaData.parent = this;
            }
        }
        this.columns.clear();
        ColumnMetaData[] ormColumns = ormFmd.getColumnMetaData();
        if (ormColumns != null) {
            for (int i = 0; i < ormColumns.length; ++i) {
                this.columns.add(ormColumns[i]);
            }
        }
        if ((ormExtensions = ormFmd.getExtensions()) != null) {
            for (int i = 0; i < ormExtensions.length; ++i) {
                this.addExtension(ormExtensions[i].vendorName, ormExtensions[i].key, ormExtensions[i].value);
            }
        }
    }

    public synchronized void populate(ClassLoaderResolver clr, Class fieldType, int modifiers) {
        if (this.isPopulated() || this.isInitialised()) {
            return;
        }
        if (fieldType == null) {
            JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Field.PopulateWithNullFieldError", this.name, this.getClassName(false)));
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Field.PopulateWithNullError", (Object)this.name, this.getClassName(false));
        }
        if (clr == null) {
            JPOXLogger.METADATA.warn(LOCALISER.msg("MetaData.Class.UsingDefaultClassLoaderResolver", this.name, this.getClassName(true)));
            clr = this.getAbstractClassMetaData().getMetaDataManager().getPMFContext().getClassLoaderResolver(null);
        }
        this.type = fieldType;
        this.modifiers = modifiers;
        if (this.className != null) {
            Class thisClass = null;
            try {
                thisClass = clr.classForName(this.getAbstractClassMetaData().getPackageName() + "." + this.getAbstractClassMetaData().getName());
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            Class fieldClass = null;
            try {
                fieldClass = clr.classForName(this.className);
            }
            catch (ClassNotResolvedException cnre) {
                try {
                    fieldClass = clr.classForName(this.getAbstractClassMetaData().getPackageName() + "." + this.className);
                    this.className = this.getAbstractClassMetaData().getPackageName() + "." + this.className;
                }
                catch (ClassNotResolvedException cnre2) {
                    JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Field.ClassNameInvalid", this.getAbstractClassMetaData().getName(), this.name, this.className));
                    throw new InvalidMetaDataException(LOCALISER, "MetaData.Field.ClassNameInvalid", (Object)this.getAbstractClassMetaData().getName(), (Object)this.name, this.className);
                }
            }
            if (fieldClass != null && !fieldClass.isAssignableFrom(thisClass)) {
                JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Field.ClassNotSuperclass", this.getAbstractClassMetaData().getName(), this.name, this.className));
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Field.ClassNotSuperclass", (Object)this.getAbstractClassMetaData().getName(), (Object)this.name, this.className);
            }
        }
        if (this.primaryKey == Boolean.FALSE && this.embedded == null) {
            Class<?> element_type = this.getType();
            if (element_type.isArray()) {
                element_type = element_type.getComponentType();
                if (this.getMetaDataManager().getPMFContext().getTypeManager().isDefaultEmbeddedType(element_type)) {
                    this.embedded = Boolean.TRUE;
                }
            } else if (this.getMetaDataManager().getPMFContext().getTypeManager().isDefaultEmbeddedType(element_type)) {
                this.embedded = Boolean.TRUE;
            }
        }
        if (this.embedded == null) {
            this.embedded = Boolean.FALSE;
        }
        if (FieldPersistenceModifier.DEFAULT.equals(this.persistenceModifier)) {
            boolean isPcClass;
            boolean bl = isPcClass = this.getType().isArray() ? this.isFieldArrayTypePersistenceCapable() : this.isFieldTypePersistenceCapable();
            if (!isPcClass) {
                if (this.getType().isArray() && this.getType().getComponentType().isInterface()) {
                    isPcClass = this.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(this.getType().getComponentType(), clr) != null;
                } else if (this.getType().isInterface()) {
                    isPcClass = this.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(this.getType(), clr) != null;
                }
            }
            this.persistenceModifier = this.getMetaDataManager().getPMFContext().getTypeManager().getDefaultFieldPersistenceModifier(this.getType(), modifiers, isPcClass);
        }
        if (!(this.persistenceModifier.equals(FieldPersistenceModifier.NONE) || !this.getType().isArray() || this.getAbstractClassMetaData().getMetaDataManager().isEnhancing() || this.getMetaDataManager().getPMFContext().getTypeManager().isSupportedType(this.getType().getName()) || (class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = AbstractPropertyMetaData.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(this.getType().getComponentType()) || this.getType().getComponentType().isInterface() || this.getType().getComponentType().getName().equals("java.lang.Object"))) {
            JPOXLogger.METADATA.warn(LOCALISER.msg("MetaData.Field.InvalidArrayType", this.name, this.getClassName(false)));
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Field.InvalidArrayType", (Object)this.name, this.getClassName(false));
        }
        if (this.defaultFetchGroup == null && this.persistenceModifier.equals(FieldPersistenceModifier.NONE)) {
            this.defaultFetchGroup = Boolean.FALSE;
        } else if (this.defaultFetchGroup == null && this.persistenceModifier.equals(FieldPersistenceModifier.TRANSACTIONAL)) {
            this.defaultFetchGroup = Boolean.FALSE;
        } else if (this.defaultFetchGroup == null) {
            this.defaultFetchGroup = Boolean.FALSE;
            if (!this.primaryKey.equals(Boolean.TRUE) && this.getMetaDataManager().getPMFContext().getTypeManager().isDefaultFetchGroup(this.getType())) {
                this.defaultFetchGroup = Boolean.TRUE;
            }
        }
        if ((this.persistenceModifier.equals(FieldPersistenceModifier.TRANSACTIONAL) || this.persistenceModifier.equals(FieldPersistenceModifier.NONE)) && (this.defaultFetchGroup == Boolean.TRUE || this.primaryKey == Boolean.TRUE)) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Field.NotPersistentWithIllegalAttributesError", (Object)this.name, (Object)this.getClassName(false), (Object)this.getType().getName(), this.persistenceModifier.toString());
        }
        if (this.container != null && this.dependent != null) {
            JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Field.DependentVsContainerDependentError", this.name, this.getClassName(false), ((ClassMetaData)this.parent).getName()));
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Field.DependentVsContainerDependentError", (Object)this.name, (Object)this.getClassName(false), ((ClassMetaData)this.parent).getName());
        }
        if (this.elementMetaData != null) {
            this.elementMetaData.populate(clr);
        }
        if (this.keyMetaData != null) {
            this.keyMetaData.populate(clr);
        }
        if (this.valueMetaData != null) {
            this.valueMetaData.populate(clr);
        }
        if (this.embeddedMetaData != null) {
            this.embeddedMetaData.populate(clr);
            this.embedded = Boolean.TRUE;
        }
        if (this.elementMetaData != null && this.elementMetaData.mappedBy != null && this.mappedBy == null) {
            this.mappedBy = this.elementMetaData.mappedBy;
        }
        if (this.container == null && this.type.isArray()) {
            Class<?> arrayCls = this.type.getComponentType();
            ArrayMetaData arrmd = new ArrayMetaData(this, arrayCls.getName(), null, null, null);
            this.container = arrmd;
        }
        if (this.container != null && this.persistenceModifier == FieldPersistenceModifier.PERSISTENT) {
            if (this.container instanceof CollectionMetaData) {
                ((CollectionMetaData)this.container).populate(clr);
            } else if (this.container instanceof MapMetaData) {
                ((MapMetaData)this.container).populate(clr);
            } else if (this.container instanceof ArrayMetaData) {
                ((ArrayMetaData)this.container).populate(clr);
            }
        }
        if (this.hasExtension("implementation-classes")) {
            StringBuffer str = new StringBuffer();
            String[] implTypes = this.getValuesForExtension("implementation-classes");
            for (int i = 0; i < implTypes.length; ++i) {
                String implTypeName = ClassUtils.createFullClassName(this.getAbstractClassMetaData().getPackageName(), implTypes[i]);
                if (i > 0) {
                    str.append(",");
                }
                try {
                    clr.classForName(implTypeName);
                    str.append(implTypeName);
                    continue;
                }
                catch (ClassNotResolvedException cnre) {
                    try {
                        String langClassName = ClassUtils.getJavaLangClassForType(implTypeName);
                        clr.classForName(langClassName);
                        str.append(langClassName);
                        continue;
                    }
                    catch (ClassNotResolvedException cnre2) {
                        throw new InvalidMetaDataException(LOCALISER, "MetaData.Field.ImplementationClassInvalid", (Object)this.name, (Object)this.getClassName(false), implTypes[i]);
                    }
                }
            }
            this.addExtension("jpox", "implementation-classes", str.toString());
        }
        this.setPopulated();
    }

    public synchronized void initialise() {
        int i;
        if (this.columns.size() == 0 && this.column != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = new ColumnMetaData((ExtendableMetaData)this, this.column);
            this.columnMetaData[0].initialise();
        } else if (this.columns.size() == 1 && this.column != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = (ColumnMetaData)this.columns.get(0);
            if (this.columnMetaData[0].getName() == null) {
                this.columnMetaData[0].setName(this.column);
            }
            this.columnMetaData[0].initialise();
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        if (this.container != null) {
            this.container.initialise();
        }
        if (this.embeddedMetaData != null) {
            this.embeddedMetaData.initialise();
        }
        if (this.joinMetaData != null) {
            this.joinMetaData.initialise();
        }
        if (this.elementMetaData != null) {
            this.elementMetaData.initialise();
        }
        if (this.keyMetaData != null) {
            this.keyMetaData.initialise();
        }
        if (this.valueMetaData != null) {
            this.valueMetaData.initialise();
        }
        if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
            this.indexMetaData = new IndexMetaData(null, null, this.indexed == IndexedValue.UNIQUE ? "true" : "false");
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.indexMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.indexMetaData != null) {
            this.indexMetaData.initialise();
        }
        if (this.uniqueMetaData == null && this.uniqueConstraint) {
            this.uniqueMetaData = new UniqueMetaData(this, null, this.column, null);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.uniqueMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.uniqueMetaData != null) {
            this.uniqueMetaData.initialise();
        }
        if (this.foreignKeyMetaData != null) {
            this.foreignKeyMetaData.initialise();
        }
        if (this.orderMetaData != null) {
            this.orderMetaData.initialise();
        }
        if (this.hasCollection() && SCOUtils.collectionHasSerialisedElements(this) || this.hasMap() && SCOUtils.mapHasSerialisedKeysAndValues(this) || this.hasArray() && SCOUtils.arrayIsStoredInSingleColumn(this)) {
            boolean setSerialised = true;
            if (this.hasArray() && MetaDataUtils.arrayStorableAsByteArrayInSingleColumn(this)) {
                setSerialised = false;
            }
            if (setSerialised) {
                this.serialized = Boolean.TRUE;
            }
        }
        this.setInitialised();
    }

    public boolean isFieldTypePersistenceCapable() {
        return ClassUtils.isPersistenceCapableClass(this.type);
    }

    public boolean isFieldArrayTypePersistenceCapable() {
        if (!this.type.isArray()) {
            return false;
        }
        return ClassUtils.isPersistenceCapableClass(this.type.getComponentType());
    }

    public boolean isStatic() {
        if (!this.isPopulated()) {
            return false;
        }
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        if (!this.isPopulated()) {
            return false;
        }
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isTransient() {
        if (!this.isPopulated()) {
            return false;
        }
        return Modifier.isTransient(this.modifiers);
    }

    public IdentityStrategy getValueStrategy() {
        return this.valueStrategy;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getLoadFetchGroup() {
        return this.loadFetchGroup;
    }

    public int getRecursionDepth() {
        return this.recursionDepth;
    }

    protected MetaData getOverallParentClassMetaData(MetaData metadata) {
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof AbstractClassMetaData) {
            return metadata;
        }
        return this.getOverallParentClassMetaData(metadata.getParent());
    }

    public AbstractClassMetaData getAbstractClassMetaData() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof AbstractClassMetaData) {
            return (AbstractClassMetaData)this.parent;
        }
        if (this.parent instanceof EmbeddedMetaData) {
            MetaData parentMd = ((EmbeddedMetaData)this.parent).getParent();
            return (AbstractClassMetaData)this.getOverallParentClassMetaData(parentMd.getParent());
        }
        return null;
    }

    public final OrderMetaData getOrderMetaData() {
        return this.orderMetaData;
    }

    public String getName() {
        return this.name;
    }

    public String getFullFieldName() {
        if (this.className != null) {
            return this.className + "." + this.name;
        }
        return this.getClassName(true) + "." + this.name;
    }

    public boolean fieldBelongsToClass() {
        return this.className == null;
    }

    public String getClassName() {
        return this.getClassName(true);
    }

    void setClassName(String className) {
        this.className = className;
    }

    public String getClassName(boolean fully_qualified) {
        MetaData grandparent;
        if (this.className != null) {
            return this.className;
        }
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof ClassMetaData) {
            ClassMetaData cmd = (ClassMetaData)this.parent;
            if (fully_qualified) {
                return cmd.getFullClassName();
            }
            return cmd.getName();
        }
        if (this.parent instanceof EmbeddedMetaData) {
            MetaData parentMd = ((EmbeddedMetaData)this.parent).getParent();
            if (parentMd instanceof AbstractPropertyMetaData) {
                return ((AbstractPropertyMetaData)parentMd).getTypeName();
            }
            if (parentMd instanceof ElementMetaData) {
                AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)((ElementMetaData)parentMd).getParent();
                return fmd.getCollection().getElementType();
            }
            if (parentMd instanceof KeyMetaData) {
                AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)((KeyMetaData)parentMd).getParent();
                return fmd.getMap().getKeyType();
            }
            if (parentMd instanceof ValueMetaData) {
                AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)((ValueMetaData)parentMd).getParent();
                return fmd.getMap().getValueType();
            }
            return null;
        }
        if (this.parent instanceof UniqueMetaData && (grandparent = ((UniqueMetaData)this.parent).getParent()) instanceof AbstractClassMetaData) {
            return ((AbstractClassMetaData)grandparent).getFullClassName();
        }
        return null;
    }

    public NullValue getNullValue() {
        return this.nullValue;
    }

    public FieldPersistenceModifier getPersistenceModifier() {
        return this.persistenceModifier;
    }

    public boolean isDefaultFetchGroup() {
        if (this.defaultFetchGroup == null) {
            return false;
        }
        return this.defaultFetchGroup;
    }

    public boolean isDependent() {
        if (this.dependent == null) {
            return false;
        }
        return this.dependent;
    }

    public boolean isEmbedded() {
        if (this.embedded == null) {
            return false;
        }
        return this.embedded;
    }

    public boolean isSerialized() {
        if (this.serialized == null) {
            return false;
        }
        return this.serialized;
    }

    public boolean isPrimaryKey() {
        if (this.primaryKey == null) {
            return false;
        }
        return this.primaryKey;
    }

    public abstract boolean isProperty();

    public String getTable() {
        return this.table;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public final String getFieldType() {
        return this.fieldType;
    }

    public int getAbsoluteFieldNumber() {
        if (this.className == null) {
            return this.fieldId + this.getAbstractClassMetaData().getNoOfInheritedManagedFields();
        }
        return this.getAbstractClassMetaData().getFieldNumberAbsolute(this.name);
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        if (this.type == null) {
            return null;
        }
        return this.type.getName();
    }

    public ContainerMetaData getContainer() {
        return this.container;
    }

    public ArrayMetaData getArray() {
        if (this.container != null && this.container instanceof ArrayMetaData) {
            return (ArrayMetaData)this.container;
        }
        return null;
    }

    public CollectionMetaData getCollection() {
        if (this.container != null && this.container instanceof CollectionMetaData) {
            return (CollectionMetaData)this.container;
        }
        return null;
    }

    public MapMetaData getMap() {
        if (this.container != null && this.container instanceof MapMetaData) {
            return (MapMetaData)this.container;
        }
        return null;
    }

    public final String getColumn() {
        return this.column;
    }

    public final String getMappedBy() {
        return this.mappedBy;
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final ElementMetaData getElementMetaData() {
        return this.elementMetaData;
    }

    public final KeyMetaData getKeyMetaData() {
        return this.keyMetaData;
    }

    public final ValueMetaData getValueMetaData() {
        return this.valueMetaData;
    }

    public final EmbeddedMetaData getEmbeddedMetaData() {
        return this.embeddedMetaData;
    }

    public final ForeignKeyMetaData getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final UniqueMetaData getUniqueMetaData() {
        return this.uniqueMetaData;
    }

    public final JoinMetaData getJoinMetaData() {
        return this.joinMetaData;
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
        this.columnMetaData = new ColumnMetaData[this.columns.size()];
        for (int i = 0; i < this.columnMetaData.length; ++i) {
            this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
        }
    }

    public boolean hasContainer() {
        return this.container != null;
    }

    public boolean hasArray() {
        if (this.container == null) {
            return false;
        }
        return this.container instanceof ArrayMetaData;
    }

    public boolean hasCollection() {
        if (this.container == null) {
            return false;
        }
        return this.container instanceof CollectionMetaData;
    }

    public boolean hasMap() {
        if (this.container == null) {
            return false;
        }
        return this.container instanceof MapMetaData;
    }

    public boolean isJdoField() {
        if (this.isPopulated() && (this.isStatic() || this.isFinal())) {
            return false;
        }
        if (this.persistenceModifier == null) {
            return false;
        }
        return !this.persistenceModifier.equals(FieldPersistenceModifier.NONE);
    }

    public void setValueStrategy(IdentityStrategy valueStrategy) {
        this.valueStrategy = valueStrategy;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public void setDependent(boolean dependent) {
        this.dependent = new Boolean(dependent);
    }

    public void setMappedBy(String mappedby) {
        this.mappedBy = mappedby;
    }

    public void setContainer(ContainerMetaData conmd) {
        this.container = conmd;
        this.container.parent = this;
    }

    public final void setElementMetaData(ElementMetaData elementMetaData) {
        this.elementMetaData = elementMetaData;
        this.elementMetaData.parent = this;
    }

    public final void setKeyMetaData(KeyMetaData keyMetaData) {
        this.keyMetaData = keyMetaData;
        this.keyMetaData.parent = this;
    }

    public final void setOrderMetaData(OrderMetaData orderMetaData) {
        this.orderMetaData = orderMetaData;
        this.orderMetaData.parent = this;
    }

    public final void setValueMetaData(ValueMetaData valueMetaData) {
        this.valueMetaData = valueMetaData;
        this.valueMetaData.parent = this;
    }

    public final void setEmbeddedMetaData(EmbeddedMetaData embeddedMetaData) {
        this.embeddedMetaData = embeddedMetaData;
        this.embeddedMetaData.parent = this;
    }

    public final void setForeignKeyMetaData(ForeignKeyMetaData foreignKeyMetaData) {
        this.foreignKeyMetaData = foreignKeyMetaData;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
    }

    public final void setUniqueMetaData(UniqueMetaData uniqueMetaData) {
        this.uniqueMetaData = uniqueMetaData;
    }

    public final void setJoinMetaData(JoinMetaData joinMetaData) {
        this.joinMetaData = joinMetaData;
        this.joinMetaData.parent = this;
    }

    void setFieldId(int field_id) {
        this.fieldId = field_id;
    }

    public void setTable(String table) {
        this.table = table;
    }

    protected void setRelation(ClassLoaderResolver clr) {
        if (this.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) {
            this.relationType = 0;
            this.relatedFieldMetaData = null;
            return;
        }
        AbstractClassMetaData otherCmd = null;
        if (this.hasCollection()) {
            otherCmd = this.getCollection().getElementClassMetaData();
            if (otherCmd == null) {
                String[] implNames;
                Class elementCls = clr.classForName(this.getCollection().getElementType());
                if (this.getMetaDataManager().getPMFContext().getTypeManager().isReferenceType(elementCls) && (implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this, 3, clr)) != null && implNames.length > 0) {
                    otherCmd = this.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
            }
        } else if (this.hasMap()) {
            otherCmd = ((MapMetaData)this.container).getValueClassMetaData();
            if (otherCmd == null) {
                otherCmd = ((MapMetaData)this.container).getKeyClassMetaData();
            }
            if (otherCmd == null) {
                // empty if block
            }
        } else if (this.hasArray()) {
            otherCmd = ((ArrayMetaData)this.container).getElementClassMetaData();
        } else if (this.getType().isInterface()) {
            String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this, 2, clr);
            if (implNames != null && implNames.length > 0) {
                otherCmd = this.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
            }
        } else {
            otherCmd = this.getMetaDataManager().getMetaDataForClass(this.getType(), clr);
        }
        if (otherCmd == null) {
            this.relatedFieldMetaData = null;
            this.relationType = 0;
        } else if (this.mappedBy != null) {
            this.relatedFieldMetaData = otherCmd.getField(this.mappedBy);
            if (this.relatedFieldMetaData == null) {
                throw new JDOFatalUserException(LOCALISER.msg("MetaData.Field.MappedByInvalid", this.getAbstractClassMetaData().getFullClassName(), this.name, this.mappedBy, otherCmd.getFullClassName()));
            }
            this.relatedFieldMetaData.relatedFieldMetaData = this;
            if (this.hasContainer() && this.relatedFieldMetaData.hasContainer()) {
                this.relationType = 5;
                this.relatedFieldMetaData.relationType = 5;
            } else if (this.hasContainer() && !this.relatedFieldMetaData.hasContainer()) {
                this.relationType = 4;
                this.relatedFieldMetaData.relationType = 6;
            } else if (!this.hasContainer() && this.relatedFieldMetaData.hasContainer()) {
                this.relationType = 6;
                this.relatedFieldMetaData.relationType = 4;
            } else {
                this.relationType = 2;
                this.relatedFieldMetaData.relationType = 2;
            }
        } else {
            int[] otherFieldNumbers = otherCmd.getAllFieldNumbers();
            for (int i = 0; i < otherFieldNumbers.length; ++i) {
                AbstractPropertyMetaData otherFmd = otherCmd.getManagedFieldAbsolute(otherFieldNumbers[i]);
                if (otherFmd.getMappedBy() == null || !otherFmd.getMappedBy().equals(this.name)) continue;
                if (otherFmd.hasContainer()) {
                    if (!(otherFmd.hasCollection() && otherFmd.getCollection().getElementType().equals(this.getClassName(true)) || otherFmd.hasArray() && otherFmd.getArray().getElementType().equals(this.getClassName(true)) || otherFmd.hasMap() && otherFmd.getMap().getKeyType().equals(this.getClassName(true))) && (!otherFmd.hasMap() || !otherFmd.getMap().getValueType().equals(this.getClassName(true)))) continue;
                    this.relatedFieldMetaData = otherFmd;
                    this.relatedFieldMetaData.relatedFieldMetaData = this;
                    if (this.hasContainer()) {
                        this.relationType = 5;
                        this.relatedFieldMetaData.relationType = 5;
                        break;
                    }
                    this.relationType = 6;
                    this.relatedFieldMetaData.relationType = 4;
                    break;
                }
                if (!otherFmd.getTypeName().equals(this.getClassName(true))) continue;
                this.relatedFieldMetaData = otherFmd;
                this.relatedFieldMetaData.relatedFieldMetaData = this;
                if (this.hasContainer()) {
                    this.relationType = 4;
                    this.relatedFieldMetaData.relationType = 6;
                    break;
                }
                this.relationType = 2;
                this.relatedFieldMetaData.relationType = 2;
                break;
            }
            if (this.relatedFieldMetaData == null) {
                this.relationType = this.hasContainer() ? 3 : 1;
            }
        }
    }

    public int getRelationType(ClassLoaderResolver clr) {
        if (this.relationType == -1) {
            this.setRelation(clr);
        }
        return this.relationType;
    }

    public AbstractPropertyMetaData getRelatedFieldMetaData(ClassLoaderResolver clr) {
        if (this.relationType == -1) {
            this.setRelation(clr);
        }
        return this.relatedFieldMetaData;
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, String dba_vendor_id, ClassLoaderResolver clr) {
        AbstractClassMetaData type_cmd = this.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClass(this.getType(), clr);
        if (type_cmd != null) {
            type_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
        }
        if (this.container != null) {
            if (this.container instanceof CollectionMetaData) {
                ((CollectionMetaData)this.container).getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
            } else if (this.container instanceof MapMetaData) {
                ((MapMetaData)this.container).getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
            } else if (this.container instanceof ArrayMetaData) {
                ((ArrayMetaData)this.container).getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
            }
        }
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        return super.toString(prefix, indent);
    }

    public int compareTo(Object o) {
        if (o instanceof AbstractPropertyMetaData) {
            AbstractPropertyMetaData c = (AbstractPropertyMetaData)o;
            return this.name.compareTo(c.name);
        }
        if (o instanceof String) {
            return this.name.compareTo((String)o);
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    public MetaDataManager getMetaDataManager() {
        if (this.parent != null && this.parent.getParent() != null && this.getAbstractClassMetaData() != null) {
            return this.getAbstractClassMetaData().getPackageMetaData().getFileMetaData().getMetaDataManager();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

