/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.management;

import javax.jdo.JDOFatalInternalException;
import org.jpox.PMFContext;
import org.jpox.management.ManagementCategory;
import org.jpox.management.ManagementServer;

public class ManagementManager {
    private final long[] statistics = new long[999];
    private final PMFContext pmfContext;
    private boolean closed = false;
    private boolean enabled = true;
    private ManagementServer mgmtServer;

    public ManagementManager(PMFContext pmfContext) {
        this.pmfContext = pmfContext;
        this.startManagementServer();
    }

    public void disable() {
        this.assertNotClosed();
        this.enabled = false;
    }

    public void enable() {
        this.assertNotClosed();
        this.enabled = true;
        this.startManagementServer();
    }

    public boolean isEnabled() {
        this.assertNotClosed();
        return this.enabled;
    }

    public synchronized void increment(ManagementCategory cat) {
        this.assertNotClosed();
        if (!this.enabled) {
            return;
        }
        int n = cat.getType();
        this.statistics[n] = this.statistics[n] + 1L;
    }

    public synchronized void increment(ManagementCategory[] cats) {
        this.assertNotClosed();
        if (!this.enabled) {
            return;
        }
        for (int i = 0; i < cats.length; ++i) {
            int n = cats[i].getType();
            this.statistics[n] = this.statistics[n] + 1L;
        }
    }

    public synchronized long getStatisticValue(ManagementCategory cat) {
        this.assertNotClosed();
        return this.statistics[cat.getType()];
    }

    public synchronized long[] getStatisticValues() {
        this.assertNotClosed();
        return this.statistics;
    }

    public synchronized void reset() {
        this.assertNotClosed();
        for (int i = 0; i < this.statistics.length; ++i) {
            this.statistics[i] = 0L;
        }
    }

    public PMFContext getPmfContext() {
        this.assertNotClosed();
        return this.pmfContext;
    }

    private void startManagementServer() {
        if (this.mgmtServer == null && this.mgmtServer != null) {
            this.mgmtServer.start();
        }
    }

    private void stopManagementServer() {
        if (this.mgmtServer != null) {
            this.mgmtServer.stop();
        }
    }

    public synchronized void close() {
        this.assertNotClosed();
        this.stopManagementServer();
        this.closed = true;
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new JDOFatalInternalException("Management instance is closed and cannot be used. You must adquire a new PMFContext");
        }
    }
}

