/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.jdo.JDOFatalUserException;
import javax.sql.DataSource;
import org.jpox.ClassLoaderResolver;
import org.jpox.util.Localiser;

public class DriverManagerDataSource
implements DataSource {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private final String driverName;
    private final String url;
    private final ClassLoaderResolver clr;

    public DriverManagerDataSource(String driverName, String url, ClassLoaderResolver clr) {
        this.driverName = driverName;
        this.url = url;
        this.clr = clr;
        if (driverName != null) {
            try {
                clr.classForName(driverName).newInstance();
                try {
                    Class.forName(driverName).newInstance();
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                throw new JDOFatalUserException(LOCALISER.msg("Driver.InvalidClass", driverName), (Throwable)e);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            Properties info = new Properties();
            return ((Driver)this.clr.classForName(this.driverName).newInstance()).connect(this.url, info);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                return DriverManager.getConnection(this.url);
            }
            catch (Exception e2) {
                throw new JDOFatalUserException(LOCALISER.msg("Driver.InvalidClass", this.driverName), (Throwable)e);
            }
        }
    }

    public Connection getConnection(String userName, String password) throws SQLException {
        try {
            Properties info = new Properties();
            if (userName != null) {
                info.put("user", userName);
            }
            if (password != null) {
                info.put("password", password);
            }
            return ((Driver)this.clr.classForName(this.driverName).newInstance()).connect(this.url, info);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                return DriverManager.getConnection(this.url, userName, password);
            }
            catch (Exception e2) {
                throw new JDOFatalUserException(LOCALISER.msg("Driver.InvalidClass", this.driverName), (Throwable)e);
            }
        }
    }

    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) {
        DriverManager.setLogWriter(out);
    }

    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) {
        DriverManager.setLoginTimeout(seconds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DriverManagerDataSource)) {
            return false;
        }
        DriverManagerDataSource dmds = (DriverManagerDataSource)obj;
        if (this.driverName == null ? dmds.driverName != null : !this.driverName.equals(dmds.driverName)) {
            return false;
        }
        return !(this.url == null ? dmds.url != null : !this.url.equals(dmds.url));
    }

    public int hashCode() {
        return (this.driverName == null ? 0 : this.driverName.hashCode()) ^ (this.url == null ? 0 : this.url.hashCode());
    }
}

